#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "7 секунд на devtest",
  comment => "переименовываем старые гео-кампании для улучшения отображения в Метрике"
}

=cut

use strict;
use warnings;
use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use Settings;
use ScriptHelper;
use Yandex::DBTools;
use utf8;

my $NAME_TEMPLATE = 'Поисковое размещение в Справочнике (заказ №%d)';

$log->out('start');
while (my $line = <DATA>) {
    chomp $line;
    my ($cid, $sprav_order_id) = split ' ', $line, 2;
    $log->die("bad line: $line") unless int($cid) && int($sprav_order_id);

    do_update_table(PPC, 'campaigns',
        {name => sprintf $NAME_TEMPLATE, $sprav_order_id},
        where => {
            cid  => $cid,
            type => 'geo'
        }
    );
    $log->out("updated cid $cid, sprav_order_id = $sprav_order_id");
}
$log->out('finish');

__DATA__
3227289	92682
3227291	92683
3227375	92685
3227418	92686
3227446	92687
3227447	92688
3227462	92689
3227900	92695
3232002	92698
3232004	92699
3232005	92700
3228018	92701
3228054	92703
3228100	92704
3229882	92705
3228124	92706
3229883	92707
3228152	92708
3228153	92709
3228159	92710
3228165	92711
3228198	92712
3228368	92714
3228392	92715
3228559	92716
3229884	92718
3228761	92719
3230194	92721
3234773	92723
3230379	92725
3230380	92726
3231601	92728
3231328	92729
3231529	92730
3231224	92733
3231329	92734
3231371	92735
3231192	92736
3231264	92737
3231462	92738
3231345	92739
3231602	92740
3231266	92741
3231650	92742
3233941	92744
3231917	92745
3233153	92746
3231881	92747
3233184	92750
3233193	92751
3233384	92753
3233302	92754
3233168	92755
3233185	92756
3233319	92757
3233032	92758
3233612	92762
3233917	92764
3233539	92765
3233632	92767
3235864	92768
3233710	92769
3234122	92770
3234199	92771
3233898	92772
3234124	92773
3235484	92774
3234327	92775
3234492	92777
3234543	92778
3235616	92779
3235096	92780
3235446	92781
3235447	92782
3235547	92783
3243674	92784
3240458	92785
3240488	92786
3236846	92787
3236409	92788
3235742	92789
3240397	92790
3237084	92791
3235869	92792
3243286	92793
3237085	92794
3235972	92795
3235991	92796
3236012	92797
3243293	92798
3236254	92799
3243272	92800
3236295	92801
3244315	92803
3236686	92804
3236698	92805
3236717	92806
3236827	92807
3240365	92808
3240287	92811
3237165	92812
3243962	92816
3240755	92818
3240525	92819
3240589	92820
3244845	92821
3243424	92823
3241354	92824
3240644	92827
3241205	92829
3241276	92830
3240427	92831
3241254	92832
3243345	92833
3242286	92834
3241021	92835
3241051	92836
3245078	92837
3243378	92838
3241446	92839
3241486	92840
3241206	92841
3240951	92842
3240963	92843
3241978	92844
3241941	92845
3241881	92846
3241494	92847
3241510	92848
3242061	92849
3243509	92851
3243725	92852
3244082	92853
3244357	92854
3243985	92855
3244681	92856
3244596	92858
3244004	92859
3244644	92860
3244725	92862
3244763	92863
3246076	92864
3246066	92865
3246126	92866
3246611	92868
3246573	92869
3246790	92872
3246878	92873
3247539	92875
3247056	92876
3246975	92877
3247513	92879
3252697	92880
3247577	92884
3247591	92885
3249237	92886
3249132	92887
3257960	92888
3249683	92889
3249163	92890
3249394	92893
3253274	92894
3249297	92895
3249746	92896
3249982	92898
3258907	92899
3250375	92900
3250679	92901
3252337	92902
3250955	92904
3250823	92905
3252310	92906
3252322	92907
3254091	92910
3252682	92911
3252436	92912
3252551	92913
3252462	92914
3252582	92915
3253362	92917
3253159	92918
3253137	92919
3253913	92920
3253196	92921
3258843	92924
3258127	92925
3257587	92929
3257828	92930
3257716	92931
3258240	92936
3258002	92937
3261575	92938
3260587	92940
3258818	92941
3258173	92942
3258631	92943
3261548	92944
3259324	92946
3259340	92947
3258740	92948
3259233	92949
3260713	92951
3261399	92953
3260930	92954
3261212	92956
3262006	92957
3261439	92958
3262009	92959
3261070	92960
3264032	92961
3262329	92962
3262457	92963
3264137	92964
3263701	92966
3262164	92967
3262165	92968
3262528	92969
3263942	92970
3266473	92971
3263814	92972
3264121	92973
3263741	92974
3263877	92975
3266906	92976
3269523	92978
3263829	92979
3265040	92980
3265051	92981
3265062	92982
3264745	92983
3264751	92985
3270437	92986
3265043	92987
3270456	92988
3265044	92990
3265319	92991
3266488	92993
3266649	92994
3267017	92995
3266740	92996
3267143	92997
3266796	92998
3267057	93001
3267588	93002
3267625	93003
3267518	93004
3267787	93006
3267755	93007
3268971	93009
3267815	93010
3267839	93011
3267845	93013
3268985	93015
3268988	93016
3270307	93018
3293256	93019
3274239	93020
3269691	93022
3268900	93023
3270218	93026
3272963	93028
3280006	93029
3278060	93031
3277985	93033
3275119	93036
3274734	93040
3274368	93044
3274708	93045
3274279	93046
3274932	93047
3274956	93053
3275504	93055
3291871	93056
3276948	93057
3276730	93058
3276657	93064
3277470	93066
3278135	93067
3278015	93068
3277662	93069
3277651	93070
3277496	93071
3277821	93072
3278016	93073
3283269	93074
3279262	93075
3280369	93076
3282149	93078
3279953	93079
3280585	93080
3282299	93081
3280393	93082
3283076	93083
3282016	93084
3282017	93085
3290195	93086
3282024	93089
3283092	93091
3283012	93093
3309813	93095
3283521	93096
3283285	93097
3283101	93098
3283487	93099
3283460	93100
3285027	93101
3285404	93104
3285485	93106
3284872	93107
3285034	93108
3285689	93109
3285683	93110
3285878	93111
3285684	93112
3290541	93113
3293530	93114
3285899	93115
3290227	93116
3293831	93118
3292894	93119
3291180	93124
3290922	93129
3290859	93130
3292938	93131
3290294	93132
3292987	93134
3290266	93135
3290799	93136
3297013	93139
3296862	93141
3298330	93142
3293159	93143
3293374	93144
3293775	93146
3300238	93149
3300353	93150
3293455	93151
3293943	93153
3389451	93154
3297740	93155
3297383	93156
3296636	93157
3297800	93158
3300488	93161
3298020	93166
3297385	93168
3297700	93170
3297386	93171
3297388	93174
3297949	93177
3297951	93178
3297952	93179
3298186	93180
3300621	93181
3298187	93182
3299791	93183
3298261	93184
3299799	93185
3299793	93186
3307460	93190
3301218	93191
3300202	93192
3300203	93193
3300204	93194
3300797	93195
3306176	93196
3300471	93198
3300446	93199
3300461	93200
3300702	93201
3303807	93202
3303809	93203
3305373	93204
3306208	93205
3307091	93206
3300936	93207
3307318	93208
3303810	93209
3305376	93210
3307212	93211
3307245	93212
3305377	93213
3305409	93214
3306429	93215
3307039	93218
3306928	93219
3309923	93222
3307336	93225
3309897	93227
3305378	93228
3305379	93229
3309695	93230
3305418	93231
3305419	93232
3305700	93233
3305703	93234
4052883	93235
3305705	93236
3309049	93237
3309439	93238
3307041	93239
3306907	93240
3306910	93241
3307042	93242
3309204	93243
3309600	93244
3308817	93245
3320029	93246
3314596	93247
3310150	93248
3310144	93251
3309510	93253
3309678	93256
3310333	93257
3309226	93258
3309229	93259
3309346	93260
3309782	93261
3320051	93262
3309608	93263
3309763	93264
3309764	93265
3310124	93269
3312499	93271
3310253	93272
3311488	93273
3311610	93275
3311489	93276
3312207	93277
3311492	93278
3312378	93279
3312208	93280
3313215	93281
3312212	93282
3314887	93283
3312215	93284
3312233	93285
3312235	93286
3312245	93287
3312246	93288
3312261	93289
3312468	93290
3315717	93291
3313767	93292
3313759	93293
3320073	93294
3314706	93296
3315085	93297
3314736	93299
3313760	93300
3313761	93301
3314773	93302
3314925	93304
3314833	93305
3314060	93306
3314419	93307
3314950	93309
3315200	93312
3361749	93313
3315501	93314
3316231	93316
3328495	93317
3318267	93318
3317415	93320
3317180	93322
3317235	93324
3318206	93325
3317713	93326
3320385	93327
3318526	93330
3318078	93331
3318079	93332
3320195	93333
3318081	93334
3318082	93335
3318105	93336
3318083	93337
3318085	93338
3318086	93339
3318511	93340
3318589	93341
3318590	93342
3318591	93343
3326684	93344
3318592	93345
3318593	93346
3318594	93347
3318595	93348
3318427	93349
3318597	93350
3318599	93351
3318825	93352
3318558	93353
3325243	93354
3318601	93355
3318840	93356
3320256	93357
3320634	93358
3320142	93359
3320232	93360
3319725	93363
3326045	93364
3326741	93365
3319475	93366
3320558	93367
3319799	93369
3325220	93373
3320578	93374
3325095	93375
3325330	93376
3326802	93378
3325664	93379
3325471	93380
3325931	93382
3325506	93385
3340449	93386
3325272	93388
3325311	93389
3328328	93390
3325433	93392
3326368	93393
3332102	93394
3329393	93395
3328840	93396
3325316	93397
3325317	93398
3328808	93399
3325676	93400
3325677	93401
3325711	93403
3332455	93404
3328999	93405
3332103	93406
3329280	93407
3329318	93408
3326619	93409
3326620	93410
3326623	93411
3327190	93412
3327191	93413
3327201	93414
3327202	93415
3327203	93416
3327192	93417
3327204	93418
3327205	93419
3327194	93420
3327195	93421
3331972	93422
3333165	93424
3332581	93425
3342227	93426
3329553	93427
3329829	93428
3337592	93430
3328057	93431
3328269	93432
3338170	93433
3331787	93434
3328776	93435
3344002	93436
3331913	93437
3332592	93438
3332183	93439
3466214	93440
3332441	93441
3332680	93442
3332222	93443
3332517	93444
3331348	93445
3331349	93446
3332641	93448
3331403	93449
3332607	93450
3332317	93451
3332818	93453
3333153	93454
3341352	93455
3332780	93456
3332734	93457
3333141	93458
3332659	93459
3337643	93460
3332801	93461
3337608	93462
3332802	93464
3332839	93465
3333018	93467
3338052	93468
3341115	93470
3333537	93471
3337888	93472
3338333	93474
3338104	93475
3337753	93477
3356234	93479
3337935	93480
3338418	93481
3338152	93483
3347639	93485
3349147	93486
3340773	93489
3337473	93490
3337953	93491
3337954	93492
3338498	93494
3338076	93495
3338701	93496
3338727	93497
3338581	93498
3340593	93499
3339016	93500
3339158	93502
3341268	93504
3341160	93506
3340639	93508
3344057	93509
3341375	93510
3343669	93511
3341604	93512
3341879	93513
3341749	93514
3341715	93515
3341985	93516
3343827	93517
3341676	93519
3343899	93520
3342022	93521
3344272	93525
3343891	93526
3344224	93527
3343330	93528
3343767	93529
3345385	93530
3344469	93533
3344581	93534
3344992	93536
3346360	93537
3344916	93538
3346739	93543
3346916	93545
3346483	93547
3346484	93549
3346825	93550
3346826	93551
3346827	93552
3347077	93554
3347214	93559
3350346	93560
3347468	93561
3347469	93562
3347470	93563
3347479	93564
3347471	93565
3361802	93566
3348939	93568
3348940	93569
3348941	93570
3348147	93571
3354415	93572
3355595	93573
3350507	93574
3349660	93576
3349661	93577
3349736	93578
3350073	93579
3350318	93580
3350074	93581
3350026	93582
3350469	93585
3354347	93586
3357408	93587
3355029	93588
3355613	93589
3355164	93590
3360298	93591
3354988	93594
3354348	93595
3355230	93596
3354936	93597
3354349	93598
3354350	93599
3354352	93600
3354353	93601
3354354	93602
3354356	93603
3354357	93604
3358340	93605
3355957	93606
3357496	93607
3354689	93608
3355036	93609
3355037	93611
3355664	93612
3355665	93613
3357759	93615
3355666	93616
3357618	93618
3355923	93619
3357321	93620
3357322	93621
3357325	93622
3360600	93624
3360983	93625
3361454	93626
3358019	93627
3357726	93628
3358185	93630
3363882	93631
3357475	93633
3372774	93634
3360696	93638
3358330	93639
3358331	93641
3358333	93642
3358239	93643
3361571	93644
3358416	93648
3360497	93649
3360234	93650
3360242	93651
3363340	93652
3363324	93654
3367232	93656
3360934	93657
3360236	93658
3363247	93659
3360499	93661
3380755	93662
3360515	93663
3360355	93665
3361597	93667
3360677	93668
3361136	93669
3375981	93670
3361598	93671
3361138	93672
3361128	93673
3379342	93675
3366461	93676
3361737	93677
3361619	93678
3364898	93679
3364485	93680
3363165	93681
3363565	93682
3364708	93683
3364018	93685
3363883	93688
3364132	93689
3364084	93690
3363855	93691
3363831	93692
3364071	93693
3364194	93694
3366649	93695
3364445	93696
3424047	93698
3365965	93699
3365966	93700
3364658	93701
3365967	93702
3366822	93703
3364816	93704
3366641	93705
3371528	93708
3366576	93709
3366174	93710
3366175	93711
3366176	93712
3366092	93714
3366406	93715
3366729	93717
3372089	93718
3377470	93722
3374522	93723
3369419	93724
3383396	93727
3375054	93728
3371275	93729
3371276	93730
3367567	93731
3371277	93732
3374985	93734
3378046	93736
3376048	93739
3378016	93740
3376228	93741
3376200	93744
3377967	93745
3378073	93746
3371916	93748
3371917	93749
3378636	93750
3378116	93751
3378118	93753
3372278	93754
3372044	93755
3372569	93756
3372571	93757
3372588	93758
3372873	93760
3372874	93761
3378377	93762
3372921	93763
3372922	93764
3380525	93765
3383840	93766
3378296	93772
3378304	93773
3378334	93774
3378614	93776
3374720	93777
3381384	93778
3375852	93779
3375253	93780
3375112	93781
3461264	93782
3375855	93783
3424292	93784
3378676	93785
3375841	93786
3375860	93787
3377939	93790
3398347	93791
3378668	93792
3381131	93794
3378547	93796
3401784	93797
3377739	93798
3377780	93799
3377793	93800
3378581	93801
3378583	93802
3378164	93803
3378730	93804
3388352	93805
3378466	93806
3378468	93807
3381340	93809
3383442	93811
3380496	93812
3380497	93813
3380354	93815
3466416	93816
3380802	93817
3380804	93818
3380807	93820
3383556	93821
3819523	93822
3381218	93824
3380851	93825
3381010	93826
3424031	93827
3424049	93828
3383655	93829
3383698	93830
3466417	93832
3381717	93833
3383895	93834
3381718	93835
3381719	93836
3384010	93838
3389108	93839
3383599	93841
3383339	93842
3383601	93843
3383927	93844
3384138	93846
3424066	93847
3402250	93848
3388355	93849
3402265	93850
3402462	93851
3391989	93856
3389042	93857
3392776	93858
3389741	93859
3388590	93861
3389064	93862
3389100	93863
3389036	93864
3389339	93865
3392015	93866
3390345	93868
3390348	93869
3392469	93871
3391519	93873
3391522	93874
3391730	93875
3391722	93876
3391523	93877
3392450	93878
3392451	93879
3392743	93881
3392500	93882
3393147	93883
3392838	93884
3393086	93885
3393070	93886
3393072	93887
3393087	93888
3393399	93889
3393486	93890
3415976	93893
3395140	93894
3399028	93895
3395715	93897
3395239	93898
3395857	93899
3395478	93900
3397943	93901
3397910	93902
3395693	93903
3395613	93904
3396101	93905
3396355	93906
3399488	93907
3396183	93908
3399495	93909
3395937	93910
3396185	93911
3399463	93912
3398413	93913
3400958	93914
3396336	93916
3397744	93918
3423046	93919
3401331	93920
3401332	93921
3401971	93922
3397040	93925
3401951	93927
3397745	93928
3397748	93929
3397749	93930
3397751	93931
3398150	93932
3398350	93933
3416036	93936
3401953	93937
3401892	93938
3398649	93939
3398650	93940
3466419	93941
3462082	93942
3399329	93943
3399126	93944
3399043	93945
3402227	93947
3399296	93948
3399361	93949
3402122	93950
3400590	93951
3400596	93952
3424990	93953
3402052	93954
3402100	93955
3416464	93956
3400591	93958
3400592	93959
3401163	93960
3421004	93961
3400864	93962
3424991	93963
3401164	93965
3424992	93966
3424993	93968
3401315	93969
3401184	93970
3427075	93971
3401551	93973
3415137	93974
3416562	93976
3422347	93977
3421126	93979
3416634	93980
3423839	93982
3416725	93984
3429468	93985
3421926	93986
3430510	93987
3414952	93988
3415047	93990
3415048	93991
3414516	93992
3415336	93993
3415049	93994
3415051	93995
3422471	93996
3415337	93997
3415453	93998
3424994	93999
3415711	94002
3424995	94005
3415924	94006
3415995	94009
3416029	94010
3416030	94011
3416032	94012
3422637	94013
3423685	94015
3423686	94016
3416219	94017
3423669	94018
3423687	94019
3422692	94020
3423193	94021
3423688	94023
3423690	94024
3423592	94025
3423650	94026
3416896	94027
3423593	94028
3417120	94029
3418477	94031
3437334	94032
3421691	94033
3423423	94034
3427479	94035
3429870	94037
3422225	94038
3424144	94039
3424145	94040
3424220	94041
3423424	94042
3429928	94043
3424593	94045
3424639	94048
3426916	94050
3426876	94051
3426945	94052
3425155	94053
3426895	94054
3427299	94056
3426707	94057
3427038	94058
3426562	94059
3427481	94061
3427471	94062
3437569	94063
3427472	94064
3430237	94065
3427588	94066
3428824	94067
3428825	94068
3432329	94069
3427892	94072
3432608	94073
3428923	94075
3433096	94077
3429648	94081
3429649	94082
3432519	94083
3429780	94084
3430238	94086
3430591	94087
3432010	94088
3432011	94089
3432012	94090
3432035	94091
3432013	94092
3432263	94094
3432652	94095
3432470	94096
3432014	94097
3432036	94098
3432015	94099
3432016	94100
3432017	94101
3432019	94102
3432020	94103
3432021	94104
3432022	94105
3431994	94106
3432430	94107
3432726	94108
3431996	94109
3431998	94110
3432156	94112
3432766	94113
3432838	94114
3432860	94115
3809717	94117
3432806	94120
3432463	94121
3432710	94123
3432946	94124
3432947	94125
3432948	94126
3432760	94127
3433227	94129
3433453	94131
3433517	94132
3433364	94133
3437998	94135
3438448	94136
3438409	94137
3438277	94138
3438641	94139
3441647	94143
3438895	94144
3438078	94145
3440788	94147
3439199	94148
3438358	94150
3438454	94151
3438394	94152
3440775	94153
3438295	94154
3438181	94155
3438501	94157
3437322	94158
3438329	94159
3437450	94161
3437984	94162
3437649	94163
3437650	94164
3448392	94165
3443857	94166
3441030	94167
3443858	94168
3438252	94170
3441108	94171
3441176	94172
3438672	94174
3438581	94176
3441402	94178
3438884	94179
3438918	94180
3440398	94181
3438938	94182
3438967	94183
3440214	94184
3441417	94185
3440099	94186
3440523	94187
3440524	94188
3440399	94190
3440557	94191
3440952	94192
3440953	94193
3447289	94194
3447290	94196
3441004	94197
3441330	94198
3441331	94199
3441332	94200
3441333	94201
3441371	94202
3441844	94203
3441627	94204
3441628	94205
3441629	94206
3441292	94207
3441574	94208
3441575	94209
3441342	94210
3441576	94212
3443703	94213
3441822	94214
3441823	94215
3441825	94216
3441837	94217
3443546	94219
3444001	94221
3444510	94222
3444174	94224
3444178	94225
3444787	94227
3443763	94231
3443548	94232
3443764	94233
3444830	94234
3443765	94235
3443848	94237
3444010	94238
3443886	94239
3443911	94240
3443941	94242
3443951	94243
3445069	94246
3447491	94247
3447552	94248
3445337	94249
3445453	94251
3445454	94252
3447094	94253
3447096	94254
3448626	94255
3447098	94256
3448363	94257
3448052	94258
3448171	94260
3446131	94261
3448024	94262
3447819	94264
3447601	94265
3447100	94267
3447101	94268
3447395	94269
3447396	94271
3447466	94272
3459686	94273
3448295	94275
3447763	94276
3450789	94277
3447827	94278
3447993	94280
3448523	94281
3448524	94282
3448525	94283
3448528	94284
3448529	94285
3448595	94287
3448596	94289
3449828	94292
3461649	94293
3449829	94295
3449830	94296
3449766	94297
3450618	94299
3450665	94301
3454639	94303
3476570	94304
3454640	94305
3454641	94306
3458345	94307
3454642	94316
3454815	94317
3456265	94318
3456413	94320
3454781	94321
3455541	94326
3455543	94327
3455544	94328
3458141	94329
3455545	94330
3455610	94331
3455546	94332
3459635	94333
3461311	94334
3484986	94336
3462228	94337
3461373	94338
3456018	94339
3461441	94340
3456163	94341
3456066	94342
3457719	94344
3466420	94346
3462278	94347
3462306	94348
3458198	94349
3461538	94350
3459095	94352
3462388	94353
3459037	94354
3459173	94355
3459591	94356
3462492	94357
3462527	94359
3462332	94360
3461614	94361
3462455	94362
3462175	94364
3462176	94365
3462761	94366
3462372	94367
3462373	94368
3484731	94369
3484732	94370
3464880	94371
3485671	94372
3463104	94373
3464473	94374
3464474	94375
3484664	94376
3465664	94377
3464773	94378
3465281	94380
3465282	94381
3465726	94382
3465747	94383
3465727	94384
3484609	94385
3518336	94386
3465966	94387
3465967	94388
3465968	94389
3467500	94390
3467501	94391
3467537	94392
3467539	94393
3484586	94394
3467731	94395
3468384	94396
3468166	94397
3468203	94398
3468703	94399
3468385	94400
3468215	94401
3468386	94402
3468704	94403
3468818	94405
3469439	94406
3469527	94407
3469441	94409
3469442	94410
3475404	94413
3483026	94414
3475853	94415
3475389	94416
3476858	94417
3475899	94418
3475900	94419
3475902	94420
3475904	94421
3475905	94422
3475906	94423
3476806	94424
3479202	94426
3476841	94427
3478560	94432
3478729	94433
3475144	94434
3478963	94435
3475145	94436
3479251	94437
3475294	94438
3475295	94439
3484920	94440
3475728	94441
3475729	94442
3475730	94443
3475731	94444
3475680	94445
3479403	94446
3476169	94447
3476110	94448
3480172	94449
3476171	94450
3476314	94451
3476779	94452
3476780	94453
3476814	94454
3476782	94455
3482355	94456
3476783	94458
3476815	94459
3482003	94461
3480140	94462
3478119	94463
3484357	94464
3478553	94465
3508422	94466
3478834	94467
3482406	94468
3483140	94471
3482992	94472
3478794	94473
3480068	94474
3479471	94476
3482332	94477
3482533	94479
3480106	94481
3482103	94482
3480107	94484
3482805	94485
3482806	94486
3482807	94487
3482808	94488
3482810	94489
3482811	94490
3481314	94491
3481550	94492
3481924	94493
3481939	94494
3481979	94495
3482624	94498
3482625	94502
3482626	94503
3482627	94504
3491283	94507
3485544	94508
3482485	94509
3484595	94510
3482488	94511
3482541	94512
3482542	94513
3482543	94514
3482667	94515
3483141	94516
3484557	94517
3483146	94518
3484210	94519
3483119	94520
3485005	94521
3485431	94522
3485355	94523
3485348	94524
3485102	94525
3494587	94526
3484211	94527
3485592	94530
3484439	94531
3484399	94532
3484514	94533
3486010	94535
3492215	94536
3486011	94537
3486012	94538
3492374	94539
3491867	94541
3485534	94542
3492001	94543
3486013	94544
3492063	94545
3492649	94548
3492291	94549
3509210	94551
3492994	94553
3492818	94557
3494961	94559
3493011	94560
3498489	94562
3495454	94565
3495365	94566
3494638	94567
3510797	94568
3493007	94569
3491667	94570
3491668	94571
3491675	94572
3491526	94573
3495513	94574
3492201	94576
3492512	94577
3514615	94578
3496281	94579
3496282	94580
3494451	94581
3495437	94585
3495604	94586
3495850	94588
3494452	94589
3498707	94590
3496005	94591
3495127	94592
3495974	94593
3495523	94594
3495128	94595
3495129	94596
3494850	94597
3495212	94598
3495214	94599
3495216	94600
3498829	94601
3496149	94602
3497769	94604
3495810	94607
3495812	94609
3495788	94610
3495975	94611
3496119	94612
3496271	94613
3498861	94615
3915128	94616
3501698	94617
3499388	94621
3501790	94622
3501639	94625
3497866	94626
3497867	94627
3501852	94628
3501894	94630
3498728	94631
3498806	94632
3498807	94633
3501950	94635
3501034	94636
3499175	94637
3499528	94638
3499529	94639
3510909	94641
3511207	94642
4114899	94643
3537515	94645
3511137	94647
3508329	94648
3500893	94649
3508179	94650
3508180	94651
3508181	94652
3508183	94653
3501119	94655
3502179	94656
3508186	94659
3508187	94660
3508188	94661
3508189	94662
3501704	94663
3508190	94664
3508191	94665
3508192	94666
3501791	94667
3508193	94668
3501872	94669
3501874	94670
3502683	94671
3502684	94672
3502119	94673
3502038	94674
3502685	94675
3502686	94676
3527230	94679
3512664	94680
3511218	94682
3513263	94683
3511267	94684
3512194	94685
3511258	94687
3509339	94689
3509381	94691
3511085	94694
3507416	94695
3508235	94696
3518972	94697
3511759	94698
3508652	94700
3509072	94703
3508861	94704
3508864	94705
3508947	94706
3511402	94707
3510707	94708
3513186	94709
3511623	94710
3509422	94711
3540928	94712
3510708	94714
3511648	94715
3511086	94719
3511087	94720
3511403	94721
3511404	94722
3511444	94723
3511831	94724
3511445	94725
3511959	94727
3512129	94728
3512089	94729
3512091	94730
3512092	94731
3513282	94732
3512183	94734
3512184	94735
3512185	94736
3515820	94737
3512682	94738
3512683	94739
3513296	94740
3515402	94742
3514680	94743
3515383	94744
3515971	94745
3515058	94747
3516160	94748
3515263	94750
3514643	94751
3515545	94753
3515546	94754
3515547	94755
3515482	94756
3516490	94757
3516003	94758
3515554	94759
3516642	94761
3515992	94763
3516682	94764
3518231	94766
3516187	94767
3519381	94769
3516360	94770
3521741	94771
3517850	94772
3517984	94773
3527096	94775
3518459	94776
3521201	94780
3518758	94781
3518749	94782
3518033	94783
3518984	94784
3518930	94785
3518863	94786
3537060	94788
3518712	94789
3519061	94790
3519138	94791
3518985	94793
3518986	94794
3519139	94795
3518910	94796
3519141	94797
3519142	94798
3519579	94799
3519357	94801
3519444	94802
3519358	94803
3534499	94805
3519864	94806
3520871	94807
3521137	94808
3521114	94812
3520872	94814
3521361	94816
3521304	94817
3521418	94818
3521634	94819
3639364	94820
3521586	94821
3521881	94822
3521635	94824
3521882	94825
3521883	94826
3544898	94827
3522606	94828
3522071	94829
3522092	94830
3522093	94831
3557745	94832
3522694	94833
3527773	94835
3533517	94836
3546323	94837
3528052	94838
3545974	94839
3545966	94840
3528777	94844
3528680	94845
3527500	94850
3546528	94851
3527437	94852
3528899	94853
3527366	94859
3547021	94860
3528222	94862
3528787	94863
3540378	94865
3528457	94867
3532122	94868
3547049	94869
3547067	94870
3547042	94871
3547121	94872
3535422	94873
3530532	94875
3530430	94876
3530533	94877
3530534	94878
3534650	94879
3534578	94880
3531474	94881
3531604	94882
3533194	94883
3533202	94884
3533195	94885
3534686	94886
3533196	94887
3533197	94888
3532148	94889
3533203	94894
3534787	94896
3533474	94898
3533492	94899
3533475	94900
3533493	94901
3533541	94902
3533542	94903
3534193	94904
3535066	94905
3539593	94906
3534966	94907
3534995	94908
3534531	94909
3534938	94910
3534533	94911
3534437	94913
3534558	94914
3534566	94915
3534572	94916
3534559	94917
3535020	94918
3534614	94919
3534825	94920
3535106	94921
3536852	94924
3539408	94925
3540653	94926
3536237	94927
3536871	94928
3537555	94929
3536993	94930
3540609	94934
3536905	94935
3665417	94937
3546287	94938
3537333	94939
3537334	94940
3537335	94941
3546342	94942
3540849	94943
3540708	94944
3537477	94945
3537516	94947
3555880	94948
3537524	94949
3538070	94950
3538071	94951
3540963	94952
3546391	94953
3540758	94954
3539603	94956
3540879	94958
3539235	94959
3539204	94961
3539594	94962
3545777	94963
3539868	94964
3539790	94967
3540400	94969
3549667	94970
3549028	94971
3540637	94972
3540666	94974
3540880	94975
3540969	94976
3547725	94978
3549891	94979
3546554	94982
3546941	94985
3549737	94988
3546446	94989
3545663	94991
3545706	94992
3545731	94994
3545765	94995
3545833	94996
3546737	94997
3545915	94998
3545968	94999
3546005	95000
3550195	95001
3546906	95002
3550708	95004
3547180	95005
3547450	95007
3551120	95008
3550573	95010
3550857	95012
3548159	95014
3548912	95015
3553227	95016
3550604	95018
3556991	95020
3549791	95021
3550408	95022
3550409	95023
3550410	95025
3551081	95026
3550411	95027
3553393	95028
3550621	95030
3551082	95031
3551305	95032
3550823	95034
3551109	95036
3551311	95037
3551312	95038
3551313	95039
3552723	95040
3551314	95041
3551315	95042
3551316	95043
3553611	95045
3553816	95046
3552534	95049
3553228	95052
3553229	95053
3552945	95054
3553231	95056
3569516	95061
3553482	95062
3553483	95063
3554343	95064
3553484	95065
3553545	95066
3553687	95067
3553798	95068
3553826	95069
3554059	95070
3586555	95072
3557334	95073
3556140	95074
3556689	95075
3557030	95076
3556672	95077
3556143	95078
3556144	95079
3556145	95080
3557111	95081
3556816	95082
3556891	95083
3556893	95084
3557776	95085
3556895	95086
3556896	95087
3556974	95088
3556976	95089
3556977	95090
3557133	95091
3557824	95092
3557408	95093
3557248	95094
3557379	95095
3593299	95096
3593301	95097
3593295	95098
3593308	95099
3568197	95100
3557673	95102
3557520	95103
3557784	95104
3557785	95105
3557786	95106
3560137	95108
3560387	95110
3559355	95111
3560363	95113
3560412	95114
3558981	95116
3560087	95117
3558982	95119
3558911	95120
3560585	95121
3560586	95122
3559921	95123
3559763	95124
3559563	95125
3560625	95127
3560721	95128
3560797	95129
3560778	95130
3560782	95131
3559816	95132
3559868	95133
3560722	95134
3560783	95135
3560558	95136
3565421	95137
3560662	95138
3565554	95140
3560827	95141
3564843	95142
3565748	95145
3565749	95146
3564844	95148
3566749	95152
3566500	95153
3566703	95154
3565613	95158
3589836	95159
3569094	95160
3566361	95161
3566774	95162
3566728	95163
3569560	95164
3566131	95165
3566324	95166
3566344	95167
3566362	95168
3566416	95169
3566704	95170
3568274	95171
3566869	95175
3573046	95176
3569826	95177
3571826	95178
3569697	95179
3571886	95183
3569048	95184
3575242	95185
3569688	95186
3575398	95187
3568492	95190
3569689	95191
3586331	95192
3579391	95193
3569715	95194
3569717	95195
3569446	95196
3569469	95197
3569690	95198
3575770	95202
3569447	95203
3569448	95204
3570028	95205
3570024	95206
3576397	95208
3578512	95210
3572818	95211
3572016	95214
3572542	95215
3572879	95216
3572017	95217
3572001	95219
3572097	95220
3572486	95221
3572492	95222
3572495	95223
3573223	95228
3573258	95230
3593309	95231
3601840	95234
3586332	95237
3574788	95238
3574858	95239
3575176	95240
3575205	95241
3575177	95242
3575270	95243
3575206	95245
3576333	95246
3576334	95247
3575888	95248
3575889	95249
3575512	95250
3575855	95251
3575856	95252
3575960	95253
3575771	95254
3576417	95255
3575961	95256
3575901	95257
3576335	95258
3586334	95259
3586432	95260
3586438	95261
3577736	95262
3589272	95263
3596317	95264
3577737	95265
3577739	95267
3594880	95268
3586335	95269
3577740	95270
3578161	95272
3578162	95274
3578059	95276
3577859	95277
3588432	95280
3578839	95281
3578840	95282
3578712	95283
3578714	95284
3586338	95285
3578902	95286
3579017	95288
3579042	95289
3579078	95290
3579198	95291
3579418	95292
3616634	95293
3586339	95295
3588485	95296
3591697	95301
3589409	95303
3591427	95304
3601420	95305
3595631	95310
3596501	95313
3596336	95316
3616751	95318
3601267	95319
3586340	95320
3586572	95324
3588848	95326
3588851	95327
3589623	95328
3586341	95329
3592388	95331
3586618	95334
3595633	95336
3589326	95337
3604643	95340
3589360	95341
3592455	95342
3589423	95343
3588049	95344
3588787	95347
3588691	95349
3588399	95350
3591366	95351
3588792	95353
3601338	95354
3588740	95356
3588799	95358
3588752	95359
3593338	95360
3601238	95362
3588859	95363
3595025	95364
3588883	95365
3588800	95366
3588618	95367
3588902	95368
3589351	95369
3592223	95370
3589227	95372
3592059	95373
3606532	95374
3592317	95375
3592389	95376
3588763	95377
3591414	95378
3592010	95379
3592011	95380
3589228	95381
3591378	95382
3591382	95384
3589229	95385
3589605	95386
3592090	95387
3589424	95392
3592238	95395
3592417	95396
3593354	95398
3589944	95400
3592275	95402
3592322	95403
3592564	95404
3589615	95405
3589916	95406
3593276	95407
3590030	95408
3590031	95409
3590075	95410
3593364	95412
3593365	95413
3594773	95414
3595218	95415
3618190	95418
3694285	95420
3694230	95421
3592443	95422
3591320	95424
3591321	95425
3591305	95427
3594824	95428
3591476	95429
3601132	95431
3591577	95433
3592323	95435
3592324	95436
3592787	95438
3592774	95439
3593386	95440
3594961	95441
3592284	95442
3592828	95443
3592830	95444
3592831	95445
3593110	95446
3592547	95447
3592832	95449
3592565	95450
3592625	95451
3593259	95453
3593260	95455
3601848	95456
3601815	95457
3593302	95458
3593411	95459
3602899	95461
3601949	95463
3602630	95465
3594740	95467
3601908	95468
3594597	95469
3594847	95470
3594848	95471
3595457	95473
3595458	95474
3595414	95475
3595079	95477
3608232	95478
3595415	95479
3595459	95480
3601575	95481
3601576	95482
3595496	95486
3596134	95487
3596135	95488
3601577	95489
3595991	95491
3602166	95493
3595688	95494
3596407	95495
3595738	95496
3604754	95497
3595992	95498
3602185	95499
3595877	95500
3602770	95501
3596527	95502
3596286	95503
3596305	95504
3601603	95505
3601771	95506
3601476	95507
3605015	95509
3604984	95510
3603020	95514
3604926	95515
3604657	95517
3602996	95518
3603133	95520
3605237	95521
3603083	95522
3606787	95524
3601186	95526
3601188	95527
3601189	95528
3601190	95529
3601191	95530
3601192	95531
3601193	95532
3601194	95533
3601195	95534
3602023	95535
3602057	95536
3608539	95537
3605309	95538
3601604	95539
3606378	95540
3602025	95541
3601342	95542
3611769	95543
3602026	95544
3602060	95546
3601590	95547
3602027	95548
3602028	95550
3612138	95552
3606309	95553
3609280	95555
3602370	95556
3602452	95557
3602810	95558
3602812	95560
3608642	95561
3602814	95562
3606632	95563
3602621	95564
3617872	95565
3602743	95566
3608978	95568
3605094	95569
3609071	95571
3603735	95572
3604939	95573
3606275	95574
3609144	95575
3622535	95576
3605016	95577
3612244	95578
3605157	95579
3612311	95580
3610408	95582
3606276	95583
3612521	95584
3611738	95585
3612579	95588
3610176	95589
3610177	95591
3610178	95592
3610086	95593
3611822	95594
3606093	95595
3606368	95596
3606310	95597
3606328	95598
3606471	95599
3606778	95600
3606779	95601
3613876	95603
3613877	95605
3606693	95606
3606703	95608
3606711	95609
3613878	95610
3606769	95612
3606851	95613
3613015	95614
3613212	95615
3613097	95616
3613370	95617
3613708	95618
3613345	95622
3608072	95623
3608425	95624
3608426	95625
3608894	95626
3608895	95627
3608825	95628
3608290	95629
3608318	95631
3613879	95632
3608827	95633
3613880	95634
3608405	95635
3608748	95637
3609575	95638
3609345	95639
3609810	95640
3609347	95641
3609811	95642
3609523	95643
3609536	95644
3616733	95645
3609861	95646
3610379	95647
3617219	95649
3611650	95650
3611480	95652
3611809	95653
3617297	95654
3613881	95656
3612786	95657
3610873	95658
3617284	95660
3611810	95661
3611481	95662
3611482	95663
3611811	95664
3617600	95665
3612570	95666
3613882	95667
3617379	95668
3611721	95669
3612020	95671
3612390	95672
3612680	95673
3617688	95674
3612475	95675
3613001	95676
3612488	95677
3613765	95678
3613839	95679
3613002	95680
3613767	95681
3613371	95684
3613843	95685
3613844	95686
3613561	95687
3613563	95688
3613378	95689
3613883	95691
3613694	95692
3614083	95693
3614084	95694
3614085	95695
3614194	95696
3614210	95698
3614390	95699
3616561	95700
3616222	95701
3622281	95702
3616223	95704
3616224	95706
3616571	95708
3617325	95709
3617410	95711
3616704	95712
3616727	95713
3618178	95714
3616817	95715
3616840	95716
3616912	95717
3616917	95718
3618179	95719
3617034	95720
3617326	95721
3617035	95722
3617046	95723
3622827	95724
3617411	95725
3618139	95726
3617313	95727
3617569	95729
3617594	95731
3617635	95733
3617637	95734
3617698	95736
3617655	95737
3617734	95738
3617700	95739
3624200	95741
3618180	95742
3618080	95743
3618029	95744
3618087	95745
3618030	95746
3622254	95747
3622255	95748
3619243	95750
3622256	95753
3622257	95754
3619481	95755
3625322	95756
3647051	95759
3622717	95761
3622258	95762
3622259	95763
3622050	95764
3622260	95766
3642440	95767
3622051	95771
3622052	95772
3622124	95773
3621970	95774
3622125	95775
3622126	95776
3622194	95778
3622196	95779
3625736	95780
3622718	95781
3641972	95782
3622719	95783
3642472	95785
3625498	95786
3645888	95787
3647084	95789
3624086	95790
3623545	95791
3625586	95792
3624230	95793
3622965	95795
3623573	95796
3625629	95798
3623812	95799
3623814	95800
3625134	95801
3625139	95802
3625368	95803
3625283	95805
3639327	95806
3639328	95807
3639329	95809
3639350	95810
3625688	95812
3639330	95813
3625581	95814
3639331	95815
3639332	95817
3639017	95818
3652000	95819
3639333	95820
3639335	95821
3639351	95822
3641003	95823
3641005	95824
3642855	95826
3641006	95827
3639957	95828
3641007	95829
3641008	95830
3641009	95831
3641010	95834
3641512	95836
3641012	95837
3641013	95838
3641513	95839
3641514	95840
3642078	95841
3640315	95842
3641515	95843
3640449	95844
3641516	95845
3641884	95846
3641885	95847
3642667	95848
3642436	95852
3642668	95854
3643136	95855
3642973	95856
3642736	95857
3642974	95858
3642786	95859
3642709	95860
3644280	95861
3644281	95862
3644282	95864
3644549	95865
3651941	95866
3644283	95867
3644284	95868
3644285	95869
3644185	95870
3644189	95871
3644196	95872
3644430	95873
3648107	95874
3644431	95876
3647965	95877
3644403	95878
3647966	95879
3647401	95880
3651959	95881
3647248	95882
3647286	95883
3647976	95884
3647977	95885
3647967	95886
3647968	95887
3651964	95888
3648420	95894
3648421	95895
3654970	95896
3648226	95897
3648422	95898
3648275	95899
3648673	95900
3648499	95901
3648586	95903
3655040	95905
3655321	95906
3651428	95907
3651407	95908
3651952	95911
3665488	95913
3652752	95914
3652753	95915
3652177	95916
3652819	95919
3655846	95920
3652550	95921
3652551	95922
3652345	95923
3652552	95924
3653056	95925
3652653	95926
3656258	95928
3665634	95929
3655878	95930
3660351	95932
3654756	95933
3660566	95934
3654757	95935
3656409	95936
3655322	95937
3655323	95938
3656308	95939
3655483	95943
3655484	95944
3656266	95946
3655720	95947
3655722	95948
3655723	95949
3655724	95950
3655746	95951
3656309	95953
3656310	95954
3656311	95955
3660339	95956
3662375	95957
3656338	95958
3656467	95959
3661992	95964
3658931	95965
3660280	95967
3661559	95968
3664842	95969
3660979	95971
3661782	95972
3661594	95973
3661605	95974
3661611	95975
3661493	95976
3662072	95977
3662075	95978
3662366	95979
3661932	95980
3662367	95982
3662311	95983
3662350	95985
3668532	95986
3664387	95988
3664389	95989
3667878	95991
3664390	95992
3664391	95993
3664577	95995
3664578	95996
3664706	95997
3665948	95998
3666269	95999
3665806	96000
3665490	96001
3665807	96002
3665588	96003
3666148	96005
3667901	96006
3666232	96007
3666581	96009
3666582	96010
3677966	96012
3676157	96013
3667903	96015
3677983	96017
3672610	96018
3667501	96019
3671921	96020
3676929	96021
3667752	96022
3676393	96023
3672611	96024
3667795	96026
3676436	96027
3668223	96028
3668396	96030
3672612	96031
3668626	96032
3668759	96033
3668782	96034
3668931	96036
3672613	96037
3669393	96038
3839043	96039
3669718	96040
3673616	96041
3672614	96042
3675828	96043
3674328	96044
3676451	96046
3672669	96048
3678021	96050
3672671	96052
3675784	96054
3671263	96055
3672672	96056
3673143	96057
3673178	96058
3671682	96059
3678443	96060
3673179	96061
3677057	96063
3671913	96064
3673145	96065
3672595	96066
3677093	96069
3672368	96070
3673383	96072
3673345	96073
3672878	96074
3673346	96075
3677223	96076
3674177	96077
3674178	96078
3673491	96080
3674193	96082
3677095	96083
3673890	96084
3675633	96085
3676968	96086
3675634	96090
3675635	96091
3677147	96092
3677096	96093
3675728	96094
3683917	96095
3676235	96097
3676097	96098
3676236	96100
3678140	96101
3678022	96102
3678024	96103
3806419	96108
3678142	96109
3677062	96110
3677224	96118
3677097	96119
3677225	96120
3678055	96121
3678069	96122
3678056	96123
3684383	96124
3678903	96125
3690973	96127
3679565	96128
3682769	96129
3681158	96131
3682770	96134
3682763	96135
3683050	96136
3682771	96137
3691488	96138
3686559	96139
3683918	96140
3684240	96141
3684639	96142
3684655	96143
3683747	96144
3687126	96145
3684241	96146
3684142	96147
3684656	96149
3686424	96150
3684445	96152
3686502	96155
3686493	96156
3686503	96157
3685317	96158
3685439	96159
3685687	96160
3685727	96161
3686476	96162
3689560	96163
3690240	96165
3687544	96166
3687545	96167
3687546	96168
3687620	96169
3687551	96171
3687464	96172
3688102	96173
3688331	96174
3688103	96177
3688157	96179
3688332	96180
3711618	96181
3693799	96182
3690090	96183
3688851	96184
3690255	96185
3690091	96187
3690092	96188
3689636	96189
3690559	96190
3689397	96191
3690093	96192
3690241	96194
3689561	96195
3689963	96197
3690130	96198
3690108	96199
3690242	96200
3690470	96201
3690472	96202
3690243	96203
3690244	96204
3696059	96205
3690131	96206
3690192	96208
3690343	96209
3690509	96210
3690510	96211
3690540	96212
3693495	96213
3690753	96214
3693785	96215
3691076	96216
3690884	96217
3695765	96218
3690981	96219
3691141	96220
3691152	96221
3691153	96222
3757962	96223
3693804	96224
3692859	96225
3694057	96226
3692861	96227
3693285	96229
3692642	96230
3696323	96232
3694291	96233
3696254	96234
3702134	96235
3693747	96237
3694331	96238
3695820	96239
3695902	96240
3694333	96241
3694334	96242
3695858	96243
3693889	96244
3694030	96245
3694309	96246
3694530	96247
3696324	96248
3696691	96249
3696060	96250
3696061	96251
3696063	96252
3696378	96253
3696065	96254
3696066	96255
3696818	96256
3695770	96257
3696753	96258
3695876	96260
3696659	96261
3696754	96262
3696982	96263
3696458	96265
3697060	96266
3696966	96267
3696967	96268
3703295	96269
3696968	96270
3696969	96272
3696970	96273
3697220	96274
3697084	96275
3702916	96277
3696832	96278
3702303	96280
3697328	96281
3705824	96282
3703463	96284
3703202	96285
3699091	96286
3699798	96288
3700149	96289
3703477	96290
3706602	96293
3703120	96294
3701734	96295
3703404	96296
3703334	96297
3839107	96298
3703121	96299
3701604	96302
3701650	96303
3703122	96304
3703123	96305
3703125	96306
3703126	96307
3703128	96308
3703129	96309
3706264	96311
3703130	96312
3702361	96313
3704934	96314
3705017	96315
3703176	96316
3711679	96317
3703035	96318
3703036	96319
3706101	96320
3703270	96321
3705119	96322
3703223	96323
3706063	96324
3703661	96325
3705334	96326
3705372	96327
3703662	96328
3703464	96329
3703572	96330
3838111	96331
3705791	96333
3706076	96335
3705631	96336
3704223	96337
3706251	96339
3705879	96340
3704840	96341
3704896	96342
3706212	96343
3705880	96344
3705881	96345
3705373	96346
3705448	96347
3706791	96348
3705618	96350
3713607	96351
3705882	96352
3705883	96354
3706265	96355
3706331	96356
3706333	96357
3705908	96358
3706335	96359
3708634	96360
3706336	96361
3706961	96362
3706962	96363
3706963	96364
3708818	96365
3708000	96366
3706882	96367
4085583	96368
3706956	96369
3708425	96370
3708001	96371
3708002	96372
3708104	96373
3708257	96375
3708444	96376
3708275	96377
3708368	96378
3708842	96379
3708453	96380
3708931	96381
3708932	96382
3708933	96383
3708935	96384
3708936	96385
3709691	96386
3709692	96387
3711630	96388
3709744	96389
3709720	96390
3712178	96391
3712240	96392
3711635	96393
3712373	96394
3709927	96395
3709957	96396
3711636	96397
3711637	96398
3711638	96399
3710283	96400
3711889	96401
3711803	96403
3712057	96404
3711639	96405
3711640	96406
3711641	96407
3711663	96408
3711664	96409
3712179	96410
3712308	96411
3712309	96412
3715110	96413
3712259	96414
3713275	96416
3713267	96418
3713049	96419
3713050	96420
3713051	96421
3712956	96422
3713379	96423
3713079	96424
3721429	96425
3716193	96426
3713308	96427
3713338	96428
3722873	96429
3713709	96430
3715531	96431
3721489	96432
3721406	96433
3715303	96434
3716169	96435
3715462	96437
3714333	96438
3721288	96439
3715214	96440
3715215	96441
3715216	96442
3715217	96443
3716170	96444
3716424	96445
3715145	96446
3716171	96447
3722550	96448
3716172	96449
3716173	96450
3716542	96451
3716571	96453
3716174	96454
3716600	96455
3716842	96458
3716910	96459
3716911	96460
3718641	96462
3722252	96463
3722461	96464
3721123	96465
3721212	96466
3721213	96467
3721867	96468
3721434	96469
3724592	96470
3721871	96471
3724899	96472
3722462	96473
3722463	96474
3722179	96475
3722805	96476
3722807	96477
3723099	96479
3724647	96480
3724684	96481
3724685	96482
3723341	96483
3723368	96484
3723369	96485
3724552	96486
3728450	96487
3724384	96488
3724553	96489
3724739	96490
3724944	96491
3725018	96492
3725532	96494
3726218	96495
3730185	96496
3731884	96497
3725563	96498
3726173	96499
3733047	96500
3725742	96501
3725978	96502
3725771	96503
3725997	96504
3729089	96506
3726238	96507
3726571	96508
3726377	96509
3726753	96510
3728425	96511
3728426	96515
3728528	96516
3728427	96517
3728429	96518
3728966	96519
3729761	96520
3728699	96521
3728729	96522
3728711	96523
3735387	96524
3728967	96525
3728969	96526
3728785	96527
3729531	96528
3729762	96529
3729532	96530
3729533	96531
3729534	96532
3729763	96533
3729535	96534
3729957	96535
3732175	96536
3732176	96537
3732613	96539
3732177	96540
3732999	96541
3729807	96542
3732178	96543
3732180	96544
3732181	96545
3732338	96546
3732182	96547
3733021	96548
3732183	96550
3732184	96551
3732756	96552
3732185	96553
3732186	96554
3731996	96556
3732078	96557
3732381	96558
3732187	96559
3733307	96560
3733000	96561
3732614	96562
3732615	96563
3733001	96564
3733076	96565
3732102	96566
3732420	96568
3732616	96570
3733257	96571
3736109	96572
3733002	96573
3733245	96574
3733246	96575
3733247	96576
3733248	96577
3735094	96578
3733249	96579
3733250	96580
3733447	96581
3734896	96582
3735699	96583
3733385	96584
3734897	96586
3733619	96587
3736133	96589
3736102	96590
3734898	96591
3734899	96592
3735278	96594
3735280	96595
3735281	96596
3765397	96597
3735282	96598
3735415	96599
3735416	96600
3735457	96601
3735688	96602
3736247	96604
3736258	96605
3736160	96606
3735540	96607
3735553	96609
3735689	96610
3735939	96611
3735690	96612
3735960	96613
3742209	96614
3745166	96615
3741651	96616
3736248	96617
3736365	96618
3736379	96619
3741654	96620
3741656	96621
3741657	96627
3742361	96628
3741798	96629
3741658	96630
3742240	96631
3742195	96633
3741905	96634
3742483	96635
3756568	96637
3740326	96638
3741659	96641
3742356	96642
3741977	96643
3742904	96644
3742702	96645
3741978	96646
3741979	96647
3742046	96649
3742541	96650
3742675	96651
3742676	96652
3742449	96655
3742474	96656
3743303	96657
3742512	96658
3742527	96659
3742677	96660
3742691	96661
3742727	96662
3742737	96663
3742755	96664
3743198	96665
3743200	96666
3745420	96667
3743486	96668
3743047	96669
3743487	96670
3745092	96671
3743172	96672
3743374	96675
3744890	96676
3749381	96677
3745671	96678
3750401	96679
3746522	96680
3746037	96681
3746682	96682
3746039	96683
3746320	96684
3746040	96686
3746691	96688
3746364	96690
3750725	96691
3746692	96692
3746764	96693
3747040	96694
3747041	96695
3747121	96696
3748956	96697
3747367	96698
3750243	96700
3805182	96701
3748890	96702
3750426	96703
3748983	96704
3751020	96705
3749124	96706
3749269	96708
3750137	96709
3750138	96710
3749402	96711
3750139	96712
3750907	96713
3750908	96714
3750909	96715
3750911	96716
3750142	96717
3753585	96718
3749783	96719
3750913	96720
3753163	96721
3750157	96724
3750914	96725
3750427	96726
3750428	96727
3750429	96728
3750599	96729
3750715	96730
3750717	96731
3750719	96732
3750720	96733
3750721	96734
3751003	96735
3751004	96736
3751006	96737
3751007	96738
3751008	96739
3751071	96740
3751072	96741
3751373	96742
3751374	96743
3751375	96744
3751376	96745
3751268	96746
3751269	96747
3752754	96748
3751270	96749
3751334	96750
3751335	96751
3751377	96752
3751378	96753
3751380	96754
3751381	96755
3752773	96756
3751995	96758
3768269	96759
3757031	96760
3752899	96761
3765144	96762
3753711	96763
3754808	96764
3752901	96765
3753446	96766
3753841	96767
3753448	96768
3765215	96769
3758074	96770
3753449	96771
3753624	96772
3753625	96773
3754337	96774
3757780	96775
3753636	96776
3753842	96777
3753684	96778
3753891	96779
3754004	96781
3754012	96784
3765327	96786
3754173	96787
3754250	96789
3754853	96790
3754854	96791
3754375	96792
3757673	96793
3754855	96794
3754875	96795
3754970	96796
3757132	96797
3756374	96798
3764322	96801
3757402	96802
3756375	96803
3756160	96805
3756984	96806
3756985	96807
3756793	96808
3764670	96809
3764589	96810
3757378	96811
3764896	96813
3759938	96814
3769869	96815
3757882	96816
3757915	96818
3757917	96819
3923850	96820
3764244	96821
3764433	96822
3758168	96823
3765415	96824
3768086	96825
3763910	96827
3763911	96828
3763058	96830
3764434	96832
3763912	96834
3763477	96835
3763913	96836
3764245	96837
3764246	96838
3772792	96839
3764198	96840
3764897	96841
3765465	96842
3768365	96843
3764799	96844
3765552	96845
3764976	96846
3765554	96847
3765038	96848
3765066	96849
3765345	96850
3765580	96851
3765555	96853
3765720	96854
3765511	96855
3765610	96856
3765750	96857
3765611	96858
3765856	96860
3766479	96861
3768169	96862
3769000	96863
3769821	96864
3767896	96865
3837818	96867
3767897	96868
3767898	96869
3767705	96870
3767899	96871
3767794	96872
3769011	96873
3769532	96874
3772586	96877
3768271	96878
3768575	96879
3768576	96880
3769012	96881
3769965	96883
3769990	96884
3769095	96888
3769838	96889
3769256	96890
3769157	96891
3769512	96893
3770520	96894
3769554	96895
3769513	96896
3770038	96898
3769490	96900
3773220	96901
3770543	96902
3773184	96903
3770498	96904
3770503	96905
3772330	96906
3771948	96908
3773244	96909
3771949	96912
3771584	96913
3772018	96914
3772020	96915
3773695	96916
3805404	96917
3772587	96918
3773302	96919
3773112	96920
3773186	96921
3808768	96923
3809936	96924
3805561	96925
3805540	96926
3805793	96928
3804776	96931
3807127	96933
3805151	96934
3805467	96935
3805491	96937
3806483	96938
3806484	96939
3806485	96940
3806486	96941
3806839	96942
3806201	96943
3806840	96944
3806841	96945
3806843	96946
3808591	96947
3806912	96948
3807259	96949
3809799	96950
3808870	96951
3808640	96956
3808922	96957
3808488	96958
3808911	96959
3808912	96960
3809918	96961
3809264	96964
3809265	96965
3809267	96966
3809268	96967
3809269	96968
3809280	96969
3819634	96970
3809553	96971
3809586	96972
3809801	96973
3809857	96974
3811495	96975
3811496	96976
3811513	96977
3809969	96978
3809970	96980
3811498	96981
3811507	96982
3811848	96984
3819507	96985
3819492	96986
3819141	96987
3821186	96988
3819143	96992
3822517	96993
3819659	96995
3819495	96996
3819144	96998
3818286	96999
3818293	97000
3818299	97001
3819145	97002
3819720	97003
3819146	97004
3819161	97005
3837238	97006
3821006	97007
3819153	97008
3819496	97009
3819225	97010
3819497	97011
3819861	97012
3821625	97013
3819862	97014
3821231	97015
3820051	97016
3820232	97017
3820233	97018
3820235	97019
3820236	97020
3822552	97021
3822554	97022
3822555	97023
3820272	97024
3821626	97026
3822615	97027
3821464	97028
3821465	97029
3822505	97030
3822617	97031
3822529	97032
3822530	97034
3822755	97035
3875933	97037
3837715	97038
3837942	97039
3837480	97040
3837505	97041
3837240	97042
3837893	97043
3837182	97044
3837184	97045
3837442	97046
3838095	97048
3838112	97050
3839054	97051
3839131	97052
3838051	97053
3839670	97054
3839035	97056
3839037	97058
3839038	97059
3839487	97060
3839820	97061
3839672	97062
3839549	97063
3839948	97064
3839949	97065
3839941	97066
3839863	97067
3923703	97068
3841448	97070
3877320	97071
3865687	97072
3875292	97073
3875302	97075
3875308	97076
3875312	97077
3886435	97078
3877325	97079
3886438	97080
3888382	97081
3888596	97082
3901564	97083
3883189	97084
3902302	97085
3897231	97086
3898542	97087
3899274	97088
3916106	97089
3897432	97090
3908980	97091
3904117	97092
3908013	97093
3904842	97094
3904620	97095
3904905	97096
3930747	97097
3905296	97098
3907930	97099
3907931	97100
3908047	97101
3907932	97102
3907933	97103
3909512	97104
3914869	97105
3908803	97106
3908804	97107
3957140	97108
3909513	97109
3909514	97110
3909515	97111
3915681	97112
3909899	97113
3909900	97114
3909901	97115
3914909	97117
3909943	97118
3910200	97119
3910209	97120
3910503	97122
3914848	97123
3914977	97124
3912377	97125
3922026	97126
3914849	97127
3914641	97128
3914850	97129
3914851	97130
3914942	97131
3915429	97132
3915433	97133
3915434	97134
3915437	97135
3922235	97137
3915194	97138
3915913	97139
3915914	97140
3915916	97141
3922172	97142
3915664	97143
3916169	97144
3916170	97145
3921610	97146
3921571	97147
3921572	97148
3921574	97149
3922078	97150
3922572	97151
3926289	97152
3922080	97153
3923383	97154
3922375	97158
3922081	97159
3922083	97160
3921575	97161
3922085	97162
3922086	97163
3925409	97164
3922087	97165
3921630	97166
3922418	97167
3922037	97168
3922089	97169
3922216	97170
3922422	97171
3922549	97172
3922382	97173
3922423	97174
3922429	97175
3925644	97176
3922566	97177
3922869	97178
3922599	97179
3922657	97180
3923113	97181
3923114	97182
3923115	97183
3925009	97184
3927134	97185
3923704	97186
3923813	97187
3925010	97189
3924015	97190
3926722	97191
3924650	97192
3949417	97195
3926101	97196
3925709	97198
3926620	97199
3926114	97201
3926974	97203
3925880	97204
3925935	97205
3926260	97206
3926382	97208
3926383	97210
3926495	97212
3929478	97213
3930105	97214
3926447	97215
3926609	97217
3926610	97218
3926697	97219
3926583	97220
3926698	97221
3926714	97222
3926753	97223
3926771	97224
3929955	97225
3928479	97226
3927708	97228
3929516	97229
3946592	97230
3928748	97231
3955462	97232
3928750	97233
3929949	97234
3928927	97236
3932085	97238
3929956	97239
3929957	97240
3932173	97242
3929958	97243
3930053	97244
3930042	97245
3929959	97246
3929960	97247
3930054	97249
3932126	97250
3935442	97251
3930072	97252
3932781	97253
3930184	97254
3930333	97255
3930359	97256
3932101	97257
3932104	97258
3932105	97259
3930498	97260
3932107	97262
3930663	97263
3932108	97264
3933499	97265
3932684	97267
3932109	97268
3932110	97269
3932112	97270
3932113	97271
3932114	97272
3932115	97273
3932975	97274
3931838	97275
3931939	97276
3932685	97277
3932686	97278
3932687	97279
3935327	97281
3932316	97282
3932192	97283
3932214	97284
3932215	97285
3932760	97286
3932580	97287
3935575	97288
3932976	97289
3932977	97290
3932978	97291
3932979	97292
3932981	97293
3932982	97294
3932990	97295
3932994	97296
3932995	97297
3932998	97298
3935328	97299
3933274	97301
3933426	97302
3933993	97303
3933866	97304
3933887	97305
3934033	97306
3933908	97307
3935329	97309
3934502	97310
3935330	97311
3935516	97312
3935517	97313
3935519	97314
3935520	97315
3935522	97317
3935786	97319
3935787	97320
4040568	97321
3935560	97322
3936792	97323
3935873	97324
3935888	97325
3936793	97326
3936794	97327
3936820	97328
3936795	97329
3938491	97331
3938493	97332
3939585	97333
3939588	97334
3945601	97335
3939706	97336
3945908	97337
3939894	97338
3940110	97339
3940237	97342
3940166	97343
3940208	97344
3940388	97345
3940389	97346
3940404	97347
3940562	97348
3940567	97349
3940577	97350
3945802	97351
3945279	97352
3941507	97354
3945281	97355
3945282	97356
3945931	97358
3945283	97360
3945284	97361
3945285	97362
3945222	97363
3945229	97364
3945558	97365
3949060	97366
3945321	97367
3955686	97368
3945438	97369
3945439	97370
3945942	97371
3945509	97372
3945584	97373
3945945	97374
3945641	97375
3945948	97376
3945949	97377
3945950	97378
3945731	97379
3945951	97380
3945980	97381
3946347	97382
3946348	97383
3946349	97384
3946421	97385
3946644	97386
3955464	97387
3946601	97388
3946790	97389
3946630	97390
3946743	97391
3946791	97392
3955396	97393
3947071	97394
3946973	97395
3947076	97397
3947273	97398
3947493	97399
3948648	97400
3947507	97401
3988080	97402
3948649	97403
3954765	97404
3949398	97405
3948023	97407
3948034	97408
3949418	97409
3958685	97410
4048883	97411
3949245	97412
3948782	97418
3948743	97419
3948783	97420
3949502	97421
3948761	97424
3948794	97425
3948960	97426
3948963	97427
3954905	97428
3948952	97429
3948982	97430
3949023	97431
3954860	97433
3949016	97434
3949072	97435
3949246	97436
3949504	97437
3954699	97438
3954703	97439
3954704	97440
3954705	97441
3954706	97442
3954715	97443
3954716	97444
3954707	97445
3949505	97446
3949506	97447
3949407	97448
3949409	97449
3954708	97450
3949442	97451
3954723	97452
3954710	97453
3954673	97454
3954674	97455
3954584	97456
3954948	97457
3954981	97458
3954730	97459
3954982	97460
3954983	97461
3954984	97462
3954949	97463
3954970	97464
3958806	97465
3955247	97466
3955265	97467
3955266	97468
3955267	97469
3964287	97470
3955343	97472
3957185	97473
3955661	97474
3955473	97475
3957186	97476
3964270	97477
3955946	97478
3955964	97479
3957944	97482
3957945	97483
3960578	97484
3957946	97485
3957947	97486
3957948	97487
3957949	97488
3957147	97489
4050626	97490
3958110	97491
3958111	97492
3958112	97493
3958114	97494
3958115	97495
3958871	97496
3957539	97497
3958116	97498
3958118	97499
3958119	97500
3958121	97501
3958908	97502
3957789	97503
3962124	97504
3957800	97505
3958028	97507
3958029	97508
3958287	97509
3958198	97510
3958349	97511
3958350	97512
3958494	97513
3958552	97514
3958495	97515
3958554	97516
3958571	97517
3958606	97518
3958929	97519
3958686	97520
3960830	97521
3964328	97522
3958819	97523
3960831	97524
3960832	97525
3960833	97528
3959187	97529
3960835	97530
3962031	97531
3960836	97532
3960837	97533
3962213	97534
3960838	97535
3962163	97536
3960839	97538
3960840	97539
3960841	97540
3960729	97541
3960730	97542
3960751	97543
3960753	97544
3964395	97546
3965296	97547
3964427	97548
3961753	97549
3962181	97550
3961806	97551
3961807	97552
3961808	97553
3962584	97554
3972537	97555
3964091	97558
3964092	97559
3964711	97560
3964712	97561
3964713	97562
3965254	97563
3965257	97564
3964657	97565
3965038	97566
3965258	97567
3964784	97568
3965259	97569
3964873	97570
3965060	97571
3965062	97572
3965871	97573
3965554	97574
3965893	97575
3965894	97576
3966087	97577
3965836	97578
3965838	97579
3965957	97580
3971646	97581
3972066	97582
3971647	97583
3971941	97584
3971943	97586
3971944	97589
3971945	97590
3968776	97591
3972098	97592
3971946	97594
3971947	97595
3972461	97596
3970161	97597
3971950	97598
3972165	97599
3971952	97600
3973593	97601
3972717	97602
3971954	97603
3971955	97604
3971956	97605
3971957	97606
3971958	97607
3972620	97608
3972375	97609
3972623	97610
3972624	97611
3972133	97612
3973313	97613
3972540	97614
3972831	97615
3973632	97616
3972885	97617
3973023	97618
3973766	97619
3973634	97621
3994426	97623
3975715	97624
3974253	97625
3974292	97626
3974305	97627
3974306	97628
3975784	97629
3977125	97630
3974692	97631
3974700	97632
3975707	97633
3996071	97634
3975708	97636
3975831	97637
3975491	97638
3975833	97639
3975616	97640
3975835	97641
3975649	97642
3976832	97643
3976833	97644
3975813	97645
3976554	97646
3976557	97647
3987829	97648
3976835	97649
3976662	97651
3977409	97652
3976854	97654
3987782	97655
3977649	97656
3977650	97657
3977652	97658
3977945	97659
3987913	97660
3978194	97661
3977743	97663
3977844	97665
3977845	97666
3977938	97667
3977967	97668
3988367	97669
3979911	97670
3985910	97672
3987707	97674
3987708	97675
3987709	97676
3988472	97678
3987754	97679
3988473	97680
3987851	97681
3988476	97682
3988043	97683
3989389	97684
3988265	97685
3989390	97686
3989391	97687
3989392	97688
3989393	97689
3989395	97691
3989396	97692
3989397	97693
3989398	97694
3989489	97695
3989399	97696
3992273	97697
3989478	97698
3989480	97699
3989481	97700
3989483	97701
3989821	97702
3989573	97703
3992305	97704
3989694	97705
3989685	97706
3996936	97707
3989918	97708
3990069	97710
4060736	97712
3991766	97713
3990819	97714
3992351	97715
3991996	97717
3991997	97718
3992493	97719
3991981	97720
3992495	97721
4040572	97722
3993062	97723
3993064	97724
3992429	97725
3992727	97726
3993065	97727
3992720	97728
3993066	97729
3993552	97730
3993188	97731
3993627	97732
3993330	97734
3993874	97735
3993629	97736
3993630	97737
3993875	97738
3993582	97739
3993920	97740
3996259	97741
3994131	97742
3994248	97743
3994192	97744
3994298	97745
3994349	97746
3996515	97747
3996525	97748
3996526	97749
3998284	97750
3996516	97751
3996769	97752
3996801	97753
3996517	97754
3996518	97755
3996968	97756
3996969	97757
3996970	97758
4023678	97759
4040099	97760
3996971	97761
4040573	97762
4040574	97763
4040575	97765
4040576	97766
4023190	97768
4023799	97769
3998271	97770
4040577	97771
4042154	97772
3998624	97773
3998626	97774
4023396	97775
4040578	97777
4028662	97778
4028879	97779
4029176	97780
4029145	97781
4023432	97782
4022915	97785
4024260	97786
4022916	97787
4022917	97788
4033961	97789
4022918	97790
4023345	97791
4023347	97792
4023362	97793
4023365	97794
4040579	97796
4023783	97797
4023549	97798
4029096	97799
4040581	97800
4024261	97802
4024262	97803
4040582	97804
4040583	97808
4024628	97809
4040584	97810
4024630	97811
4040585	97812
4025254	97813
4025020	97814
4025021	97815
4025060	97816
4086057	97817
4040586	97818
4040587	97819
4040588	97820
4029373	97822
4034042	97823
4040589	97824
4029147	97825
4029005	97827
4031040	97828
4040590	97830
4040591	97831
4029844	97832
4040592	97833
4040593	97834
4035379	97835
4030390	97836
4030716	97837
4030717	97838
4031041	97839
4040594	97840
4030123	97841
4030132	97842
4031054	97843
4031055	97844
4031262	97845
4040596	97846
4031171	97847
4033518	97853
4040597	97856
4034604	97857
4034606	97858
4040598	97859
4034607	97860
4040599	97861
4040600	97862
4042920	97863
4035157	97864
4035129	97865
4035158	97866
4042943	97867
4035131	97868
4035392	97869
4035395	97870
4037721	97871
4035396	97872
4035398	97874
4040601	97875
4042208	97876
4035433	97877
4037748	97878
4082253	97879
4039052	97880
4037874	97881
4038071	97883
4041515	97884
4037479	97886
4107120	97887
4037480	97888
4037481	97889
4037660	97890
4037482	97891
4049447	97893
4042448	97894
4039053	97895
4038016	97896
4043389	97897
4038017	97898
4040602	97899
4040603	97900
4040605	97901
4038583	97903
4038584	97904
4040607	97905
4040608	97906
4038585	97907
4039311	97908
4040610	97909
4042654	97910
4040611	97911
4040612	97912
4041870	97913
4039312	97914
4040613	97915
4039821	97916
4039984	97917
4041686	97918
4039823	97919
4040615	97920
4039824	97921
4041877	97922
4041387	97923
4041564	97924
4042098	97925
4042099	97926
4042101	97932
4042102	97933
4042103	97934
4042193	97935
4042194	97936
4042248	97937
4042249	97938
4042298	97939
4042458	97940
4043030	97941
4042471	97942
4043032	97943
4043033	97944
4042519	97945
4043112	97946
4043034	97947
4063753	97948
4063754	97949
4043671	97950
4043672	97951
4063756	97952
4048710	97953
4049741	97954
4043399	97955
4043400	97956
4043390	97957
4043947	97958
4049078	97960
4048711	97961
4063757	97962
4048712	97963
4048713	97966
4063758	97967
4048714	97968
4063759	97969
4050153	97970
4063760	97971
4048715	97972
4092121	97973
4049606	97974
4050422	97975
4050433	97976
4052441	97978
4054071	97979
4063761	97981
4052410	97982
4063762	97983
4063764	97984
4050342	97985
4052520	97986
4063765	97987
4050423	97989
4063767	97990
4056516	97991
4050424	97992
4050425	97993
4063768	97994
4050587	97995
4050958	97996
4050960	97997
4066168	97998
4066102	97999
4063769	98000
4051164	98002
4135364	98003
4063770	98004
4052774	98006
4052278	98007
4053670	98008
4053671	98009
4053672	98010
4053674	98011
4053675	98012
4053676	98013
4054090	98014
4053677	98015
4149987	98016
4053936	98017
4063772	98018
4053937	98019
4054537	98023
4060521	98024
4060958	98025
4066289	98026
4055045	98027
4063773	98028
4063775	98029
4056358	98030
4063776	98031
4056359	98032
4058339	98033
4059117	98034
4056361	98035
4056800	98036
4056903	98037
4063777	98038
4063778	98039
4063779	98040
4056362	98041
4056619	98042
4056620	98043
4063780	98044
4063781	98045
4063782	98046
4057387	98047
4058340	98048
4060666	98049
4057389	98050
4104486	98051
4063783	98052
4057577	98053
4057960	98054
4057972	98055
4057973	98056
4058341	98057
4058343	98058
4058345	98059
4067125	98060
4058497	98061
4058543	98062
4059118	98063
4063784	98064
4060513	98065
4060579	98066
4060796	98067
4060689	98068
4060837	98070
4060514	98072
4063785	98073
4061320	98074
4060797	98075
4061322	98076
4061324	98077
4061325	98078
4061326	98079
4063786	98081
4063787	98082
4063788	98083
4062278	98084
4063789	98085
4063045	98087
4063790	98088
4063791	98089
4063793	98090
4063794	98091
4062279	98092
4063795	98093
4063796	98094
4063797	98095
4062281	98096
4062282	98097
4063798	98099
4062283	98100
4063799	98101
4063801	98102
4063802	98103
4063804	98104
4063805	98105
4062284	98106
4062285	98107
4063806	98108
4062286	98110
4062287	98111
4063807	98112
4063808	98113
4062862	98114
4062863	98115
4063046	98116
4063048	98117
4063111	98118
4063124	98119
4063113	98120
4063809	98121
4063810	98122
4066035	98123
4076300	98124
4063811	98125
4063825	98126
4063812	98128
4063814	98129
4063815	98130
4063816	98131
4063817	98132
4066002	98133
4076144	98134
4082373	98135
4067105	98136
4067532	98137
4066820	98138
4082374	98139
4067310	98140
4066821	98141
4082375	98142
4067311	98143
4082376	98144
4082378	98146
4067991	98148
4082379	98149
4067963	98150
4076056	98151
4082381	98152
4082382	98153
4076057	98154
4076058	98155
4082383	98156
4082384	98158
4076059	98159
4082385	98160
4080394	98161
4076060	98162
4076061	98163
4076062	98164
4076076	98165
4078304	98167
4076331	98168
4076332	98169
4076333	98170
4076334	98171
4082386	98173
4076812	98174
4076813	98175
4076817	98176
4076818	98177
4082387	98178
4077347	98179
4082388	98180
4080930	98181
4082390	98183
4082391	98184
4077878	98185
4078273	98186
4082392	98187
4082393	98188
4078274	98189
4086053	98190
4082395	98191
4079959	98192
4080152	98193
4080517	98194
4080153	98195
4082396	98196
4081618	98198
4082397	98199
4080931	98200
4081619	98201
4081620	98205
4081621	98206
4082398	98207
4082427	98208
4082399	98209
4081622	98210
4082032	98211
4082401	98212
4082033	98213
4084528	98214
4082402	98215
4082403	98216
4084419	98217
4082034	98218
4082035	98219
4082036	98220
4082164	98221
4082165	98222
4082404	98223
4082166	98224
4084494	98225
4082579	98226
4082581	98227
4082602	98228
4082603	98229
4085494	98230
4089327	98232
4082747	98233
4092376	98234
4085628	98235
4083171	98236
4083610	98237
4083615	98238
4088385	98239
4083993	98240
4085520	98241
4089607	98242
4084115	98243
4085522	98244
4084875	98245
4098865	98246
4092773	98247
4085524	98248
4085525	98249
4084821	98250
4085085	98251
4089154	98253
4089156	98254
4085344	98255
4089157	98256
4092880	98257
4085831	98258
4091899	98259
4086338	98260
4089609	98262
4087599	98263
4087600	98269
4087602	98270
4089610	98271
4089611	98272
4087879	98273
4092576	98274
4089612	98275
4089613	98276
4089614	98277
4093172	98279
4089615	98280
4089616	98282
4089618	98283
4092252	98284
4089619	98285
4089620	98286
4089621	98287
4093428	98288
4089724	98290
4089725	98291
4089726	98292
4089729	98293
4130985	98294
4089752	98295
4089974	98296
4089975	98297
4089775	98298
4090192	98299
4091428	98301
4091429	98302
4092577	98303
4092578	98304
4106758	98305
4091936	98307
4091937	98308
4091938	98309
4091939	98310
4092579	98311
4098516	98312
4092580	98313
4092805	98314
4092806	98315
4093128	98316
4092774	98317
4093681	98318
4099048	98319
4092933	98320
4093682	98321
4093829	98322
4098517	98323
4094118	98324
4098518	98325
4099428	98326
4098519	98327
4095459	98329
4099080	98330
4108694	98331
4098520	98332
4099111	98334
4096622	98335
4098521	98336
4098522	98337
4098816	98338
4100225	98339
4099900	98340
4098912	98341
4099901	98342
4099902	98343
4099903	98344
4099904	98345
4099526	98346
4099540	98347
4099697	98348
4099893	98350
4100264	98351
4100296	98352
4100695	98353
4100659	98354
4101433	98358
4102473	98359
4102474	98360
4102756	98361
4102757	98362
4102758	98363
4103510	98364
4103412	98365
4103413	98366
4103415	98367
4104323	98368
4103416	98369
4104324	98370
4104325	98371
4104326	98372
4104327	98373
4104644	98374
4103838	98375
4104329	98376
4103699	98377
4104330	98378
4104526	98379
4103852	98380
4104527	98381
4104331	98383
4104428	98384
4104333	98385
4104528	98386
4104091	98387
4110631	98388
4104530	98389
4106937	98390
4104738	98391
4107257	98392
4108299	98393
4105027	98394
4105451	98395
4106552	98396
4106554	98398
4106600	98400
4108695	98401
4107019	98402
4107020	98403
4106955	98404
4107021	98406
4107191	98409
4149781	98411
4107798	98412
4107799	98413
4108364	98414
4107800	98415
4108380	98416
4115693	98417
4108381	98418
4110601	98420
4108382	98421
4107895	98422
4110751	98423
4108763	98425
4108703	98426
4108935	98427
4108978	98428
4109125	98429
4110430	98430
4110431	98431
4110432	98432
4112360	98433
4110851	98434
4110433	98435
4110434	98436
4110435	98437
4110436	98438
4110437	98439
4110860	98440
4111227	98441
4110861	98442
4110862	98443
4110694	98444
4110795	98445
4110825	98446
4112131	98448
4114751	98449
4112132	98450
4112133	98451
4114786	98454
4112134	98455
4112181	98456
4112135	98458
4113043	98459
4114034	98461
4114060	98462
4114064	98463
4114035	98464
4114038	98465
4114039	98466
4114040	98467
4114041	98468
4114042	98469
4114052	98470
4114254	98471
4114682	98472
4115251	98473
4115966	98475
4115550	98476
4115582	98478
4115694	98479
4121133	98480
4121647	98481
4121134	98482
4117241	98484
4118246	98485
4127662	98486
4118990	98487
4119024	98488
4121759	98489
4126568	98490
4121135	98491
4121136	98492
4122818	98493
4121137	98494
4121468	98495
4121469	98496
4122047	98497
4121470	98498
4121471	98499
4121472	98500
4121473	98501
4121256	98502
4122415	98503
4122416	98504
4122417	98505
4126602	98506
4129171	98507
4122253	98508
4122452	98509
4122370	98510
4122487	98512
4122755	98513
4126980	98514
4123075	98515
4122939	98516
4122957	98517
4125613	98518
4123571	98520
4125110	98521
4125111	98522
4123853	98523
4126717	98524
4126860	98525
4125112	98526
4125113	98527
4125363	98528
4129823	98529
4125123	98530
4125364	98531
4125365	98532
4125187	98533
4125366	98534
4126268	98535
4126269	98536
4198425	98537
4126270	98538
4125326	98540
4126271	98541
4125614	98542
4126954	98543
4126272	98544
4126275	98545
4126895	98546
4126309	98547
4126310	98548
4126139	98549
4126743	98550
4126744	98551
4126745	98552
4126746	98553
4129527	98554
4127348	98555
4127350	98557
4127351	98558
4129347	98559
4128905	98560
4128906	98561
4128014	98564
4128907	98565
4128691	98566
4128908	98567
4133248	98568
4129804	98569
4129745	98570
4129805	98571
4129806	98572
4129348	98573
4129282	98574
4133504	98575
4129807	98576
4129841	98578
4129663	98579
4129842	98580
4130001	98581
4133694	98582
4130002	98583
4130003	98584
4129894	98585
4133066	98586
4134655	98587
4149491	98588
4130152	98589
4133654	98590
4138073	98591
4130616	98592
4131508	98594
4131540	98595
4130973	98597
4134049	98598
4131541	98600
4134103	98601
4131417	98602
4131604	98603
4133067	98604
4133441	98609
4133442	98610
4146715	98612
4133197	98613
4138541	98615
4133675	98616
4134325	98617
4134326	98619
4134776	98620
4133791	98621
4134327	98623
4135161	98624
4134777	98625
4135179	98626
4228974	98628
4135056	98629
4134785	98630
4134854	98631
4135231	98632
4135646	98633
4135830	98634
4135831	98635
4137210	98638
4137211	98639
4137212	98640
4138542	98641
4138543	98642
4140954	98643
4138544	98644
4137485	98645
4137520	98646
4138546	98647
4137824	98648
4138547	98649
4138548	98650
4138189	98651
4138287	98652
4138322	98653
4138446	98654
4138474	98655
4139690	98657
4139160	98658
4139691	98659
4139693	98660
4146511	98661
4140955	98662
4139657	98663
4139712	98664
4140956	98665
4149263	98668
4141635	98669
4141653	98670
4142007	98671
4142542	98672
4146646	98675
4195479	98676
4145091	98681
4145398	98682
4148984	98683
4145399	98684
4202991	98685
4145400	98686
4145401	98687
4146152	98688
4146153	98689
4146154	98690
4146155	98691
4146793	98692
4146794	98693
4146797	98694
4146948	98695
4146452	98696
4146798	98697
4146858	98698
4146600	98700
4146998	98701
4149110	98702
4147254	98703
4149164	98704
4149184	98705
4147255	98706
4147200	98707
4149376	98708
4149076	98709
4149659	98710
4147472	98711
4154580	98712
4149204	98713
4149449	98716
4151419	98717
4148782	98719
4148784	98720
4148785	98721
4149586	98722
4149023	98723
4148866	98724
4149024	98725
4149025	98726
4149048	98727
4149026	98728
4149049	98729
4149660	98730
4149172	98733
4149840	98734
4149771	98736
4149878	98737
4153834	98739
4153779	98740
4150270	98741
4150534	98742
4153962	98743
4151186	98744
4152901	98745
4151243	98746
4151289	98747
4151425	98748
4151405	98749
4151431	98750
4152902	98751
4154513	98753
4154794	98754
4153932	98755
4152127	98756
4153092	98757
4183173	98762
4153268	98763
4153281	98764
4153378	98765
4154046	98766
4153552	98767
4157284	98768
4153626	98769
4154047	98770
4154484	98771
4154049	98772
4154050	98773
4153982	98774
4154052	98775
4154756	98776
4154194	98777
4154485	98778
4154148	98779
4154197	98780
4154486	98781
4154265	98782
4154337	98783
4157078	98784
4155586	98785
4155588	98786
4155332	98787
4155385	98788
4155428	98789
4157365	98790
4156819	98791
4157421	98792
4157520	98793
4157079	98794
4157080	98795
4157201	98796
4157202	98797
4156948	98798
4157203	98799
4157204	98800
4157205	98801
4157206	98802
4157207	98803
4157610	98804
4157209	98805
4157210	98806
4157359	98807
4157611	98808
4157612	98809
4157613	98810
4157614	98811
4157366	98813
4157648	98814
4157649	98815
4158335	98816
4158336	98817
4158981	98818
4161109	98819
4158713	98820
4158794	98821
4158780	98822
4158845	98823
4159469	98824
4161241	98825
4159470	98826
4160757	98827
4160762	98828
4160263	98829
4160758	98830
4160878	98831
4160879	98832
4160880	98833
4160881	98834
4160883	98835
4160734	98836
4161420	98837
4160884	98838
4161446	98839
4161070	98840
4160902	98842
4161071	98843
4161387	98844
4161858	98845
4161859	98846
4161699	98847
4161827	98848
4162276	98849
4161973	98850
4162277	98851
4168683	98852
4162278	98853
4162339	98854
4162836	98855
4168749	98856
4168750	98857
4162876	98858
4162527	98859
4162862	98860
4163020	98861
4203120	98862
4167797	98863
4173565	98864
4167798	98865
4164865	98866
4167799	98867
4167800	98868
4167801	98869
4165679	98870
4168751	98871
4172244	98872
4172068	98873
4172392	98874
4170054	98876
4167802	98877
4168752	98878
4173616	98879
4168753	98880
4168017	98881
4169626	98883
4168630	98884
4169710	98885
4169150	98887
4169151	98888
4169627	98889
4169711	98890
4169592	98891
4173673	98892
4169859	98895
4177392	98896
4236433	98897
4183161	98900
4171895	98901
4171896	98902
4171897	98903
4171898	98904
4172773	98905
4172774	98906
4171714	98907
4172775	98908
4172776	98909
4171993	98910
4172777	98911
4179568	98912
4173177	98913
4172559	98915
4177345	98916
4172650	98917
4179708	98918
4183188	98919
4173575	98920
4173343	98921
4173439	98922
4173524	98923
4173566	98924
4179764	98925
4173865	98926
4174017	98927
4175887	98928
4179862	98929
4176351	98930
4174219	98931
4191365	98932
4176065	98935
4175898	98936
4175888	98937
4175889	98938
4175890	98939
4175891	98940
4175782	98941
4175784	98942
4175825	98943
4175826	98944
4181310	98945
4180958	98946
4176604	98947
4177013	98948
4184466	98949
4176543	98950
4177611	98951
4184665	98952
4177233	98953
4177160	98954
4177661	98955
4177854	98956
4180582	98957
4191549	98958
4184995	98959
4190311	98961
4179310	98963
4179301	98964
4179258	98965
4179421	98966
4179423	98968
4180006	98969
4180007	98970
4180008	98971
4183543	98972
4180009	98973
4180252	98974
4179853	98975
4179954	98976
4180583	98977
4180288	98978
4181035	98979
4180817	98980
4181036	98981
4181037	98982
4181038	98983
4183204	98984
4181111	98985
4181569	98986
4181702	98987
4182960	98988
4182094	98989
4185039	98991
4182961	98992
4182962	98993
4182963	98994
4182964	98995
4183205	98996
4182835	98997
4183206	98998
4183207	98999
4183210	99000
4183174	99001
4183175	99002
4183211	99003
4183783	99004
4183784	99005
4183785	99006
4185262	99007
4183951	99009
4184365	99010
4184366	99011
4184202	99012
4184483	99013
4184494	99014
4184273	99015
4184474	99016
4184475	99017
4184476	99018
4184477	99019
4184495	99020
4184496	99021
4184392	99022
4184445	99023
4184425	99024
4185298	99025
4185300	99026
4185301	99027
4185302	99028
4184666	99029
4184574	99030
4184575	99031
4185294	99032
4185277	99033
4185303	99034
4185304	99036
4190116	99037
4190195	99038
4192029	99039
4190117	99040
4190119	99042
4195153	99043
4195396	99045
4195382	99046
4190120	99047
4189094	99048
4190121	99049
4189299	99050
4189898	99051
4190122	99052
4190196	99053
4190268	99055
4190269	99056
4191695	99057
4191865	99059
4191505	99060
4191506	99061
4191507	99062
4191508	99063
4190905	99064
4190534	99065
4191313	99066
4191314	99067
4192152	99068
4191315	99069
4191316	99070
4192153	99071
4191317	99072
4191318	99073
4190841	99074
4191160	99075
4191510	99076
4191286	99077
4195835	99078
4191936	99079
4192015	99080
4192038	99081
4192521	99082
4192495	99083
4195209	99084
4194487	99085
4196533	99086
4194488	99087
4198234	99088
4195921	99093
4196014	99094
4194559	99095
4195002	99096
4194708	99097
4194709	99098
4194710	99099
4194687	99100
4195561	99101
4194892	99102
4194925	99103
4194945	99104
4194964	99105
4196121	99106
4195562	99107
4195222	99108
4196054	99109
4195383	99110
4195407	99111
4195487	99112
4196055	99113
4196056	99115
4195734	99116
4196169	99118
4196171	99119
4196173	99120
4198909	99121
4196384	99123
4196441	99124
4196838	99125
4198632	99126
4198981	99127
4212372	99128
4198259	99129
4199069	99130
4197670	99132
4198261	99134
4198262	99135
4198524	99136
4198263	99137
4198264	99138
4198525	99140
4198526	99141
4198527	99142
4198528	99143
4198205	99144
4198224	99145
4198427	99146
4198428	99147
4198641	99148
4198642	99149
4198483	99150
4198929	99151
4198930	99153
4198931	99154
4198967	99155
4198982	99156
4200174	99157
4199613	99158
4200175	99159
4200176	99160
4200177	99161
4200178	99162
4200986	99163
4200160	99164
4200987	99165
4200989	99166
4201277	99167
4202774	99168
4201280	99169
4202745	99170
4202870	99171
4201369	99172
4202830	99173
4201423	99175
4202746	99176
4266814	99177
4202747	99178
4202748	99179
4202782	99180
4202783	99181
4203037	99182
4203038	99183
4203041	99184
4203042	99185
4203881	99186
4212418	99187
4273321	99188
4203883	99189
4203884	99190
4212324	99191
4203885	99192
4212419	99194
4205096	99195
4205049	99196
4205030	99197
4204605	99198
4212502	99199
4206947	99200
4206948	99201
4205462	99202
4205764	99203
4212761	99205
4206602	99206
4206908	99207
4212926	99208
4212710	99211
4208220	99212
4212887	99213
4208328	99214
4208483	99215
4212685	99216
4216087	99217
4220954	99218
4212686	99219
4212061	99220
4209113	99221
4212962	99222
4214373	99224
4279765	99225
4217138	99227
4212062	99228
4214149	99229
4213785	99230
4216340	99231
4226402	99232
4212116	99233
4218248	99234
4211783	99235
4212117	99236
4305756	99237
4212453	99238
4212454	99239
4212143	99240
4212711	99241
4216436	99242
4212259	99243
4212416	99245
4212789	99246
4212791	99247
4212827	99248
4212828	99249
4213018	99250
4213485	99251
4213963	99252
4216511	99253
4216122	99254
4214027	99255
4214028	99256
4213964	99257
4214120	99258
4214007	99259
4214662	99260
4214218	99261
4214268	99262
4218042	99263
4276960	99264
4218160	99265
4214768	99266
4214802	99267
4216283	99268
4219154	99269
4215927	99270
4220250	99271
4217080	99272
4216095	99273
4217081	99274
4226424	99276
4217036	99277
4217037	99278
4216522	99279
4218810	99280
4217039	99281
4217042	99282
4220946	99283
4217821	99284
4220737	99285
4217822	99286
4217824	99287
4217825	99288
4217826	99289
4217828	99290
4217829	99291
4217830	99292
4217831	99293
4217832	99294
4217833	99295
4218873	99296
4218812	99297
4217834	99298
4217712	99299
4217714	99300
4218003	99301
4218004	99302
4218813	99303
4218814	99304
4222349	99305
4226522	99307
4219896	99308
4220298	99309
4220299	99310
4220300	99311
4221003	99312
4220441	99313
4220442	99314
4220192	99315
4220443	99316
4220444	99317
4222595	99318
4220445	99319
4220710	99320
4224622	99321
4220711	99322
4220446	99323
4220482	99324
4221184	99325
4221446	99326
4221185	99327
4221186	99328
4221189	99329
4220879	99330
4221888	99331
4221211	99332
4221244	99333
4221996	99334
4221447	99335
4221448	99336
4221281	99337
4221324	99338
4221381	99339
4222023	99340
4221350	99341
4221530	99342
4229665	99343
4221909	99344
4221969	99345
4222216	99346
4221797	99347
4222130	99348
4221582	99350
4222808	99351
4222131	99352
4222132	99353
4222529	99354
4221847	99355
4222350	99356
4222252	99357
4222371	99358
4222097	99359
4222321	99360
4222297	99361
4273654	99362
4222472	99363
4226483	99364
4222438	99365
4223272	99366
4222547	99367
4224741	99368
4225139	99369
4224790	99370
4223062	99371
4224823	99372
4224538	99373
4224539	99374
4224855	99375
4237793	99376
4224872	99377
4224540	99378
4224936	99379
4224112	99380
4224541	99381
4225502	99382
4225535	99383
4225192	99384
4226484	99385
4228721	99387
4225150	99388
4226751	99389
4228637	99390
4225049	99392
4225232	99393
4228419	99394
4225140	99395
4229069	99396
4226734	99397
4225545	99398
4228770	99399
4228809	99400
4228756	99401
4228699	99402
4228757	99403
4228792	99404
4228847	99405
4226035	99406
4226174	99407
4230140	99408
4226211	99409
4226212	99410
4230315	99411
4230126	99412
4226485	99413
4226486	99414
4226403	99415
4229162	99416
4229056	99420
4227191	99423
4229217	99424
4273710	99425
4229280	99426
4229317	99427
4228262	99428
4229287	99429
4228426	99430
4229366	99432
4229080	99433
4229081	99434
4229898	99435
4236493	99436
4229863	99437
4228913	99438
4229288	99439
4238324	99440
4229127	99441
4229233	99442
4229234	99443
4230486	99445
4229330	99446
4229425	99447
4229426	99448
4229754	99449
4229755	99450
4273816	99451
4237095	99452
4237578	99453
4230487	99454
4240868	99456
4230401	99457
4236970	99458
4230638	99459
4230692	99460
4237033	99461
4231247	99463
4238145	99464
4237096	99465
4247538	99466
4242425	99467
4237097	99468
4237098	99469
4237099	99471
4241069	99472
4237100	99473
4237101	99474
4237102	99475
4237103	99476
4236494	99477
4237104	99478
4237162	99479
4237164	99480
4241104	99481
4237165	99482
4236919	99483
4237356	99484
4237205	99485
4237263	99487
4237264	99488
4237341	99489
4237889	99490
4237890	99491
4241135	99492
4238146	99493
4238532	99494
4237817	99495
4237857	99496
4238904	99497
4238534	99498
4238271	99499
4238272	99500
4238395	99501
4238905	99502
4238907	99503
4238908	99504
4241376	99505
4240297	99507
4239979	99508
4240299	99509
4240752	99510
4241272	99512
4240952	99513
4241292	99514
4240841	99515
4240984	99516
4240985	99517
4360794	99518
4241009	99519
4241033	99520
4241036	99521
4241864	99522
4241399	99523
4241865	99524
4241867	99525
4241869	99526
4242304	99527
4242025	99528
4242586	99529
4277170	99530
4242949	99531
4243354	99532
4245270	99533
4242950	99535
4243373	99536
4243668	99537
4243669	99538
4245305	99539
4244986	99540
4244987	99541
4244988	99542
4245355	99543
4245356	99544
4246232	99545
4245653	99546
4280548	99547
4245465	99548
4246101	99549
4246400	99550
4254384	99551
4246617	99552
4246794	99553
4247025	99554
4247818	99556
4247263	99557
4247139	99558
4247291	99559
4247820	99560
4247831	99561
4247909	99562
4247822	99563
4247629	99564
4250170	99565
4269174	99566
4249379	99567
4250043	99568
4263198	99569
4249108	99570
4249380	99571
4250044	99572
4250046	99573
4249854	99574
4265061	99575
4250300	99576
4250020	99577
4250022	99578
4263613	99579
4250578	99580
4250637	99581
4251313	99582
4251365	99584
4251520	99585
4251709	99586
4251710	99587
4251507	99588
4251643	99589
4251644	99590
4277113	99591
4252392	99592
4251922	99593
4252272	99594
4252549	99595
4254122	99597
4254198	99598
4254213	99599
4254960	99600
4254123	99601
4254199	99604
4254200	99605
4254201	99606
4254410	99607
4255023	99609
4255024	99610
4255025	99611
4255026	99612
4255148	99613
4254945	99614
4255149	99615
4255150	99616
4255489	99617
4255100	99618
4255162	99619
4255490	99620
4255492	99621
4255566	99622
4266846	99623
4255846	99624
4256474	99625
4256475	99626
4256095	99627
4256476	99628
4256520	99629
4256367	99630
4257586	99631
4267050	99632
4263546	99633
4263519	99634
4263447	99635
4262449	99637
4267090	99638
4257462	99639
4262901	99640
4257698	99641
4262450	99642
4267325	99646
4267348	99649
4262451	99657
4351473	99658
4262571	99659
4262572	99660
4267846	99661
4268252	99662
4258982	99663
4262573	99664
4262574	99666
4262576	99667
4262577	99668
4262185	99669
4263231	99670
4262601	99671
4262603	99672
4262604	99673
4262605	99674
4262287	99675
4262606	99676
4262607	99677
4267017	99678
4262608	99679
4267805	99680
4262462	99681
4262708	99682
4267894	99683
4263233	99684
4263234	99685
4262646	99686
4262698	99687
4264044	99688
4263466	99689
4263467	99690
4268228	99692
4267962	99693
4267963	99694
4272026	99695
4267964	99696
4267966	99697
4268108	99698
4267442	99699
4267967	99700
4269066	99701
4269076	99702
4269151	99703
4267968	99704
4273274	99705
4264594	99707
4272915	99708
4271647	99711
4267969	99712
4267970	99714
4267971	99715
4271749	99716
4267972	99717
4267975	99718
4271402	99719
4266853	99720
4267976	99721
4267977	99722
4267123	99723
4267978	99724
4267979	99725
4267980	99726
4267982	99727
4268035	99728
4268036	99729
4268073	99730
4268037	99731
4268038	99732
4268039	99733
4268041	99734
4268042	99735
4268044	99736
4268140	99738
4272162	99739
4268074	99740
4267998	99742
4268311	99743
4268599	99744
4268788	99745
4268789	99746
4268791	99747
4269712	99748
4269137	99749
4270962	99750
4270963	99751
4269930	99752
4270964	99753
4270965	99754
4270975	99755
4273118	99756
4270966	99757
4270967	99758
4270968	99759
4271095	99760
4271096	99761
4271097	99762
4271098	99763
4273201	99764
4271188	99765
4272565	99766
4272566	99767
4273234	99768
4271812	99769
4272873	99770
4271814	99771
4271942	99773
4275957	99774
4271946	99775
4272568	99776
4272569	99777
4272604	99778
4272605	99779
4272092	99780
4272093	99781
4272465	99782
4272669	99783
4272804	99784
4272805	99785
4273325	99786
4273327	99787
4273328	99788
4273338	99789
4273866	99791
4273502	99792
4273867	99793
4273868	99794
4274034	99795
4276310	99796
4275466	99797
4274769	99798
4275467	99800
4275468	99801
4275469	99802
4275431	99803
4275492	99804
4276207	99805
4275716	99806
4276311	99807
4276209	99808
4276212	99809
4276213	99810
4276574	99811
4276576	99812
4276578	99813
4276579	99814
4276581	99815
4276725	99816
4276473	99817
4279940	99818
4276726	99819
4276704	99820
4278001	99821
4280447	99822
4277333	99823
4278003	99824
4279973	99825
4280448	99827
4280932	99828
4278148	99829
4278160	99830
4280043	99832
4278223	99833
4278327	99834
4280105	99836
4279032	99837
4279357	99838
4279571	99839
4280083	99840
4279624	99841
4279680	99842
4281121	99843
4279904	99844
4281122	99846
4282043	99847
4281123	99848
4281124	99849
4280524	99850
4282045	99851
4280887	99852
4281037	99853
4282046	99854
4281547	99855
4281548	99856
4281549	99857
4281455	99858
4282047	99859
4287816	99860
4282424	99863
4283454	99864
4283615	99865
4288257	99866
4287744	99867
4287745	99868
4287746	99869
4288111	99871
4287747	99872
4287817	99873
4287818	99874
4287819	99875
4287820	99876
4287821	99877
4287842	99878
4288031	99879
4288635	99881
4288014	99882
4288636	99883
4288637	99884
4288717	99885
4298346	99886
4288638	99887
4292936	99888
4288432	99889
4288280	99890
4289068	99891
4289069	99893
4288958	99894
4289022	99895
4289326	99896
4289637	99897
4293807	99898
4289753	99899
4293952	99900
4290418	99901
4292253	99902
4292701	99903
4292254	99904
4292702	99905
4292255	99907
4292703	99908
4292704	99909
4293914	99910
4292705	99911
4297906	99913
4293162	99914
4293163	99915
4302187	99916
4293076	99917
4293560	99918
4293561	99919
4293562	99920
4293823	99921
4294077	99922
4297969	99923
4298444	99924
4293824	99925
4294078	99926
4293960	99927
4294266	99929
4294574	99930
4294330	99931
4294464	99932
4295045	99933
4294529	99934
4296657	99936
4296549	99939
4302872	99940
4297208	99941
4297209	99943
4296996	99944
4297254	99945
4297066	99946
4297348	99947
4297593	99948
4297594	99949
4303484	99950
4298155	99951
4298525	99952
4298723	99953
4298724	99954
4298526	99955
4298527	99956
4298725	99957
4298834	99958
4302343	99959
4298835	99960
4299109	99961
4316907	99962
4299960	99963
4302696	99964
4299962	99965
4302370	99966
4302753	99967
4301494	99969
4301496	99970
4301499	99971
4301500	99972
4302957	99973
4302959	99974
4301641	99975
4301446	99976
4301705	99977
4301706	99978
4301707	99979
4302776	99980
4302493	99981
4302848	99982
4318144	99984
4302960	99985
4302962	99986
4302376	99987
4302433	99988
4302467	99989
4302708	99990
4302710	99991
4302711	99992
4302538	99993
4302540	99994
4302927	99995
4302566	99996
4302928	99997
4303920	99998
4302963	99999
4305972	100000
4303267	100001
4303001	100002
4303268	100004
4303806	100005
4303921	100007
4303922	100008
4303857	100009
4304011	100010
4304012	100011
4305708	100013
4306041	100014
4305709	100015
4321436	100016
4307481	100017
4304678	100018
4304986	100020
4305744	100022
4305715	100023
4305318	100024
4305716	100026
4307362	100027
4306287	100028
4306104	100029
4307069	100031
4321496	100032
4307484	100033
4306988	100034
4307485	100035
4307486	100036
4307363	100037
4308142	100039
4316791	100040
4317351	100041
4308179	100042
4318240	100043
4316792	100044
4317222	100045
4312280	100046
4317318	100047
4314601	100050
4317087	100052
4317056	100053
4316793	100054
4317240	100055
4317106	100056
4317039	100057
4317040	100059
4317041	100060
4317174	100061
4317717	100062
4317718	100063
4317719	100064
4317720	100065
4317721	100066
4317722	100067
4317723	100068
4317724	100069
4317725	100070
4317726	100071
4317727	100072
4317728	100073
4317687	100074
4317409	100075
4317689	100076
4317690	100077
4317691	100078
4317692	100079
4317693	100080
4317735	100081
4317978	100082
4317708	100083
4318000	100084
4318677	100085
4318369	100086
4318304	100087
4331700	100088
4318558	100089
4322417	100090
4319071	100091
4319240	100092
4322501	100093
4322600	100094
4320880	100096
4323389	100097
4320881	100100
4320882	100101
4320883	100102
4321844	100104
4321845	100105
4322746	100106
4322031	100107
4322032	100108
4322033	100109
4322232	100110
4322233	100111
4322235	100112
4322236	100113
4322238	100114
4322239	100115
4322242	100116
4321703	100117
4322243	100118
4323020	100119
4322170	100120
4322357	100121
4322530	100122
4322828	100123
4322829	100124
4326834	100125
4323147	100127
4323201	100128
4323505	100129
4323938	100130
4323749	100131
4323786	100132
4325233	100133
4326941	100134
4325234	100135
4325236	100136
4325237	100139
4325551	100140
4325553	100141
4325554	100142
4325555	100143
4325454	100144
4325654	100145
4325742	100146
4325745	100147
4326065	100148
4326067	100149
4326001	100150
4326019	100152
4325775	100153
4326069	100154
4326134	100155
4326136	100156
4326100	100157
4326461	100159
4326739	100160
4327366	100161
4327572	100162
4327007	100163
4327787	100164
4327788	100165
4330028	100166
4327425	100167
4327397	100168
4327692	100169
4327686	100170
4328095	100171
4327973	100172
4328448	100174
4353325	100176
4329777	100178
4329338	100179
4329778	100180
4330905	100181
4329869	100182
4329930	100183
4331339	100184
4330906	100185
4330909	100186
4330261	100187
4330610	100188
4330614	100189
4330616	100190
4330910	100191
4330813	100192
4331753	100193
4330959	100194
4330969	100195
4331811	100196
4331389	100197
4331366	100199
4331400	100200
4331303	100201
4353326	100202
4331701	100203
4331703	100204
4331754	100205
4331755	100206
4332173	100207
4332321	100208
4332071	100210
4332323	100211
4332130	100212
4332193	100213
4332233	100215
4332236	100216
4332237	100217
4332255	100218
4332256	100219
4332257	100220
4332273	100221
4332433	100222
4332535	100223
4332627	100225
4354009	100226
4353328	100227
4335046	100228
4353329	100229
4335038	100230
4353330	100231
4353332	100232
4353334	100233
4335282	100234
4354010	100235
4353335	100236
4356031	100237
4353337	100238
4353338	100239
4353339	100240
4356606	100241
4353340	100242
4353341	100243
4353342	100244
4353343	100246
4356473	100247
4353344	100249
4353346	100250
4353347	100251
4353349	100252
4353350	100253
4353351	100254
4353353	100255
4353354	100256
4353355	100257
4353356	100258
4353357	100259
4353358	100261
4353359	100262
4353360	100263
4356003	100264
4355847	100266
4353361	100267
4353362	100268
4355778	100269
4356104	100270
4356577	100271
4353363	100272
4353364	100273
4353365	100274
4353366	100277
4353368	100278
4353369	100279
4353370	100280
4353371	100281
4353372	100282
4353373	100283
4353374	100284
4353377	100285
4353378	100286
4354015	100287
4353379	100288
4353380	100289
4353381	100290
4343450	100291
4353383	100292
4353385	100293
4353386	100294
4356544	100295
4343885	100296
4356171	100297
4353387	100298
4353388	100299
4353389	100300
4353390	100301
4353392	100302
4353393	100303
4344206	100304
4353394	100305
4353426	100306
4353395	100307
4353397	100308
4353398	100309
4353399	100310
4353400	100311
4353692	100312
4353401	100313
4353403	100314
4353405	100315
4356109	100316
4357079	100317
4353650	100318
4353427	100319
4353428	100320
4353429	100321
4353407	100322
4353408	100323
4355582	100324
4356658	100325
4356681	100326
4367972	100327
4353409	100328
4353430	100329
4353431	100330
4353411	100331
4353412	100332
4353432	100333
4353413	100334
4353414	100335
4353415	100336
4353433	100337
4353434	100338
4353435	100339
4353416	100340
4353417	100341
4347756	100342
4353436	100343
4353437	100344
4353439	100345
4353440	100346
4347943	100347
4353441	100348
4353442	100350
4353443	100351
4353444	100352
4353445	100353
4353446	100354
4353447	100355
4353448	100358
4353449	100359
4353877	100360
4353450	100361
4353451	100364
4353878	100365
4360761	100366
4353452	100367
4351670	100368
4355151	100370
4353453	100371
4353454	100372
4353455	100373
4353879	100374
4353456	100375
4353457	100377
4356787	100378
4353458	100380
4362079	100381
4353460	100382
4353461	100383
4353462	100384
4353463	100385
4356788	100386
4360985	100387
4356789	100388
4353464	100389
4353465	100391
4357167	100392
4353466	100393
4353467	100394
4353418	100395
4360952	100396
4353881	100397
4353468	100398
4353470	100399
4356975	100401
4353471	100402
4353472	100403
4353882	100404
4353419	100405
4353883	100406
4360670	100407
4353473	100408
4353799	100409
4353801	100410
4353884	100411
4357262	100412
4353802	100413
4355209	100414
4361948	100415
4354508	100416
4355454	100417
4355455	100418
4355038	100422
4355143	100423
4355456	100424
4355400	100425
4355486	100426
4356537	100430
4356878	100431
4356886	100432
4356879	100433
4357063	100434
4356864	100435
4356950	100436
4357064	100437
4356978	100438
4358803	100439
4357666	100440
4357148	100441
4358804	100442
4358805	100443
4357667	100444
4358808	100445
4361380	100446
4358809	100447
4358811	100448
4358812	100449
4358813	100450
4358890	100452
4359010	100453
4362125	100454
4359859	100455
4360383	100456
4360727	100457
4368353	100458
4360728	100459
4360729	100460
4360731	100461
4360732	100462
4360671	100463
4361381	100464
4361867	100465
4361383	100466
4360851	100467
4361076	100468
4361084	100469
4361078	100470
4361098	100471
4361384	100472
4361385	100473
4361147	100474
4361620	100475
4361621	100476
4361622	100477
4361868	100479
4368324	100480
4361870	100481
4361880	100482
4361881	100483
4362424	100485
4362315	100486
4362425	100487
4367925	100488
4362891	100489
4367939	100490
4367927	100491
4367928	100494
4368044	100495
4367929	100496
4367930	100498
4367931	100502
4368511	100503
4367932	100504
4368067	100505
4368068	100506
4368000	100507
4368001	100508
4368023	100510
4368024	100511
4368025	100512
4368554	100513
4368026	100514
4368033	100515
4368034	100516
4368099	100517
4368543	100519
4368545	100520
4368546	100521
4368547	100522
4368602	100525
