#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'На продакшене порядка 3 минут',
        comment => q[
            Переотправляем в БК сайтлинки со спец параметрами в урлах. Раньше не было поддержки параметров в сайтлинках.
            Переотправится примерно 75 773 объявлений, из 881 кампаний, принадлежащих 60 пользователям (без учета денег на кампании)
                С учетом денег: 71 824 баннер, 782 кампании, 45 пользователей.

            Запускать после перезапуска bsClientData.pl после выкладки пакета (примерно через 5-10 минут)
        ],
    }

=cut

=head1 Review board
    
    http://rb.yandex-team.ru/direct/r/1295/
    
=cut

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

my $sql = qq{
  select bid, cid
    from (
           select distinct sitelinks_set_id 
             from sitelinks_links sl 
                  left join sitelinks_set_to_link ln using(sl_id) 
            where href rlike '\{(param1|param2|source|source_type|position_type|position|keyword|addphrases)\}') t 
    left join banners b on t.sitelinks_set_id = b.sitelinks_set_id left join campaigns c using(cid)
   where b.statusBsSynced = 'Yes' 
};

$log->warn("start");

my $bids_list = get_all_sql(PPC_HEAVY, $sql) || [];

my $cnt = scalar @$bids_list;

$log->warn("todo: $cnt");

while (my @chunk = splice @$bids_list, 0, 5000) {

    do_mass_insert_sql(PPC, 'insert ignore into bs_resync_queue (cid, bid) values %s'
                        , [ map {[$_->{cid}, $_->{bid}]} @chunk ]
                        , { dont_quote => 1 });

    $cnt -= scalar(@chunk);
    $log->out("remains: $cnt");    
    sleep(5);
}

$log->warn("end.");
