#!/usr/bin/perl -w

=head1 DEPLOY
# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        comment => "возвращает потерянные флаги unfamily в Директ",
        time_estimate => '15 минут'
    }

=cut

=head1

    Скрипт сожержит номера объявлений взрослой тематики.
    Проставляет для них соотвествующие флаги в Директе.
    
=cut

use strict;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use Yandex::Log;
use List::MoreUtils qw(uniq);
use Data::Dumper;
use ScriptHelper;

$log->out("START");

my $cnt = 0;
my $cache = {};

$log->out("START PROCESS");

while(<DATA>) {
    chomp;
    my ($cid, $bid, $flags) = split(/\t/, $_);
    push @{ $cache->{ $flags } }, { cid => $cid, bid => $bid };
}

foreach my $flags (keys %$cache) {
    
    while (my @slice = splice @{ $cache->{$flags} }, 0, 1000) {

        $log->out({flags => $flags, entries => \@slice});
        
        my @bids = map { $_->{bid} } @slice;
        
        # обновляем флаги и переотправляем в БК
        do_update_table(PPC, 'banners', { flags => $flags}, where => { bid => \@bids });

        do_mass_insert_sql(PPC, 
                           'insert ignore into bs_resync_queue (cid, bid) values %s',
                           [ map {[$_->{cid}, $_->{bid}]} @slice ],
                           { dont_quote => 1 });

        sleep(5);
    }
}

$log->out("END.");

__DATA__
3520652	27643181	weapons,unfamily
529352	1097369	unfamily,magic
1956672	9485249	unfamily,magic
3514556	27517618	unfamily,magic
3514556	27537653	unfamily,magic
3514556	27538376	unfamily,magic
3514556	27567160	unfamily,magic
3514556	27826629	unfamily,magic
2454804	29105090	unfamily,magic
3566875	29593529	unfamily,magic
3514556	32877116	unfamily,magic
3514556	32877413	unfamily,magic
3514556	34899245	unfamily,magic
4129903	52143728	unfamily,magic
4129903	52350670	unfamily,magic
3566835	29591112	detective,unfamily
3566835	30321031	detective,unfamily
3566835	30321066	detective,unfamily
4323479	52821765	copyright,unfamily
2906513	14203655	unfamily,medicine
2906552	14206055	unfamily,medicine
3922322	43634397	unfamily,medicine
3751162	45345223	unfamily,medicine
206779	475009	medicine,unfamily
2456525	9241483	medicine,unfamily
3337963	27757242	medicine,unfamily
3608487	29954096	medicine,unfamily
3647078	30948681	medicine,unfamily
3647078	30948686	medicine,unfamily
3530787	32817553	medicine,unfamily
3163219	37564938	medicine,unfamily
4131651	43093867	medicine,unfamily
3647078	51534985	medicine,unfamily
2282012	51931097	medicine,unfamily
4339102	52775000	medicine,unfamily
1570626	10702826	unfamily,detective
4131651	43093835	finance,unfamily
202042	254150	unfamily
202042	254190	unfamily
202042	254197	unfamily
708584	1008784	unfamily
708584	1008785	unfamily
633622	1129576	unfamily
560169	1501880	unfamily
894909	1755117	unfamily
756718	2027747	unfamily
1456495	3430690	unfamily
1588568	4047317	unfamily
1588568	4093429	unfamily
1588568	4093438	unfamily
1588568	4093447	unfamily
1588568	4093450	unfamily
1588568	4093466	unfamily
1588568	4093475	unfamily
1588568	4093483	unfamily
1588568	4356404	unfamily
1680943	4583936	unfamily
1007648	4716826	unfamily
1695055	4812527	unfamily
1588568	4892601	unfamily
1640256	5094033	unfamily
1588568	5260364	unfamily
1588568	5260603	unfamily
1660998	5996465	unfamily
1588568	6007794	unfamily
1588568	6011049	unfamily
1588568	6011106	unfamily
1588568	6090055	unfamily
1569075	6139001	unfamily
1588568	6292990	unfamily
1695055	6315209	unfamily
1615880	6332940	unfamily
1432269	6343771	unfamily
1968875	6526588	unfamily
1968875	6638730	unfamily
2048391	6926058	unfamily
1663025	7802162	unfamily
1588568	9626814	unfamily
2530908	9961056	unfamily
2065831	10029524	unfamily
2349274	10051078	unfamily
2650948	10215288	unfamily
1570626	10250883	unfamily
1570626	10251072	unfamily
1570626	10252460	unfamily
1570626	10252537	unfamily
1570626	10252636	unfamily
1570626	10667127	unfamily
1570626	10667845	unfamily
2128714	10689501	unfamily
1900056	10723571	unfamily
2726891	10807550	unfamily
2730509	10917138	unfamily
2730509	10917157	unfamily
2803353	11603346	unfamily
2065831	11844129	unfamily
1588568	12313619	unfamily
2857198	12743717	unfamily
1588568	12834609	unfamily
1588568	12849312	unfamily
2857198	14558262	unfamily
2857198	14851361	unfamily
2857198	14851362	unfamily
2857198	14851367	unfamily
2857198	14851374	unfamily
2857198	14851376	unfamily
2857198	14851384	unfamily
2857198	14851385	unfamily
2857198	14851393	unfamily
2857198	14851397	unfamily
2857198	14851399	unfamily
2857198	14851401	unfamily
2857198	14851405	unfamily
2857198	14851408	unfamily
2857198	14851409	unfamily
2857198	14851414	unfamily
2857198	14851416	unfamily
2857198	14851417	unfamily
2857198	14851419	unfamily
2857198	14851428	unfamily
2857198	14851431	unfamily
2857198	14851433	unfamily
2857198	14851439	unfamily
2857198	14851441	unfamily
2857198	14851447	unfamily
2857198	14851452	unfamily
2857198	14851459	unfamily
2857198	14851465	unfamily
2857198	14851468	unfamily
2857198	14851481	unfamily
2857198	14851486	unfamily
2857198	14851488	unfamily
2857198	14851491	unfamily
2857198	14851498	unfamily
2857198	14851500	unfamily
2857198	14851503	unfamily
2857198	14851504	unfamily
2857198	14851508	unfamily
2857198	14851511	unfamily
2857198	14851512	unfamily
2857198	14851514	unfamily
2857198	14851516	unfamily
2857198	14851517	unfamily
2857198	14851523	unfamily
2857198	14851524	unfamily
2857198	14851526	unfamily
2857198	14851527	unfamily
2857198	14851530	unfamily
2857198	14851536	unfamily
2857198	14851539	unfamily
2857198	14851540	unfamily
2913812	14968927	unfamily
2948003	15439831	unfamily
1431203	16288485	unfamily
3104699	18237356	unfamily
3104699	18237360	unfamily
2049090	18622777	unfamily
2366842	18792828	unfamily
3098897	18965276	unfamily
3150943	19278372	unfamily
1749719	19349622	unfamily
2794155	20165666	unfamily
1695055	20369397	unfamily
1619674	20676033	unfamily
3071041	20714954	unfamily
1588568	21314239	unfamily
1588568	21314298	unfamily
1588568	21314559	unfamily
1968875	21429179	unfamily
2663261	22858792	unfamily
3313036	23090114	unfamily
3336021	23550945	unfamily
1695055	23575776	unfamily
3342753	23802189	unfamily
3342753	23804363	unfamily
3342753	23804376	unfamily
3342753	23804679	unfamily
1588568	23855908	unfamily
1588568	23856687	unfamily
1588568	23857911	unfamily
3323746	24080403	unfamily
3191531	24126715	unfamily
3336021	24139598	unfamily
3362955	24219253	unfamily
3362955	24219411	unfamily
3321187	24308885	unfamily
3361413	24513193	unfamily
3169937	24757797	unfamily
1588568	24839911	unfamily
3391265	24882071	unfamily
3391265	24882072	unfamily
3391265	24882081	unfamily
3391265	24882085	unfamily
3391265	24882086	unfamily
3391265	24882087	unfamily
3391265	24882090	unfamily
3391265	24882092	unfamily
3391265	24882093	unfamily
3391265	24882096	unfamily
3391265	24882098	unfamily
3391265	24882099	unfamily
3391265	24882105	unfamily
3391265	24882106	unfamily
3391265	24882108	unfamily
3391265	24882109	unfamily
3391265	24882111	unfamily
3391265	24882118	unfamily
3391265	24882122	unfamily
3391265	24882124	unfamily
3391265	24882125	unfamily
3391265	24882126	unfamily
3391265	24882127	unfamily
3391265	24882134	unfamily
3391265	24882137	unfamily
3391265	24882141	unfamily
3391265	24882143	unfamily
3391265	24882151	unfamily
3391265	24882152	unfamily
3391265	24882153	unfamily
3391265	24882158	unfamily
3391265	24882161	unfamily
3391265	24882162	unfamily
3391265	24882165	unfamily
3391265	24882166	unfamily
3391265	24882169	unfamily
3391265	24882176	unfamily
3391265	24882178	unfamily
3391265	24882180	unfamily
3391265	24882181	unfamily
3391265	24882182	unfamily
3391265	24882183	unfamily
3391265	24882188	unfamily
3391265	24882190	unfamily
3391265	24882198	unfamily
3391265	24882203	unfamily
3391265	24882205	unfamily
3391265	24882206	unfamily
3391265	24882210	unfamily
3391265	24882212	unfamily
3391265	24882214	unfamily
3391265	24882222	unfamily
3391265	24882226	unfamily
3391265	24882228	unfamily
3391265	24882232	unfamily
3391265	24882233	unfamily
3391265	24882234	unfamily
3391265	24882235	unfamily
3391265	24882241	unfamily
3391265	24882246	unfamily
3391265	24882247	unfamily
3391265	24882248	unfamily
3391265	24882254	unfamily
3391265	24882256	unfamily
3391265	24882258	unfamily
3391265	24882268	unfamily
3391265	24882279	unfamily
3391265	24882280	unfamily
3391265	24882281	unfamily
3391265	24882287	unfamily
3391265	24882288	unfamily
3391265	24882291	unfamily
3391265	24882292	unfamily
3391265	24882294	unfamily
3391265	24882295	unfamily
3391265	24882297	unfamily
3391265	24882312	unfamily
3391265	24882348	unfamily
3067128	27035561	unfamily
3516603	27573401	unfamily
3067128	27901693	unfamily
3067128	27945001	unfamily
3391265	24882299	unfamily
3391265	24882300	unfamily
3391265	24882302	unfamily
3391265	24882303	unfamily
3391265	24882308	unfamily
3391265	24882309	unfamily
3391265	24882310	unfamily
3391265	24882311	unfamily
3391265	24882313	unfamily
3391265	24882316	unfamily
3391265	24882318	unfamily
3391265	24882319	unfamily
3391265	24882325	unfamily
3391265	24882326	unfamily
3391265	24882327	unfamily
3391265	24882329	unfamily
3391265	24882331	unfamily
3391265	24882332	unfamily
3391265	24882333	unfamily
3391265	24882336	unfamily
3391265	24882338	unfamily
3391265	24882341	unfamily
3391265	24882346	unfamily
3391265	24882347	unfamily
3391265	24882350	unfamily
3391265	24882352	unfamily
3391265	24882357	unfamily
3391265	24882359	unfamily
3391265	24882363	unfamily
3391265	24882367	unfamily
3391265	24882369	unfamily
3391265	24882370	unfamily
3391265	24882372	unfamily
3391265	24882376	unfamily
3391265	24882377	unfamily
3391265	24882381	unfamily
3391265	24882384	unfamily
3391265	24882387	unfamily
3391265	24882389	unfamily
3391265	24882392	unfamily
3391265	24882393	unfamily
3391265	24882394	unfamily
3391265	24882396	unfamily
3391265	24882397	unfamily
3391265	24882404	unfamily
3391265	24882407	unfamily
3282983	24958728	unfamily
3282983	24958729	unfamily
3282983	24958731	unfamily
3282983	24958732	unfamily
3282983	24958734	unfamily
3336021	25121232	unfamily
3408710	25209244	unfamily
3408710	25304364	unfamily
3408710	25304366	unfamily
3408710	25304367	unfamily
3408710	25304374	unfamily
3408710	25304379	unfamily
3408710	25304419	unfamily
3408710	25304428	unfamily
3408710	25304455	unfamily
3408710	25304464	unfamily
3408710	25304465	unfamily
3408710	25304467	unfamily
3408710	25304661	unfamily
3408710	25304662	unfamily
3408710	25304663	unfamily
3408710	25304664	unfamily
3408710	25304665	unfamily
3408710	25304666	unfamily
3408710	25304667	unfamily
3408710	25304738	unfamily
3408710	25304739	unfamily
3408710	25304740	unfamily
3408710	25304841	unfamily
3408710	25304846	unfamily
3408710	25304850	unfamily
3408710	25304892	unfamily
3408710	25304893	unfamily
3408710	25304895	unfamily
3408710	25304896	unfamily
3408710	25304897	unfamily
3443095	26047328	unfamily
1588568	26211124	unfamily
1588568	26211568	unfamily
1588568	26212612	unfamily
3393343	26904088	unfamily
3361057	26960194	unfamily
3282801	27096294	unfamily
1588568	27399301	unfamily
3479828	27416065	unfamily
3514556	27533902	unfamily
3514556	27534230	unfamily
1619674	27562132	unfamily
1695055	27567259	unfamily
3516603	27573400	unfamily
3516603	27573402	unfamily
3516603	27573403	unfamily
3516603	27573404	unfamily
3516603	27573405	unfamily
3516603	27573406	unfamily
3365199	27622662	unfamily
3067128	27944996	unfamily
3519958	28035804	unfamily
3519958	28035820	unfamily
3519958	28035823	unfamily
3519958	28035832	unfamily
3519958	28035876	unfamily
3519958	28035899	unfamily
3519958	28035900	unfamily
3519958	28035913	unfamily
3519958	28035941	unfamily
3519958	28035960	unfamily
3519958	28035992	unfamily
3519958	28035997	unfamily
3519958	28036019	unfamily
3519958	28036020	unfamily
3519958	28036028	unfamily
3519958	28036059	unfamily
3521859	28070030	unfamily
3478855	28676009	unfamily
3566835	28805896	unfamily
3566835	28805903	unfamily
3566835	28805909	unfamily
3566835	28805925	unfamily
3566835	28805954	unfamily
3566835	28805966	unfamily
3566835	28805978	unfamily
3566835	28805989	unfamily
3566835	28806011	unfamily
3566835	28806016	unfamily
3566835	28806045	unfamily
3566835	28806065	unfamily
3566866	28807278	unfamily
3566875	28807474	unfamily
3566875	28807483	unfamily
2282012	28970081	unfamily
3566986	29275162	unfamily
3566875	29593531	unfamily
3602488	29743037	unfamily
3566835	30321011	unfamily
3566835	30321023	unfamily
3566835	30321051	unfamily
3566875	30321722	unfamily
3622506	30440159	unfamily
3630256	30703775	unfamily
3630256	30703788	unfamily
3630256	30703850	unfamily
3630256	30703918	unfamily
3630256	30703957	unfamily
3630256	30703963	unfamily
3630256	30704017	unfamily
3630256	30704025	unfamily
3630256	30704039	unfamily
3644639	30935911	unfamily
3644639	30936010	unfamily
3644639	30937417	unfamily
3644639	30938300	unfamily
3644639	30939153	unfamily
3644639	30939647	unfamily
2454804	31295349	unfamily
3653210	31668469	unfamily
3679202	32560658	unfamily
3679202	32602996	unfamily
3679202	32738755	unfamily
3283061	28533289	unfamily
1570626	28569668	unfamily
3560288	28681560	unfamily
3366093	28702093	unfamily
3366093	28702097	unfamily
3365199	28720695	unfamily
3365199	28720741	unfamily
3566835	28805884	unfamily
3566835	28805889	unfamily
3566835	28805892	unfamily
3566835	28805899	unfamily
3566835	28805908	unfamily
3566835	28805914	unfamily
3566835	28805926	unfamily
3566835	28805928	unfamily
3566835	28805930	unfamily
3566835	28805935	unfamily
3566835	28805937	unfamily
3566835	28805938	unfamily
3566835	28805940	unfamily
3566835	28805943	unfamily
3566835	28805944	unfamily
3566835	28805946	unfamily
3566835	28805949	unfamily
3566835	28805952	unfamily
3566835	28805959	unfamily
3566835	28805961	unfamily
3566835	28805962	unfamily
3566835	28805964	unfamily
3566835	28805968	unfamily
3566835	28805969	unfamily
3566835	28805976	unfamily
3566835	28805981	unfamily
3566835	28805983	unfamily
3566835	28805993	unfamily
3566835	28806000	unfamily
3566835	28806001	unfamily
3566835	28806003	unfamily
3566835	28806006	unfamily
3566835	28806008	unfamily
3566835	28806009	unfamily
3566835	28806012	unfamily
3566835	28806019	unfamily
3566835	28806022	unfamily
3566835	28806024	unfamily
3566835	28806026	unfamily
3566835	28806028	unfamily
3566835	28806030	unfamily
3566835	28806035	unfamily
3566835	28806037	unfamily
3566835	28806040	unfamily
3566835	28806042	unfamily
3566835	28806044	unfamily
3566835	28806047	unfamily
3566835	28806049	unfamily
3566835	28806051	unfamily
3566835	28806057	unfamily
3566835	28806062	unfamily
3566835	28806067	unfamily
3566835	28806068	unfamily
3566835	28806070	unfamily
3566866	28807265	unfamily
3566866	28807267	unfamily
3566866	28807269	unfamily
3566866	28807270	unfamily
3566866	28807283	unfamily
3566875	28807460	unfamily
3566875	28807462	unfamily
3566875	28807463	unfamily
3566875	28807470	unfamily
3566875	28807473	unfamily
3566875	28807475	unfamily
3566875	28807476	unfamily
3566875	28807477	unfamily
3566875	28807478	unfamily
3566875	28807485	unfamily
3566875	28807489	unfamily
3566875	28807490	unfamily
3067128	28808672	unfamily
3283061	28900542	unfamily
3366093	29043719	unfamily
3581435	29136712	unfamily
3581435	29137265	unfamily
3581435	29137274	unfamily
3566986	29275164	unfamily
2454804	29287561	unfamily
3047056	29290155	unfamily
3593535	29480916	unfamily
3593535	29480926	unfamily
3593535	29481035	unfamily
3593535	29481045	unfamily
3366093	29489626	unfamily
3596402	29579157	unfamily
3596402	29579271	unfamily
3566835	29591105	unfamily
3566835	29591107	unfamily
3566835	29591108	unfamily
3566835	29591115	unfamily
3566875	29593533	unfamily
3566875	29593534	unfamily
3566875	29593535	unfamily
3598176	29630317	unfamily
3366093	29774397	unfamily
3602488	29791331	unfamily
3608487	29956219	unfamily
3609475	29984861	unfamily
3566875	30016135	unfamily
3566875	30016252	unfamily
3566875	30016254	unfamily
3566875	30016260	unfamily
3566875	30016262	unfamily
3612422	30088760	unfamily
3612422	30088784	unfamily
3610412	30129700	unfamily
3610412	30130391	unfamily
3610412	30130527	unfamily
3610412	30131291	unfamily
3610412	30131347	unfamily
3610412	30149306	unfamily
3610412	30150454	unfamily
3067128	30159845	unfamily
3610412	30176620	unfamily
3610412	30177883	unfamily
3566835	30321007	unfamily
3566835	30321015	unfamily
3566835	30321020	unfamily
3566835	30321024	unfamily
3566835	30321025	unfamily
3566835	30321026	unfamily
3566835	30321027	unfamily
3566835	30321041	unfamily
3566835	30321053	unfamily
3566835	30321059	unfamily
3566835	30321062	unfamily
3566835	30321063	unfamily
3566835	30321064	unfamily
3566835	30321065	unfamily
3566875	30321699	unfamily
3566875	30321700	unfamily
3566875	30321706	unfamily
3566875	30321712	unfamily
3566875	30321713	unfamily
3566875	30321724	unfamily
3566875	30321725	unfamily
3566875	30321731	unfamily
3566875	30321732	unfamily
3566875	30321733	unfamily
3566875	30321734	unfamily
3566875	30321736	unfamily
3566875	30321739	unfamily
3566875	30321740	unfamily
2282012	30352478	unfamily
3622506	30439371	unfamily
3630256	30703764	unfamily
3630256	30703770	unfamily
3630256	30703779	unfamily
3630256	30703783	unfamily
3630256	30703811	unfamily
3630256	30703815	unfamily
3630256	30703841	unfamily
3630256	30703843	unfamily
3630256	30703881	unfamily
3630256	30703885	unfamily
3630256	30703890	unfamily
3630256	30703894	unfamily
3630256	30703903	unfamily
3630256	30703912	unfamily
3630256	30703923	unfamily
3630256	30703930	unfamily
3630256	30703937	unfamily
3630256	30703944	unfamily
3630256	30703951	unfamily
3630256	30703969	unfamily
3630256	30703979	unfamily
3630256	30703985	unfamily
3630256	30703990	unfamily
3630256	30703996	unfamily
3630256	30704004	unfamily
3630256	30704010	unfamily
3630256	30704012	unfamily
3630256	30704030	unfamily
3630256	30704036	unfamily
3630256	30704047	unfamily
3630256	30704055	unfamily
3630256	30704065	unfamily
3630256	30704070	unfamily
3630256	30704080	unfamily
3630256	30704090	unfamily
3630256	30704093	unfamily
3630256	30704102	unfamily
3644639	30935834	unfamily
3644639	30935849	unfamily
3644639	30935897	unfamily
3644639	30935960	unfamily
3644639	30936880	unfamily
3644639	30937273	unfamily
3644639	30937328	unfamily
3644639	30937403	unfamily
3644639	30937411	unfamily
3644639	30937446	unfamily
3644639	30937473	unfamily
3644639	30938271	unfamily
3644639	30938275	unfamily
3644639	30938283	unfamily
3644639	30938288	unfamily
3644639	30938295	unfamily
3644639	30938308	unfamily
3644639	30938312	unfamily
3644639	30938319	unfamily
3644639	30938323	unfamily
3644639	30938339	unfamily
3644639	30938353	unfamily
3644639	30938358	unfamily
3644639	30938671	unfamily
3644639	30938688	unfamily
3644639	30938866	unfamily
3644639	30938878	unfamily
3644639	30938882	unfamily
3644639	30938884	unfamily
3644639	30938925	unfamily
3644639	30938953	unfamily
3644639	30938956	unfamily
3644639	30939048	unfamily
3644639	30939051	unfamily
3644639	30939105	unfamily
3644639	30939109	unfamily
3644639	30939124	unfamily
3644639	30939125	unfamily
3644639	30939126	unfamily
3644639	30939130	unfamily
3644639	30939150	unfamily
3644639	30939165	unfamily
3644639	30939169	unfamily
3644639	30939171	unfamily
3622796	30958119	unfamily
3622804	31076037	unfamily
3652314	31086293	unfamily
3622747	31157550	unfamily
3622795	31159094	unfamily
3047056	31464036	unfamily
3047056	31465404	unfamily
3047056	31466588	unfamily
3047056	31466745	unfamily
3047056	31466779	unfamily
3047056	31466844	unfamily
3361057	31505221	unfamily
3622808	31513657	unfamily
3673027	31716137	unfamily
3679202	32037437	unfamily
3679202	32038793	unfamily
3679202	32041283	unfamily
3679202	32041486	unfamily
3679202	32046243	unfamily
3679202	32046605	unfamily
3679202	32046747	unfamily
3438334	32141353	unfamily
3438334	32141360	unfamily
3438334	32141389	unfamily
3691262	32396584	unfamily
3691345	32424484	unfamily
3387698	32425247	unfamily
3387698	32425248	unfamily
3387698	32425254	unfamily
3047056	32708237	unfamily
3047056	32708292	unfamily
3047056	32708298	unfamily
3047056	32708308	unfamily
3047056	32708318	unfamily
3047056	32708365	unfamily
3047056	32708466	unfamily
3047056	32708759	unfamily
3047056	32708900	unfamily
3047056	32709235	unfamily
3047056	32709439	unfamily
3047056	32709566	unfamily
3679383	32723674	unfamily
3679202	32738559	unfamily
3679202	32738658	unfamily
3679202	32738667	unfamily
3679202	32738751	unfamily
3679202	32741207	unfamily
3679202	32741361	unfamily
3679202	32742498	unfamily
3679202	32742590	unfamily
3679202	32742596	unfamily
3679202	32742633	unfamily
3514556	32877444	unfamily
3729599	33694009	unfamily
3729599	33694013	unfamily
3729599	33694024	unfamily
3679202	33919061	unfamily
3728009	33927690	unfamily
3679202	33934975	unfamily
3353269	34100548	unfamily
3809523	35576206	unfamily
3679202	35686317	unfamily
3915509	36220995	unfamily
3691345	38419962	unfamily
3705314	32855979	unfamily
3705314	32856230	unfamily
3705314	32856382	unfamily
3705314	32857964	unfamily
3705314	32858035	unfamily
3705314	32858303	unfamily
3705314	32858304	unfamily
3705314	32858305	unfamily
3705314	32860110	unfamily
3705314	32861645	unfamily
3705314	32861646	unfamily
3705314	32863036	unfamily
3705314	32863041	unfamily
3705314	32863366	unfamily
3705314	32863535	unfamily
3679202	32907844	unfamily
3679202	32908030	unfamily
3679202	32908631	unfamily
3679202	32909741	unfamily
3679202	32910195	unfamily
3679202	32910406	unfamily
3387698	33019024	unfamily
3387698	33019029	unfamily
3691663	33084099	unfamily
3387698	33193510	unfamily
3387698	33193522	unfamily
3387698	33193527	unfamily
3387698	33193558	unfamily
3387698	33193605	unfamily
3715810	33205530	unfamily
3581435	33269063	unfamily
3691663	33358373	unfamily
3720534	33377761	unfamily
3726844	33613820	unfamily
3726844	33613828	unfamily
3728865	33663840	unfamily
3728865	33663843	unfamily
3723993	33677568	unfamily
3729599	33694001	unfamily
3729599	33694002	unfamily
3729599	33694004	unfamily
3729599	33694006	unfamily
3729599	33694012	unfamily
3729599	33694015	unfamily
3729599	33694016	unfamily
3729599	33694017	unfamily
3729599	33694019	unfamily
3729599	33694021	unfamily
3729599	33694022	unfamily
3729599	33694025	unfamily
3729599	33694027	unfamily
3729599	33694029	unfamily
3729599	33694033	unfamily
3691663	33747888	unfamily
3691663	33747929	unfamily
3691663	33905094	unfamily
3691663	33905129	unfamily
3679202	33916653	unfamily
3679202	33920355	unfamily
3679202	33935273	unfamily
3679202	33937718	unfamily
3735698	33937853	unfamily
3679202	34257314	unfamily
3746997	34324527	unfamily
3734212	34388230	unfamily
3679202	34487941	unfamily
3679202	34488004	unfamily
3762194	34809600	unfamily
3762194	35000754	unfamily
3812188	35450337	unfamily
3809523	35574776	unfamily
3679202	35686684	unfamily
3679202	35867758	unfamily
3915513	36221039	unfamily
1660998	36951900	unfamily
3679202	37286386	unfamily
3607943	37427699	unfamily
3972794	38335882	unfamily
3691345	38419940	unfamily
3720534	38755728	unfamily
3607943	38921109	unfamily
3607943	38923273	unfamily
2884152	38957945	unfamily
4045538	40246366	unfamily
3478855	40424718	unfamily
3005130	40442530	unfamily
3367702	41956764	unfamily
3367702	41956918	unfamily
4124729	42827290	unfamily
4131651	43093649	unfamily
4131651	43093688	unfamily
4131651	43093699	unfamily
4131651	43093847	unfamily
4131651	43093848	unfamily
4132770	43136910	unfamily
3513436	43386963	unfamily
4143019	43529711	unfamily
4143019	43530692	unfamily
4143019	43530837	unfamily
4143019	43530857	unfamily
4143019	43530861	unfamily
3461421	43693475	unfamily
3809523	41088122	unfamily
3762194	41941809	unfamily
3367702	41956724	unfamily
3367702	41956803	unfamily
3367702	41956846	unfamily
3367702	41956996	unfamily
3367702	41957076	unfamily
4090940	42125573	unfamily
4119480	42639430	unfamily
4131651	43093480	unfamily
4131651	43093692	unfamily
4131651	43093693	unfamily
4131651	43093697	unfamily
4131651	43093709	unfamily
4131651	43093836	unfamily
4131651	43093849	unfamily
3809523	43420350	unfamily
3809523	43420433	unfamily
3809523	43420472	unfamily
4131648	43499449	unfamily
4131648	43499665	unfamily
1973849	43506137	unfamily
4143019	43529636	unfamily
4143019	43529657	unfamily
4143019	43529714	unfamily
4143019	43529715	unfamily
4143019	43529723	unfamily
4143019	43530665	unfamily
4143019	43530668	unfamily
4143019	43530678	unfamily
4143019	43530689	unfamily
4143019	43530690	unfamily
4143019	43530693	unfamily
4143019	43530694	unfamily
4143019	43530696	unfamily
4143019	43530697	unfamily
4143019	43530698	unfamily
4143019	43530710	unfamily
4143019	43530845	unfamily
4143019	43530851	unfamily
4143019	43530854	unfamily
4143019	43530864	unfamily
4143019	43530871	unfamily
4143019	43530874	unfamily
4143019	43530877	unfamily
4143019	43530879	unfamily
4143019	43530882	unfamily
4143019	43530888	unfamily
4143019	43530894	unfamily
4143019	43530896	unfamily
4143019	43530897	unfamily
4143019	43530899	unfamily
4143019	43530900	unfamily
4143019	43530902	unfamily
4143019	43530904	unfamily
4143019	43531013	unfamily
4143019	43531017	unfamily
3461421	43673207	unfamily
3536602	43990485	unfamily
3509674	44025405	unfamily
4161651	44323740	unfamily
2859467	44410856	unfamily
3957100	44788189	unfamily
4131648	45105492	unfamily
4131648	45107670	unfamily
4131648	45107980	unfamily
2884152	45345212	unfamily
4185434	45365736	unfamily
4101126	43934764	unfamily
4124729	43940810	unfamily
4132770	43995994	unfamily
4161651	44246812	unfamily
4161651	44297397	unfamily
4139635	44327351	unfamily
3957100	44786134	unfamily
3097117	44796660	unfamily
3762194	44848112	unfamily
3679202	44981043	unfamily
4131648	45106854	unfamily
3751162	45345230	unfamily
3366093	45372611	unfamily
3361057	45418565	unfamily
3531848	45495300	unfamily
4161924	45674012	unfamily
3968808	45775241	unfamily
4241875	47733936	unfamily
4241875	47733978	unfamily
4250119	48133908	unfamily
4273585	49348656	unfamily
4273781	49356983	unfamily
4273781	49356988	unfamily
4273782	49356999	unfamily
4241875	47733955	unfamily
4241875	47733972	unfamily
4241875	47733982	unfamily
4241875	47733985	unfamily
4273781	49356981	unfamily
4273781	49356984	unfamily
4273781	49356987	unfamily
4273781	49356992	unfamily
4273782	49357000	unfamily
4273782	49357002	unfamily
4273782	49357004	unfamily
4273782	49357006	unfamily
4273782	49357009	unfamily
4291893	50176959	unfamily
4291893	50176962	unfamily
4291894	50176963	unfamily
4291894	50176981	unfamily
4291894	50177005	unfamily
4291893	50177010	unfamily
4291893	50177013	unfamily
4291893	50177022	unfamily
4291894	50177023	unfamily
4291893	50177025	unfamily
4291893	50177028	unfamily
4291893	50177034	unfamily
4291894	50177047	unfamily
4291894	50176960	unfamily
4291893	50176971	unfamily
4291894	50176972	unfamily
4291894	50176996	unfamily
4291893	50177001	unfamily
4291894	50177002	unfamily
4291894	50177014	unfamily
4291893	50177031	unfamily
4291894	50177032	unfamily
4291893	50177043	unfamily
4291893	50177046	unfamily
4291894	50177056	unfamily
4291894	50177065	unfamily
4226162	50701505	unfamily
4302551	50707908	unfamily
4303379	50768519	unfamily
4303379	50768542	unfamily
4303827	50783983	unfamily
4237747	50801758	unfamily
4273974	50816583	unfamily
4282140	50825104	unfamily
4302193	50837323	unfamily
4298726	50837654	unfamily
4305388	50885222	unfamily
4305644	50888515	unfamily
4301812	50920757	unfamily
4306022	50925698	unfamily
4306961	50967251	unfamily
4306961	50967339	unfamily
4306961	50967451	unfamily
4306961	50967918	unfamily
4306961	50968305	unfamily
4212398	50975461	unfamily
4291894	51017980	unfamily
4291895	51017981	unfamily
4295011	51068923	unfamily
3672852	51182967	unfamily
3672852	51182968	unfamily
3672852	51182969	unfamily
3672852	51182970	unfamily
4221302	51198996	unfamily
4312384	51218608	unfamily
4312384	51218852	unfamily
4312294	51243460	unfamily
4312294	51243461	unfamily
4312294	51243464	unfamily
4312294	51243466	unfamily
2794155	51243491	unfamily
4312344	51246141	unfamily
4312344	51246142	unfamily
4312344	51246143	unfamily
4312344	51246144	unfamily
4312344	51246146	unfamily
4312344	51246147	unfamily
4312344	51246148	unfamily
4312344	51246150	unfamily
4312344	51246151	unfamily
4312344	51246152	unfamily
4312344	51246153	unfamily
4312344	51246154	unfamily
4312344	51246155	unfamily
4312344	51246156	unfamily
4312344	51246157	unfamily
4312344	51246158	unfamily
4312344	51246159	unfamily
4312344	51246160	unfamily
4312344	51246161	unfamily
4312344	51246162	unfamily
4312344	51246163	unfamily
4312344	51246165	unfamily
4312344	51250457	unfamily
4312344	51250458	unfamily
4312344	51250459	unfamily
4312344	51250460	unfamily
4312344	51250461	unfamily
4312344	51250462	unfamily
4312344	51250464	unfamily
4312344	51250465	unfamily
4312344	51250466	unfamily
4312344	51250467	unfamily
4312344	51250468	unfamily
4312344	51250469	unfamily
4312344	51250471	unfamily
4312344	51250472	unfamily
4312344	51250475	unfamily
4312344	51250476	unfamily
4312344	51250478	unfamily
4312344	51250998	unfamily
4312344	51250999	unfamily
4312344	51251000	unfamily
4312344	51251001	unfamily
4312344	51251002	unfamily
4312344	51251003	unfamily
4312344	51251004	unfamily
4312344	51251005	unfamily
4312344	51251006	unfamily
4312344	51251007	unfamily
4312344	51251008	unfamily
4312344	51251009	unfamily
4312344	51251010	unfamily
4312344	51251011	unfamily
4312344	51251012	unfamily
4312344	51251013	unfamily
4312344	51251015	unfamily
4312344	51251016	unfamily
4312344	51257350	unfamily
4313463	51274939	unfamily
4313463	51282138	unfamily
4313463	51282173	unfamily
4313463	51298137	unfamily
4260502	51342923	unfamily
4282140	51359794	unfamily
4292696	51362955	unfamily
4168319	51436953	unfamily
4316139	51630783	unfamily
4316139	51630844	unfamily
3520652	51480255	unfamily
652741	51533367	unfamily
652741	51533506	unfamily
652741	51533523	unfamily
652741	51534083	unfamily
3932622	51546023	unfamily
4319703	51594390	unfamily
4282140	51597129	unfamily
4316139	51630753	unfamily
4316139	51630756	unfamily
4316139	51630757	unfamily
4316139	51630758	unfamily
4316139	51630759	unfamily
4316139	51630760	unfamily
4316139	51630761	unfamily
4316139	51630763	unfamily
4316139	51630764	unfamily
4316139	51630765	unfamily
4316139	51630766	unfamily
4316139	51630767	unfamily
4316139	51630768	unfamily
4316139	51630769	unfamily
4316139	51630770	unfamily
4316139	51630771	unfamily
4316139	51630772	unfamily
4316139	51630773	unfamily
4316139	51630774	unfamily
4316139	51630776	unfamily
4316139	51630777	unfamily
4316139	51630778	unfamily
4316139	51630779	unfamily
4316139	51630780	unfamily
4316139	51630781	unfamily
4316139	51630782	unfamily
4316139	51630784	unfamily
4316139	51630785	unfamily
4316139	51630786	unfamily
4316139	51630787	unfamily
4316139	51630789	unfamily
4316139	51630790	unfamily
4316139	51630791	unfamily
4316139	51630792	unfamily
4316139	51630793	unfamily
4316139	51630797	unfamily
4316139	51630798	unfamily
4316139	51630799	unfamily
4316139	51630800	unfamily
4316139	51630801	unfamily
4316139	51630803	unfamily
4316139	51630804	unfamily
4316139	51630805	unfamily
4316139	51630806	unfamily
4316139	51630807	unfamily
4316139	51630808	unfamily
4316139	51630809	unfamily
4316139	51630811	unfamily
4316139	51630812	unfamily
4316139	51630813	unfamily
4316139	51630814	unfamily
4316139	51630815	unfamily
4316139	51630816	unfamily
4316139	51630817	unfamily
4316139	51630818	unfamily
4316139	51630819	unfamily
4316139	51630822	unfamily
4316139	51630823	unfamily
4316139	51630825	unfamily
4316139	51630826	unfamily
4316139	51630828	unfamily
4316139	51630829	unfamily
4316139	51630830	unfamily
4316139	51630832	unfamily
4316139	51630833	unfamily
4316139	51630835	unfamily
4316139	51630836	unfamily
4316139	51630838	unfamily
4316139	51630840	unfamily
4316139	51630842	unfamily
4316139	51630843	unfamily
4316139	51630845	unfamily
4316139	51630846	unfamily
4316139	51630848	unfamily
4316139	51630849	unfamily
4316139	51630851	unfamily
4316139	51630853	unfamily
4316139	51630856	unfamily
4316139	51630858	unfamily
4316139	51630859	unfamily
4316139	51630861	unfamily
4282140	51631004	unfamily
4282140	51631647	unfamily
4318401	51650901	unfamily
4321154	51704834	unfamily
4286646	51713737	unfamily
4320327	51745095	unfamily
4304461	51756701	unfamily
4304461	51757201	unfamily
2913812	51770329	unfamily
4322648	51780152	unfamily
4322679	51797178	unfamily
4322906	51803917	unfamily
4286646	51862090	unfamily
4282140	51864675	unfamily
4282140	51866011	unfamily
4282140	51866410	unfamily
4319703	51866992	unfamily
4302000	51882436	unfamily
4312384	51898999	unfamily
3730367	51917809	unfamily
4321157	51921685	unfamily
4321157	51921690	unfamily
4322906	51922894	unfamily
4325975	51946674	unfamily
3121593	51947403	unfamily
4325975	51947816	unfamily
4322906	51965079	unfamily
4318401	52045119	unfamily
4318401	52048907	unfamily
3968808	52095712	unfamily
3583456	52098147	unfamily
3966812	52128527	unfamily
2634080	52136739	unfamily
4310587	52142493	unfamily
3672852	52170384	unfamily
4329860	52196873	unfamily
4329991	52201279	unfamily
4329991	52201295	unfamily
4329991	52201296	unfamily
4329991	52201300	unfamily
4329991	52201301	unfamily
4329991	52201303	unfamily
4329991	52201308	unfamily
4329991	52201310	unfamily
4329991	52201314	unfamily
4329991	52201329	unfamily
4329991	52201332	unfamily
4329991	52201342	unfamily
4329991	52201345	unfamily
4329991	52201348	unfamily
4329991	52201351	unfamily
4329991	52201360	unfamily
4329991	52201365	unfamily
4329991	52201366	unfamily
4329991	52201367	unfamily
4329991	52201370	unfamily
4329991	52201383	unfamily
4329991	52201387	unfamily
4329991	52201389	unfamily
4329991	52201390	unfamily
4329991	52201391	unfamily
4329991	52201397	unfamily
4329991	52201401	unfamily
4321160	52202089	unfamily
4329978	52204537	unfamily
4329978	52204554	unfamily
4329978	52204564	unfamily
4329978	52204570	unfamily
4329978	52204576	unfamily
4329978	52204593	unfamily
4329978	52204601	unfamily
4329978	52204607	unfamily
4329978	52204619	unfamily
4329978	52204620	unfamily
4329978	52204621	unfamily
4329978	52204629	unfamily
4329978	52204631	unfamily
4329978	52204639	unfamily
4329978	52204643	unfamily
4329978	52204644	unfamily
4329978	52204646	unfamily
4329978	52204647	unfamily
4329978	52204648	unfamily
4329978	52204649	unfamily
4042007	52223235	unfamily
4324314	52230519	unfamily
4324314	52231515	unfamily
4235125	52257966	unfamily
4235125	52257982	unfamily
4235125	52258009	unfamily
4329627	52267512	unfamily
4311217	52283897	unfamily
4176272	52299721	unfamily
4325789	52313787	unfamily
4325423	52423598	unfamily
4325423	52426341	unfamily
4325423	52426407	unfamily
4325423	52426451	unfamily
4325423	52426483	unfamily
4325423	52426937	unfamily
4329627	52186910	unfamily
4329991	52201291	unfamily
4329991	52201292	unfamily
4329991	52201293	unfamily
4329991	52201297	unfamily
4329991	52201305	unfamily
4329991	52201306	unfamily
4329991	52201311	unfamily
4329991	52201325	unfamily
4329991	52201338	unfamily
4329991	52201340	unfamily
4329991	52201344	unfamily
4329991	52201346	unfamily
4329991	52201347	unfamily
4329991	52201353	unfamily
4329991	52201355	unfamily
4329991	52201357	unfamily
4329991	52201368	unfamily
4329991	52201369	unfamily
4329991	52201376	unfamily
4329991	52201407	unfamily
4321160	52202088	unfamily
4329978	52204520	unfamily
4329978	52204526	unfamily
4329978	52204530	unfamily
4329978	52204532	unfamily
4329978	52204534	unfamily
4329978	52204543	unfamily
4329978	52204549	unfamily
4329978	52204583	unfamily
4329978	52204614	unfamily
4329978	52204623	unfamily
4329978	52204624	unfamily
4329978	52204625	unfamily
4329978	52204626	unfamily
4329978	52204627	unfamily
4329978	52204634	unfamily
4329978	52204635	unfamily
4329978	52204640	unfamily
4329978	52204641	unfamily
4329978	52204642	unfamily
4235125	52257978	unfamily
4235125	52258008	unfamily
4176272	52300700	unfamily
4334492	52487527	unfamily
3672852	52490290	unfamily
3672852	52490292	unfamily
4176272	52502239	unfamily
4176272	52503003	unfamily
4325423	52505970	unfamily
4325423	52506046	unfamily
4335003	52506068	unfamily
4335003	52506091	unfamily
4176272	52506745	unfamily
4176272	52507083	unfamily
4176272	52507769	unfamily
4321164	52508420	unfamily
4176272	52508484	unfamily
4321164	52508931	unfamily
4176272	52509289	unfamily
4176272	52509633	unfamily
4321164	52509649	unfamily
4321164	52509655	unfamily
4176275	52517419	unfamily
4176275	52517443	unfamily
4176275	52517464	unfamily
4176275	52517484	unfamily
4176275	52517492	unfamily
4176275	52517516	unfamily
4176275	52517537	unfamily
4176275	52517551	unfamily
4176275	52517568	unfamily
4176275	52517595	unfamily
4176275	52517610	unfamily
4176275	52517643	unfamily
4176275	52517656	unfamily
4176275	52517668	unfamily
4176275	52517686	unfamily
4176275	52517697	unfamily
4176275	52517718	unfamily
4176275	52517753	unfamily
4176275	52517771	unfamily
4176275	52517794	unfamily
4176275	52517839	unfamily
4176275	52517869	unfamily
4176275	52517897	unfamily
4176275	52517929	unfamily
4176275	52517957	unfamily
4176275	52517993	unfamily
4176275	52518024	unfamily
4176275	52518042	unfamily
4176275	52518061	unfamily
4176275	52518078	unfamily
4176275	52518095	unfamily
4176275	52518111	unfamily
4176275	52518130	unfamily
4176275	52518148	unfamily
4176275	52518160	unfamily
4176275	52518179	unfamily
4176275	52518201	unfamily
4176275	52518224	unfamily
4176275	52518233	unfamily
4176275	52518248	unfamily
4176275	52518252	unfamily
4176275	52518270	unfamily
4176275	52518284	unfamily
4176275	52518308	unfamily
4176275	52518326	unfamily
4176275	52518335	unfamily
4176275	52518349	unfamily
4176275	52518460	unfamily
4176275	52518484	unfamily
4176275	52518500	unfamily
4176275	52518518	unfamily
4176275	52518522	unfamily
4176275	52518539	unfamily
4176275	52518544	unfamily
4176275	52518560	unfamily
4176275	52518589	unfamily
4176275	52518624	unfamily
4176275	52518664	unfamily
4176275	52518676	unfamily
4176275	52518700	unfamily
4176275	52518718	unfamily
4176275	52518721	unfamily
4176275	52518744	unfamily
4176275	52518753	unfamily
4176275	52518771	unfamily
4176275	52518788	unfamily
4176275	52518798	unfamily
4176275	52518812	unfamily
4176275	52518827	unfamily
4176275	52518837	unfamily
4176275	52518848	unfamily
4176275	52518851	unfamily
4176275	52518878	unfamily
4176275	52518908	unfamily
4176275	52518920	unfamily
4176275	52518930	unfamily
4176275	52518934	unfamily
4176275	52518945	unfamily
4176275	52518961	unfamily
4176275	52519000	unfamily
4176275	52519049	unfamily
4176275	52519089	unfamily
4176275	52519125	unfamily
4176275	52519156	unfamily
4176275	52519211	unfamily
4176275	52519230	unfamily
4176275	52519240	unfamily
4176275	52519256	unfamily
4176275	52519272	unfamily
4176275	52519279	unfamily
4176275	52519295	unfamily
4176275	52519314	unfamily
4176275	52519326	unfamily
4176275	52519345	unfamily
4176275	52519378	unfamily
4176275	52519390	unfamily
4176275	52519418	unfamily
4176275	52519442	unfamily
4176275	52519462	unfamily
4176275	52519472	unfamily
4176275	52519485	unfamily
4176275	52519494	unfamily
4176275	52519506	unfamily
4176275	52519522	unfamily
4176275	52519530	unfamily
4176275	52519543	unfamily
4176275	52519557	unfamily
4176275	52519567	unfamily
4176275	52519580	unfamily
4176275	52519583	unfamily
4176275	52519595	unfamily
4176275	52519601	unfamily
4176275	52519636	unfamily
4176275	52519705	unfamily
4176275	52519781	unfamily
4176275	52519829	unfamily
4176275	52519870	unfamily
4176275	52519917	unfamily
4176275	52519954	unfamily
4176275	52520037	unfamily
4176275	52520087	unfamily
4176275	52520128	unfamily
4176275	52520137	unfamily
4176275	52520142	unfamily
4176275	52520143	unfamily
4176275	52520144	unfamily
4176275	52520147	unfamily
4176275	52520177	unfamily
4176275	52520194	unfamily
4176275	52520214	unfamily
4176275	52520220	unfamily
4176275	52520232	unfamily
4176275	52520243	unfamily
4176275	52520252	unfamily
4176275	52520265	unfamily
4176275	52520272	unfamily
4176275	52520276	unfamily
4176275	52520287	unfamily
4176275	52520296	unfamily
4176275	52520305	unfamily
4176275	52520316	unfamily
4176275	52520318	unfamily
4176275	52520319	unfamily
4176275	52520320	unfamily
4176275	52520321	unfamily
4176275	52520326	unfamily
4176275	52520332	unfamily
4176275	52520337	unfamily
4176275	52520343	unfamily
4176275	52520367	unfamily
4176275	52520398	unfamily
4176275	52520430	unfamily
4176275	52520457	unfamily
4176275	52520482	unfamily
4176275	52520507	unfamily
4176275	52520513	unfamily
4176275	52520518	unfamily
4176275	52520527	unfamily
4176275	52522918	unfamily
4176275	52522967	unfamily
4176275	52523003	unfamily
4176275	52523038	unfamily
4176275	52523081	unfamily
4176275	52523124	unfamily
4176275	52523182	unfamily
4176275	52523264	unfamily
4176275	52523352	unfamily
4176275	52523431	unfamily
4176275	52523502	unfamily
4176275	52523559	unfamily
4176275	52523640	unfamily
4176275	52523712	unfamily
4176275	52523787	unfamily
4176275	52523865	unfamily
4176275	52523976	unfamily
4176275	52524079	unfamily
4176275	52524127	unfamily
4176275	52524177	unfamily
4176275	52524246	unfamily
4176275	52524318	unfamily
4176275	52524375	unfamily
4176275	52524438	unfamily
4176275	52524510	unfamily
4176275	52524919	unfamily
4176275	52525102	unfamily
4176275	52525198	unfamily
4176275	52525379	unfamily
4176275	52525693	unfamily
4176275	52525789	unfamily
4176275	52525973	unfamily
4176275	52526105	unfamily
4176275	52526203	unfamily
4176275	52526309	unfamily
4176275	52526328	unfamily
4176275	52526406	unfamily
4176275	52526533	unfamily
4176275	52526588	unfamily
4176275	52526666	unfamily
4176275	52526745	unfamily
4176275	52526792	unfamily
4176275	52526835	unfamily
4176275	52526878	unfamily
4176275	52526925	unfamily
4176275	52526960	unfamily
4176275	52526997	unfamily
4176275	52527047	unfamily
4176275	52527086	unfamily
4176275	52527118	unfamily
4176275	52527158	unfamily
4176275	52527193	unfamily
4176275	52527234	unfamily
4176275	52527272	unfamily
4176275	52527312	unfamily
4176275	52527350	unfamily
4176275	52527382	unfamily
4176275	52527420	unfamily
4176275	52527453	unfamily
4176275	52527482	unfamily
4176275	52527514	unfamily
4176275	52527549	unfamily
4176275	52527660	unfamily
4176275	52527726	unfamily
4176275	52527794	unfamily
4176275	52527856	unfamily
4176275	52527922	unfamily
4176275	52527984	unfamily
4176275	52528040	unfamily
4176275	52528087	unfamily
4176275	52528157	unfamily
4176275	52528213	unfamily
4176275	52528282	unfamily
4176275	52528362	unfamily
4176275	52528437	unfamily
4176275	52528526	unfamily
4176275	52528615	unfamily
4176275	52528694	unfamily
4176275	52528778	unfamily
4176275	52528864	unfamily
4176275	52528946	unfamily
4176275	52529034	unfamily
4176275	52529112	unfamily
4176275	52529257	unfamily
4176275	52529335	unfamily
4176275	52529373	unfamily
4176275	52529484	unfamily
4176275	52529545	unfamily
4176275	52529601	unfamily
4176275	52529665	unfamily
4176275	52529718	unfamily
4176275	52529790	unfamily
4176275	52529842	unfamily
4176275	52529846	unfamily
4176275	52529850	unfamily
4176275	52529852	unfamily
4176275	52529853	unfamily
4176275	52529855	unfamily
4176275	52529856	unfamily
4176275	52529858	unfamily
4176275	52529859	unfamily
4176275	52529861	unfamily
4176275	52529865	unfamily
4176275	52529885	unfamily
4176275	52529924	unfamily
4176275	52529956	unfamily
4176275	52530002	unfamily
4176275	52530035	unfamily
4176275	52530070	unfamily
4176275	52530113	unfamily
4176275	52530138	unfamily
4176275	52530145	unfamily
4176275	52530212	unfamily
4176275	52530289	unfamily
4176275	52530366	unfamily
4176275	52530463	unfamily
4176275	52530602	unfamily
4176275	52530734	unfamily
4176275	52530837	unfamily
4176275	52530940	unfamily
4176275	52530994	unfamily
4176275	52531091	unfamily
4176275	52531187	unfamily
4176275	52531248	unfamily
4176275	52531374	unfamily
4176275	52531482	unfamily
4176275	52531627	unfamily
4176275	52531764	unfamily
4176275	52531876	unfamily
4176275	52532006	unfamily
4176275	52532133	unfamily
4176275	52532244	unfamily
4176275	52532363	unfamily
4176275	52532491	unfamily
4176275	52532625	unfamily
4176275	52532712	unfamily
4176275	52532816	unfamily
4176275	52532902	unfamily
4176275	52533008	unfamily
4176275	52533155	unfamily
4176275	52533264	unfamily
4176275	52533319	unfamily
4176275	52533372	unfamily
4176275	52533399	unfamily
4176275	52533436	unfamily
4176275	52533489	unfamily
4176275	52533515	unfamily
4176275	52533518	unfamily
4176275	52533526	unfamily
4176275	52533528	unfamily
4176275	52533538	unfamily
4176275	52533542	unfamily
4176275	52533548	unfamily
4176275	52533554	unfamily
4176275	52533560	unfamily
4176275	52533587	unfamily
4176275	52533639	unfamily
4176275	52533691	unfamily
4176275	52533716	unfamily
4176275	52533740	unfamily
4176275	52533772	unfamily
4176275	52533804	unfamily
4176275	52533818	unfamily
4176275	52533824	unfamily
4176275	52542411	unfamily
4176275	52542421	unfamily
4176275	52542446	unfamily
4176275	52542462	unfamily
4176275	52542482	unfamily
4176275	52542505	unfamily
4176275	52542528	unfamily
4176275	52542537	unfamily
4176275	52542548	unfamily
4176275	52542550	unfamily
4176275	52542558	unfamily
4176275	52542577	unfamily
4176275	52542586	unfamily
4176275	52542595	unfamily
4176275	52542601	unfamily
4176275	52542610	unfamily
4176275	52542618	unfamily
4176275	52542623	unfamily
4176275	52542635	unfamily
4176275	52542658	unfamily
4176275	52542680	unfamily
4176275	52542708	unfamily
4176275	52542738	unfamily
4176275	52542766	unfamily
4176275	52542818	unfamily
4176275	52542886	unfamily
4176275	52542927	unfamily
4176275	52542964	unfamily
4176275	52543007	unfamily
4176275	52543043	unfamily
4176275	52543077	unfamily
4176275	52543098	unfamily
4176275	52543103	unfamily
4176275	52543111	unfamily
4176275	52543113	unfamily
4176275	52543115	unfamily
4176275	52543116	unfamily
4176275	52543118	unfamily
4176275	52543120	unfamily
4176275	52543123	unfamily
4176275	52543128	unfamily
4176275	52543129	unfamily
4176275	52543151	unfamily
4176275	52543187	unfamily
4176275	52543234	unfamily
4176275	52543269	unfamily
4176275	52543277	unfamily
4176275	52543286	unfamily
4131521	52674081	unfamily
3723457	52743773	unfamily
4339078	52751249	unfamily
4339078	52751251	unfamily
4339078	52751254	unfamily
4339078	52751256	unfamily
4339078	52751257	unfamily
4339078	52751260	unfamily
4339078	52751261	unfamily
4339078	52751262	unfamily
4339078	52751265	unfamily
1572990	52613369	unfamily
4129903	52635822	unfamily
4332832	52663586	unfamily
4318401	52669082	unfamily
4334814	52683741	unfamily
4334814	52683747	unfamily
3672852	52743239	unfamily
3672852	52743245	unfamily
3723457	52743697	unfamily
4339078	52751247	unfamily
4339078	52751250	unfamily
4339078	52751252	unfamily
4339078	52751253	unfamily
4339078	52751258	unfamily
4339078	52751263	unfamily
4339078	52751264	unfamily
4339078	52751266	unfamily
4339078	52751267	unfamily
4339078	52751268	unfamily
4339078	52751269	unfamily
4339078	52751270	unfamily
4339078	52751272	unfamily
4339078	52751274	unfamily
4283484	52757220	unfamily
4322262	52768385	unfamily
3516603	52775285	unfamily
4340185	52775764	unfamily
4340185	52775832	unfamily
4340185	52779620	unfamily
4340185	52779771	unfamily
4340185	52779779	unfamily
4340185	52779945	unfamily
4340185	52780203	unfamily
4340185	52780466	unfamily
4340185	52780479	unfamily
4340611	52802420	unfamily
3762194	52803273	unfamily
4340730	52818584	unfamily
4340757	52821930	unfamily
4340830	52827078	unfamily
2969295	52859556	unfamily
3762194	52868183	unfamily
4312595	52872903	unfamily
4312595	52873830	unfamily
4312595	52877396	unfamily
4341628	52893203	unfamily
4312595	52894695	unfamily
4344448	53051372	unfamily
4345250	53082028	unfamily
4176270	53089540	unfamily
4176270	53092851	unfamily
4176270	53092917	unfamily
4176270	53093608	unfamily
4176270	53093666	unfamily
4176270	53093685	unfamily
4176270	53093686	unfamily
4176270	53093691	unfamily
4176270	53093697	unfamily
4176270	53093745	unfamily
4176270	53093748	unfamily
4176270	53093756	unfamily
4176270	53093779	unfamily
4337086	53107872	unfamily
4337086	53117919	unfamily
4341628	53303334	unfamily
4333395	53145912	unfamily
4131651	53219670	unfamily
4131651	53220104	unfamily
4131651	53220347	unfamily
4131651	53220958	unfamily
4131651	53221969	unfamily
4131651	53225660	unfamily
4131651	53226645	unfamily
4131651	53227213	unfamily
4131651	53228175	unfamily
4131651	53228847	unfamily
4131651	53229739	unfamily
4286646	53330690	unfamily
4129903	53348559	unfamily
4349936	53371910	unfamily
4351028	53436566	unfamily
4351028	53436575	unfamily
4351028	53436633	unfamily
4351028	53436636	unfamily
4351028	53436643	unfamily
4351028	53436703	unfamily
4352163	53526111	unfamily
4352163	53592607	unfamily
4352163	53595193	unfamily
4352163	53596378	unfamily
2857198	14851365	jewelry,unfamily
893353	4606442	casino,unfamily
3397831	25061820	unfamily,jewelry,magic
3005130	21487808	unfamily,copyright
3715810	33205942	unfamily,copyright
3688173	32299793	unfamily,seo
3691663	33089993	unfamily,finance
4131648	43499224	unfamily,finance
4292877	51032104	unfamily,finance
2857198	14851387	magic,unfamily
2857198	14851538	magic,unfamily
2384560	23310382	magic,unfamily
3520652	51480461	magic,unfamily
4318089	51610712	magic,unfamily
3590179	29365082	unfamily,security
4129903	52650379	foundry,unfamily
4352163	53526543	foundry,unfamily
4352163	53527518	foundry,unfamily
3126504	27346070	tobacco_ex,unfamily
