#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
    {
      type => 'sql',
      when => 'before',
      webstop => 0,
      db => "ppc",
      time_estimate => "1 сек",
      sql => "CREATE TABLE bids_init_stats (
                cid int unsigned not null,
                id int unsigned not null,
                shows int unsigned not null,
                clicks int unsigned not null,
                primary key (cid, id)
                );",
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => 'На devtest около часа',
        comment => q[
            Запускать вечером(в 19 или позже) после выкладки
            Копируем bids(,_arc).(shows,clicks) в bids_init_stats
        ],
    }
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;

my @TBL = (
    {name => 'bids', key => 'id', chunk => 1_000_000},
    {name => 'bids_arc', key => 'cid', chunk => 50_000},
);

for my $tbl (@TBL) {
    my ($min_id, $max_id) = get_one_line_array_sql(PPC_HEAVY, "SELECT min($tbl->{key}), max($tbl->{key}) FROM $tbl->{name}");
    $log->out("start process table $tbl->{name}, max_id=$max_id");
    while($min_id <= $max_id) {
        my $cnt = do_insert_select_sql(PPC_HEAVY,
                "INSERT IGNORE INTO bids_init_stats (cid, id, shows, clicks) VALUES %s",
                ["SELECT cid, id, shows, clicks
                  FROM $tbl->{name}",
                  WHERE => {
                        PhraseID => 0,
                        shows__gt => 0,
                        "$tbl->{key}__between" => [$min_id, $min_id + $tbl->{chunk} - 1]
                  }
                ],
                dbw => PPC
            );
        $log->out("Moved $cnt rows for $tbl->{name} where $min_id <= $tbl->{key} < ".($min_id + $tbl->{chunk} - 1));
        $min_id += $tbl->{chunk};
    }
}

