#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '20 sec',
        comment => "меняем логины в users на актуальные, которые были удалены и заведены заново, присланные паспортом",
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Primitives;
use Yandex::DBTools;

# -----------------------------------------------------------------------------
sub main {
    $log->out("start");

    for my $line (<DATA>) {
        chomp $line;
        my ($uid, $new_login) = $line =~ /^(\d+) \s+ (\S+)$/x;
        my $old_login = get_one_field_sql(PPC, "select login from users where uid = ?", $uid);
        my $login_in_passport_now = get_login_by_uid_passport($uid);

        if (! $login_in_passport_now || lc($login_in_passport_now) ne lc($new_login)) {
            $log->out({uid => $uid, old_login => $old_login, new_login => $new_login, login_in_passport_now => $login_in_passport_now, passport_login_changed => 1});
            next;
        }

        if (! defined $old_login) {
            $log->out({uid => $uid, new_login => $new_login, login_not_exists_in_direct => 1});
            next;
        }

        my $res = do_update_table(PPC, 'users', {login => $new_login}, where => {uid => $uid});
        $log->out({uid => $uid, old_login => $old_login, new_login => $new_login, update_result => $res});
    }

    $log->out("finish");
}

# -----------------------------------------------------------------------------
main();

__DATA__
64657450	o-kudaeva-2
95907147	te-ivanova-2
102489343	dkopach-con-2
102545706	ira-megamir-2
102546455	sobolev-megamir-2
102546701	anton-megamir-2
103868906	senior-fedoseew-2
26353144	anatolijnikitin-2
26610652	Potolki5-2
26749768	danil-fomenko-2
129090	Falkor-2
669508	Liechka2
782436	nechitailov-2
1466449	machik-1
1766767	Taranina-2
3500558	Meshkof-2
3791541	tat-korobova-2
3941376	lipatov-aleks-2
3971944	petrovkin-2
4264186	amirh-2
4637362	klop1-2
4641506	Denis8-3
4642220	atl-3
4804202	vendor-2
4860710	layda-1
4886487	nova6-2
4903575	olimpik-1
6722582	gouache-2
7014316	ser009-2
7016055	inzel-2
7560439	ajour1-2
7593721	Zhernakov-2
7692287	Sasha-Alya-2
7707837	ecoterm2
7742454	sam008-2
8293759	spartak1488-2
8389485	frolov333-2
8472717	mud-ak-2
8673063	max-h-2
8707026	alla-rus-2
8807278	Stalin0002
8907035	alisa-super-2
8934038	slashs-2
9046793	opostal-2
9055435	Demon8-2
9110771	alexlev-2
9131249	kirill7-2
9201494	kdaria-2
9276921	ser445-2
9331342	master65-2
9344930	RED-KILLER-2
9356174	feodom-2
9487097	poop-3
9503256	happybaby-2
9508677	Sexxxxx-2
9509957	Karacurt-2
9578079	alik-a-2
9716009	Ksenia12345-2
9801532	makarov-2
9880304	nionila-2
9961281	lolo666-2
9969238	Shepel-2
9994996	mo5kva-2
10043853	Togin-2
10044538	lottom-2
10076759	asoka-1
10183103	oksana-glushkova-2
10222821	pppp12-2
10263420	stolberg-2
10468818	argo1-2
10690658	dmitripetrov-2
10792521	okb-2
10835710	nic2012-2
10910860	UTI-2
10983468	Akhmat-2
11004176	nadya-abramova-2
11014883	Andrea7-2
11059136	alexandrparfenov-2
11102789	razin-dima-2
11158261	www-ya-2
11320202	zulfiya1986-2
11575279	mity8-2
11933709	gjkz-2
11962082	megavlad-2
11967286	petrit-2
12058919	Jkmuf1
12082096	tdutybq-2
12082647	mastiff-2
12111568	sivacheva-2
12132213	Maksik72-2
12207951	Tatiana-Korchagina-2
12419981	kino-2
12424792	abay-1
12432289	sanlasar-2
12508510	hyy-2
12596682	vdych-2
12701782	trdn-2
12759543	tiristor-2
12917797	avatar-a-2
13345245	Ledi-Ket-2
13455418	masha-smile-2
13531666	dimon666999-2
13622570	Gleb68-2
13721740	ilia97-2
13837072	Sergeeva-Sasha-2
14000673	SM2000-2
14033741	Alena1992-2
14246646	TRR-RRT-2
14331607	dsge-2
14349347	Sasha-0000-2
14600052	vladislavermakov-2
14837631	walda-2
14853470	BOOMEER-2
14895864	b04-2
14937903	deniskulagin-2
14942423	froli-2
14950663	vtb24-2
14975351	AndreyKa1992-2
15094346	Ganibal15-2
15096988	lukin-dima-2
15138953	alek-somov-2
15194070	serzar-2
15222190	pupkinvasilij-2
15274268	Lisa-14-2
15277858	vlesu-2
15413622	Natural-Stone-2
15505197	fadeeww-2
15577311	Nexsus2-2
15593407	i-95-2
15607711	OLIMPIETS-2
15611246	ruslanguliev-2
15620298	kradinov-2
15663360	electro-shok-2
15675455	anikin-oleg-2
15702439	ermakov-maksim-2
15733203	kirilsmirnov-2
15736956	prudnikov-s-2
15745706	helpo-2
15747807	ryblik-2
15756013	valera-safin-2
15761863	lidiya-markova-2
15767632	lena-kudinova-2
15799033	oleg-ivanko-2
15799296	torg-shop-2
15810566	annasorokin-2
15814639	Krikova-2
15827159	Katya-Katya-Katerina-2
15848622	sega-111-2
15864583	masterdesk-2
15874192	starostenkoS-2
15882665	kisa-1984-2
15913044	cherfil-2
15929188	ruda9-2
15939341	Chesnok12-2
15953331	ceroja-2
15966903	ALEKSANDER86-2
15969232	sergo282-2
15972157	fryg-2
15975710	julia-orlova-2
15988811	tech-snab-2
15995496	ARTIMED-2
16022285	ivanovaanastasiya-2
16031789	Mefisto666-2
16090475	gorina-olga-2
16094417	alfiya-karimova-2
16118018	and-gorb-2
16132074	mariy-gavrilova-2
16138095	dima-pupkov-2
16147273	davidoo-2
16147781	Andronovartem-2
16155689	n-aksenova-2
16163794	LoGan505-2
16186143	press-kz-2
16190189	Slavunec-2
16217367	sergeydemin-2
16231367	interiorart-2
16235486	antonermakoff-2
16277944	blov-2
16284002	evgeniy-antonov-2
16312687	pva555-2
16352513	anatoly-bondarenko-2
16356220	kotsyuba-2
16360752	Konstantin-Bel-2
16363066	vitalik-golubev-2
16381954	prijmak-2
16426820	midoyan-2
16434786	vovalazarev-2
16440921	autoglobus-2
16442759	Super-koshka-2
16444260	menchikov-2
16450370	natalyaerofeeva-2
16482081	Boladi-2
16483906	eklmn11-2
16499280	bonmon-2
16504448	Caku-2
16518774	arkan2012-2
16523368	smirno-nataliya-2
16524157	Stef666-2
16555230	qwe-qweewq-2
16567483	savinirina-2
16581028	RSCtuapse-2
16592486	macximus-2
16602205	mkonakova-2
16603161	PSP-gamer-2
16604228	alina-alieva-2
16615492	paxa-paxa-2
16617141	liza-kim-2
16621464	mironova2012-2
16624131	timur-garaev-2
16624398	stroitelniy-2
16630991	DEM-123-2
16654937	fantomas68-2
16655588	denis-nekrasov-2
16657546	preved-2
16699773	lama00-2
16705698	BATTLE-RAP-2
16731694	dinara-amineva-2
16757570	tdelectric-2
16758301	o-kar-2
16761281	inway2
16794188	nasti2011-2
16831096	venta-direct-2
16857239	MAA2011-2
16876184	karlino-2
16884950	samson00-2
16910144	tamara-petrenko-2
16918846	ashimov-2
16931726	er123er-2
16958625	zabolotnev-2
16962682	Coockie-2
16975518	psha-2
16981664	daniil-dmitriev-2
16995311	antonrepin-2
17013539	avto-tp-2
17060956	Romanova-Ekaterina-2
17068380	sergei-kon-2
17095751	antonosergej-2
17096750	rinatsabirov-2
17113020	kisel-v-2
17131116	Vera-Fedorovna-2
17132946	soloalena-2
17141241	tema-titov-2
17143775	pav-tom-2
17146532	and-avdeev-2
17153192	pashanikolaev-2
17167713	sorokina-N-2
17169438	romanantipin-2
17169863	svetlana-mokrushina-2
17177390	oven2012-2
17177709	zenja8-2
17186701	meleana-2
17191700	svetlana-kolobaeva-2
17194331	dim-reznik-2
17206909	evakuat-2
17240482	lyudmilafedorova-2
17246331	acumen1-2
17247343	svetlana-bodrova-2
17258042	konev-andrei-2
17259258	kotov-dmitrij-2
17264261	stroyka25-2
17267125	gennady-gorbunov-2
17270728	yanabogdanova-2
17293472	natape-2
17303589	skladmetalla-2
17310726	anohin-denis-2
17316122	konstantin-bragin-2
17322037	rabota-747-2
17331558	rodionov-vladimir-2
17337440	vladislav-marchenko-2
17341687	Kristall2012-2
17350932	vlad1919-2
17351739	natali-samsonova-2
17354006	Nastusha333-2
17370343	George-73-2
17383941	ggogo-2
17389840	Ershik0-2
17397527	alena-54-2
17414532	slava-rudenko-2
17416080	SASHA2403-2
17422928	alex9934-2
17427910	fyv-f-2
17433209	biz2011-2
17433615	aleks-demchenko-2
17438411	galina-ivaschenko-2
17443652	roma-losev-2
17445596	nastya-ramazanova-2
17460635	gemotest1-2
17464790	romanva-2
17484169	msamsamsa-2
17491338	andrei-voronov-2
17495084	sergey-timoshenko-2
17496524	artiom-petrov-2
17518814	viktoriya-morozova-2
17524251	anastasia-alexeeva-2
17525058	ekaterina-kondratova-2
17527292	Sergey-Che-2
17527297	geras-galina-2
17551883	sergeevanata-2
17552967	sveta-zinina-2
17558542	LarisaPetrovna-2
17561633	petr-prokhorov-2
17562040	itrd-2
17562683	benbou1-2
17577551	tatjanaklimova-2
17578358	grechaniy-2
17581618	COUNTER2011-2
17587013	yurtaeff-2
17601506	sherzod2011-2
17612799	RAX1k-2
17640908	dmitry-lavrov-2
17648175	s-kochkin-2
17653847	gena-crokodil-2
17658508	yablonskih-2
17664620	torooo-2
17677910	dimarik93-2
17678732	AlenaPonomareva-2
17679391	rusik1974-2
17680112	alga2011-2
17691576	VALERY1111-2
17700177	vlad-tim-2
17703024	petrek-2
17739517	avitor-2
17745671	svitov-2
17752298	sergej-dodonov-2
17753566	dasha-va-2
17753832	voron-olya-2
17778932	inna-zhdanova-2
17789595	nikolai1973-2
17790035	nail-sultanov-2
17793697	se64-2
17796587	proffi2012-2
17801552	arm-arakelyan-2
17807396	mikhailpopo-2
17815384	slava-nikiforov-2
17837147	trentino-2
17841472	koz-misha-2
17859354	pip88-2
17872134	gena-123-2
17894742	pr-z-2
17910143	xas2011-2
17927313	marchenkoff-2
17937993	turx-2
17945364	elena-gaponova-2
17950839	ser-kartashov-2
17974764	YarSan-2
17989066	anastasia-pronina-2
18011048	surov-oleg-2
18012614	textpro-2
18020046	Raissssa-2
18046583	smi-iv-2
18054884	sergey-gol-2
18058289	chinaline-2
18061341	len-fokin-2
18076090	denisberezin-2
18082009	vladimir-zarubin-2
18083332	dunya2011-2
18093259	zxcvbnnb-2
18099885	Roman689-2
18100830	Y-56-2
18109562	nonstop2012-2
18109898	aleksejjj-2
18112870	sanya-berezin-2
18126807	zem2012-2
18129840	petrenko-o-2
18131711	Karl2012-2
18151677	iv-smi-2
18152935	alekszaharov-2
18154575	DOKA2011-2
18192167	sbolonin-2
18201924	Shmidt2011-2
18209319	zevis-2
18233835	shanti-s-2
18245745	SHEFF84-2
18251050	PLAST2011-2
18260891	sergey-61-2
18272186	frau-v-2
18274912	ooo-a-1
18277799	viktoriyaromanova-2
18284475	git2011-2
18287391	alena-alimova-2
18296500	meschankin-2
18315546	vera-sheina-2
18316613	mikroavto-2
18316988	Alla-mama-2
18336552	Ivanov1705-2
18353400	chernikov-dmitry-2
18363678	arm-margaryan-2
18364685	sergey-bo-2
18365600	gluhof-2
18372763	irinafedoseeva-2
18373539	VOLGOS-2
18374072	vip-villa-2
18382238	sabyr-z-2
18385720	alfa-teh-2
18393160	tsvetkovaa-2
18413606	kirillov2012-2
18414850	SSN2011-2
18419984	lena-bulatova-2
18443786	vital-fomin-2
18446363	SATarasova-2
18467368	mar-shevchenko-2
18477023	martynova-olga-2
18479270	vanno3-2
18500932	ya-alice-2
18521564	businessinform-2
18530883	liza-tarasova-2
18542420	olga-minina-2
18551508	newsnip-2
18553899	ganya321-2
18556977	suvenir12-2
18566176	slavik-kuzin-2
18571747	danila-antonov-2
18579300	kabanova-ekaterina-2
18579553	tzibizov-2
18580055	rabota21v-2
18616408	prostoinfo-2
18626595	lizavetas-2
18636146	vanya-makarov-2
18639971	dmitry-konoplin-2
18661644	SergejVasiljev-2
18684547	petrogena-2
18692040	eduardivanov-2
18694498	i-miheeva-2
18697627	pawel-pawel-2
18701869	misha-swat-2
18706025	oreh-oreh-2
18714521	kuzm-i-2
18719290	an-ek-2
18725494	asasas2012-2
18734134	Mura2012-2
18743717	e-06-2
18744352	lena-ovcharenko-2
18756967	thovo-2
18760799	lola-ibragimova-2
18773329	ska-s-2
18789962	Belova43-2
18810856	agraff1-2
18861053	Curus-2
18897022	Pechurkina-2
18897699	Dmitri-Krasnov-2
18899530	ser-zhdanov-2
18913055	Krasniansky-2
18915071	antono-sergey-2
18918118	s-2105-2
18921520	tigrof-2
18935520	gera-simow-2
18947939	german-petrov-2
18956106	stroi-profi-2
18982488	gagauz2011-2
19002049	renata-p-2
19005543	ooocmc-2
19013287	denisov-danil-2
19033665	victor-kalugin-2
19049062	Krol211-2
19049218	vitalik-74-2
19065733	Russia1992-2
19088824	o-efim-2
19103235	solovej-igor-2
19119383	konkord1973-2
19129565	mazda03-2
19142237	ilyin-el-2
19142982	ilya-kan-2
19143167	Kostya666666-2
19164283	Lika752-2
19169345	cnhtktw27-2
19172216	abyhto-2
19187167	olegromanenko-2
19220229	lekha-andreev-2
19224268	sergee-tatyana-2
19228613	Korochkin1-2
19229262	MIFNS6-2
19232156	fil77777-2
19237214	injgjh-2
19274054	fdsafdsafdsafdsa-2
19287631	peter0-2
19304255	Prohor82-2
19307392	ya-ex-2
19323680	parosha-2
19350477	artem-koshkin-2
19351597	overdo151-2
19354122	MASHINA32-2
19354946	glassproekt-2
19355734	dg201-2
19359310	allaprint-2
19360229	pet-pavlov-2
19360625	vitalij-stepanov-2
19365767	ruzalin-2
19381061	saipulaev-2
19388312	komavto12-2
19391080	katerina-lineva-2
19401053	Filin-74-2
19430708	igor-igolkin-2
19441472	Olga-Ivanushkina-2
19453414	AleksaDen-2
19462515	irina-doroshenko-2
19471256	grosheva-l-2
19474266	is2012-2
19475295	djakonoff-2
19476846	lar-matveeva-2
19484428	arte10-2
19501357	zvenigorod1-2
19513377	Ivanov2050-2
19517007	ridus-2
19541412	igor-komissarov-2
19562176	Radmirrr-2
19565287	ya-fors-2
19566980	lyubov-moiseeva-2
19568623	bereznikov-aleks-2
19586899	Viktor-Kucherenko-2
19618335	ya-vortex-2
19622814	canek2012-2
19626956	qweeqwee-2
19659416	rainbow77777-2
19661216	Tamerlan-M-2
19663900	marina-zin-2
19668421	veradudkina-2
19684449	vova-ts-2
19694642	denis-school-2
19695789	fedornadya-2
19696876	Rasul2012-2
19702263	nadezhdaefimova-2
19736810	koks-alex-2
19773511	yakubov-nn-2
19781511	AlexeevPavel-2
19789231	andrei-onishenko-2
19800351	anyabelousova-2
19813952	irina-trushkova-2
19828340	rus-suleimanov-2
19830296	valentin-kot-2
19873426	salamon21-2
19881788	Rauna-2
19894366	sasha-karimov-2
19925978	danilalekseev-2
19938274	lll0lll-2
19945104	mk-km-2
19945854	vadim-babenko-2
19950487	vera-kolupaeva-2
19955202	tatyana-lisina-2
19973263	evg-melnik-2
19985106	yuliya-trofimova-2
19988951	FetisovaElena-2
19995736	kuznecovatanya-2
19997200	anyamiller-2
20009727	balabanovegor-2
20014352	evg-velichko-2
20023695	Larisa-08-2
20024483	tek2011-2
20025263	anna-bulaeva-2
20032052	fishmagnet-2
20040981	bojko-andrej-2
20041822	oleg-kosmachev-2
20049938	vladimirkalugin-2
20054678	Zotova-Tatyana-2
20058439	e-orsk-2
20062547	kapchik-2
20091663	wmr11-2
20127555	lazarev-m-2
20129437	andr-or-2
20139020	nevesti-2
20142917	marina1709-2
20144730	grom-00-2
20150110	qwer1232011-2
20170205	fedin-v-2
20206116	sergej-palkin-2
20226740	TRON2012-2
20228745	tatyana-semenchenko-2
20279312	AS12AS12-2
20280497	dverinn-2
20287017	zaitsev09-2
20312821	dvurru-2
20324331	bondarenko-1-2
20368617	vaz1951-2
20379322	oksana-komissarova-2
20444287	best-dima-2
20445338	ain96-2
20507921	maxim-ermakov-2
20525138	kms2011-2
20553306	otel-servis-2
20570005	andrej-korovkin-2
20615233	AD163-2
20630812	rus1015-2
20631376	dep2011-2
20647617	valentinafedotowa-2
20670809	din55555-2
20671402	ya-andrei1-2
20696570	igorgarik-2
20711203	vkusleta-2
20719914	larin-sergej-2
20741965	olegsafin-2
20757897	sokolo-s-2
20788364	Super-mashin-2
20801987	andrey-kuchin-2
20855622	medve-oksana-2
20915996	jack-riper-2
20930944	arturkamalov-2
20958568	RAXIM79-2
21008237	Bresson-2
21026344	shevchenko-roman-2
21047470	maks7-7-2
21048241	Kuba85-2
21057186	saf71-2
21066207	vladisl-smirnov-2
21096809	dok-t-2
21098401	doroshkov-2
21112469	oksana-zadorozhnaya-2
21119856	trofimova2012-2
21122357	oleg-mazaj-2
21130346	dmitrievanatalya-2
21150728	rrevizor-2
21173522	arturakopyan-2
21181579	mari-aleksandrovna-2
21193906	studio-mg-2
21194165	sergeyfedoto-2
21195454	fital2
21207367	Malinowsky-2
21223997	cehan-2
21236126	galanikolaeva-2
21283976	Digit-N-2
21285125	cntafybz-2
21312239	valerijstepanov-2
21376446	vasilevmax-2
21395268	sergey2545-2
21412563	Dima2587-2
21413964	KlimovaSvetlana-2
21420381	sergi2012-2
21428156	andr-orlo-2
21433993	altair-p-2
21486721	galinaselezneva-2
21490362	romek7-2
21533143	p-fomin-2
21550471	boris-polyakov-2
21554888	boom163-2
21571943	nikolae-nikolai-2
21572151	senia2012-2
21613171	diana-bojko-2
21650769	lyubov-filippova-2
21689755	Zimin-Alexander-2
21690349	tatyana-turkova-2
21731844	Darmidon777-2
21732684	divo-group-2
21741019	svetlana-bulanova-2
21745372	bell94-2
21753035	krikki-2
21759417	ikub-2
21763719	vasileva-nadezhda-2
21770356	gorin-aleksandr-2
21776135	sergeysamson-2
21781898	vasilmaks-2
21824608	gevorg07-2
21828620	t-kar-2
21834974	alexisae-2
21855584	telegin-a-2
21877638	S1957A-2
21893015	vsepro100-2
21931039	Buyer2011-2
21938684	Ksennn-2
21944254	serg-borodkin-2
21948220	mish-sergey-2
21985179	pashukova-2
22003488	gfhfgf-2
22045093	rus12312-2
22076313	oleg-qqq-2
22141157	nunu23-2
22146220	romanovzhenya-2
22173360	evgen-roman-2
22374524	vladimir-smirnow-2
22384651	KristinaGavrilova-2
22397703	deniskudinov-2
22416646	aleksandrovsergej-2
22488993	pig2011-2
22506811	ry-d-2
22531089	mashina49-2
22531245	malkin2011-2
22570732	markin2012-2
22619597	maga-magomed-2
22680035	mahoninaolga-2
22681274	kost-morozov-2
22723334	F-34-2
22754551	anas-tarasova-2
22773119	zvezd7-2
22806556	pawe-p-2
22823804	ira-kolo-2
22834756	sizvekova-2
22883563	MDante-2
22893824	AN-Lukin-2
22917522	pupki-vas-2
22943041	galina-kolpakova-2
23110935	vadim-budaev-2
23149176	olga-rya-2
23233196	lexapavloff-2
23282336	zaharov-victor-2
23302808	svirid-oleg-2
23311308	artyom-nazarov-2
23311363	poletkov-2
23552264	elfxf89-2
23563274	RS-Catalog-2
23592027	Voitovitch-2
23649644	uchastok2012-2
23650541	belikovdenis-2
23696168	redibyrf-2
23702291	lifeordeath-2
23736364	seiidova-2
23783063	andre994-2
23890549	kuzmina2011-2
23912712	nurmatow-2
23920763	makarov-zhenya-2
24168201	Hukuta8-2
24309037	egor-nazarov-2
24332812	papillon71-2
