#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '3 min',
        comment => "удаляем сохраненные цены == 0 из bids_manual_prices",
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Yandex::DBTools;

# -----------------------------------------------------------------------------
sub main {
    $log->out("start");

    my $zero_prices = get_all_sql(PPC_HEAVY, "select * from bids_manual_prices where price = 0");
    return unless @$zero_prices;
    $log->out($zero_prices);

    my $res = do_delete_from_table(PPC, 'bids_manual_prices', where => {id => [map {$_->{id}} @$zero_prices], price => 0});
    $log->out("result: $res");

    $log->out("finish");
}

# -----------------------------------------------------------------------------
main();
