#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => 0,
    db => "monitor",
    when => 'before',
    time_estimate => "1 sec",
    sql => "
        CREATE TABLE `events` (
          `eid` int(10) NOT NULL auto_increment,
          `eventobject` enum('camp','banner','phrase') NOT NULL default 'camp',
          `eventtype` enum('c_start','c_finish','c_status','c_pay','c_autooptimisation','c_autobudget','c_day_budget','b_create','b_text','b_status','b_word','b_category','b_geo','ph_price','ph_autobr','ph_change','c_strategy','ph_price_ctx') default NULL,
          `eventtime` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
          `objectid` int(10) NOT NULL default '0',
          `objectuid` bigint(20) NOT NULL default '0',
          `uid` bigint(20) NOT NULL default '0',
          `cid` int(10) NOT NULL default '0',
          `oldtext` text,
          `newtext` text,
          `statusSent` enum('Yes','No') NOT NULL default 'No',
          PRIMARY KEY  (`eid`),
          KEY `i_Sent` (`statusSent`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8
    ",
  },
  {
    type => 'manual',
    when => 'before',
    text => 'запустить на ppcback01f
sudo -u ppc /var/www/ppc.yandex.ru/protected/ppcClearEvents.pl
', 
    time_estimate => '15 минут',
  },
  {
    type => 'script',
    when => 'instructions',
    instructions => 'запустить через 10 минут после выкладки',
    time_estimate => "5 минут",
  },
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

$log->out("start");
my $cnt = do_insert_select_sql(PPC, "INSERT IGNORE INTO events (
                                            eventobject, eventtype, eventtime,
                                            objectid, objectuid, uid, cid,
                                            oldtext, newtext, statusSent
                                            ) VALUES %s", 
                                    "SELECT eventobject, eventtype, eventtime,
                                            objectid, objectuid, uid, cid,
                                            oldtext, newtext, statusSent
                                       FROM events",
    dbw => MONITOR
    );
$log->out("Moved $cnt rows of events from PPC to MONITOR");
$log->out("finish");
