#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '5 часов',
        comment => 'Переносим ссылки со статусом Deleted в конец очереди',
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Antispam;
use Data::Dumper;

$log->out('START');


my $antispam_urls;
# Я точно знаю, что ссылки раньше этого номера уже были отправлены в Антиспам и видится, что их нет смысле отправлять снова.
my $from_request_id = 13681628;
my $count_urls = 20_000;
#Запоминаем последний request_id в очереди, чтобы не перепроходить те, которые будут изменены в процессе. 
my $max_request_id = Antispam::get_max_id();
do {
    # Берем ссылки пачками по $count_urls урлов
    $antispam_urls = get_antispam_url_list($from_request_id, $count_urls, $max_request_id);
    $log->out(sprintf("Have got %d deleted urls from request_id=%d", scalar(@{$antispam_urls}), $from_request_id));

    # Запоминаем request_id для следующей выборки
    my $last_antispam_url = $antispam_urls->[scalar(@{$antispam_urls})-1];
    $from_request_id = ($last_antispam_url->{request_id} || 0) + 1;

    # Удаляем request_id, чтобы replace оператор вставил записи с новым значением (что позволит оказаться ссылкам в конце очереди).
    my @urls_for_save = map {delete $_->{request_id}; $_} @{$antispam_urls};
    my $t = time();
    Antispam::save_urls(\@urls_for_save);
    my $time_diff = time()-$t;
    $log->out(sprintf("Updated %d deleted urls. Spent %d sec", scalar(@{$antispam_urls}), $time_diff));
    # Спим
    sleep($time_diff);
} while ($max_request_id > $from_request_id && $from_request_id > 1);

sub get_antispam_url_list {
    my ($from_request_id, $count_urls, $max_request_id) = @_;
    return get_all_sql(MONITOR, "SELECT request_id, href, href_hash, status, priority FROM antispam_queue WHERE status='Delete' AND request_id>= ? AND request_id<=? ORDER BY request_id LIMIT ?", $from_request_id, $max_request_id, $count_urls);
}
$log->out('FINISH');
exit(0);