#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
    {
      type => 'sql',
      when => 'before',
      webstop => 0,
      db => "ppc",
      time_estimate => "1 сек",
      sql => "CREATE TABLE IF NOT EXISTS bids_bs_history (
                    `cid` int(10) unsigned NOT NULL,
                    `id` int(10) unsigned NOT NULL,
                    `bsIdHistory` varchar(100) NOT NULL,
                    `update_time` timestamp NOT NULL default CURRENT_TIMESTAMP,
                    PRIMARY KEY (cid, id)
                );",
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => 'На devtest около 4-х часов',
        comment => q[
            Запускать вечером(в 19 или позже) после выкладки
            Копируем bids(,_arc).bsIdHistory в bids_bs_history
        ],
    }
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;

my @TBL = (
    {name => 'bids', key => 'id', chunk => 1_000_000},
    {name => 'bids_arc', key => 'cid', chunk => 50_000},
);

for my $tbl (@TBL) {
    my ($min_id, $max_id) = get_one_line_array_sql(PPC_HEAVY, "SELECT min($tbl->{key}), max($tbl->{key}) FROM $tbl->{name}");
    $log->out("start process table $tbl->{name}, max_id=$max_id");
    while($min_id <= $max_id) {
        my $cnt = do_insert_select_sql(PPC_HEAVY,
                "INSERT IGNORE INTO bids_bs_history (cid, id, bsIdHistory, update_time) VALUES %s",
                "SELECT cid, id, bsIdHistory, modtime
                  FROM $tbl->{name}
                  WHERE PhraseID = 0
                    AND IFNULL(bsIdHistory, '') != ''
                    AND $tbl->{key} between $min_id and ".($min_id + $tbl->{chunk} - 1)
                ,
                dbw => PPC
            );
        $log->out("Moved $cnt rows for $tbl->{name} where $min_id <= $tbl->{key} < ".($min_id + $tbl->{chunk} - 1));
        $min_id += $tbl->{chunk};
    }
}
