#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '1 sec',
        comment => "удаляем одного из менеджеров на агентстве molinosmb",
    }

=cut

=head1 DESCRIPTION

    https://jira.yandex-team.ru/browse/DIRECT-14934

    Агентство Molinos (логин molinosmb).
    Сейчас у аг-ва два менеджера:
    Юля Козлова, логин yndx.julia-ko.manager.
    Людмила Данилушкина, логин ldanilushkina.
    Должна остаться только Людмила Данилушкина, логин ldanilushkina, и в медийке, и в Директе.
    Оторвите, пожалуйста, менеджера yndx.julia-ko.manager от этого агентства.

    production:ppc:heavy> select uid, ClientID, login, FIO from users where login = 'molinosmb';
    +----------+----------+-----------+---------+
    | uid      | ClientID | login     | FIO     |
    +----------+----------+-----------+---------+
    | 14587524 |    34975 | molinosmb | Molinos |
    +----------+----------+-----------+---------+

    production:ppc:heavy> select * from clients where ClientID = 34975 \G
    *************************** 1. row ***************************
                           ClientID: 34975
                               name: Molinos
                      work_currency: NULL
                       pay_currency: NULL
                        create_date: 2005-10-28 00:00:00
                       deleted_reps: 86908522,84243528,69765791,21508571,88554367,82525728,134539
                         agency_url: www.molinos.ru
                      agency_status: SA
                primary_manager_uid: 41488200
          primary_bayan_manager_uid: 139770521
            primary_geo_manager_uid: 112635943
             last_stopped_warn_mail: NULL
               sum_on_stopped_camps: NULL
    allow_create_scamp_by_subclient: No
                 can_use_day_budget: No

    production:ppc:heavy> select uid, login, FIO from users where uid in (41488200, 139770521, 112635943);
    +-----------+-----------------------+---------------------------------------+
    | uid       | login                 | FIO                                   |
    +-----------+-----------------------+---------------------------------------+
    |  41488200 | ldanilushkina         | Данилушкина Людмила                   |
    | 112635943 | yndx-geomanager       | Сидорова Мария                        |
    | 139770521 | yndx-julia-ko-manager | Козлова Юлия                          |
    +-----------+-----------------------+---------------------------------------+

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Primitives;
use RBACDirect;
use RBAC2::Extended;
use Yandex::DBTools;

# -----------------------------------------------------------------------------
sub main {
    $log->out("start");

    my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
    $log->die("RBAC2 create failed") if ! defined $rbac || $rbac->InitReq(1) != 1;

    my $old_manager_uid = get_uid_by_login('yndx.julia-ko.manager') or $log->die("manager yndx.julia-ko.manager not found");
    my $new_manager_uid = get_uid_by_login('ldanilushkina') or $log->die("manager ldanilushkina not found");

    my $agency_uid = get_uid_by_login('molinosmb') or $log->die("agency molinosmb not found");
    my $agency_client_id = rbac_get_agency_clientid_by_uid( $agency_uid) or $log->die("agency ClientID not found");

    my $rbac_error = rbac_withdraw_manager_from_agency($rbac, $old_manager_uid, $agency_client_id);
    my $update_result = do_update_table(PPC, "clients", {primary_bayan_manager_uid => $new_manager_uid}, where => {ClientID => $agency_client_id});

    $log->out({
        old_manager_uid  => $old_manager_uid,
        new_manager_uid  => $new_manager_uid,
        agency_uid       => $agency_uid,
        agency_client_id => $agency_client_id,
        rbac_error       => $rbac_error,
        update_result    => $update_result,
    });

    $log->out("finish");
}

# -----------------------------------------------------------------------------
main();
