#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2.5 часа",
  comment => "Проставляем метро всем старым визиткам, переотправляем в БК все визитки с метро"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;

use Settings;
use Metro;
use Yandex::DBTools;
use Yandex::Retry;
use geo_regions;
use open ':std' => ':utf8';
use Time::HiRes qw/sleep/;
$|++;

my $UPDATE_CHUNK = 50_000;

my $xycache = {};

$log->out('start');

my ($vcards_seen, $vcards_updated, $metro_found) = (0,0,0);

my ($min_cid, $max_cid) = get_one_line_array_sql(PPC, "select min(cid), max(cid) from campaigns");

while ($min_cid < $max_cid) {
    update_metro($min_cid, $min_cid + $UPDATE_CHUNK);
    $min_cid += $UPDATE_CHUNK;
}

# переотправляем все визитки с метро, старый экспорт работал неправильно, см. DIRECT-14992
my $resend = int do_sql(PPC, "
    insert ignore into bs_resync_queue (cid, bid) 
    select vc.cid, b.bid from vcards vc join banners b on b.vcard_id = vc.vcard_id 
    where metro is not null and metro <> 0");

$log->out("updated vcards - $vcards_updated of $vcards_seen processed; metro found for $metro_found vcards, $resend banners to resend to BS");
$log->out('finish');
exit;

sub update_metro
{
    my ($min_cid, $max_cid) = @_;
    my $sth = exec_sql(PPC, ["select c.cid, vc.vcard_id, x, y, vc.city, a.aid, vc.LastChange
            from campaigns c
            join vcards vc on vc.cid = c.cid
            join addresses a on vc.address_id = a.aid
            join maps m on a.map_id = m.mid
            ", where => {
                'vc.metro__is_null' => 1,
                'vc.geo_id' => [213,143,2],
                'c.archived' => 'No',
                'c.cid__between' => [$min_cid, $max_cid],
        }, " order by c.cid, vc.vcard_id"]);
    while (my $row = $sth->fetchrow_hashref()) {
        $vcards_seen++;
        my ($x, $y) = @$row{qw/x y/};
        my $metro = $xycache->{"$x,$y"};
        unless (exists $metro->{region_id}) {
            retry tries => 5, pauses => [ 0.5,1,2,5 ], sub {
                local $SIG{__WARN__} = sub {
                    if ($_[0] =~ /Geocode error/) {
                        die 'retry';
                    }
                };
                $metro = search_metro(@$row{qw/x y city/});
                if ($metro->{distance} > 1.5) {
                    $metro->{region_id} = 0;
                }
                sleep 0.05; # be nice to geocoder
            };
            unless ($metro) {
                $metro = { region_id => 0 };
            }
            $xycache->{"$x,$y"} = $metro;
        }
        next unless $metro->{region_id};
        $metro_found++;
        my $updated = int do_update_table(PPC, 'vcards', 
            { metro => $metro->{region_id} }, where => 
            { vcard_id => $row->{vcard_id}, LastChange => $row->{LastChange} });
        if ($updated) {
            do_update_table(PPC, 'addresses', { metro => $metro->{region_id} }, where => { aid => $row->{aid} } );
        }
        $vcards_updated += $updated;
        $row->{metro} = $metro;
        $row->{updated} = $updated;
        $log->out($row);
    }
}



