#!/usr/bin/perl -w



use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use RBACDirect;
use RBAC2::Extended;
use Notification;

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '30 sec',
        comment => 'adds notifications to crm_queue table',
    }
=cut

my $rbac = new RBAC2::Extended(RBAC, RBAC_SLAVE);
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

my $uid_clientid = rbac_get_agencies_clientids_by_uids( rbac_get_all_agencies($rbac));

my $clients = {};
for my $uid (keys %$uid_clientid) {
    $clients->{ $uid_clientid->{$uid} } = 1;
}

for my $client_id (keys %$clients) {
    Notification::add(PPC, $rbac, 'agency_manager_changed', { client_id => $client_id });
}
