#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
    {
      type => 'sql',
      when => 'before',
      webstop => 0,
      db => "ppcdict",
      time_estimate => "1 сек",
      sql => "CREATE TABLE `bid_experiment` (
                  `ClientID` int(10) NOT NULL DEFAULT '0' UNIQUE,
                  `slot` tinyint(2) NOT NULL
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8;",
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => '8 sec',
        comment => q[populate table bid_experiment],
    }
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;

use JSON;
use File::Slurp;

my $slots = decode_json read_file("$Bin/20120130_create_bid_experiment.json.data", binmode => ':utf8');
foreach my $slot (keys %$slots) {
    
    $log->out("start insert clients from slot $slot");
    $log->out("slot $slot quantity " . scalar @{$slots->{$slot}});
    do_mass_insert_sql(PPCDICT,
        'INSERT IGNORE INTO bid_experiment(ClientID, slot) VALUES %s',
        [map {[$_, $slot]} @{$slots->{$slot}}], {
            max_row_for_insert => 8000
        });
    $log->out("finish slot $slot");
}

