#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '15 min',
        comment => "разархивируем гео-кампании",
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Yandex::DBTools;
use Common qw/unarc_camp/;


$log->out('start');
my $camps = get_all_sql(PPC, '
    SELECT cid, uid
    FROM campaigns
    WHERE type = "geo" and archived = "Yes"
');
for my $camp (@$camps) {
    $log->out("going to unarc camp $camp->{cid}");
    unarc_camp(PPC, $camp->{uid}, $camp->{cid}, force => 1);
}
$log->out('finish');
