#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 минут",
  comment => "Сбрасываем метро у визиток, у которых не указан адрес"
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;

use Settings;
use Yandex::DBTools;
use open ':std' => ':utf8';

$log->out('start');

my $vcards = get_all_sql(PPC, ["
        select vc.cid, vc.vcard_id, a.aid, vc.metro
        from vcards vc 
        join addresses a on vc.address_id = a.aid
        join maps m on a.map_id = m.mid
        where (", 
        {
            'vc.metro' => 20489, # Библиотека им. Ленина - станция по-умолчанию
            x => 37.609218, # точки по-умолчанию
            y => 55.753559,
        }, ') OR (',
        {
            'vc.metro' =>20347, # Невский пр.
            x => 30.313622,
            y => 59.937720
        }, ') OR (',
        {
            'vc.metro' => 101907, # Площадь Независимости
            x => 30.522301,
            y => 50.451118 ,
        },
        ') AND ',
        {
            precision => 'other' ,
            LastChange__between => ['2012-01-30 16:18:48', '2012-01-30 17:56:49'], # был изменен во время работы прошлого деплоя
        }, ]);

$log->out('BEFORE:');
$log->out(get_all_sql(PPC, "select metro, count(*) cnt from vcards group by metro having cnt > 0 order by metro"));

$log->out({ selected_vcards => scalar @$vcards });

my @resend_vcard;
for my $vcard (@$vcards) {
    do_update_table(PPC, 'vcards',    { metro => 0 }, where => { vcard_id => $vcard->{vcard_id} });
    do_update_table(PPC, 'addresses', { metro => 0 }, where => { aid => $vcard->{aid} });
    push @resend_vcard, $vcard->{vcard_id};
    $log->out($vcard);
}

my $resend = int do_sql(PPC, ["
    insert ignore into bs_resync_queue (cid, bid) 
    select vc.cid, b.bid from vcards vc join banners b on b.vcard_id = vc.vcard_id",
    where => { 
        metro => 0,  
        'vc.vcard_id' => \@resend_vcard,
    }] );

$log->out("$resend banners to bs_resync_queue");

$log->out('AFTER:');
$log->out(get_all_sql(PPC, "select metro, count(*) cnt from vcards group by metro having cnt > 0 order by metro"));

$log->out('finish');


