#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '25 min',
        comment => 'В неспешном режиме зануляем флаг statusUnFamily в таблице banners',
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out('START');

my $from_bid = 0;
my $count_banners = 50_000;
my $max_bid = get_one_field_sql(PPC, "SELECT MAX(bid) FROM banners");
while ($from_bid <= $max_bid) {
    my $bids = get_one_column_sql(PPC, "SELECT bid FROM banners WHERE statusUnFamily='Yes' AND bid>= ? AND bid<=? ORDER BY bid LIMIT ?", 
                            $from_bid, $max_bid, $count_banners);
    last unless (scalar(@{$bids || []}));

    my $t = time();
    do_update_table(PPC, 'banners', {statusUnFamily=>'No'}, where => {bid => $bids});
    my $time_diff = time()-$t;
    $log->out(sprintf("Updated banners, spent %d sec", $time_diff));
    # Запоминаем bid для следующей выборки
    $from_bid = (pop @{$bids}) + 1;

    # Спим
    sleep($time_diff);

}

$log->out('FINISH');
exit(0);