#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => '0 sec',
        comment => 'Исключаем из эксперимента клиентов',
    }
]

=cut


use warnings;
use strict;
use utf8;

use lib '../protected';

use Settings;
use Yandex::DBTools;

my @logins = qw/pricesearch www-MaxVerona-ru tecompany-new1 pixelon2817 almaks-geo academy-health-ru alexey-strokin dendenden77/;

my @exclude = @{get_one_column_sql(PPC,
    ['select ClientID from users', where => {login => \@logins}]) || []};
do_delete_from_table(PPCDICT, 'bid_experiment', where => {ClientID => \@exclude});

my @agencies = qw/uraldextra mskdextra/;
my $clients = get_one_column_sql(PPC,
    ['select ClientID from users', where => {login => \@agencies}]) || [];
my $add_clients = get_one_column_sql(PPC,
    ['select DISTINCT ClientID from campaigns', where => {AgencyID => [-1, @$clients]}]) || [];

my $slot = 0;
do_mass_insert_sql(PPCDICT, q[INSERT bid_experiment(ClientID, slot) 
    VALUES %s 
    ON DUPLICATE KEY UPDATE 
        slot = IF(slot > 10, VALUES(slot), slot)], [map {
    [$_, (++$slot % 10) + 1]
} @$add_clients]);
