#!/usr/bin/perl -w

use strict;

=head1 DEPLOY

# approved by lena-san
# .migr
[{
    type => 'script',
    when => 'after',
    time_estimate => 'на devtest: порядка 2 минут',
    comment => 'удаляет пробелы из users.email клиентов (затрагивает порядка 5000 клиентов)',
}]

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Yandex::DBTools;
use Settings;
use ScriptHelper;

my @mass;

$log->warn("Start!");

my $res = get_all_sql(PPC, q{ select uid, email from users where email != '' and (email rlike '^[[.space.]]' or email rlike '[[.space.]]$') } ); # порядка 5000 пользователей

$log->warn("Selected ".scalar(@$res)." items");

foreach my $u (@$res) {
    my $old_email = $u->{email};

    $u->{email} =~ s/^\s+//;
    $u->{email} =~ s/\s+$//;

    push @mass, { uid => $u->{uid}, new_email => $u->{email}, old_email => $old_email};
}

$log->out(\@mass);

my $cnt = 0;
foreach my $l (@mass) {
    $log->out({item => $l});

    my $res = do_update_table(PPC, "users", {email => $l->{new_email}}, where => { uid => $l->{uid}, email => $l->{old_email} });

    $log->warn({error => $l}) if !$res;

    unless ($cnt++ % 100) {
        sleep(2);
    }
}

$log->warn("End.");
