#!/usr/bin/perl

# https://jira.yandex-team.ru/browse/DIRECT-15030

=head1 DEPLOY

# approved by zhur
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => '1 min',
        comment => 'чистим vcard_id в banners для которых нет записей в vcards',
    }

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    my $broken_bids = get_one_column_sql(PPC, "
        select bid
        from banners b
        left join vcards using(vcard_id)
        where b.vcard_id is not null
          and vcards.vcard_id is null
    ") || [];

    $log->out({broken_bids => $broken_bids});
    return unless @$broken_bids;

    my $count = do_sql(PPC, [
        "update banners b
         left join vcards using(vcard_id)
         set b.vcard_id = NULL
        ",
         where  => {
             bid => $broken_bids,
             'b.vcard_id__is_not_null' => 1,
             'vcards.vcard_id__is_null' => 1,
        }
    ]);

    $log->out("update banners count = $count");
    $log->out('finish');
}
main();
