#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'примерно 2,5 часа',
  comment => 'переотправляем в БК фразы с дефисами в кавычках, которые отправляли 6-й и 7-й версий yandex-du-mygoodwords-perl',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;
use Yandex::DBTools;

use utf8;

$log->out("START");

my @TBL = (
    {name => 'bids', key => 'id', chunk => 1_000_000},
    {name => 'bids_arc', key => 'cid', chunk => 50_000},
);

for my $tbl (@TBL) {
    my ($min_id, $max_id) = get_one_line_array_sql(PPC_HEAVY, "SELECT min($tbl->{key}), max($tbl->{key}) FROM $tbl->{name}");
    $log->out("start process table $tbl->{name}, max_id=$max_id");

    while($min_id <= $max_id) {
        my $last_id = $min_id + $tbl->{chunk} - 1;
        my $cnt = do_insert_select_sql(PPC_HEAVY,
            q/INSERT IGNORE INTO bs_resync_queue(pid) VALUES %s/,
            qq/SELECT p.pid
              FROM $tbl->{name} bi
              INNER JOIN banners b ON bi.bid = b.bid
              INNER JOIN phrases p ON p.bid = b.bid
              WHERE
                  b.LastChange BETWEEN "2012-01-26 17:00" AND "2012-02-08 15:00"
                  AND bi.phrase LIKE '%"_%-%"%'
                  AND p.statusBsSynced = "Yes"
                  AND bi.$tbl->{key} BETWEEN $min_id AND $last_id
            /,
            dbw => PPC,
        );

        $log->out("Added $cnt phrases to resync queue from table $tbl->{name} where $min_id <= $tbl->{key} < $last_id");
        $min_id += $tbl->{chunk};
    }
}

$log->out("FINISH");
