#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Yandex::DBTools;
$|++;


=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => '25 min',
        comment => 'убираем город Сатис из гео-дерева',
    },
    {
        type => 'manual',
        when => 'after',
        text => 'запустить на ppcback01f
sudo -u ppc /var/www/ppc.yandex.ru/protected/mk_regions.pl --db
',
        time_estimate => '2 минуты',
    },
]
=cut

$log->out('start');

$log->out('selecting from campaigns');

my $camps = get_all_sql(PPC, ["select cid,geo from campaigns", where => {
            geo__like => '%20258%',
        }
    ]);

$log->out('preparing data');

my %update;
for my $camp (@$camps) {
    my ($cid, $geo) = @$camp{qw/cid geo/};
    my $new_geo = join ',', grep { !/^-?20258$/ } split /,/, $geo;
    if ($geo eq $new_geo) {
        $log->out("geo not changed ($geo)");
        next;
    }
    $log->out("camp $cid changing $geo to $new_geo");
    $update{$cid}{new_geo} = $new_geo;
    $update{$cid}{geo} = $geo;
}

$log->out('updating campaigns');

do_sql(PPC, [ "update campaigns set geo = case cid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
        where => { cid => [ keys %update ], geo => [ map { $update{$_}{geo} } keys %update ] } ]);


$log->out('selecting phrases');

my $phr = get_all_sql(PPC, ["select pid,geo,b.cid from phrases p join banners b using(bid)", where => {
            geo__like => '%20258%',
        }
    ]);

$log->out('preparing data');

%update = ();
my @bs_resync;
for my $p (@$phr) {
    my ($pid, $geo, $cid) = @$p{qw/pid geo cid/};
    my $new_geo = join ',', grep { !/^-?20258$/ } split /,/, $geo;
    if ($geo eq $new_geo) {
        $log->out("geo not changed ($geo)");
        next;
    }
    $log->out("campaign $cid phrase $pid changing geo '$geo' to '$new_geo'");
    $update{$pid}{new_geo} = $new_geo;
    $update{$pid}{geo} = $geo;
    push @bs_resync, [$cid, $pid];
    if (keys %update > 1000) {
        do_sql(PPC, [ "update phrases set geo = case pid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
                where => { 
                    pid => [ keys %update ], 
                    geo => [ map { $update{$_}{geo} } keys %update ] 
                }
        ]);
        %update = ();
    }
}

if (keys %update) {
    do_sql(PPC, [ "update phrases set geo = case pid ".( join ' ', map { " when $_ then '$update{$_}{new_geo}' " } keys %update )." else geo end ", 
            where => { 
                pid => [ keys %update ], 
                geo => [ map { $update{$_}{geo} } keys %update ] 
            }
    ]);
    %update = ();
}

do_mass_insert_sql(PPC, "insert ignore into bs_resync_queue (cid, pid) values %s", \@bs_resync);

$log->out('end');


