#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 секунд",
  comment => "Добавляем новые темы для пакетных МКБ"
}

=cut

use strict;
use warnings;
use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use ScriptHelper;
use Settings;
use Mcb qw/create_theme/;
use Yandex::DBTools;

$log->out('start');

my @themes = (
    {
      'EngineID'    => '77',
      'NDS'         => '0',
      'Price'       => 400_000/30, # Цена минимального заказа, в $
      'Rate'        => '1',
      'UnitName'    => 'Bucks',
      'daily_shows' => '0',
      'ProductID'   => '503134',
      'product_name' => "МКБ - Пакеты",
      'theme_id'    => create_theme('Игры, развлечения, праздники','Развлечения Онлайн', [
            '!ужасы', 'арт-хаус', 'боевик', 'детектив', 'документальные', 'драма', 'Кино', 'Киноафиша', 'Кинопросмотр', 'Кинотеатр',
            'комедия', 'короткометражки', 'короткометражные', 'мелодрама', 'Посмотреть -порно -секс -фото', 'приключения -игры', 'приключенческий', 'Просмотр -порно -секс -фото', 'Сериалы', 'тв',
            'телевидение', 'телепередачи', 'телепрограммы', 'трилер', 'триллер', 'фантастика -книги -научная',
            'фантастические -книги',] ),
      'type'        => 'mcb_pkg',
      'packet_size' => 2_000_000, # Число показов в месяц для расчета растяжения
    },
    {
      'EngineID'    => '77',
      'NDS'         => '0',
      'Price'       => 400_000/30,
      'Rate'        => '1',
      'UnitName'    => 'Bucks',
      'daily_shows' => '0',
      'ProductID'   => '503133',
      'product_name' => "МКБ - Пакеты",
      'theme_id'    => create_theme('Игры, развлечения, праздники', 'Развлечения Оффлайн', ['+Что посмотреть', 'Macdonalds', 'Аквапарки', 'Афиша', 'Балет',
            'Бары', 'Билеты в оперу', 'Бильярд', 'Боулинг', 'Выставки',
            'Выступление', 'Галереи', 'Дискотека', 'Досуг', 'Закусочная',
            'Зоопарки', 'Кафе', 'Киноафиша', 'Кинопросмотр', 'Кинотеатр',
            'Концерты', 'Кофе-Хауз', 'Куда сходить', 'Макдональдс', 'Музеи',
            'Мюзикл', 'Пабы', 'Познакомиться', 'Развлечения', 'Развлечься',
            'Репертуар', 'Рестораны', 'Спектакли', 'Фотовыставки', 'Цирк',
            'Шоколадница',] ),
      'type'        => 'mcb_pkg',
      'packet_size' => 2_000_000,
    },
    {
      'EngineID'    => '77',
      'NDS'         => '0',
      'Price'       => 1_200_000/30,
      'Rate'        => '1',
      'UnitName'    => 'Bucks',
      'daily_shows' => '0',
      'ProductID'   => '503131',
      'product_name' => "МКБ - Пакеты",
      'theme_id'    => create_theme('Финансы', 'Финансы', ['Bank', 'CITIBANK', 'HOME CREDIT', 'master card', 'mastercard',
            'RAIFFEISEN', 'UNICREDIT', 'visa', 'авто рассрочка', 'автокредит',
            'автокредитование', 'автомобиль рассрочка', 'Альфабанк', 'банк -данных -изображений -фото -спермы', 'банкинг',
            'биржа акций', 'биржевой брокер', 'брокерская деятельность', 'брокерская компания', 'брокерская контора',
            'брокерские услуги', 'брокерские фирмы', 'брокерский счет', 'брокерское обслуживание', 'вексель',
            'вклады', 'вложения', 'вложить деньги', 'вложить средства', 'ВТБ',
            'ВТБ24', 'ГАЗПРОМБАНК', 'денежные переводы', 'депозитный', 'депозиты',
            'доверительное управление', 'инвестиции', 'инвестор', 'интернет трейдинг', 'кредитки',
            'кредитные карточки', 'лизинг', 'машина рассрочка', 'облигации', 'овердрафт',
            'паевой', 'перевести деньги -мтс -мегафоне -билайне -теле2', 'перевод денег -мтс -мегафон -билайн -мобильный', 'пиф -паф', 'пластиковые карты',
            'положить процент', 'ПРОМСВЯЗЬБАНК', 'Райффайзен', 'РОСБАНК', 'Русский стандарт -водка',
            'СБЕРБАНК', 'торговля акциями', 'трейдер', 'управление капиталом', 'управляющая компания',
            'Уралсиб', 'услуги брокера -таможенного', 'факторинг', 'финансирование', 'финансовые услуги',
            'финансы', 'фонд -социальный -жилищный -благотворительный -ОМС', 'форфейтинг', 'эмитент', 'Юникредит',] ),
      'type'        => 'mcb_pkg',
      'packet_size' => 3_000_000,
    },
    {
      'EngineID'    => '77',
      'NDS'         => '0',
      'Price'       => 1_050_000/30,
      'Rate'        => '1',
      'UnitName'    => 'Bucks',
      'daily_shows' => '0',
      'ProductID'   => '503132',
      'product_name' => "МКБ - Пакеты",
              'theme_id'    => create_theme('Здоровье', 'Беременность/Роды', ['!merries', '!moony', '+для малышей', '1 !неделя -русского -языка -класс -математики -котята', '10 !неделя',
        '11 !неделя', '12 !неделя', '13 !неделя', '14 !неделя', '15 !неделя',
        '16 !неделя', '17 !неделя', '18 !неделя', '19 !неделя', '2 !неделя',
        '20 !неделя', '21 !неделя', '22 !неделя', '23 !неделя', '24 !неделя',
        '25 !неделя', '26 !неделя', '27 !неделя', '28 !неделя', '29 !неделя',
        '3 !неделя', '30 !неделя', '31 !неделя', '32 !неделя', '33 !неделя',
        '34 !неделя', '35 !неделя', '36 !неделя', '37 !неделя', '38 !неделя',
        '39 !неделя', '4 !неделя', '40 !неделя', '41 !неделя', '42 !неделя',
        '5 !неделя', '6 !неделя', '7 !неделя', '8 !неделя', '9 !неделя',
        'goon', 'pampers', 'беременая', 'беременная', 'беременность',
        'беременость', 'будущие мамы -хвастайте -телами', 'будущие родители', 'воспитание', 'где рожать',
        'грудничек', 'грудной -клетка -железа -боль -отдел -мышца -накачать -позвоночник -увеличение -упражнение -сбор', 'детские', 'мериес', 'младенец',
        'молодые родители', 'новорожденный', 'памперс', 'плод', 'подгузники',
        'прикорм', 'роддом', 'родильный дом', 'роды -какого -женский -мужской -средний -слово -войск -болейн', 'триместр',
        'школа мам',
        'школа родителей',] ),
      'type'        => 'mcb_pkg',
      'packet_size' => 3_500_000,
    },
);

for my $theme (@themes) {
    do_insert_into_table(PPC, 'products', $theme, on_duplicate_key_update => 1);
}

Mcb::update_product_daily_shows();

$log->out('finish');

