#!/usr/bin/perl

use strict;
use warnings;

use utf8;
use open ':std' => ':utf8';

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Yandex::DBTools;
use URLDomain;
$|++;


=head1 DEPLOY

# approved by lena-san
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '3 минуты',
    comment => 'Всем ссылкам-сокращателям ставим сам сокращатель в видимый домен',
}
=cut

my @short = qw/1ink.ru 6fr.ru bit.ly blinq.org clck.ru cli.gs click.cpa1.ru fb.me fff.to goo.gl is.gd of.by ow.ly py6.ru tinyurl.com u.to weeg.ru www.tiny9.com/;
my $href_like = join " or ", map { "href like '$_/%'" } @short;

$log->out('start');
my $dbh = get_dbh(PPC);

my ($min_bid, $max_bid) = get_one_line_array_sql(PPC, "select min(bid), max(bid) from banners");
my $chunk = 100_000;
while ($min_bid < $max_bid) {
    my $rows = get_all_sql(PPC, ["select bid, href, domain from banners", where => {
        bid__between => [$min_bid, $min_bid+$chunk-1],
    }, "and ($href_like)" ]);
    next unless @$rows;

    my %upd = map { $_->{bid} => get_Host($_->{href}) } @$rows;
    $log->out([$rows, \%upd]);
    do_sql(PPC, ["update banners set domain = case bid ".( join " ", map { " when $_ then ".$dbh->quote($upd{$_})."" } keys %upd)." else domain end,   reverse_domain = case bid ".(join " ", map { "when $_ then".$dbh->quote(scalar reverse($upd{$_}))."" } keys %upd)." else reverse_domain end, statusBsSynced = 'No'", 
        where => { bid => [keys %upd] } ]);
} continue {
    $min_bid += $chunk;
}

$log->out('end');



