#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
[{
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: ~3 часов',
        comment => 'дополняет таблицу истории изменения PhraseID <=> bids_id потерянными данными',
}]

=cut

=pod

    Перебирает данные в таблицах bids & bids_arc и сравнивает с наличием записей в таблице bids_phraseid_associate
    Недостающие записи - добавляет.

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

$log->out("Start!");

my @TBL = (
    {name => 'bids', key => 'bi.cid', chunk => 1_000},
    {name => 'bids_arc', key => 'bi.cid', chunk => 5_000},
);


# максимальный bids.id за 2012.02.13 (максимальный уменьшенный примерно на 1 млн)
# в этот день было начальное заполнение таблицы данными
my $MAX_ID_20120213180000 = 520500000;

for my $tbl (@TBL) {

    my ($min_id, $max_id) = get_one_line_array_sql(PPC_HEAVY, "SELECT min($tbl->{key}), max($tbl->{key}) FROM $tbl->{name} bi");
    $log->out("start process table $tbl->{name}, max_id=$max_id");

    while ($min_id <= $max_id) {

        my $res_select = get_all_sql(PPC_HEAVY, ["select bi.cid, bi.bid, bi.PhraseID, bi.id as bids_id, bi.modtime
                                              from ".$tbl->{name}." bi
                                                   left join bids_phraseid_associate ba on bi.cid = ba.cid
                                                                                           and bi.bid = ba.bid
                                                                                           and bi.id = ba.bids_id
                                             where IFNULL(bi.PhraseID, 0) != 0
                                                     and bi.id > $MAX_ID_20120213180000
                                                     and $tbl->{key} between $min_id and ".($min_id + $tbl->{chunk} - 1)
                                                  ." and ba.bids_id is NULL"
                                           ]);

        $min_id += $tbl->{chunk};
                                           
        next unless $res_select && @$res_select;

        my $mass = [ map { [ @{$_}{qw/cid bid PhraseID bids_id modtime/} ] } @$res_select ];
        
        my $res_insert = do_mass_insert_sql(PPC, "INSERT IGNORE INTO bids_phraseid_associate (cid, bid, PhraseID, bids_id, logtime) VALUES %s", $mass, { sleep => 1, max_row_for_insert => 5000 });

        $log->out("Added ".($res_insert||0)." rows for $tbl->{name} where $min_id <= $tbl->{key} < ".($min_id + $tbl->{chunk} - 1));
        $log->out($mass);
    }
}

$log->out("End.");
