#!/usr/bin/perl

use strict;
use warnings;

=head1 DEPLOY

# approved by lena-san
# .migr
[{
    type => 'script',
    when => 'after',
    time_estimate => 'на devtest: порядка 20 секунд',
    comment => 'заполняем новое поле в camp_secondary_options - пересчитываем сумму из рублей в уе',
}]

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Yandex::DBTools;
use Settings;
use Common;
use Currencies;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    $log->out("Start");
    my $pseudo_currency = get_pseudo_currency(id => 'rub');
    $log->out($pseudo_currency);

    update_camp_options($pseudo_currency->{rate});

    $log->out("Finish");
}

# --------------------------------------------------------------------
sub update_camp_options {
    my ($rate) = @_;

    my $cids = get_one_column_sql(PPC, "select cid from camp_options where budget_strategy = 'easy_week_bundle'") || [];

    for my $cid (@$cids) {
        $log->out("cid: $cid");
        my $options = Common::get_camp_options($cid);
        next if $options->{easy_week_bundle_sum_ue}; # уже установили, пропускаем

        $options->{easy_week_bundle_sum_ue} = $options->{easy_week_bundle_sum} / $rate;
        Common::set_camp_options($cid, $options);

        $log->out($options);
    }
}

# --------------------------------------------------------------------
main();
