#!/usr/bin/perl

# https://jira.yandex-team.ru/browse/DIRECT-15466

use strict;
use warnings;

=head1 DEPLOY

# approved by lena-san
# .migr
[{
    type => 'script',
    when => 'after',
    time_estimate => 'на devtest: порядка 10 секунд',
    comment => 'чистим легкие кампании со старыми стратегиями и данными от новой, переотправляем в БК',
}]

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Yandex::DBTools;
use Settings;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    $log->out("Start");

    my $cids = get_one_column_sql(PPC,
        "select cid
         from campaigns c
         join camp_options co using(cid)
         join users_options uo using(uid)
         where budget_strategy in ('distributed', 'fast')
           and (autobudget_limit_clicks > 0 OR autobudget_avg_bid > 0)
           and uo.statusEasy = 'Yes'
        "
    ) || [];

    $log->out($cids);

    for my $cid (@$cids) {
        my $res = do_sql(PPC, "update campaigns c
                               join camp_options co using(cid)
                               join users_options uo using(uid)
                               set c.LastChange = c.LastChange
                                 , c.autobudget_limit_clicks = NULL
                                 , c.autobudget_avg_bid = NULL
                                 , c.statusBsSynced = 'No'
                               where c.cid = ?
                                 and budget_strategy in ('distributed', 'fast')
                                 and uo.statusEasy = 'Yes'
                                 and (autobudget_limit_clicks > 0 OR autobudget_avg_bid > 0)
                              ", $cid);

        $log->out({res => $res, cid => $cid});
    }

    $log->out("Finish");
}

# --------------------------------------------------------------------
main();
