#!/usr/bin/perl

# https://jira.yandex-team.ru/browse/DIRECT-15484

use strict;
use warnings;

=head1 DEPLOY

# approved by lena-san
# .migr
[{
    type => 'script',
    when => 'after',
    time_estimate => 'порядка 30 секунд',
    comment => 'восстанавливаем autobudget_sum на легких кампаниях, переотправляем в БК',
}]

=cut

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Yandex::DBTools;
use JSON;
use Settings;
use ScriptHelper;

# --------------------------------------------------------------------
sub main {
    $log->out("Start");

    my $cids = get_one_column_sql(PPC,
        "select cid
         from campaigns c
         join camp_options co using(cid)
         join users_options uo using(uid)
         where budget_strategy in ('distributed', 'fast')
           and autobudget_sum is NULL
           and uo.statusEasy = 'Yes'
        "
    ) || [];

    $log->out($cids);

    for my $cid (@$cids) {
        $log->out({camp_before_update => get_one_line_sql(PPC, "select * from campaigns c join camp_options co using(cid) where c.cid = ?", $cid)});

        my $strategy_json = get_one_field_sql(MONITOR, "select data_json
                                                        from log_strategy_change
                                                        where cid = ?
                                                          and new_strategy_name in ('easy:distributed', 'easy:fast')
                                                        order by logtime desc
                                                        limit 1", $cid);

        unless ($strategy_json) {
            $log->out("$cid: log not found");
            next;
        }

        my $autobudget_sum = eval {from_json($strategy_json)->{new}->{autobudget_sum}};
        if ($@ || ! $autobudget_sum) {
            $log->out({autobudget_sum_not_found => 1, json => $strategy_json, error => $@});
            next;
        }

        my $res = do_sql(PPC, "update campaigns c
                               join camp_options co using(cid)
                               join users_options uo using(uid)
                               set c.LastChange = c.LastChange
                                 , c.autobudget_sum = ?
                                 , c.statusBsSynced = 'No'
                               where c.cid = ?
                                 and budget_strategy in ('distributed', 'fast')
                                 and uo.statusEasy = 'Yes'
                                 and autobudget_sum is NULL
                              ", $autobudget_sum, $cid);

        $log->out({res => $res, cid => $cid, autobudget_sum => $autobudget_sum});
    }

    $log->out("Finish");
}

# --------------------------------------------------------------------
main();
