#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'sql',
        webstop => 0,
        db => 'ppc',
        when => 'before',
        time_estimate => 'About 10 minutes',
        sql => [
            "RENAME TABLE pdf_reports TO new_pdf_reports",
            "ALTER TABLE new_pdf_reports ADD COLUMN phrases_count int(10) unsigned NOT NULL DEFAULT 0",
            "RENAME TABLE new_pdf_reports TO pdf_reports"
        ],
    },
    {
        type => 'script',
        when => 'after',
        time_estimate => 'зависит от количества новых отчетов, предположительно на продакшене около 1 минуты',
        comment => 'Подсчет количества фраз в pdf отчетах',
    }
]

=cut

use strict;
use warnings;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;
use List::Util qw/sum/;

my (%cids, @pdf_phrases);
my $reports = get_all_sql(PPC, "SELECT id, cids FROM pdf_reports WHERE status = 'new' AND phrases_count = 0");
foreach (@{$reports || []}) {
    
    my @origin_ids = split /\D+/, $_->{cids};
    if (my @ids = grep {!exists $cids{$_}} @origin_ids) {
        my $quantity = get_all_sql(PPC, ['SELECT cid, COUNT(*) cnt FROM bids',
            WHERE => {cid => \@ids, PhraseID__gt => 0, numword__gt => 0}, 'GROUP BY cid']);
        $cids{$$_{cid}} = $$_{cnt} foreach @{$quantity || []};
    }
    
    push @pdf_phrases, [$_->{id}, sum @cids{@origin_ids}];
}

do_mass_insert_sql(PPC,
    'INSERT INTO pdf_reports(id, phrases_count) VALUES %s ON DUPLICATE KEY UPDATE phrases_count = VALUES(phrases_count)',
    \@pdf_phrases) if @pdf_phrases;
