#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
{
        type => 'script',
        when => 'after',
        time_estimate => '10 секунд',
        comment => 'исправляем пустые campaign.start_time',
}

=cut

# https://jira.yandex-team.ru/browse/DIRECT-15483

use strict;
use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use Yandex::TimeCommon;
use ScriptHelper;


$log->out("start");

my $cids = get_all_sql(PPC, ["select c.cid, co.create_time from campaigns c join camp_options co on c.cid = co.cid", where => {
    'c.start_time' => '0000-00-00 00:00:00',
    type => 'text',
}]);
for my $c (@$cids) {
    next if !$c->{create_time} or $c->{create_time} eq '0000-00-00 00:00:00';
    my $start_time = ts_round_day( mysql2unix($c->{create_time}) );
    $c->{start_time} = unix2human($start_time, '%F %T');
    $log->out($c);
    do_update_table(PPC, 'campaigns', { start_time => $c->{start_time} }, where => { cid => $c->{cid} });
}

$log->out("finish");

