#!/usr/bin/perl -w

=head1 DEPLOY

# approved by lena-san
# .migr
{
        type => 'script',
        when => 'after',
        time_estimate => '~ 2 min per iteration',
        comment => 'отправляем зависшие сайтлинки на модерацию требутеся запустить примерно 4 раза, с интервалом в 3-4 часа (чтобы не завалить модераторов)',
}

=cut

# https://jira.yandex-team.ru/browse/DIRECT-15483

use strict;
use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;


$log->out("start");

my $bids = get_one_column_sql(PPC, "select bid from banners where ifnull(sitelinks_set_id,0)!=0 and statusSitelinksModerate ='New' and statusModerate != 'New' limit 5000");
$log->out("selected: ". scalar @$bids);
$log->out($bids);
my $res = do_update_table(PPC, 'banners', { statusSitelinksModerate => 'Ready' }, 
            where => {  bid => $bids, 
                        sitelinks_set_id__is_not_null => 1, 
                        sitelinks_set_id__gt => 0, 
                        statusSitelinksModerate => 'New', 
                        statusModerate__ne => 'New' 
                    });
$log->out("updated: $res");
print $res;

$log->out("finish");

