#!/usr/bin/perl

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use Yandex::DBTools;

=head1 DEPLOY

# approved by lena-san
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => '15 min',
        comment => "выбираем все слова по которым изменения были более суток назад,
            учитывая все условия, при которых должны отправляться уведомления об отключении фраз, за исключением bi.warn='Yes'.
            Выбранные слова апдейтим, как-будто уведомления об отключении этих слов были отправлены.",
    },
]
=cut

$log->out('start');

my $MAX_CHUNK_SIZE = 1000;
my $time = get_one_field_sql(PPC, "select date_sub(now(), interval 1 day)");

my $select = qq{
select STRAIGHT_JOIN bi.id
from campaigns c
    JOIN users u ON u.uid = c.uid
    LEFT JOIN users_options uo ON uo.uid = u.uid
    JOIN banners b ON b.cid = c.cid
    JOIN phrases p ON p.bid = b.bid
    JOIN priorities pr ON pr.PriorityID = p.PriorityID
    JOIN bids bi on bi.bid = b.bid and bi.PhraseID = pr.PhraseID
    JOIN camp_options co ON co.cid = c.cid
    LEFT JOIN users m ON m.uid=c.ManagerUID
WHERE c.statusShow='Yes'
    AND ifnull(uo.statusEasy, 'No') = 'No'
    AND c.sum > c.sum_spent
    AND (c.autoOptimization = 'No' or bi.optimizeTry = -1)
    AND b.statusShow='Yes'
    AND pr.rank < 7000
    AND bi.numword > 0
    AND ((bi.WarnCtr < 2 and pr.rank = 0) OR (bi.WarnCtr = 0 AND pr.rank < 7000 AND pr.rank > 0) )
    AND pr.stattime < '$time'
};

$log->out('getting appropriate ids from bids');
my $bids = get_one_column_sql(PPC_HEAVY, $select);
@$bids = () unless $bids;
$log->out(sprintf("got %s ids", scalar(@$bids)));

$log->out('updating bids');
my $updated = 0;
while(@$bids)
{
    # будем апдейтить чанками по 1000 слов
    my @ids = splice(@$bids,0,$MAX_CHUNK_SIZE);

    my $update = sprintf(qq{
    UPDATE campaigns c
        JOIN banners b ON b.cid = c.cid
        JOIN phrases p ON p.bid = b.bid
        JOIN priorities pr ON pr.PriorityID = p.PriorityID
        JOIN bids bi on bi.bid = b.bid and bi.PhraseID = pr.PhraseID
    SET bi.WarnCtr = 2
    WHERE bi.id in (%s)
        AND pr.stattime < '$time'
    }, join(',',@ids));

    $updated += do_sql(PPC, $update, );
}

$log->out("$updated rows were updated");
$log->out('end');
