#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 20 минут',
  comment => 'Добавляем в очередь на переотправку в БК баннеры, по которым возобновлялись показы с 14 марта (423121 баннеров)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Common qw/get_log_tables_list/;
use Settings;
use Yandex::DBTools;
use YAML::Syck;
use List::MoreUtils qw/uniq/;

use utf8;
use open ':std' => ':utf8';

my $BUG_DEPLOY_DATE = '20120314';

my @data_to_sync;

$log->out('START');

$log->out('Fetching banners resumed using WEB interface');
my $logcmd_tables = get_log_tables_list('cmd', date_from => $BUG_DEPLOY_DATE, heavy => 1);
push @data_to_sync, map { @{get_one_column_sql(PPCLOG_HEAVY, qq/SELECT CONCAT(cid, ":", bid) FROM $_ WHERE cmd = "resumeBanner" AND bid > 0/) || []} } @$logcmd_tables;

$log->out('Fetching banners resumed using API');
my $logapi_tables = get_log_tables_list('api', date_from => $BUG_DEPLOY_DATE, heavy => 1);
for my $table(@$logapi_tables) {
    my $x = get_all_sql(PPCLOG_HEAVY, qq/SELECT cid, param FROM $table WHERE cmd = "ResumeBanners" AND param IS NOT NULL/);
    for my $row(@$x) {
        my $data = eval {Load($row->{param})};
        next unless $data && ref($data) eq 'HASH' && $data->{BannerIDS} && ref($data->{BannerIDS}) eq 'ARRAY';
        my $cid = $data->{CampaignID} || $row->{cid};
        next unless $cid;
        for my $bid (@{$data->{BannerIDS}}) {
            push @data_to_sync, "$cid:$bid";
        }
    }
}

@data_to_sync = uniq @data_to_sync;
my $bids_cnt = scalar @data_to_sync;

$log->out("Adding $bids_cnt bids to resync queue", \@data_to_sync);
my @data_to_insert = map {[split /:/, $_, 2]} @data_to_sync;
do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s/, \@data_to_insert, {max_row_for_insert => 5000, sleep => 5});

$log->out('FINISH');
