#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 3 минуты',
  comment => 'Добавляем в очередь на переотправку в БК баннеры, по которым множественными операциями из веб-интерфейса возобновлялись показы с 14 марта (~ 22_398 баннеров)',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Common qw/get_log_tables_list/;
use Settings;
use Yandex::DBTools;
use List::MoreUtils qw/uniq/;

use utf8;
use open ':std' => ':utf8';

my $BUG_DEPLOY_DATE = '20120314';

my @data_to_sync;

$log->out('START');

$log->out('Fetching banners resumed using mass commands from WEB interface');
my $logcmd_tables = get_log_tables_list('cmd', date_from => $BUG_DEPLOY_DATE, heavy => 1);
for my $table(@$logcmd_tables) {
    my $x = get_all_sql(PPCLOG_HEAVY, qq/SELECT cid, bid, param FROM $table WHERE cmd = "resumeBanner"/);
    for my $row(@$x) {
        next unless $row->{param};
        my %param_hash = map { split(/=/, $_, 2) } grep {/.+=.+/} split(/\t/, $row->{param});
        next unless $param_hash{bid};
        my @bids = split /,/, $param_hash{bid};
        push @data_to_sync, map { $row->{cid}.':'.$_ } grep { $_ != $row->{bid} } @bids;
    }
}

@data_to_sync = uniq @data_to_sync;
my $bids_cnt = scalar @data_to_sync;

$log->out("Adding $bids_cnt bids to resync queue", \@data_to_sync);
my @data_to_insert = map {[split /:/, $_, 2]} @data_to_sync;
do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s/, \@data_to_insert);

$log->out('FINISH');
