#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san 
# .migr
[{
  type => 'sql',
  webstop => "0",
  db => "ppc",
  when => 'before',
  time_estimate => "на devtest - 0 сек",
  sql => "alter table mod_reasons modify column `statusSending` enum('Yes','No','Sending') NOT NULL DEFAULT 'No'"
},
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 9 минут',
  comment => 'Удаляем из mod_reasons лишние записи (порядка 2 138 490 строк)',
}
]
=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;
use Yandex::DBTools;

use utf8;
use open ':std' => ':utf8';

$log->out('START');

my $rids = get_one_column_sql(PPC, "select rid from mod_reasons where statusModerate = 'Old' or (statusModerate='New' and statusPostModerate='No')");
$log->out("selected ".@$rids." records");

my $cnt = 0;
$log->out("start clear");
while (my @ids = splice @$rids, 0, 10000) {

    do_sql(PPC, ["delete from mod_reasons", where => { rid => \@ids }]);
    $log->out("iteration ".$cnt++);
    
    sleep(1);
}

$log->out('FINISH');
