#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1m 30s',
  comment => 'заполняем поле domain в таблице banners_bs_log_20120405',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use Yandex::DBTools;
use MirrorsTools;

my $tablename = 'banners_bs_log_20120405';
my $tmp_tablename = $tablename . '_' . $$;

do_sql(PPCLOG, "create table $tmp_tablename like $tablename");

my $rows = get_all_sql(PPCLOG, "select * from $tablename");
my $insert = [];

for my $row (@$rows){
    if($row->{href} and !$row->{domain}){
        $row->{domain} = $row->{href};
        $row->{domain} = MirrorsTools->url2host($row->{domain});
    }

    push(@$insert, [
            $row->{bid},
            $row->{cid},
            $row->{store_time},
            $row->{title},
            $row->{body},
            $row->{href},
            $row->{domain},
            $row->{statusShow}]);
}

while(my @chunk = splice(@$insert, 0, 10000)){
    do_mass_insert_sql(PPCLOG, "insert into $tmp_tablename (bid, cid, store_time, title, body, href, domain, statusShow) values %s", \@chunk);
}

do_sql(PPCLOG, "drop table $tablename");
do_sql(PPCLOG, "rename table $tmp_tablename to $tablename");
