#!/usr/bin/perl -w

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько часов',
  comment => 'добавляем в таблички profile_logs.*_cmd_* поле mem',
}

=cut

use strict;
use warnings;

use Time::HiRes qw/time sleep/;
use Yandex::DBTools;
use Yandex::ListUtils;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

for my $table (reverse xsort {/_(\d+)/ ? $1 : ''} @{get_one_column_sql(PPCPROFILE, "show tables like 'profile_cmd_stats_%'") || []}) {
    $log->out($table);
    next if grep {$_->{Field} eq 'mem'} @{get_all_sql(PPCPROFILE, "DESC $table")};
    $log->out(" start alter");
    my $t = time();
    do_sql(PPCPROFILE, "ALTER TABLE $table ADD COLUMN `mem` float NOT NULL AFTER cpu_system");
    my $sleep = time() - $t;
    $log->out(" start sleep $sleep");
    sleep($sleep);
}

