#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 sec",
  comment => "отвязываем в RBAC определенные uid'ы от агентств"
}

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use Settings;
use ScriptHelper;
use RBACDirect;
use RBAC2::Extended;

my $rbac = get_singleton RBAC2::Extended();
die "Can't connect to RBAC" if ! defined $rbac || ! $rbac->InitReq(1);

$log->out('start');
my @uids = <DATA>;
chomp for @uids;

# DISCLAIMER
# известно, что кампаний у них нет, поэтому не проверяем их наличие

for my $client_uid (@uids) {
    my $client_id = rbac_get_client_clientid_by_uid($client_uid) || $log->die("ClientID for $client_uid not found");
    my @agency_uids = @{ rbac_get_agencies_of_client($rbac, $client_uid) };
    my @agency_ids = uniq map {rbac_get_agency_clientid_by_uid( $_)} @agency_uids;
    unless (@agency_ids) {
        $log->out("no agencies for $client_uid");
        next;
    }
    for my $agency_id (@agency_ids) {
        if (my $error = $rbac->Handle('RBAC_UnbindAgency', {agency_id => $agency_id, client_id => $client_id})) {
            $log->out("failed for agency_id $agency_id client_id $client_id");
        } else {
            $rbac->Commit and $log->die("failed commit for agency_id $agency_id client_id $client_id");
            $log->out("succeeded for agency_id $agency_id client_id $client_id");

        }
    }
}

$log->out('finish');

__DATA__
113098415
113564263
113566810
113573135
113658934
113681071
113681241
113776959
113776989
113777116
113777188
113780782
113781451
113781603
113781615
113781693
113781768
114110877
114883905
116596682
116596739
116596776
116596790
116596810
116605544
119523160
119523589
119524828
120315359
121648708
121651503
121651512
121651581
121651605
121651649
121651713
121653264
121653387
121909866
122087960
122088517
122091125
122091924
122159694
122159711
122159730
122160080
122252557
122253648
122254023
122518288
122518314
122518357
122518383
122518407
122518472
122518751
122518851
122519042
122519207
122521074
122530300
122530317
122530409
122532663
122534225
122538515
122543587
122549164
122570180
122570294
122598804
122599037
122599342
122621584
122621600
122621721
122621826
122628237
122628661
122850230
122850249
122850389
122850722
122851287
122859110
123051380
123198337
123201102
123214435
123274995
123289112
123844925
124260253
124260275
124260315
124260367
124307575
124529339
124533692
124534116
124534497
124535813
124539575
124540340
124544878
124545202
124545722
124813564
124820579
124820598
125149319
125171468
125172314
125174340
125184859
125230234
125230267
125232733
125302208
125591158
126050897
126050928
126051012
126109370
126486792
126489082
126489137
126489274
126505739
126505760
