#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '2m 30s',
  comment => q{
      Добавляем в очередь на переотправку в БК баннеры у который адрес имеет точность number.
      Исправленный код в protected/bsClientData.pl будет отправлять их с точностью exact},
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use ScriptHelper;
use Settings;
use Yandex::DBTools;

$log->out('START');

$log->out('Fetching banners with addresses which have precision "number"');
my $banners = get_all_sql(PPC, qq{
    select b.bid, b.cid
    from banners b
        join vcards v using (vcard_id)
        join addresses a on (v.address_id = a.aid)
    where a.precision = 'number'
        and b.statusBsSynced = 'Yes'
        and b.statusShow = 'Yes'
        and BannerID > 0
        and statusArch = 'No'});

my @banners_to_resend = map {
    $log->out(sprintf("bid: %s, cid: %s",$_->{bid}, $_->{cid} ));
    [$_->{bid}, $_->{cid}]
} @$banners;

$log->out('inserting banners');
do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (bid, cid) VALUES %s/, \@banners_to_resend);

$log->out('FINISH');
