#!/usr/bin/perl

=head1 DESCRIPTION

  Восстанавливаем привязку представителей в биллинге после ошибочного удаления
  https://jira.yandex-team.ru/browse/MBI-7299

  uid-ы достаем из логов - ppcdev:/mnt/direct-logs/ppcback*/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.201204*

=head1 DEPLOY

# approved by zhur
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => "10 sec",
    comment => "Восстанавливаем привязку представителей в биллинге после ошибочного удаления"
}

=cut

use strict;
use warnings;

use List::MoreUtils qw/uniq/;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";
use Settings;
use ScriptHelper;
use PrimitivesIds;
use Yandex::Balance;

our $OPERATOR_UID = 1;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    # parse logs for DATA
    # my @clientids = <DATA>;
    # chomp for @clientids;
    #
    # my $logs = parse_logs();
    # for my $ClientID (@clientids) {
    #     if (exists $logs->{$ClientID}) {
    #         printf "$ClientID\t%s\n", join("\t", @{$logs->{$ClientID}});
    #     } else {
    #         p_rint "not exists\n";
    #     }
    # }

    my @clientids = map {m/^(\d+) \s+ (\d+) \s* $/x; {ClientID => $1, uid => $2}} <DATA>;
    for my $row (@clientids) {

        my $balance_client_id = get_clientid(uid => $row->{uid});
        if ($balance_client_id) {
            $log->out("$row->{uid} already have $balance_client_id (ClientID from log: $row->{ClientID} )");
        } else {
            my $result = create_client_id_association($row->{uid}, $row->{ClientID}, $OPERATOR_UID);
            $log->out("create_client_id_association( $row->{uid} $row->{ClientID} ): $result");
        }
    }

    $log->out('finish');
}

# --------------------------------------------------------------------
sub parse_logs {
    # до исправления удаляли 6 раз
    my @log_files = qw[
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120418
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120419
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120420
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120421
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120422
        /mnt/direct-logs/ppcback01f/ppc.yandex.ru/protected/logs/ppcClearEmptyClients.log.20120423
    ];

    my $logs = {};
    for my $filename (@log_files) {
        open my $FH, '<', $filename or die "Error: $!";
        while (my $line = <$FH>) {
            if ($line =~ /Start \s+ process \s+ ClientID: \s+ (\d+) \s+ uids: \s+ ([\d,]+) \s* $/x) {
                my ($ClientID, $uids) = ($1, $2);
                $logs->{$ClientID} = [split /,/, $uids];
            }
        }
        close $FH;
    }

    return $logs;
}

# --------------------------------------------------------------------
main();

__DATA__
705	9594792
1966	11723735
3851	11369989
10171	13485640
15324	4962414
47944	17303669
49977	451189
52658	17377061
316691	17193788
318984	13074641
335232	15436211
347081	14421164
356265	13486979
356715	17553165
357100	13659701
357213	22445073
371206	16472598
373443	15316965
389413	15560492
393938	16480167
394386	16516525
394805	16611211
395058	23551340
396316	16916381
397660	17127884
401566	17665675
401632	17323836
403624	17954209
404874	18153455
404926	18010485
405334	18239406
412004	19197240
412014	12639371
412568	19247917
412757	19269936
415618	19758447
416903	19813019
417262	19926005
417504	19471104
420130	20257067
422418	20511071
431258	21437643
434016	21762825
434112	21714754
436715	22168672
441411	22803138
443794	23118345
447488	23620369
453540	1368838
461091	24794466
474407	26653988
474423	26551579
474817	26661680
482358	27019525
489554	22256524
490291	28482349
495243	29060280
502181	26012770
502752	24744635
511579	30958671
513065	31184782
525900	4322822
549224	10756380
550097	26126072
580646	33862
580751	78325
583298	661388
583479	748735
584831	1445230
585080	1583309
585718	1906924
586244	2205235
587926	3056719
587967	3076720
593864	5678249
594574	5985637
600884	7850852
607702	9250468
614049	10194082
617375	10591677
620474	10908955
653735	14170883
671675	16545964
696182	19136948
699376	19505059
706547	20436558
714679	21720927
720503	22739579
720922	22811381
722881	23184259
724337	23555883
728488	24347040
730270	24853911
750536	30380789
