# approved by zhur
# .migr
{
    type => 'sql',
    webstop => 0,
    db => "ppc",
    when => 'before',
    time_estimate => "1 сек.",
    sql => [
        "
        create table retargeting_conditions (
            ret_cond_id    int unsigned NOT NULL AUTO_INCREMENT,
            ClientID       int unsigned NOT NULL default 0,
            condition_name varchar(4096) NOT NULL default '',
            condition_desc varchar(4096) NOT NULL default '',
            condition_json TEXT NOT NULL default '',
            is_deleted tinyint unsigned NOT NULL default 0,
            modtime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

            primary key (ret_cond_id),
            key (ClientID)
        )
        ",
        "
        create table bids_retargeting (
            ret_id int unsigned NOT NULL AUTO_INCREMENT,
            ret_cond_id int unsigned NOT NULL default 0,
            bid int unsigned NOT NULL DEFAULT 0,

            modtime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            price_context decimal(10,2) NOT NULL,
            statusBsSynced enum('No', 'Yes', 'Sending') NOT NULL DEFAULT 'No',
            autobudgetPriority tinyint(4) DEFAULT NULL,
            is_suspended tinyint(3) unsigned NOT NULL default '0',

            PRIMARY KEY (ret_id),
            KEY bid (bid),
            KEY idx_bids_sbs (statusBsSynced)
        )
        ",
        "
        create table if not exists mediaplan_bids_retargeting (
            ret_id int unsigned NOT NULL AUTO_INCREMENT,
            ret_cond_id int unsigned NOT NULL default 0,
            mbid int unsigned NOT NULL DEFAULT 0,

            modtime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            place int NOT NULL DEFAULT 0,
            is_suspended tinyint(3) unsigned NOT NULL default '0',

            statusPhrase enum('new', 'declined') NOT NULL DEFAULT 'new',

            PRIMARY KEY (ret_id),
            KEY mbid (mbid),
            KEY ret_cond_id (ret_cond_id)
        )
        ",
        "
        create table retargeting_goals (
            ret_cond_id int unsigned NOT NULL default 0,
            goal_id int unsigned NOT NULL default 0,
            is_accessible tinyint unsigned NOT NULL default 1,
            modtime timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            UNIQUE KEY (ret_cond_id, goal_id),
            KEY (goal_id)
        )
        ",
        "
        create table clients_allow_retargeting (
            ClientID int unsigned NOT NULL,
            set_date timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (ClientID)
        )
        "
    ]
}
