#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '20 секунд',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

$log->out('Fetching data');
my $cids = get_one_column_sql(PPC_HEAVY, q/
    SELECT cid
    FROM campaigns
    WHERE
        LENGTH(timeTarget) > 0
        AND timeTarget like "%9%"
/);

$log->out('Adding cids to resync queue: ', $cids);
do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid) VALUES %s/, [map {[$_]} @$cids]);

$log->out('FINISH');
