#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

$log->out('Fetching data');

my @orderids = map {chomp; $_} <DATA>;

my $data = get_all_sql(PPC_HEAVY, [q/
    SELECT c.cid, b.bid, p.pid
    FROM campaigns c
    INNER JOIN banners b ON c.cid=b.cid
    INNER JOIN phrases p ON b.bid = p.bid
/,  WHERE => {OrderID => \@orderids}]);

while (my @packet = splice @$data, 0, 10_000) {
    $log->out('Adding to resync queue: ', \@packet);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, pid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid pid/]} @packet]);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid bid/]} @packet]);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid/]} @packet]);
}

$log->out('FINISH');

__DATA__
20334
20335
20440
24594
27241
27242
27244
27361
27578
34768
35248
41032
42568
45656
47113
48199
49248
49558
52550
53963
55186
55519
60264
61444
65576
65894
66749
68859
73709
74577
75467
76876
76890
78339
80128
80694
81925
82365
84209
86049
86616
87763
88122
88127
88417
90086
90861
158542
165108
165556
166717
166744
168636
168833
169838
170446
174440
176077
177834
179421
180869
181010
181127
186874
186979
191695
191764
195166
196640
198435
198503
198572
198960
198974
201976
202261
202373
206232
207180
207884
208002
208783
209622
211488
211861
212959
213304
213525
214159
214755
214811
215897
216851
217763
217770
217908
218247
218486
219098
219303
220277
221833
224621
224916
225274
226043
226230
226904
227698
228680
229611
230695
230922
231238
231493
231518
232458
232725
234486
234488
236711
241524
241932
244992
245908
245973
246962
247853
248078
249634
252497
253235
253241
256829
256971
258271
259638
262567
262589
265871
267170
267460
267942
267965
269636
272549
275140
275999
276051
276152
276196
276883
277138
281050
284628
285344
285345
288767
290907
291294
291672
293547
293952
295389
299914
301210
303174
304764
305995
307333
307632
308345
312954
312963
312994
313117
313245
316969
317646
321940
322040
323205
327260
330198
330273
333196
335328
337072
337590
338477
338802
339208
339840
345719
346570
348128
348284
349218
351915
352153
353116
354690
356198
356647
356980
357053
357431
357509
367608
368542
368843
374449
377859
381180
381385
381699
381974
382999
384957
385335
386535
386792
388077
389123
391722
392373
392583
393400
393525
393529
394274
394360
395219
395555
398129
398516
398993
398997
398999
399001
400084
400100
400332
402126
402457
403496
403901
404550
405506
406514
409755
411262
411806
411997
412579
414333
416758
417353
418539
420824
421066
425057
426217
426381
430792
430841
432490
435815
435886
435979
438853
440324
441128
441391
441895
441896
443126
443208
443988
444052
444833
445983
446424
449026
449395
451357
451949
455595
455910
456552
457434
458555
458776
458990
460349
462456
462673
463867
464147
464619
465071
467637
468328
469305
470113
470799
471097
471373
474629
475397
476695
478016
479436
479456
481181
481429
482269
482632
484253
484407
484565
484768
484949
485719
485945
488568
488797
489317
491592
493147
493564
496730
496823
497463
498475
499434
499670
500762
501583
502475
503556
504161
504169
504579
504580
504582
504584
504586
504588
504670
504796
504934
505398
505562
507461
508000
508403
508941
510555
511363
511368
513700
515841
519983
520148
520181
520284
521380
523209
524136
524284
527399
528115
528332
529208
530029
530704
530974
531804
532019
535851
536179
540972
541274
541835
542178
542283
542810
543331
543851
544679
545853
547149
547476
547916
548105
548854
549195
549484
551823
552344
554056
554197
554377
555019
555164
558899
561446
562896
563782
564206
565043
565137
565536
565723
566183
566549
567525
568064
568487
568594
570763
570983
570990
571750
575060
575622
575650
577223
577675
577676
577680
578868
579083
580347
580654
582149
584758
584790
585233
585839
586503
586859
587152
587658
587818
588113
588621
588642
591759
594214
594371
594695
594697
595146
596603
597128
597982
598437
598453
598623
600842
601897
602564
604326
605854
607085
608889
609267
609668
611212
611855
612969
613275
613699
615128
615129
615131
615241
615418
615497
615796
616572
618069
619027
619305
620635
620643
621619
621843
623363
624233
625117
626560
626700
626877
627316
627879
628972
630264
630475
634771
635233
635241
636280
638754
639374
640933
641455
643042
645034
645179
648530
650096
651462
652337
653067
653149
653422
654818
655646
657214
657803
659846
660909
663777
663829
664471
665457
666553
666861
667053
668722
668950
669516
669528
669533
669724
669832
670071
671037
671657
672503
672640
672923
673358
674231
675296
675712
676179
678226
678563
678677
679198
681004
682459
682790
683095
684195
684966
685120
687321
688281
690404
690586
691130
691411
692148
693220
697877
700962
700970
702361
702705
703201
704218
704677
706394
706967
707593
707815
708095
709617
710215
711454
712423
712567
712573
712577
712578
713730
713822
714174
714308
715798
717497
717585
719546
721036
721722
721761
721945
722967
723310
723482
724019
724581
724841
725067
725673
727150
728976
729933
730013
730265
730727
731775
732140
732154
732503
732820
734452
734749
736237
738797
741583
741626
741841
742470
744507
745485
745716
745990
746213
747042
749641
750039
750667
751269
752206
752363
753528
753677
755169
757869
758735
758920
760298
762904
763121
764514
765713
766089
766132
766939
768487
771525
772690
774027
775471
777338
778018
778027
779215
781285
781287
782788
783082
784314
784642
785030
786635
786992
787004
787015
787299
787685
790569
791329
792164
792430
792765
792971
793041
793482
793608
795736
795923
795964
796074
796658
796680
797081
797605
799078
799284
799433
799737
799810
801722
802501
803375
803843
804293
805408
806325
806786
806941
807120
808791
809028
809417
809453
809695
810106
810376
811202
811457
811673
813517
814737
814872
816068
816079
817648
817902
819029
819319
820785
820787
820794
820801
820810
820814
821885
825248
825266
825401
825707
826080
826672
828408
828526
828581
829888
831089
831090
831423
831464
831541
832132
832165
833455
833615
834752
835391
835706
836639
837454
837512
837548
838220
838224
838346
838403
838648
843335
845538
847137
848056
849629
849721
849733
850156
851222
852769
853283
856995
857132
858638
858656
859272
859280
859908
861428
864135
864992
865923
866656
866750
870231
870992
871158
872032
873251
873256
873662
874102
875313
875779
875784
875804
876064
876092
876326
877252
877939
878320
879438
879443
879455
879739
880680
880774
883384
883386
887533
887569
889863
894539
894540
895159
895642
896726
896994
899445
901649
902139
902324
902519
902876
902917
903118
904949
906504
906544
906721
907093
907446
908427
908531
908727
910035
910318
911063
911347
913173
913484
918480
918710
918884
919227
919410
919652
919695
919992
920816
921079
921553
921861
922641
924173
925830
925831
925839
928399
929321
929322
929323
929325
929327
929328
929329
929330
929331
929333
929334
929335
929338
929339
929341
931000
931417
932890
936041
939706
940148
940157
940164
940180
940184
940219
940221
940292
942008
943015
951499
953774
953780
956497
958559
960965
968119
969241
969386
980614
980933
988039
989655
998321
1001667
1004954
1006937
1008546
1011029
1011260
1014374
1017387
1020100
1031254
1035049
1035520
1038986
1042088
1042159
1042664
1045803
1050076
1051305
1051337
1051506
1052654
1053032
1053568
1053669
1053671
1054522
1056878
1060769
1062321
1063051
1063626
1064064
1064315
1065011
1065406
1065449
1065668
1067106
1070648
1072469
1073161
1075204
1077413
1077496
1079840
1081536
1082493
1082975
1086257
1086290
1087178
1087268
1087881
1089175
1089329
1089533
1090225
1091371
1091374
1091534
1092307
1094262
1097392
1098629
1101353
1102031
1102167
1102961
1103294
1105194
1107870
1107933
1108863
1111757
1111762
1112300
1112302
1112460
1112470
1112751
1112836
1113475
1115065
1115612
1115767
1115909
1116124
1116684
1117396
1117490
1117535
1117546
1117581
1117678
1117978
1118006
1118011
1118451
1119956
1119960
1120009
1120118
1120670
1120912
1120978
1126552
1127802
1127871
1127951
1130984
1131637
1134465
1134484
1134796
1135356
1135941
1135944
1135949
1135987
1136295
1136870
1136926
1137007
1137277
1137445
1141771
1142390
1143062
1145133
1147314
1147943
1148008
1148515
1148532
1148554
1148611
1148645
1148779
1148801
1148816
1148832
1148878
1149427
1149588
1149784
1149788
1149790
1149793
1150337
1151261
1151281
1151457
1152251
1153204
1156989
1157036
1159502
1161392
1162790
1165540
1165641
1166363
1166389
1166405
1166568
1166588
1166607
1166924
1168045
1168557
1170792
1172078
1173960
1176825
1177696
1179992
1181365
1182724
1185502
1185746
1186469
1188748
1193759
1194847
1197791
1202933
1204932
1206362
1206381
1207665
1211712
1216513
1218761
1220881
1223205
1223285
1224928
1227179
1228252
1230195
1230703
1230961
1231273
1231307
1232500
1233236
1233782
1234997
1236700
1238383
1239017
1239801
1239891
1240052
1240747
1243211
1243414
1245865
1248042
1249836
1251716
1252472
1253157
1253237
1253266
1253922
1254895
1255907
1256174
1256818
1257433
1259320
1259445
1260415
1260884
1261854
1262003
1262371
1263204
1264041
1264516
1264562
1264593
1267377
1270122
1270447
1270449
1270450
1271002
1271149
1272056
1272255
1272278
1273133
1274895
1275324
1275410
1275855
1275862
1278882
1279242
1279969
1279970
1279974
1280035
1280847
1281073
1281738
1281741
1283335
1283899
1286065
1287530
1287821
1288002
1290672
1290674
1290690
1291023
1291036
1291037
1291043
1292322
1292327
1292663
1294422
1294654
1295883
1296561
1296569
1297468
1298635
1299769
1301807
1304074
1304088
1304241
1304280
1304401
1304692
1305359
1305600
1306147
1307225
1308273
1308744
1309133
1312448
1312787
1314583
1314980
1315808
1316853
1318507
1319115
1319241
1320100
1321161
1322087
1322771
1323471
1323648
1327205
1327464
1329828
1330721
1331393
1331519
1332141
1332144
1332289
1332578
1332673
1332842
1333808
1335051
1335055
1335623
1335778
1336210
1339048
1340333
1342286
1343616
1343931
1343932
1343933
1345455
1346160
1346161
1347413
1347523
1348160
1348190
1348201
1348227
1348236
1348254
1348256
1348302
1348503
1348541
1349203
1349839
1350194
1350597
1350656
1350657
1351521
1353483
1354683
1355647
1355859
1356820
1359665
1359666
1360669
1361153
1361332
1361333
1362745
1365579
1366932
1367090
1369646
1369880
1371092
1371543
1371993
1373033
1373438
1376638
1379405
1380334
1381149
1382156
1382756
1382784
1382887
1383958
1384468
1384940
1387240
1387439
1387498
1387599
1388753
1388925
1389626
1389627
1389634
1389636
1389640
1389801
1390253
1390554
1391148
1391531
1391575
1393341
1393440
1393877
1394101
1395893
1395895
1395896
1395962
1395965
1395966
1395967
1395968
1395969
1395987
1395990
1395997
1395998
1396003
1396005
1396006
1396009
1396019
1396037
1396042
1396044
1396064
1396081
1396090
1396116
1396127
1396141
1396537
1396657
1396702
1397721
1398104
1399399
1400233
1400344
1401419
1401428
1402530
1403453
1404042
1404370
1404633
1404679
1405259
1405284
1405416
1405488
1405526
1405717
1405757
1405785
1405787
1405803
1406402
1407116
1407348
1407393
1407514
1407536
1407550
1408094
1408362
1409065
1409499
1410058
1413647
1413697
1414073
1414206
1414684
1415688
1416252
1419094
1419258
1420307
1420437
1421931
1421932
1423175
1425364
1425386
1425704
1425706
1425827
1426828
1427449
1428439
1428475
1428809
1429046
1429284
1429413
1430131
1431309
1433144
1433513
1436206
1436524
1437500
1438874
1440251
1440484
1440715
1441478
1444825
1445412
1445678
1445681
1445733
1445751
1445768
1446369
1446373
1446597
1447041
1447936
1447940
1447941
1447943
1447949
1447950
1447954
1447968
1447969
1447980
1447992
1449019
1449047
1449279
1450055
1450785
1450922
1451684
1452288
1453252
1453644
1454030
1454049
1454170
1454368
1454369
1454373
1454432
1454449
1454459
1454762
1455123
1455126
1455127
1455134
1456803
1457763
1458679
1459236
1459417
1459479
1459581
1459612
1459957
1460232
1461107
1461139
1461502
1461645
1462137
1463334
1463718
1463916
1464617
1464648
1464665
1465500
1465798
1465902
1466085
1468237
1469518
1469991
1471328
1471608
1471689
1473153
1473166
1473468
1473663
1473956
1474124
1474204
1474786
1474791
1475071
1475621
1475914
1476213
1476751
1478428
1479304
1479478
1479654
1479660
1479872
1480279
1480621
1481040
1481059
1481066
1481079
1482520
1482632
1483762
1483763
1483878
1485508
1485588
1485589
1486818
1486819
1486829
1486830
1486833
1486834
1486840
1486841
1486842
1486843
1486858
1486862
1486863
1486865
1486871
1486872
1486891
1487115
1487996
1488262
1489980
1490794
1490926
1492313
1492883
1499222
1499886
1501262
1501408
1501503
1501610
1501942
1502387
1503238
1503241
1503242
1503243
1503244
1503245
1503246
1503247
1503256
1503257
1503258
1503260
1503265
1503266
1503267
1503268
1503271
1503557
1506147
1507282
1507599
1508007
1508451
1510354
1510753
1511186
1511889
1512398
1512787
1513014
1513103
1514548
1515206
1515209
1515213
1515223
1515794
1516200
1516213
1516228
1516229
1516246
1516279
1516301
1516339
1518091
1518816
1519423
1520696
1520700
1520761
1520775
1520810
1522414
1522599
1522672
1522673
1523812
1523813
1524331
1525702
1525953
1526183
1528291
1528369
1530676
1530905
1530911
1531033
1531635
1532575
1532913
1533203
1533334
1533349
1533387
1533428
1533897
1534694
1535204
1535290
1535438
1536201
1536412
1536863
1536872
1536875
1536977
1536983
1536988
1536989
1538204
1538760
1539303
1540166
1541125
1541126
1541127
1541133
1541176
1541675
1542362
1542442
1542569
1543090
1543230
1543310
1543940
1544211
1544621
1545416
1545579
1545825
1546179
1546199
1546200
1546203
1546204
1546207
1546209
1546210
1546211
1546213
1546216
1546219
1546220
1546224
1546225
1546242
1546244
1546245
1546246
1546247
1546251
1546252
1546255
1546256
1546258
1546259
1546260
1546261
1546265
1546266
1546267
1546268
1546270
1546271
1546272
1546274
1546275
1546281
1546288
1546289
1546487
1547154
1547587
1547590
1547936
1548483
1549042
1549043
1549363
1549548
1549615
1549695
1549788
1549917
1550530
1550534
1550691
1550769
1550866
1550875
1551538
1551681
1551820
1551985
1552270
1552683
1552785
1553166
1553558
1553597
1553675
1554445
