#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

$log->out('Fetching data');

my @orderids = map {chomp; $_} <DATA>;

my $data = get_all_sql(PPC_HEAVY, [q/
    SELECT c.cid, b.bid, p.pid
    FROM campaigns c
    INNER JOIN banners b ON c.cid=b.cid
    INNER JOIN phrases p ON b.bid = p.bid
/,  WHERE => {OrderID => \@orderids}]);

while (my @packet = splice @$data, 0, 10_000) {
    $log->out('Adding to resync queue: ', \@packet);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, pid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid pid/]} @packet]);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid bid/]} @packet]);
    do_mass_insert_sql(PPC, q/INSERT IGNORE INTO bs_resync_queue (cid) VALUES %s/, [map {my $row=$_; [map {$row->{$_}} qw/cid/]} @packet]);
}

$log->out('FINISH');

__DATA__
20440
27242
28105
31701
39876
41468
52393
58370
75080
75410
81101
82319
82365
85031
88417
165108
168636
169160
171435
172265
173762
174938
193037
193692
196640
198503
206990
208002
213921
214215
221982
223884
224589
228676
236882
238271
243948
244716
250028
252598
255157
256189
256528
257231
266038
267055
274089
278421
278528
280975
281050
290697
296701
297211
299860
300825
308345
314902
315170
315892
317116
319461
320404
330273
333046
348132
350769
353037
355462
356224
357973
359091
362569
364458
364722
365025
374067
374199
375389
377037
379602
383121
384154
385062
385064
385067
387744
390120
394180
396596
398954
404361
405584
408085
409742
419156
424633
434824
435645
435940
438853
439527
441579
445152
445671
447113
455965
457190
458818
459086
459589
465456
466352
468916
468947
469985
470510
470785
477415
478224
480758
480936
481051
481129
481181
488586
489055
489861
489862
491257
494358
497616
501561
506634
507681
509492
520461
520634
528110
528120
528365
530398
537031
537654
539005
540932
541138
542079
543143
543716
546182
546431
546547
547149
549197
551549
555110
556378
556603
556605
556610
556939
558512
558606
561115
561149
568526
570050
570879
571730
578988
579083
581895
582945
586936
586943
586945
588498
592094
596421
596751
601632
602564
605946
608530
608733
610196
610729
615947
616572
617779
624881
626563
627879
628174
631768
633521
635271
638629
641525
643477
644735
645034
645063
647322
651263
651462
652986
654310
657214
658460
659621
659622
659846
660951
671131
671554
672450
673004
674157
676837
678226
678229
681415
681454
686409
687232
689255
690404
691346
693258
694976
696812
698064
702467
706053
706348
708494
710215
712423
712577
721383
723585
725067
725282
725831
732160
735321
736007
743010
748365
751349
752856
755434
758013
760654
761215
761979
762904
763567
764194
764586
766447
770237
771833
777002
777814
779141
780424
783220
784803
786121
789782
791728
791743
793245
795942
796456
799277
802372
805626
807345
809293
811063
817099
819029
819034
825474
827392
828964
853278
855446
857391
858873
875834
887303
896401
898162
944963
949930
975744
981650
987744
995012
998381
1000907
1002165
1012749
1013077
1013799
1015765
1024190
1032048
1032476
1039671
1041666
1042979
1045779
1052654
1056945
1070681
1082877
1092286
1092667
1100221
1255429
1256992
1260318
1260754
1262906
1263088
1269197
1279611
1368591
1436545
1440839
1443421
1444653
