#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 час",
  comment => "ставим в очередь перепосылки все домены с www."
}

=cut

use strict;
use warnings;

use Yandex::DBTools;
use Yandex::IDN;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;
use MirrorsTools;
use Yandex::MirrorsTools::Hostings qw/strip_www/;

$log->out("start");

my $mirror = MirrorsTools->new(dbh => PPCDICT, use_db => 1, dont_load_file => 1);

get_dbh(PPC_HEAVY)->{mysql_use_result} = 1;
my $sth = exec_sql(PPC_HEAVY, "SELECT cid, bid, domain FROM banners WHERE statusBsSynced = 'Yes' AND ifnull(domain, '') != '' order by bid");

my $n = 0;
my @buffer;
my $inserted = 0;
my %D;
while(my ($cid, $bid, $domain) = $sth->fetchrow_array) {
    if ($n++ % 100_000 == 0) {
        if (@buffer) {
            $log->out(sprintf "insert %d rows to resync", scalar(@buffer));
            $inserted += do_mass_insert_sql(PPC, "INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s", \@buffer);
            @buffer = ();
        }
        $log->out("Row #$n, bid=$bid");
    }
    if (! exists $D{$domain}) {
        if ($domain =~ /^www\./) {
            $D{$domain} = 1;
        } else {
            my $site_ascii = Yandex::IDN::idn_to_ascii($domain);
            my $domain_filter = $mirror->domain_filter($site_ascii);
            $D{$domain} = $site_ascii && strip_www($site_ascii) ne $site_ascii
                || $domain_filter && strip_www($domain_filter) ne $domain_filter;
        }
    }
    if ($D{$domain}) {
        #$log->out("$bid $site_ascii $domain_filter");
        push @buffer, [$cid, $bid];
    }
}
if (@buffer) {
    $log->out(sprintf "insert %d rows to resync", scalar(@buffer));
    $inserted += do_mass_insert_sql(PPC, "INSERT IGNORE INTO bs_resync_queue (cid, bid) VALUES %s", \@buffer);
    @buffer = ();
}

$log->out("inserted $inserted rows, finish");

