#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '3 минуты',
  comment => 'Исправляем признак отправки визитки на модерацию (phoneflag) для баннеров без визитки',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;

use utf8;

$log->out('START');

my $cond = 'phoneflag <> "New" AND IFNULL(vcard_id,0) = 0';

$log->out('Fetching bids to fix');
my $bids = get_one_column_sql(PPC_HEAVY, "SELECT bid FROM banners WHERE $cond");
$log->out('Possible bids to fix (' . scalar(@$bids) . '):', $bids);

while(my @bids_bundle = splice @$bids, 0, 1000) {
    $log->out('Updating bundle of bids (' . scalar(@bids_bundle) . ' pcs): ', \@bids_bundle);
    do_sql(PPC, [qq/UPDATE banners SET phoneflag = "New" WHERE $cond AND/, {bid => \@bids_bundle}]);
}

$log->out('FINISH');
