#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 час",
  comment => 'перед началом работы скрипта нужно скачать файл
scp root@ppcdev.yandex.ru:/home/zhur/priorities_to_resend /tmp/priorities_to_resend
'
}

=cut

use strict;
use warnings;

use Time::HiRes;

use Yandex::DBTools;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Settings;
use ScriptHelper;

$log->out("start");
open(my $fh, "<", "/tmp/priorities_to_resend") || $log->die("Can't open /tmp/priorities_to_resend: $!");
my @pids = map {chomp; $_} <$fh>;
close $fh;

while(my @chunk = splice @pids, 0, 1000) {
    $log->out("Process pids = ".join(",", @chunk));
    my $cnt = do_insert_select_sql(PPC,
                                   "INSERT IGNORE INTO bs_resync_queue (cid, pid) VALUES %s",
                                   ["SELECT b.cid, p.pid FROM phrases p join banners b using (bid)",
                                            WHERE => {'p.pid' => \@chunk}
                                   ]
        );
    $log->out("inserted $cnt rows");
    Time::HiRes::sleep(0.5);
}

$log->out("finish");
