#!/usr/bin/perl -w

use strict;

=head1 DEPLOY

# approved by zhur 
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "~12 часов",
  comment => 'Удаляем дублирующиеся записи в истории bids.id <=> PhraseID. Пишет лог файл.'
}

=cut

use utf8;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use ScriptHelper;
use Yandex::DBTools;

$log->out("start");

my $cur_cid = 4519557 || get_one_field_sql(PPC, "select max(cid) from campaigns");
my $step = 1000;
my $counter = 0;

get_dbh(PPC_HEAVY)->{mysql_use_result} = 1;

while ($cur_cid > 0) {
    $cur_cid -= $step;

    my $sth = exec_sql(PPC_HEAVY, "select cid, bid, PhraseID, bids_id, logtime
                                     from bids_phraseid_associate
                                    where cid between ? and ?
                                 order by cid, bid, PhraseID, logtime", $cur_cid, $cur_cid + $step);

    my $to_del;
    my $prev = {cid => 0, bid => 0, PhraseID => 0};
    
    while (my $row = $sth->fetchrow_hashref) {

        if ($row->{cid} != $prev->{cid} && scalar keys %$to_del) {
            _delete_records($prev->{cid}, $to_del);
            undef $to_del;
        }
        
        if ($row->{cid} == $prev->{cid}
                && $row->{bid} == $prev->{bid}
                && $row->{PhraseID} == $prev->{PhraseID}
                && $row->{bids_id} == $prev->{bids_id}) {

            push @{$to_del->{$row->{bid}}}, [$row->{bids_id}, $row->{logtime}];
            $counter++;
        }

        $prev = $row;
    }

    _delete_records($prev->{cid}, $to_del) if defined $to_del;

    $log->out("processed from $cur_cid to ".($cur_cid + $step).": $counter");
}

$log->out("end.");

sub _delete_records
{
    my $cid = shift;
    my $to_del = shift;

    foreach my $bid (keys %$to_del) {
        $log->out("\t$cid:$bid:".(scalar @{$to_del->{$bid}}));
        
        while (my @mass = splice(@{$to_del->{$bid}}, 0, 500)) {
            my $cond = join ',', map { "(".$_->[0].", ".get_dbh(PPC)->quote($_->[1]).")" } @mass;

            my $sql = "delete from bids_phraseid_associate where cid=$cid and bid=$bid and (bids_id, logtime) in ($cond)";
            do_sql(PPC, $sql);
        }        
    }
}
