#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 min",
  comment => "перепосылаем в БК кампании по списку от Захара"
}

=cut

use strict;
use warnings;

use Time::HiRes qw/time sleep/;

use FindBin qw/$Bin/;
use lib "$Bin/../protected";

use Yandex::DBTools;
use Settings;
use ScriptHelper;

$log->out("start");
my @bids = sort {$a <=> $b} grep {/^\d+$/} map {s/\D//g; $_} <DATA>;
while(my @chunk = splice @bids, 0, 1000) {
    $log->out("resend bids" => \@chunk);
    my $t1 = time();
    my $cnt = do_sql(PPC, ["INSERT IGNORE INTO bs_resync_queue (cid, bid, pid, priority) 
                  SELECT b.cid, b.bid, p.pid, 1
                    FROM banners b join phrases p on p.bid = b.bid
                   ", WHERE => {'b.bid' => \@chunk}]);
    $log->out("inserted $cnt rows");
    sleep(time - $t1);
}
$log->out("finish");

__DATA__
194563
194571
217792
194554
253685
253684
253687
253690
253689
636734
744919
1605452
1605454
2039212
1834485
2070995
2378720
2658796
3179019
3718260
4025635
4535959
4629252
6237650
6312819
6312814
6312854
6484551
6924603
6924451
7025589
744918
474288
7316838
7543331
8392877
8415172
9145616
9622378
10251759
10630056
11433539
2075184
11737606
11737597
11671874
11986368
13317116
13175345
15848141
16432641
11997907
17056803
17394203
18181645
18181646
19673572
21191700
21430048
22190286
22732937
10690562
24299629
16992561
19730063
2280125
24708519
24833142
24102000
25645857
25645490
25691502
25693430
25645489
25645625
25645599
25645844
25896927
25645488
25645511
25645493
27012093
27012077
27011944
27012016
26119162
27011912
26997111
26118681
25916642
27155580
25896950
25896928
25896985
25896984
25896995
25896987
28006796
23134101
28547061
28538125
28537188
28536863
28537682
28538365
28547129
28547006
28547014
28775655
28775855
26990880
29070917
10780145
18842942
18842902
18842922
19368512
19395395
19674997
19674976
22115926
25398048
25804125
26236632
28279244
9109976
18842912
19368502
19395385
19395325
19395426
19675007
19674966
19674987
25647964
25645984
25804173
9922267
25695097
25646074
25647584
25399674
18842943
18842903
18842933
18842913
19368493
19395386
19395396
19395467
19395417
19395376
19674977
19675008
19674998
19674988
19674967
19972818
25398477
25397874
21458476
21667667
22115927
25400153
25438636
25647544
25804117
25802974
25802987
25938471
28281457
28279245
28281447
28281467
3585072
7100209
23632591
10081461
15316185
18842934
18842924
18842914
18842904
18842944
19391724
19674999
19674968
19674978
19674989
21458477
22115889
25646354
25804127
25802962
26484056
27228551
28279197
28281671
4188263
25379448
4980955
7380600
8949228
5480148
25715354
25715343
25715213
25715212
24542700
10041360
18842285
18842935
18842905
18842915
19368495
19395469
19395318
19674990
19675000
19674979
19674969
30973770
23632601
25400234
25400016
25438408
25460339
25646106
25682670
31073342
25695221
25802977
26236605
26236665
26236505
27719705
28279247
28281559
28281529
8319339
25398757
25678848
8999768
8999679
8999738
31075990
25399521
9633053
25397978
25398060
27716732
25361737
25399009
25399496
25662200
25695186
25715011
25646105
25398593
25397905
23632570
30401415
10885373
25648060
25647379
27719721
18470868
18842946
18842906
18842936
18842926
25646049
25714960
19395440
19395369
19395209
19395460
19395410
19674980
19675001
19674970
27541362
25398800
25398763
25678698
2640977
25802917
25802964
25802991
25802951
2652403
27369051
27719874
28281560
28279199
28279208
28281663
28783088
7100202
7100193
7380602
7426591
7426601
9061603
9056402
9632718
27716702
23632590
25400941
25401021
28825903
27637245
23632569
24518350
25941684
6163225
25399160
20059105
22035658
24026299
23690919
25695555
25715126
25942204
26236569
26236539
25802892
25802985
28279194
29092444
29070937
29070907
29150199
25398709
25398926
25398736
25398771
25400071
25645472
7380596
7380606
31524654
20059106
20059103
19418049
31625638
31625635
31625632
25399154
25647438
25398980
25401031
25400973
28281441
28281561
28281461
28281664
29070899
29070858
29070848
29551854
404661
7380597
31062469
23632593
18842927
18842917
18842947
18842907
18842937
19368497
19391691
21000620
21000840
24312905
24943448
25566617
25647359
25648050
25645516
25399208
31157141
25399276
25400994
28281462
28281482
29070890
29070880
29070859
29070849
27369044
27425184
27369062
27425210
25715019
25715016
8999704
11200637
18842928
19674971
19674992
19675002
19674981
18842908
19674961
18842918
19395380
19395350
22115876
25647360
2640980
27739198
28281463
28281533
29070940
29070860
29070891
25647376
9891947
23632596
10270879
1961224
18843731
18842288
19674993
19675003
18842939
19674972
19674962
19674982
18842929
19395321
19368509
19395381
19391693
19395361
19972853
20823604
26490360
27559669
28281454
28281484
29070951
29070851
7426586
17092348
18156656
18842921
18842920
18842911
18842930
18842931
18842940
18842941
19368511
19391694
19368500
19368510
19395332
19395433
19395405
19674974
19674996
19674975
19675005
19675006
19674983
19674965
19674964
19675004
19674994
19674984
19674986
19674963
19674995
19972764
19972825
19972765
19972826
20060813
20060811
25647843
21667599
21667385
31361551
26424266
26464035
26440945
24531453
26424273
26415479
26424263
25661544
24529971
23632587
25399418
24832256
25661545
25695732
2589136
25804130
25804172
25804131
25804113
25802996
25804178
25804112
25804124
27425212
27425219
28279329
28279201
28279251
28281455
28279249
28279239
28279202
28279229
28281435
28279231
28279211
28281414
28631640
28783089
21364268
17778365
29549640
29549654
29974626
30382537
12070825
31086228
31135781
5340676
5480112
25398993
25645543
25645837
25645813
25695984
25645714
7100222
7380595
7380604
7380603
7380605
8649912
25646959
9056006
9056630
31503848
31503477
9803815
9996008
9958126
23632571
30709313
23632588
30728580
25647551
25696828
26897609
31760020
25400337
31330318
31330328
31330327
32447111
32447116
32447109
32447114
32447113
32447110
32447115
32583960
32584006
32583975
32583970
31625579
32026685
32026664
9628338
31003974
32325256
32325267
32325236
32407242
32520356
32551050
32578865
25397160
26415472
25361074
27542383
28051602
25454406
27018957
27108752
27070518
31209679
31209682
19972834
19972832
31597740
25802995
25804110
25802897
25802886
25802948
25802955
25804118
25802979
25802899
25802909
25802967
25804122
25804109
27719639
25646911
17092375
17092376
32921978
32923002
28249417
28281545
9948470
32951641
32752684
31793958
33164099
33164377
33164862
33164935
33164461
33164103
33164350
33178521
33290888
33361709
33361707
33361706
33361708
33361712
33361710
32041919
33501169
32049769
32050040
32049998
32049904
32049928
32049820
32049974
32049767
32049898
32049863
32050088
25647157
30642260
33465095
33465083
33465103
33465101
33474321
31349296
31349303
31349355
31349400
31349402
31349362
31349370
31349421
31349325
31349398
31349284
31349357
31349307
31349375
31349390
31349360
31349386
31349329
31349393
31349281
31349320
31349395
31349289
31349381
31349367
33521828
5480102
5480139
5480103
5480138
5798191
5932360
5932333
32852829
33598812
25645470
32794046
33971174
33971173
12196948
21170504
27070324
27070101
27070130
27070294
31485996
34095071
34365686
31793392
31793436
31793412
32615320
31794773
31794783
31818993
32931458
31818605
32613657
31818651
32931462
32931464
32931466
32931484
32931501
31818633
32931472
32931504
32931518
31818643
32931505
31818597
31818615
32931456
32931540
31818590
31818957
32931543
32931534
32931474
31818626
32613655
32931469
34457746
34457234
34457477
34457494
34457276
34457115
34457347
34457400
34457764
34457701
34457359
34457299
34457824
34457811
34457855
34457925
5480118
5480019
5480117
5480114
5480095
34535861
34365983
34914658
34914608
34914634
34914628
34914595
34914602
34914644
34914653
34914605
34914645
34914647
34914648
34914582
34914599
34914576
30617003
30616832
30616009
30616502
30616741
30615909
30615136
30615364
30617196
30616106
30617561
30615793
30615943
30615895
30616701
30616866
30615997
30615692
30617360
30617329
30615568
30615617
30615284
30616115
30617206
30616822
30617013
30615730
30615387
30615416
30615714
30615628
30617166
30615846
30615978
30617647
30615064
30615256
30616624
30615814
30616559
30616634
30615318
30615701
30615859
30615559
30615144
30617228
30616716
30617720
30616139
30615339
30615758
30616727
30615743
30617216
30615840
30615295
30617474
30616753
30615928
30616583
30617142
30617623
30617674
30615266
30615826
30615222
30615376
30615957
30615196
30617127
30616689
30617393
30616132
30615650
30616966
30616876
30615987
30617449
30617379
30616789
30616543
30616039
30616675
30615250
30616735
30615608
30616122
30615409
30617156
30617440
30617657
30616777
30615304
30615643
30615117
30617133
30616165
30615919
30616098
30616149
30615879
30617542
30616663
30615275
30615351
30617407
30616090
30617117
30616995
30615126
30616938
30615660
30616031
30616613
30617737
30615833
30616017
30616978
30615329
31851390
31851358
31851371
31851336
31851394
31851365
31851341
31851353
31851348
31851378
31642842
34914255
34914223
34914052
34914247
34914116
34914237
34914194
34914153
34914189
34914254
34914268
34914097
34914275
34914192
34914145
34914101
34914087
34914317
34914222
34914331
34914288
34914176
34914224
34914069
34914127
34914107
34914136
34914167
34914219
34914228
34914266
34914298
34914130
34914151
34914083
34914152
34914244
34914289
34914305
34914161
34914092
34914199
34914241
34914148
34914164
34914256
34914431
34914423
34914383
34914345
34914495
34914489
34914509
34914472
34914514
34914356
34914427
34914549
34914486
34914428
34914365
34914505
34914461
34914406
34914415
34914381
34914418
34914363
34914526
34914551
34914511
34914468
34914400
34914553
34914439
34914389
34914524
34914434
34914557
34914422
34914426
34914559
34914457
34914433
26615776
27229096
25397886
25397850
25398769
25398916
25695238
32591446
25402043
25645401
26557472
28097477
27264545
25402757
25695463
32041953
28703068
24933479
25361130
25402243
25397856
29615965
25397081
27229259
25402268
25396880
25402472
25647614
32551049
25678715
27719601
32551061
33501191
35611883
25647772
35455814
29489833
35613710
25396914
25715257
25401069
25647448
25647582
25361007
25397860
27719741
25647143
25648081
28197826
25398288
25695761
25678706
34365362
33505188
20184643
35251047
31630230
31630215
31630233
31630235
31630219
31630222
31630217
31630231
31630225
31630224
31630227
25647619
25647593
31215350
26898557
35867123
34365365
25361482
32166672
32166617
32166566
34367569
33504685
25714952
25397853
33300271
33468817
34964315
34967516
34967499
34970573
35014236
35014238
35014237
35228746
35228677
35228680
35228675
35228726
35228738
35228710
35228731
35228709
35228719
32891223
35400315
35400330
35400239
35400324
35400273
35400253
35400339
35400282
35400316
35400319
35400310
35400285
35400284
35400322
35400313
35400274
35400318
35417862
35417817
35455749
35455754
35455746
35455767
35458153
35457615
28558554
36213836
36214224
36245110
36242552
28197778
25715134
15459745
12070830
15459740
15458867
35847167
35846860
32578867
32578858
32578863
32578880
32578850
32578847
32578868
32578854
34366573
25647179
25646960
25715344
34611290
26615810
26615809
25645709
35656507
35678822
35678793
35678714
35678817
35678792
35678825
35678781
35678751
35686501
35686532
35686524
35686528
35686516
35686546
35686514
35686494
35686562
35686515
35686571
35686534
35686569
35686835
35686840
35686826
35686831
35686816
35686795
35686833
35637522
35912880
35912889
35912784
35912820
35912838
35912764
35912788
35912828
35912878
13215300
36483728
36483806
36483993
36484038
36484191
36484484
35630482
36486691
36496638
35289089
34552996
33878225
35708131
35708064
35708068
35708146
35708137
35708083
35708160
35708127
35708060
35708071
35708133
35708061
35708099
35708142
35708200
35708163
35708135
35708145
35708087
35708147
35708138
35708091
35708132
35708130
35708155
35708139
35708161
35708065
35708140
35708124
35708164
35708097
35708158
35708120
35708129
35708089
35708058
35708059
35708069
35708070
35708128
35708066
35708143
35708062
35708063
35708150
35708153
35708136
35708122
35708157
35708067
35708094
35708437
35709815
35708443
35712488
35709861
35712495
35712548
35709913
35709853
35709930
35709826
35709869
35708816
35709839
35708439
35709806
35708779
35709796
35708777
35708441
35708445
35709922
35710383
35708050
35708021
35709288
35707996
35708000
35708026
35708020
35708007
35707479
35708010
35708037
35708045
35708042
35708009
35708011
35707995
35708032
35708005
35708043
35708044
35708041
35707478
35708014
35708035
35708051
35707474
35707993
35708012
35707992
35707991
35707997
35708049
35708019
35708025
35708004
35708017
35708036
35708034
35708047
35709391
35708048
35708029
35708022
35707999
35707998
35707484
35707477
35707994
35708016
35708002
35708038
35708030
35708033
35708024
35708039
35708001
35708031
35708013
35708027
35707475
35708015
35708003
35708053
35708052
35708046
35708008
35707483
35707480
25696829
27719873
25401443
25398315
25646159
27228547
35103694
35100069
36734320
35743115
35749667
35749636
35749652
35749677
35749593
35749615
35749647
35749643
35749642
35749675
35749695
35749592
35749670
35847634
25648120
25647496
25715258
25682652
27274441
34612920
25678708
25398622
25398623
35704063
35704062
35704064
35704068
25399232
25715253
25402800
37013110
37013091
37013112
37013093
37013115
25647089
32609366
32609364
32609363
32609365
36315186
37028349
37028340
37027977
37028348
37028346
37027976
37028376
37027974
37028353
37028398
37027973
36811216
36811230
36811218
36811225
36811227
36811217
36811212
36811210
36811226
36811223
36811215
36811229
36811214
36811228
36811233
37029726
5954177
28703220
25396561
3756615
25402264
37227018
25360978
25397266
25360951
27201465
25398284
25678709
28008964
37535031
37535029
37535023
37535150
37535255
37535262
37535266
31484830
37552878
25402317
25402235
37619200
27719571
35457628
35457632
25715121
25398286
27228548
25714959
37808864
37808888
37808879
37808875
37808870
27792476
35457587
25695636
37982363
25361305
3756549
38031033
38031156
25397564
35417791
35417728
35417793
35417861
35417830
35417756
35417905
35479686
35678829
35678769
35678820
35678821
35678757
36252802
36252786
36252814
36252810
36252783
36252797
36252791
36252788
36252763
36252734
36252782
36252778
36252735
36254371
36254385
36254411
36254461
36254454
36254406
36304727
36311717
37581080
37696377
37696470
37696383
37696388
37793976
37793974
37793984
37793986
37793983
37793982
37793979
37793981
37793985
37793980
7459901
37029956
37029954
28702224
25647426
25647319
27201451
35594725
37118038
31885757
25646895
36932753
29048934
37187550
37130507
37184341
37177409
37132979
37186398
37116076
37123564
38735737
25662224
38846131
33503239
3324588
35525924
35525515
35526269
36890792
37506822
37982603
37982600
38378473
8731333
34965281
27201464
5954197
39229455
25360831
32952759
25398332
25398317
38735947
21662586
21662639
21662742
21662654
21662575
21662741
21662740
21662580
21662592
21662595
21662601
21662620
21662737
21662588
21662747
21662746
21662634
21662657
21662743
21662598
21662612
27757087
25361059
25877803
25877802
31786415
37537295
37568250
38194348
39642223
39642218
39642207
39642211
39642217
39642216
39760453
39760463
39537994
39882253
39882254
39882255
39904752
39904747
39904739
39904740
39904744
39904754
39904749
39904751
39904737
39904746
39904742
39904736
39904761
39904757
39904759
39904762
39904765
39904767
39904755
18200949
5932362
5480017
5480104
32161285
40146629
40161585
40162783
29418887
29419829
40163715
40163979
40164235
29999744
31625625
31625647
31625603
31625623
31625607
31625627
31625641
31625600
31625644
39761311
39761315
39761309
34967509
39134815
39134826
39134816
39136345
36480569
30558328
40241473
38470092
38470091
27451679
38870519
38870522
37242399
37243672
38948267
38939922
38939923
32951653
39696746
39700815
39700806
39700817
39700798
39700790
39700827
39700804
39700803
39700792
39700797
39700801
39700802
39700818
39700799
39700814
39700816
39700826
39700805
39700800
39700791
39750186
39750219
39750187
39750602
39750303
39750598
39750372
39750647
39750364
39750651
39750390
39750358
39750276
39750632
39750272
39750295
39750384
39750630
39750248
39750634
39750599
39820841
40004091
40004090
40002431
40002451
40010426
40013249
40021143
25714993
25714964
28754655
25695723
25648041
40419012
39932159
25648154
39942206
33088315
39706496
39706484
39706337
39706377
39706449
40077010
40156132
40156140
40156161
39136172
31632297
40951697
40955620
40414832
40414791
40414844
40414847
40414786
40414788
40414801
40414805
40548693
31625567
40672095
40673814
40730510
40725050
40725057
40725055
40730303
40725052
40730492
40725047
40730502
40730418
40730508
40725046
40730496
40725054
40730500
40725059
40730494
40730449
40730331
40730486
40730493
40725056
40730506
40725051
40730433
40730503
40730509
40730501
40725058
40725041
40730497
40725053
40730499
40725048
40730507
40730495
40639039
25695331
41151626
40414008
26021465
37980820
35458270
41383461
39886118
41130166
41172781
41286709
41286703
41286690
41286682
41203578
41227780
38507622
41201057
25714989
25714951
35456176
41127407
41127385
25715229
25715125
41881872
41881870
41881871
41881867
41881874
30515670
30515637
22755427
35704067
41305363
41318754
41319389
41383453
41383407
41383425
41383412
41383388
41383455
41383414
41383449
41454793
41454653
41506159
41506776
41522777
41569206
41544952
41591160
39641008
41452110
25648230
41036612
38744393
25648255
41155218
25397049
34964322
32029577
41977513
42027498
42118492
25648252
25400870
42425931
25715239
25714991
25715224
41160051
39652090
26763199
27719589
42139041
42139045
42139040
42230699
42378628
42378792
42378674
42378695
42378636
42378644
42378729
42378669
42378699
42378638
42378643
42378813
42378812
42378617
42378703
42378635
42378694
42378641
42378672
42378670
42378690
42378648
42378706
42378647
42378637
42378671
42378675
42378817
42438655
27719628
42779263
41633638
42891045
42891039
42891040
22594526
22594519
22594531
22594530
22594514
22594513
22594544
22594535
22594529
22594554
22594552
22594549
42659792
42680817
32136022
42986846
19394784
43151291
43151255
43151282
25798056
25798186
33912490
33912394
33912342
33912374
33912328
33912457
33912368
33912317
33912379
33912399
33912356
33912429
33912353
33912402
33912398
33912408
33912498
33912413
33912474
33912489
33912420
33912455
33912488
33912376
33912433
33912388
33912464
33912451
33912486
33912459
43213693
43321739
43335560
43335549
43335546
43335573
43335567
43040209
43040188
43040215
43040198
43040223
43040204
43040201
43040230
43040202
43040180
43040377
43040242
43040250
43040380
43040366
43040270
43040273
43040293
43040295
43040320
43040335
43040317
43040252
43040312
43040233
43040263
43040371
43040336
43040411
43040339
43040238
43040355
43040331
43040465
43040483
43040501
43040544
43040517
43040486
43040426
43040495
43040456
43040543
43040540
43040574
43040527
43040567
43040438
43040545
43440173
37793978
37793987
37793988
37793975
41633649
41633627
41633631
41633632
41633634
41633633
41633635
41172843
41172837
5302616
43511622
43511716
43511632
43511605
43511607
43511611
43511610
43511603
43511616
43511602
43511627
43511625
43511753
43511621
43511608
43511623
43511609
43511615
43511624
43511720
43511606
43511620
43511612
43511633
43511617
43511711
43511613
43511726
43511759
43511747
43511601
43524363
25695311
43540711
28703219
41053932
39018535
32784095
40036379
43627026
43627010
43627218
43626822
43627146
43701560
43667415
43735834
43735853
43735857
43735859
43735855
43735843
43756616
42699139
43867530
43863774
40033199
40033876
40033226
40034560
43896432
43896440
43918846
43918843
43918852
43918842
43918854
43918844
43918845
43918849
43918848
43990711
40976812
40979472
41150279
41797232
42514711
44061110
44092082
44092002
44092025
44092059
44092009
35940453
44072737
44072728
44074478
44074818
43553605
43581495
43581516
43581459
44252979
44257999
38741363
44342858
44139896
44075338
44139895
43944798
43945000
44066862
44347613
44349626
44396349
44406309
44426314
44426974
44427345
37880145
44442427
44442436
44442437
44442047
44442048
44441919
44441910
44441920
44442714
44442704
44442713
44442560
44442559
44442550
44426861
44427024
44427415
44427492
44427462
36658321
36658359
36658438
36658274
36658254
36658262
36658345
36658286
36658308
41765649
41765611
44491614
44483911
44496009
44496063
44496023
44496035
44337042
44473691
44473402
44610213
44623572
40689852
42748964
44693726
44744903
44777532
44795036
44795931
44807277
44836463
44836466
44836512
44836487
44836494
44836501
44836468
44836496
44836515
44843762
44843739
44843729
44843763
44843750
44842352
44843760
44844534
44843770
44843766
44844238
44844691
44844733
44844748
44843942
44844160
44843767
44844198
44844629
44844580
44843773
44844484
44844444
44846034
44846042
44846037
44846044
44846043
44846045
44855890
41053796
44912746
16142518
43540307
28783009
31638602
41243168
45182670
43211616
43208394
43210395
43209585
43210342
43209626
43209654
43208378
43210402
43209685
43209666
43210350
43209631
43209672
43209701
43209679
43210355
43209659
43208396
43209687
43209676
43209638
43209646
43208409
43209658
43209675
43209652
43209682
43209663
43211614
43209699
43209683
43211677
43209689
43213212
43208399
43210356
43210400
43210382
43209697
43209694
43211675
43211649
43209696
43209691
43213215
43208405
43209586
43211617
43210385
43209667
43208401
43209584
43208384
43209684
43211609
43209636
43210384
43211638
43211627
43209641
43209634
43210351
43209670
43210383
43211673
43209700
43209678
43211612
43209702
43210827
43210398
43209669
43209707
43208370
43209693
43209668
43208392
43209615
43208408
43209587
43209717
43211605
43208305
43209593
43210346
43208388
43209698
43209673
43209690
43209692
43211676
43210348
43209589
43210343
43211661
43209643
43209661
43208386
43208324
43208390
43209664
43209650
43209648
43209677
43209640
43209680
43210353
43209686
43210354
45184599
43627220
43627221
43627135
43806418
43853653
8032637
45310081
30175714
45367455
45374754
45376421
44834315
45364820
45364839
45365053
45364817
45369356
45369360
45364830
45347043
45401090
45402939
45382138
45382195
45382136
45416603
45416814
45456186
30819020
45554070
45581858
45595104
45595016
45595049
45595035
45599191
45561769
45731225
45731267
45731239
45731230
45731243
45731237
45731263
45731255
45731241
45731226
45731228
45731238
45731266
45731276
45731250
45731264
45731249
45732502
45732475
45732469
45732482
45732500
45732456
45732510
45732461
45732497
45732470
45732496
45732455
45732472
45732468
45732512
45732457
45732483
45732459
45731247
45732466
45732478
45825464
45830895
45832460
45597953
45597545
45598298
45597589
45597558
45596186
45598297
45598674
45597523
45598285
45598647
45595804
45596986
45597528
45596198
45597919
45597077
45598348
45597590
45597569
45597587
45597936
45597880
45673774
45782962
45859216
45859385
45864552
45864537
45939674
45942762
45943049
45945361
45952625
45965909
45994585
45964613
45949280
45949552
45950442
45951729
45949948
45950225
45951487
45950375
45949584
45952391
45952290
45952564
45950703
45950581
45952484
45951909
45952377
45950659
45950972
45958843
45952655
45952623
45956814
45955989
45956548
45957280
45952633
46042146
46038705
46045112
45365059
25645770
25645620
22840904
24642917
26273086
27631739
3305924
31794488
31794001
31794591
31793952
34509618
31794552
31793962
31793922
31794541
34509617
31794411
31793985
31794479
31642472
37404934
37281218
37545010
46108539
39641049
39641044
39641047
39641019
39641010
45345485
45356609
45356150
45354019
45354017
45354016
45347011
45356324
45347668
45347585
45347650
45352673
45346913
45356315
46006965
41706668
41706607
41706677
46230225
46232526
46232590
42672981
42672971
43430953
43430954
43430950
43430956
43744191
43744211
44336859
44443304
46246067
46246066
46246077
46246142
46246038
46246057
46246064
46246045
46246119
46246070
46246036
46246127
46246032
46246202
46246128
46246131
46246074
46246033
46246058
46246050
46246042
46246053
46246051
46246125
46246178
46246028
46246049
46246059
46246043
46246083
46246193
46246065
46246133
46246169
46246076
46246055
46246035
46246054
46246034
46246052
46246047
46246072
46246062
46246110
46246136
46246134
46246071
46246029
46246039
46246046
46246130
46246048
46246063
46246068
46246126
46246122
46246078
46246199
46246040
46246030
46246041
46246061
44902322
45016800
45345508
45351347
45349144
45346966
45349167
45354015
45352767
45354004
45352681
45356331
45356047
45354014
45352756
46006975
43440068
46338902
46355100
46355091
46355099
46355090
46355092
46355098
46355116
46355109
46355108
46355110
46355101
46355114
46354964
46354969
46354965
46354963
46355118
46355117
46354971
46354972
46354970
46362857
46362855
46362858
25647267
44789170
44796380
44789225
45664408
46102146
45813453
46231288
46231291
46393776
46393806
46398903
46434802
46434803
46434817
46434823
46495821
46644869
46644867
46644871
46670524
41745971
41745951
41745949
41746021
41746054
41746022
41745998
41745999
30587480
46796332
42102630
46835780
44342968
46232069
46845128
46845131
11716796
46799700
46799695
46799706
46846890
46872381
46997544
46999968
46999960
46999977
46799708
46799698
46799701
46799707
46799705
46799690
46799682
46799693
46799710
46799704
46799702
46799699
37537312
25646418
47029991
32099000
43493533
43493532
47099190
32099003
32099002
47096918
46648111
46648112
46648113
47175080
47185251
46801950
46801954
46801874
46801940
46801956
46801873
46801883
46801951
46801870
46801868
47188374
46799117
47294720
47294729
47294727
47299354
47162473
47162466
47162465
47162421
47162462
47162405
47162467
47162382
47162468
47162425
47162381
47162388
47162470
47162471
47162449
47162455
47162426
47162413
47162383
47330310
47330307
47330309
47330311
47330312
47349141
47349136
10070369
13215289
15547315
15547319
18159076
18200955
19703880
19703876
41053734
46668506
43581466
44846026
46165013
46799724
46801863
46801961
9775345
47182575
47182595
47182558
37002480
47442562
47442575
47442887
47442884
47442889
47442910
47442899
47442890
47442892
47442917
47442929
47442891
47442869
47442934
47442941
27741209
32135934
47511283
47593258
47658420
47349490
47321292
47321293
47321329
47321337
47321312
47321310
47321317
47321319
41610562
46976339
46976344
46976336
47824984
47825429
47891718
47891737
47891720
47986185
48024950
48055796
48055800
48055805
48055832
48055840
48055838
48055837
48064323
48066520
48067230
48067254
48066796
48070066
21522878
21853966
21526099
27671466
21587503
21853468
21526466
21525553
28573214
21526527
21525513
28573957
21526065
21526483
21864304
28539851
21855469
21522798
21851947
21523466
21856271
21526375
21522951
21526329
21864672
37418752
37418725
37418873
34914285
34914401
34914545
34987397
34914180
34914448
34914193
34914561
34914227
34914095
34914121
47030667
47030666
48097709
30498237
48099287
48220458
48220553
48253289
48255826
48255825
48258838
45345522
48273065
48273121
48273070
48212238
48275269
48501017
48501019
48501010
48501030
48501021
48501022
48501020
48501027
48501015
48501029
48501028
48501009
48501023
48501014
48501026
47400109
48276644
48523866
38886500
38886499
45186501
47644290
48617539
38906761
48704530
48852598
48852576
48852616
48852550
48852577
48852542
48852674
48853011
48852935
48852945
48852702
48852534
48853002
48853099
48853078
48853159
48942261
46621430
46621498
46621332
49079059
24501355
49223880
49281265
47015266
49400918
46045380
49403500
47530436
46997256
32099012
49393153
49392971
49393155
49392949
49392917
49393008
49392844
49392853
49392879
49392939
49392995
49392919
49393160
49392863
49393166
49392972
49393157
49392970
49392875
49392862
49392851
49392940
49392870
49392973
49393159
49392885
49392873
49392887
49392889
49392877
49393163
49392984
49392882
49392931
49393168
49392860
49392950
49392909
49392993
49393484
49393200
49393422
49393453
49393386
49393393
49393374
49393264
49393493
49393178
49393260
49393363
49393366
49393392
49393368
49393497
49393261
49393410
49393243
49393316
49393395
49393279
49393385
49393390
49393420
49393481
49393263
49393271
49393193
49393303
49393233
49393495
49393222
49393398
49393421
49393483
49393447
49393361
49393543
49393610
49393625
49393690
49393620
49393583
49393614
49393780
49393587
49393606
49393544
49393788
49393667
49393531
49393747
49393695
49393791
49393539
49393537
49393711
49393785
49393685
49393542
49393795
49393761
49393789
49393759
49393783
49393505
49393623
49393616
49393580
49393618
49393794
49393824
49393507
49393541
49393718
49393578
49393675
49393603
49393743
49393576
49393760
49393540
49393514
49393696
49393750
49393710
49393772
49393660
49393672
49393609
49393650
49393784
49393535
49393873
49393863
49393879
49574245
49426254
49428187
49428277
49428341
49428253
49428266
49428357
49428350
49428247
49428354
49428230
49428335
49428317
49428290
49428323
49428361
49428252
49428346
49428288
49428271
49428221
49428325
49428273
49428234
49428243
49428190
49428255
49428330
49428227
49428173
49428320
49428269
49428177
49428338
35528519
42450666
49335198
35575533
35575517
35575541
35575556
35526379
35575583
35526934
35528508
35528530
35575550
35575584
35575562
35575553
35575514
35526372
35575570
35526958
35575564
35575593
35575590
35526366
35526369
35528516
35575544
35526367
35526932
35526365
35526955
35528525
35575601
35575735
35575746
35575538
35575513
35526957
35575575
35528521
35575797
35575747
35575522
35575594
35528050
35528507
35526371
35575519
35575600
35575525
35528070
35575530
35575603
35575559
35575586
35575552
35575543
35575555
35528049
35526938
35575546
35575549
35575568
35575532
35528524
35526935
35526375
35526376
4939883
20868156
8332878
49652329
49652142
49652224
49652165
49652267
49652323
49652159
49652168
49652268
49652222
49652223
49652154
49652149
49652362
49652152
49652705
49652646
49652637
49652416
49652417
49652648
49652412
49652411
49652623
49652602
49652707
49652700
49652495
49652703
49652609
49652706
49652414
49652722
49652395
49652701
49652642
49652405
49652709
49652629
49652571
49652694
49652546
49652696
49652558
49652163
49652628
49652403
49652542
49652564
49652391
49652687
49652639
49652702
49652699
49652733
49652394
49657244
49656610
45040517
49652535
49652198
49652467
49652540
49652138
49652484
49652160
49652156
49652340
49652337
49652410
49652487
49652413
49652554
49652148
49652545
49652601
49652172
49653116
49653096
49653072
49652860
49652691
49652731
49653089
49652626
49653029
49652883
49653070
49652886
49652697
49653066
49652903
49653084
49652695
49652790
49653024
49653086
49653068
49653023
49653060
49653064
49652725
49652624
49652909
49653094
49652723
49653097
49652889
49652726
49652633
49652647
49652858
49652784
49653092
49653055
49653091
49653110
49652638
49653057
49653087
49652951
49653063
49652870
35528510
35575557
35526961
35575572
35528517
35526928
35575587
35528051
35575749
35575599
44770869
35575598
35575573
11421838
35526368
35526361
35526956
35575757
49394633
49394624
49394636
49394642
49394634
49394625
49394630
49394632
49394638
49394641
49394628
49394639
35575548
35528450
35528432
35527823
35528494
49763991
49763966
49790754
49790835
49790964
49791155
46376388
49807224
18656342
24606223
26022865
26023014
26022985
26978887
28063075
29142673
30264770
30264677
29974668
23941150
34940586
34940553
34940588
34940589
34940431
34940567
34940487
34940521
34940627
34940688
34940652
34940612
34940680
35526930
35527831
35526370
35526378
35526377
35526373
35526933
35526358
35526929
35526374
35526959
35526960
35526380
35526931
35575783
35575540
35575515
35575535
35528518
35575761
35575745
35575736
35528088
35528035
35575512
35575561
35575520
35575794
35575577
35575534
35528505
35575796
35575547
35528498
35575585
35575605
35528506
35575528
35575748
35528078
35575518
35575793
35528440
35575551
35575539
35575574
35528512
36007842
35528436
35528028
35528449
35528446
35528075
35528430
35528085
35526356
35528441
35528444
35526945
35528090
35528457
35528454
35528445
35528482
37416722
38908815
38908820
38909630
38908800
39024228
39365347
39538129
39538080
39538131
40039021
40049167
40044995
40049169
35526363
35528105
42196107
43440245
43440067
43440332
43440780
43440606
43440614
43440782
43440771
43440772
43440689
43440520
43440428
43440617
43440452
43440672
43440793
43440831
43440800
44536484
44968923
46304701
46851567
46843545
47312980
47400153
35526335
35526940
35526952
35526954
35526345
35526939
35526948
35526950
35526352
35526357
35528005
35528040
35528025
35528026
35528039
35528042
35528022
35528082
35527829
35528431
35528102
35528492
35528435
35528495
35575760
35575768
18387283
13699785
49851165
32864315
49853212
49854912
47196348
48259407
45790918
42199660
18922216
44771541
26021522
47766389
47767258
47766466
47767284
47767221
47193543
48241977
49862495
49869111
26021496
39866981
47157910
47329550
38500066
38398141
46376225
46377952
46378977
46378278
46376022
46377966
40756603
40756616
40447017
40796814
38963160
26021591
34978240
39365411
39249694
20829389
29017960
49134108
49134125
49134120
49134115
29978384
31736004
13700156
21717288
21718569
49638938
49843725
49843724
48544754
30003907
35949421
35949415
35949469
35949477
35949423
22201400
39537441
39018050
39365505
45500550
39537442
45004745
47103305
23077760
46815520
25533842
25177699
24676847
29092614
25266112
25179185
26527136
26524636
26612339
29448981
29311526
26425560
38766672
38766697
49137165
39537697
39538337
39537843
39537686
39537804
39538338
39537714
39537530
39537687
39537448
39537875
39537667
39537662
39537574
47096223
47096329
47096217
47096249
47096360
47096305
47096258
47096303
47096348
47096338
47096347
47096332
47096272
47096313
47096289
47096326
47096251
47096354
47096192
47096277
47096296
47096293
47096284
47096262
47096319
47096357
47096356
47096206
47096287
47096350
47096199
47096179
47096336
47096311
47096341
47096345
47096362
47096186
47096175
47096235
47096242
47096351
43320152
39538330
39537882
44770991
40044719
17273093
49269756
49269746
49269758
49269710
49269738
25521668
24699696
26523144
45431024
31428492
46835636
19264699
39537887
39537925
39537535
39537884
44825756
40049556
40046018
40054462
40046022
40049567
40073235
39868700
40073211
40073236
40073216
40054448
40046052
40054575
38906366
39017594
39017405
38909602
38906364
39017703
38908100
39017671
38908054
38906296
39017759
46377592
46376368
46376545
46378781
46375669
46378480
46376047
46378748
46376551
46378478
46376541
46376564
46375832
46385549
47828365
47825236
47827031
39024286
18911712
46378751
46377948
46376524
46378596
46377750
46377475
38071351
35527736
47358933
18061647
11290317
11741179
47348337
47138361
47364250
48150227
29953661
47666308
47666293
47666147
47666211
47666200
47666187
47666403
47666150
47666201
47666184
47666109
47896513
47896634
47896527
47896537
47896476
47896526
47896472
47896473
47896437
47896618
47896510
47666915
47666907
47666841
47666688
47666889
47666842
47666736
47897401
47897191
47897004
47897126
47897282
47897125
47897070
47897199
47897363
47897315
47897400
47897173
47896989
47667078
47667115
47667117
47667047
47766808
44290704
40041419
35272913
47766462
47766824
24410079
47766930
47766401
47766767
24410076
47766762
24410085
24410062
47766452
47766456
24410056
24410070
47766686
24410011
24410005
24410018
24410161
24410151
24410036
24410043
47766716
24410111
24410074
24410072
24410063
24410152
24410097
24410115
24410140
24410038
24410025
24410071
47766921
24410165
47766789
24410096
47767286
47767323
47767254
47767255
47767283
47767293
47767320
47767242
47767335
47767239
47767294
47767310
47767230
39018539
46385486
46377569
37508570
23026321
42742884
45279219
13699971
46682160
46681822
38907854
49195956
25918544
25937550
25917308
25780850
29051182
45913963
45209351
42260178
47666333
47896659
45004658
45380500
42966623
44563983
1117260
41631
44508984
23941440
46385501
42966657
42966632
42966634
42966636
42966622
42966624
42966626
42966629
40871077
40447024
46377471
46377013
46378170
46376346
46378836
46376550
46377021
46376355
46376647
46376511
46378639
46376098
46377518
46377533
46377005
46377015
46378515
46378185
46378657
46375816
46378504
46378168
37549224
22108975
22108951
13699503
39017413
49269743
49264489
49269748
38398686
38398611
45378870
40046882
38702998
46378513
46377950
46376460
26022054
45232823
45381994
45841942
41160091
45576872
44825384
45378177
49953808
22108955
21819439
34748149
45834104
38400551
44968930
49971181
40446993
40454906
40455099
40871076
40455545
40871078
40783517
40796830
40447025
31096922
40871079
48992857
32599764
32599802
32599881
32599862
32599874
32600124
32600126
32599829
32599869
32599812
32599806
23823512
23823495
40454931
40454930
40871073
48451343
49364488
43770843
43770845
47667053
45392754
36635138
36635101
36635041
37252711
37252719
37252717
37252704
37332401
38908564
50145520
39018514
50146208
50146206
39537811
50151541
41053513
50172294
50172292
43440704
43440239
43440702
25065549
45575464
45935431
45944268
45970395
45996545
44846029
44846003
44846052
44846276
44846280
44846012
44845993
44846031
44846008
44846005
44846002
44846022
44846278
44846036
44846006
44846028
44846024
44846049
44846015
44846016
44846047
44846014
44846000
44846050
44846054
44846275
44846004
44846023
44846001
44845999
44846025
41328267
41328277
41328274
41328262
28900450
46801968
46801877
46801945
46801946
46801996
46801850
46801984
46801827
46801982
46801839
46801952
46801884
46801974
46801838
46801947
46801985
46801964
46801879
46801865
46801837
46801857
46801995
46801938
46801978
46801967
46801960
46801859
46801943
46801979
46801835
46801980
46801971
46638014
46801973
46801881
46801983
46801997
46801841
46801990
46801963
46801981
46801944
46801958
46801977
46801856
46801939
46801842
46801846
46801834
46801962
46801948
46801831
46801975
46801988
46801987
46801860
46801970
46801852
46801847
46801989
46801844
46801937
46801986
46801953
46801875
46801942
46801876
46801828
46801949
46801886
46801853
46801840
46801858
46801878
46801969
46801848
46801976
46801991
46801833
46801993
46801972
46801832
46801957
46801845
46801966
46801843
46801854
46801871
46801869
46801849
46801992
46801836
46801885
46801872
46801965
46801851
46801955
46801862
46801959
46801855
46801830
46801882
46801867
46801829
46801880
46801861
48252529
48253918
48534886
48252528
48534894
48534892
48534889
48534890
48534896
48534888
48534887
41387957
41387852
45881905
45881894
45881895
46973090
48027527
49051603
49259965
46954543
47909845
48793890
46970147
47918699
47233723
48671929
46982804
47926300
49040662
48740074
49222897
48779951
48892468
46977569
48904631
48162078
46970526
49515054
47823006
48696337
47103246
47987325
46980696
46978755
46975785
48176085
49487128
46799697
46799663
46799670
46799662
46799647
46799664
46799721
46799713
46799714
46799667
46799722
46799674
46799675
46799659
46799672
46799678
46799648
46799720
46799646
46799691
46799652
46799653
46799671
46799709
46799645
46799658
46799668
46799715
46799696
46799669
46799651
46799726
46799718
46799717
46799660
46799711
46799689
46799644
46799642
46799654
46799688
46799673
46799725
46799677
46799661
46799681
46799665
46799656
46799657
46799676
46799685
46799680
46799650
46799649
46855729
47349458
47389091
47349528
45500487
46376223
48033654
48032588
48033990
45146892
50226521
50226522
50226527
50226561
50226529
50226560
50226524
50226528
50226563
50226526
50226558
45580150
47896653
47666327
47674219
48362225
48362341
49054054
46093519
46093508
46093499
46093514
46093501
46093512
46093504
44977981
50316414
50232379
50225464
50369085
39354870
48149030
9143839
9406480
9406794
9406715
9410054
9406679
9406438
9406469
9406692
9406453
34669863
46377429
46376108
46378648
47500117
47673155
49831762
49587303
49603473
49658196
49642668
40871124
47412840
48487075
45571062
45571061
21526315
21646362
21825112
21523721
21642080
21645071
21964244
21825276
21963686
28507647
22012327
47389038
40046032
38199030
38198869
38198896
38356548
38198817
38356586
38198755
45004870
32295608
38112432
48489683
48480979
28887950
31332779
32860795
39364516
43944948
43944911
45314191
24600509
33718415
42385890
47668391
43021766
50466958
38909667
35272910
50472044
50464331
49981754
50096284
46379012
44776456
44776455
13451744
13451734
13451749
13451746
39139939
43866861
29134216
46681833
26021644
22970020
22970665
38909604
46378864
26137742
44639152
48671917
41432043
47389034
45742577
48241980
44953527
45827553
44960618
45232192
45378175
45840719
44968928
48240622
45384644
44779473
13692613
38909376
39018523
39018526
38909498
38909526
45812506
39532841
39248861
45384645
48242846
48471549
43866912
43866789
43866856
43866741
43866780
43866850
43866749
43866764
43866891
43866875
43866750
43866876
43866821
43866765
43866845
43866881
43866879
43866791
43866756
43866793
43866854
43866779
43866907
43866882
43866895
43866813
43866739
43866797
43866740
43866901
43866866
43866905
43866852
43866847
43866888
43866843
43866786
43866811
43866766
43866751
43866761
43866799
43866748
43866752
43866837
43866892
43866800
43866759
43866760
43866763
43866848
43866923
43866865
43866874
43866889
43866816
43866747
43866815
43866792
43866762
43866871
43866868
43866817
43866853
39538011
39537610
43959962
44563903
46375801
46375805
46377942
46376552
46378506
46377935
46378303
46375663
46257481
38398081
40756637
46375668
46377964
46377406
46378146
46377513
46378551
46376352
46377408
46378979
46376381
46377965
46375839
46378270
46377799
46377006
46376532
46377024
46375821
46378149
44563973
9291188
8092819
43432636
50588352
43876307
43432965
43432335
43432783
43432916
46376458
46376250
46377956
46378164
41799929
46572863
45007377
46814982
37511575
41882290
37332392
40044426
40049172
39017785
39017700
38908917
39017902
39018522
30870425
43318807
29368843
45578986
17657606
21237951
50665812
50665817
447083
50665771
50689217
50665810
50665806
50665769
50665800
50689196
50665811
50689239
50665788
50665809
50689174
50665782
50665773
50689255
50727759
50727706
50727720
50727713
50727728
36139140
36140726
40951105
40670088
48794689
44980826
50759266
44974787
40705445
44825421
41317880
49647199
49844475
48241978
45240596
45436900
45381062
45218304
37404705
37545492
37545491
37545553
37545462
37405125
38849919
41639750
38375645
38375537
38375075
38375344
38376958
38376301
38377257
38376310
37269211
37269290
37269501
37405998
37269773
37271266
37271293
38378511
38378613
38378635
38378595
38378446
37281153
37280409
37281050
38378680
38380714
38379412
38708639
38379385
38708633
38378692
45374876
48454710
38708694
38709056
38709097
38709028
38708932
38709089
38709035
45112008
43469616
38709181
38709250
38709255
38709321
38709235
47011932
47011928
37323284
37324410
35949473
35949392
35949408
35949395
35949393
35949410
35949409
35949396
35949386
35949370
35949382
35949404
35949422
35949390
35949374
35949407
35949380
35949398
35949379
35949376
35949394
35949405
35949383
35949411
35949397
35949406
35949389
35949385
35949375
47186403
45381531
50480314
11491946
11491902
11491913
11491936
46377517
39532773
45380468
46375653
46378759
46378659
46378485
46378469
46385325
46377562
46376254
46378481
46375656
46375667
46378833
46377572
46375837
46376691
46376008
46377957
46376231
43277651
38708831
44563981
46375814
46376519
46378584
46375822
19123764
38709285
46378775
46376354
46376020
46378598
46376349
46377009
26021621
43320111
40047923
38908839
38908844
39017755
38908110
38908093
49269711
41882298
39868706
42845976
50860130
38376245
46855621
40770147
41044695
41047694
41805507
41805582
22232023
41800143
44910256
39364680
29392102
38400550
47674301
47674370
47667438
47667506
47494255
47500289
47666692
47667402
47667358
47667434
47667404
47668754
47667511
47673338
47897085
47674361
47674296
47674217
47674392
47674262
47674264
29479447
29479408
29479458
29479747
44932125
43409549
50672176
50672156
48115649
45050252
30041771
30041794
47168561
46378561
46378163
46375802
46376469
20956803
45742608
40455579
40756625
40446991
40447016
46377574
30748886
37252724
46378753
46378640
46376100
46376471
46377560
46376538
40454933
45326484
43432982
43432813
45841015
49985729
39647252
16369021
16369033
16369032
16369023
16369022
16369019
16369037
16369017
16369038
16369016
19123765
19123767
19123587
19123773
19123584
19123588
19123626
19123771
2073170
21951642
24410141
25805792
2600144
27049146
27090602
31079039
31074308
31072415
32448906
32885951
31040341
31640062
31488459
31640032
32089876
45381997
31907341
31907343
31907369
31907344
31907366
31907363
31641032
34523671
34732816
35144514
35144594
35144477
35144601
35144611
35144632
35144418
35144439
35144801
35144782
35144789
35267951
35268349
35268420
35268380
35268488
35268450
35575809
35575812
35949250
35949249
36315590
37332400
38375004
38399958
38544910
38544911
38500182
38908556
38909297
39364495
39386914
39386889
39537735
40185196
40185277
40185178
40185224
40185186
40185200
40185232
40185245
40185246
40185238
40185177
40185205
40185235
40185234
40185325
40185274
40185203
40185318
40185295
40185181
40185265
40185183
40185312
40185286
40185339
40185314
40185189
40185244
40185237
40185184
40185321
40185215
40185225
40185219
40185192
40185176
40185209
40185227
40495373
41041223
41041143
41041135
41041233
41041076
41041152
41041130
41041064
41041205
41040934
41040937
41041229
41041030
41041074
41041092
41041068
41041002
41041046
41041201
41041012
41040983
41041163
41041193
41041242
41040947
41040949
41041007
41041231
41041024
41041105
41041045
41041158
41041188
41041185
41041179
41041244
41041191
41040990
41041198
41041227
41040979
41040948
41041146
41041026
41040964
41041020
41041164
41040941
41041015
41041019
41041084
41041077
41040925
41041041
41041171
41040930
41041214
41041173
41041222
41041220
41041086
41040954
41041150
41040977
41041172
41041080
41040989
41041237
41040957
41041162
41041106
41041121
41041203
41041072
41041111
41041170
41041240
41040936
41041093
41041148
41041014
41041044
41040975
41040927
41041157
41041225
41041175
41041154
41041183
41041207
41041063
41041133
41041047
41041196
41041169
41041035
41041083
41041037
41041213
41041079
41041107
41041098
41040951
41041155
41041070
41040959
41041186
41041145
41041043
41041113
41041004
41041167
41041103
41041097
41040986
41040950
41041050
41040922
41041071
41041119
41040974
41040956
41041182
41040955
41041017
41041235
41040926
41040943
41040962
41041211
41040987
41041082
41041018
41041195
41041027
41040970
41041009
41040939
41040997
41041128
41041230
41041051
41041190
41040981
41041000
41041100
41041096
41041161
41041115
41041066
41041141
41041090
41041114
41040969
41041085
41041078
41041181
41041099
41041180
41040992
41041058
41040960
41041102
41041056
41041054
41041126
41041239
41041160
41041061
41041189
41040971
41232291
42378692
42521521
42518833
42525206
42399834
50585321
50585337
50585309
50585367
50585358
43770828
50585323
50585306
50585370
50589430
50589409
50589383
50589422
44290086
44693725
44776705
44846041
50585288
44445299
45220057
50536163
44877388
45372245
46082838
46082900
45345114
45345102
45345097
45345105
45345118
45345103
45345108
45345109
45345092
45345110
45345121
45345116
45345089
45345104
45345093
45345112
45345090
45345111
45345099
45345106
46835763
47038342
47767312
47766726
47767334
47766835
48523853
48523882
46835641
46799160
46851635
46855591
46855590
47349447
46851543
47389096
47349526
47354552
51337057
13256358
16884557
16670563
16442677
16443165
10954865
4088517
4088550
41805647
41800299
41708912
41708829
41708818
41708838
41708903
41708841
41708913
41708911
41708899
44465347
41708807
41708820
41708830
41708819
41708825
41708815
41708816
41708910
41708817
41708906
28797780
41711476
7380541
7380543
7380538
7380537
7598128
1663633
22109663
22109604
22109686
31187876
31187883
22110289
22110060
31187878
42749086
22108968
45765989
48471551
46976738
51178937
44825831
46375795
51375361
28660461
32765539
43409548
8697475
8697472
8760921
12096210
10874846
8697468
46229907
46229920
46229858
46229947
22109074
44825088
44825242
38720084
45305081
43432637
50231872
50231885
50320106
21526608
41800202
41800330
44826049
45381066
45219933
47359662
48348640
34911572
42518248
45006003
45005081
45004653
45005256
45004787
45005330
47622639
47304685
46210398
16178448
16178447
45376567
42251336
45006021
45534417
34911607
37252690
37252714
45882041
45881884
45882019
45882017
45881904
45882042
45882040
45881885
45882031
45882038
45881886
45882029
45881909
45882047
45882028
45881876
45882033
45882036
45881903
45881877
45882030
46093503
46093520
45219900
48357299
25792220
47667362
20369212
20367258
20369811
48026994
29134399
45221013
42254220
50924840
50924836
49426725
49428179
49428343
49428345
49428232
37252707
46376341
46376528
51561721
44823665
43440065
43432814
44060116
44019460
50231903
50233698
50232898
50231899
51599471
45675411
45382307
16406485
45006047
44770216
45220010
30046513
43279427
34911580
46571557
37252715
37252721
37252708
37252700
11613922
50672177
50672149
50672115
50672154
50672188
50672062
50672218
50672248
50672140
50672200
50672250
50672210
50672202
50672186
50672232
50672090
50672162
45628110
50531931
50531884
50536145
50534391
50536136
50585790
50585308
50585997
50588244
50588246
50582690
50588862
50665822
50664104
50667001
50608574
46490679
51662269
49681621
49682445
16141295
47354565
47354576
44769830
45215723
51743593
51743598
51743441
51743816
51743601
45006035
46823324
23077486
48301634
24933732
46851615
45314186
51524686
51846574
51846499
51774848
51772814
34869624
38198700
38357755
6470001
38709067
38380713
39365471
38906328
50609267
50531887
50585789
50586024
39017419
38906436
38399994
37544753
37545224
37544327
37544592
37545327
37545250
37544630
37544954
37545391
37544625
29953698
50583146
13700396
29121358
39364508
41789575
50636904
50997503
38909701
38906411
44825138
38397321
45500039
47401546
2267997
2267998
2267995
38500912
36905866
36905922
36906360
37111859
36907508
37111905
36906811
37112310
29689260
38908071
38906421
38908099
46855606
37332465
39018565
47164666
23077927
13088531
17657645
17730644
25177631
25271219
39537484
23077660
47666547
47896866
47667336
51951683
35417789
35114238
16022827
38199189
47400131
37416645
51846517
50430130
47033209
45562343
45562307
48535701
48535697
48535698
48535699
48544755
45564122
45564107
45564095
45564104
45564114
34865619
48477812
48483206
48477824
48489664
48480943
48489649
34602223
29978182
52163213
50429972
50430087
50430025
50429949
50429940
50429938
50839494
50839647
51184970
39364473
39018761
39139842
29479549
21954942
29978081
26155048
45380414
45215746
39018484
37545081
37405543
6590882
38398163
28952527
47198787
47198798
50227858
50227849
50227937
50227865
50227938
50227935
50227851
50227860
50227856
50227869
50227936
50227884
50227863
50227866
50227921
50227896
50227853
50227940
50227872
50227942
50227941
50227923
50227934
50227874
50227907
37113023
37112624
46851613
47352904
47349417
50227734
50227725
50227721
50227815
50227779
50227827
50227767
50227838
50227717
50227784
50227755
50227772
50227763
50227776
50227738
42200079
42199698
42199720
42199799
42199818
42200086
42200073
42199686
42199757
42199814
42199739
42199777
42199780
42199760
42199657
42199786
42199821
39533130
37332493
46448141
21956689
33685894
47896681
39469543
48794690
38506562
48034016
52325920
34865878
34864596
7428141
44563975
44563902
23944794
39868170
39537591
47355870
45004385
50430004
50429885
50429852
50429848
50429990
44974785
52456302
47493844
47499698
47499988
47668369
47668464
47668770
44989943
25662287
35527738
50838618
50838682
50839358
50839310
50839357
39537836
50839515
50839505
50839481
50839544
50839530
31278203
37722300
37723160
37544514
37544362
47667971
28109060
51296462
51296453
45378653
13699455
49112600
47907437
42199755
42199676
42199766
42199730
42199801
42199650
42199683
42199827
42199759
47142063
46696126
43581689
42199684
43255566
30130471
33685781
10613965
29414433
51343428
51343400
52208730
52565848
52566992
52566965
51039538
39537688
39537880
39537915
39537905
52641483
52641474
48115644
38398651
38398618
29953612
37332396
37252695
37252693
37252702
39365441
39532819
38908628
23944766
37976496
7428290
38464420
44823488
38398072
47304687
44770449
46799155
40508946
51420690
51512440
38908507
38908637
50579391
49437786
39365518
35528036
35526360
35528437
35528438
46377958
51421927
39017407
40973904
51422324
52031132
52031138
38342082
34941745
37332466
38908145
37332621
44697257
44697166
44697399
44697417
44697245
44697195
44697271
44697146
44697233
44697143
44994458
44994419
44994596
44994590
44994593
44994591
44994592
44994401
44994427
44994641
44994454
44994587
44994595
44994594
44994589
45215543
45813608
47304689
51375626
52231086
49037465
49037466
49037448
49037467
49037441
49037457
49037450
51904888
44203836
47401580
52315752
52296501
52284504
52312206
52297156
52290554
52297048
52318982
52285225
52305702
52290894
52294615
52297091
52309053
52295256
52394445
52390287
52313837
22108995
43258847
49510630
43258857
52201428
43258849
43258860
51434431
43258850
43258858
26524992
25734453
26029647
38400862
47896902
52319031
25167414
25930463
52442828
52435016
34865702
45221548
52816648
52816636
52816692
52816685
52816695
52816719
52816731
52816755
52816728
52816746
52816722
52816749
52816772
52816818
52816798
52816796
52816829
52816843
52816821
52816789
52816788
52816836
52816837
52816896
52816881
52816878
52816865
52816897
52816893
52816887
52816857
52816872
52816855
52816899
52816929
52816947
52816914
52816931
52816965
52816951
52816902
52816968
52816912
52816956
41193440
52294376
52285449
29361608
52284432
52293240
52290994
44938209
50730004
52289422
52290989
52674978
52674972
52672911
52318992
52691800
52701142
52699570
52746713
52771249
52758033
50985339
27070523
27706827
37416860
45042802
46799694
49427110
49395325
49426667
49426666
49426393
49426918
49427112
49426150
49426386
49426832
49426668
49653017
49652421
49652418
49652407
50838724
50839305
51775672
51751978
51877761
52668640
44493175
39537948
52547623
52701132
52701129
33089592
52776140
47156422
47156436
47156465
47156480
47156487
47156523
47156473
47385864
44932127
38176982
47184814
51862621
39980748
52425731
45381855
46999953
52284337
52287596
52295810
52291830
52291552
52285092
52284718
52287195
52287341
46302393
25964622
52284981
52284888
52290619
52285933
52288438
52295340
52284403
52290026
52285880
52287268
52295726
52286555
52294558
52284123
49426669
52297879
52442797
52434998
52426069
52681495
52745990
52745986
47907465
35272917
46687908
52839139
50999981
40906265
52852698
52991780
52993645
52991781
52992755
52994378
52994377
52994480
52758056
52746695
52746724
45442999
52758058
52758024
52745366
16369114
16369116
52900889
52551579
52701121
52699588
52701122
52764489
52701128
52031144
47379389
52780277
23823437
47184819
50231905
50231901
50231874
50231876
52285173
52289650
52285714
52283799
52284409
52289504
52289332
52283701
52284479
52288692
52284975
48249921
52289568
52296869
52289458
52290434
52291637
44977983
48137061
44989945
35526353
35526953
35528107
47033214
52555469
52678669
52844166
45255363
52856121
52856124
32378179
32378165
32378164
32378181
52852699
47494921
47896500
52856248
37544744
37545726
39277342
45730781
45730777
45730779
45730768
45730788
45730783
45730765
45730790
45730791
45730770
45730786
45730764
45730810
45730807
45730806
47255376
45730808
45730802
45730822
45730805
45730798
53276657
53276716
53276675
53276717
53276694
53276616
53276634
53276666
53276626
53276685
53276680
53276710
53276645
53276678
53276740
53276659
53276714
53276711
53276636
53276692
53276663
53276738
53276713
53276643
53276660
53276644
46851553
50680224
53276042
53276043
51996087
53254430
53254207
53254364
53254359
53254415
53254517
53254679
53254483
52569305
52575900
52701136
52562062
52551562
52701127
52701134
52681542
53364374
43945006
53385280
38503134
52401400
47666094
53289186
25534093
41987773
50227731
50227806
37332715
38011709
38342173
38282762
50636793
35528084
35528106
35528077
53433935
53433963
53433958
47414910
48249917
47197546
53442009
44770462
45218182
45006548
45006534
45006545
35417852
38008569
35417956
35417920
35417858
35417859
35417874
35417819
35417839
35417914
35417775
53475374
53475539
53476677
53480064
53492970
53492855
53493091
53492773
49428176
39866975
50636790
50636792
50636786
52318389
52311346
52428902
52428894
52428880
52428901
52566353
53612173
46851554
47672004
44290099
44290093
47666735
52493846
50507654
32211608
38463585
53289157
51154495
53644898
52030743
52030740
52030734
22753140
25715255
25715261
35528487
52285903
52284928
52315554
52299185
53428644
53503695
47499165
53681746
53681759
53681770
53681768
50588349
44769520
48515604
50398428
43432689
43432717
50586961
50583633
50585133
53892980
53919296
38072735
32345511
47400129
53968533
53968597
37252689
37252725
47304682
52310901
52301203
52302694
52311000
52318734
52298584
52284971
47500259
47673317
52313532
53455084
53613518
53674280
53391989
54032308
39664670
54093256
54090061
54093474
53720650
53720590
53721350
53720593
53720607
53720602
53720646
53720491
47667970
34865892
53668365
4599076
51553909
49407153
39364998
39365023
32717245
32717254
32717244
32717247
32717253
32717249
32717251
32717252
32717246
32717243
54211850
54213151
54216555
54222706
54224641
54226488
54227947
53753781
53990184
53990237
53990239
53990191
53990238
53990241
53990245
53990197
53990203
53995297
45006046
35874940
36887030
53990248
53990243
53990180
53990244
53990252
53990250
53990181
53990201
53990242
53990246
54024076
54024131
51664319
51555412
54300078
53972211
51553886
51554758
19123762
51555345
34865484
34866060
46385526
34669895
49137164
54132759
54138654
54132741
54138669
54132964
54138694
54132974
51420712
52292087
52315587
22047626
45369210
54132748
1117390
20094735
1766345
24102151
24717990
24717997
25647146
25647156
28583656
28858408
28858384
28855741
28948656
28854110
28948820
28942156
34865796
36712674
36905892
54377853
38398610
38499782
38398637
38398603
38398652
38500885
38499808
38399970
38499998
38398588
38500889
39224185
40389712
4088433
41626
41708875
41708874
41710846
43469612
38909522
38398602
43944408
39532985
39532817
53753764
46038682
46895406
45872583
45872576
45872558
45958239
54402279
45004104
47766982
48585147
48599677
49094178
49547046
49171535
49652780
49652257
49652762
49393423
51258777
51258778
4741176
12134496
52209073
51888682
51888681
52569190
54434089
54434593
53167720
53182640
53155798
53155816
53239741
53366653
53469920
53674277
32863902
54271141
53753761
53753760
53753723
53753727
51553974
48253241
38400029
52436305
52768703
54132662
54138692
35575756
35528459
52306613
52314423
52311125
52311112
44026045
44036081
44026088
44026355
43939652
43939651
44026353
43939712
44365538
44365528
44365542
44365537
44365536
44365535
9815349
51420913
44321556
53244413
26350269
52313735
52313331
52313650
52313321
52313328
52313741
52313391
52313360
52313260
52313567
52313541
52313549
52313409
52313467
52313561
52313380
52313396
52313496
52313692
52313681
52313640
52313718
52313388
52313507
52313481
52313239
52313344
52313511
52313304
48599679
48599680
52277269
52745527
43021734
43021689
43021700
51554910
51553891
54024132
49951171
49951225
49951196
53766845
49951178
48516870
48516867
54155512
54156163
54680564
47668752
47494253
52077902
52061490
54278796
54467249
54467375
54467100
54467076
54467082
54467228
47096286
47096334
47096330
47096308
47096318
47096306
47096231
47096263
47096220
47096257
47096274
47096239
38464375
53182625
53182633
53182635
28109066
26031169
26031427
26605157
52296414
52315282
52300154
34941854
33361704
33361705
33361703
37739293
37724052
37720550
37724196
29507889
38500275
32378158
44771536
53662148
31491118
54745976
43878993
35115831
43021656
43021881
53753736
53753754
53753780
53753782
53753752
54514140
54514138
54514125
54514116
54514130
53046821
54804872
47666105
53720470
54278421
54831599
46490657
52229749
54748680
54748568
54748910
54745846
54426209
46384918
54530842
54531589
54531602
54531600
54531594
54536572
44770403
44770424
54864841
54864843
45006050
45006911
54689260
54752746
54752752
54752714
54752762
54821320
26272820
26272818
52148715
46843349
54277943
54278083
54278055
54278702
54278116
54278057
33120885
33301542
37723726
37722249
36906285
38072770
38469213
46937514
54274231
54132630
54223121
54990361
54991172
38198796
32529486
43021548
43021869
43021491
53469923
53469943
53586845
53469922
53469924
53469921
53532735
53753755
38470223
38908151
38198728
38475917
54758756
38198705
51554018
53487032
46385053
54795673
54795671
54752751
54752767
54752773
54752741
54752759
54752748
54752744
54752735
54752780
54752724
54752766
54752711
54752710
38908666
38397203
38906406
35575766
35526333
54888402
54888440
54888425
54956639
38398619
53182627
53182624
52297742
52294278
37544970
33718751
52148748
52148738
39364655
50499860
50499885
50499880
50499867
50499882
50499881
50499883
50499868
50499863
50499895
50499862
50499897
50499893
50499878
50499871
50499875
54817555
32497783
43021887
54816373
54816358
54816371
54816372
54816343
54887956
54888441
54888455
54888380
54888436
54888444
54888435
54888460
54888417
54888407
54888457
54888459
54888420
54888411
54888408
54888406
54888404
48516529
47767260
35526947
34776079
40952133
55263849
38072987
53182629
53182639
47169278
52306142
52289355
55089012
55089015
55088989
55089018
21526586
43554522
44025804
39010927
45564089
45564098
45564094
45571055
45564091
38378534
47352832
47354613
42832341
42201307
42201320
41639775
55092014
55092002
55091957
55091863
55091845
55091890
55091881
55091879
55091961
55091843
55091925
55091996
55091939
55091989
55091950
55092020
55091947
55092019
55091882
55091999
55092012
55092010
55091954
55091990
55091888
55091817
55091931
55091960
55091915
55091872
55091935
55091912
55091984
55091916
55092023
55091969
55091894
55091876
55091911
55091991
55091963
55092005
55091972
55091975
55091976
55091917
55091895
55092013
55091945
55091998
55091855
55091921
55092004
55091862
55091850
55091940
55092056
55092028
55092045
55092062
55092053
55092077
55092073
55092064
55092093
55092041
55092026
55092089
55092034
55092066
55092083
55092054
55092084
55092042
55092071
55092086
55092080
55092039
55092046
55092069
55092090
55182139
55182048
55090587
47896433
54698934
55261138
55261183
55261193
55261375
55261196
55261236
55261278
55262174
55262120
55261881
55261925
55261914
55261861
55262014
55262164
55261949
55262073
55261917
55262111
55262155
55262176
55261875
55261850
55262114
55261962
55261915
55262110
55262075
55262070
55262293
55262278
47188944
54590694
54590710
54590649
54590646
54203764
54203960
54268856
54695309
55088986
55088987
55088929
55088990
55089029
55089001
43021462
27001174
54964258
39873093
55396803
53487023
54956526
54956532
54956545
54956627
54956625
46099140
52298487
52288613
55271839
35528033
55433699
52923314
52915953
54278422
55177845
55177865
55177887
55291496
55291534
55291500
55291529
55291671
55291533
55291595
55291771
55291567
55291555
55291554
55291602
55291537
55291557
55298088
55298093
55298095
55298179
55298096
55298178
55284545
55284544
55284500
55284522
55284542
55371478
55371487
55371498
38708708
38709127
14664813
18200958
17040257
22374016
23823421
16153385
25333267
55284477
55284538
55284527
55284517
55284516
55284532
55284534
55284537
37549571
40044398
39983418
41036629
40241641
40241629
40241627
41700315
41700319
41700323
41700321
42378598
43021911
43021531
43021848
43021815
43021598
43021895
43021731
43021896
43021836
43021537
43736084
44431235
44563961
46257494
47000042
46999924
47193542
55457982
48451313
48451315
48451311
49313991
49308667
49102245
49215667
49324119
49290891
49403498
50721201
50636823
50636812
50636856
50636853
51442865
51442874
51442864
51442875
52031175
51512363
52031157
52031165
51554547
51555418
53239746
53447548
53447539
53262878
53276690
53276670
53276682
53276630
53747175
54138678
54138674
53747138
54138675
54132874
54132957
53747114
54133136
53747110
54133015
54133041
53747173
53747133
54093730
54325833
54349181
54326579
54501297
54501295
54501377
54501299
54501370
54501369
54501298
54501375
54501291
54501368
54501376
54501296
54531572
54531640
54531634
54531638
54531586
54531571
54531645
54531642
54531570
54590712
54590772
54590655
54590806
5954125
6101508
5954183
37545075
55300169
54207884
26860954
54211311
54211373
54211464
54211802
54356614
54356547
54281673
54281695
54351926
55291501
55291553
55291772
55291814
55291530
55291498
55291815
55291536
55291568
55080524
54457831
54132773
55352025
55371472
55371479
55371476
54956588
55371497
55361436
55352024
55371469
54956646
55371486
55371484
55371493
55371500
55371463
55361441
55371496
55371483
55371473
55371468
55371470
55371491
55352020
55371475
55361440
55371466
55371494
55371481
55371502
55371488
55298168
55298172
55298180
55298092
55298167
55298091
55298169
55298173
39458055
39458060
41800285
44026087
46385031
27001462
38908103
54752733
54752732
54752734
34790032
52298192
54994731
55426185
45380930
55457961
55457980
47383887
45507195
39277340
47400146
47389052
38708975
55284521
55284529
55284505
55284520
55284539
55284523
37544733
52229756
52229759
37544527
47362151
47332233
34713043
55468699
46398421
55177864
55177867
55177877
35863155
55457981
55457967
55457974
55457979
55457990
55457986
55457964
55457962
55457969
55457977
55457966
55457987
39010925
54922111
44825478
55559184
55558989
55559081
55559191
55558288
55575913
55560002
55585325
47358810
44989930
47275162
52360916
46976692
38500315
38708979
30413060
29689344
49986097
47400112
36026832
55622689
47389081
37545292
37544899
37545165
37545356
37544367
47896803
47666484
37544876
37544730
47357943
47332512
53447540
55705842
55705800
55704845
55705885
55705829
55704804
55705808
55704846
55705905
55705875
55705807
55705951
55705828
55705918
55705821
55704843
55705903
55705904
55706916
55706906
55706881
55706964
55706862
55749304
55750624
55750618
55750287
55548360
55749341
55749327
55749429
47332513
45466044
47360001
44989940
47366533
48787786
47400124
52923315
52923341
52942007
53026705
52318421
47185716
41805817
54779894
54779905
54779893
54779910
54779895
54779914
54779909
54779913
55855980
55856166
55853983
55853999
55854058
55854002
37545205
55860223
55860258
55860208
55860170
55860246
52758042
52942004
52758044
52758043
55890793
38377165
37544907
37544296
44770433
44770434
47673020
34861612
33038894
44564009
44564002
44563955
44563998
51554493
54864569
53665725
35275138
48618729
25139718
25139671
25139055
25139065
28703186
28008900
55699913
56087960
52317293
55426592
55750030
55889681
55750024
55889619
55889576
20720640
55889580
42512993
37281227
37283327
37269333
38380712
29953547
55844918
50636789
45562306
45564105
45564078
45564082
45571054
55889613
55750183
55750173
55750191
55750196
55750160
55750050
55750008
55750148
55750180
55750019
55750113
55750013
55750177
55750011
55750035
55750009
55750016
55750038
55750157
55889629
55750119
55750045
55750021
55750007
55750185
55750018
55750168
55889695
55889677
55889674
55889693
55889685
55890778
55890773
55890743
55890741
55889670
55890781
55890783
55890775
55889683
55889694
55889691
55889688
55889657
55889697
55890782
55889673
52374120
56130871
56203140
56203143
54971222
53364997
34747600
44290095
56231344
56196665
44823467
45635649
54501371
54501367
54133003
35528037
35526350
53278866
53312557
53312559
53312586
53312558
53312607
56030308
56029565
56029886
56030289
56029548
56029626
56029552
56029620
56030401
56029580
56029550
56029554
56031134
56031129
56031136
56031414
56031120
53487083
53487086
53487004
53486971
53487014
53312527
53312520
53312542
53312522
56165560
56031622
56031141
56031433
56029510
56030335
56031654
56029832
56031174
56029841
55294662
55294696
55294663
55294721
55294738
55294699
55294736
55294664
55294702
55294667
55294698
55294701
55294676
55294657
55294700
55294679
55294840
55294665
55294704
55294841
55294737
55294677
55299539
55299543
55299676
55299541
55299671
55299693
55299545
55299531
55299683
55299680
55299673
55299699
55299695
55299547
55295001
29288959
55346762
37544711
56236024
56131398
56131547
56131595
56131537
56131744
56131821
56131732
56131727
56131829
56131711
56131733
56131738
56030617
56030635
56029630
56031659
56031146
56030612
56031675
56030293
56030879
56031384
55659190
55652122
52982654
52982690
37269226
53312502
53312563
53312503
53312513
53312505
53312616
55291600
53312597
53312587
53312517
53312508
53312580
53312624
53312605
53312581
53312596
37545589
53312519
53312570
53312509
53312536
55294839
53312531
53312523
53312588
53312613
53312546
53312512
53312501
53312529
52982692
53312565
53312511
53312619
53747136
54752742
56031169
56031388
56588910
56588951
56589156
56589136
56588972
56589102
56589027
56031409
31237486
43689107
56131513
56131743
56131472
56131517
56131797
56131808
56131583
56131400
56131511
56131401
56131514
56131445
56131673
56131636
56131641
56131635
56131714
56131634
56131728
54888384
54888390
54888388
54888389
27018956
27108756
56029904
56030653
36042968
32370137
38500304
38400427
42494727
56690107
56690116
56690159
52319037
53155808
54224435
55164083
55291816
55291511
55291531
55291532
55291510
55291509
55291502
55291552
55291556
55291769
55291770
55291569
55291499
55291606
55750111
54764387
56030959
56031123
56031656
56031124
56031657
56030960
56029533
56030422
56030158
56031623
56029682
56030877
56031125
56030279
56030876
9769625
50219106
50155452
55470086
50166664
50155446
50158473
55134807
55468348
55468501
50166683
50166668
55136904
50158478
50158468
55135424
50166674
50219107
55524877
55521707
55522894
55523927
55520842
55516767
55522805
55522807
55521863
55524246
55522810
55525060
55523914
55518726
55522514
55520452
55523920
55522633
55516771
56131510
56131578
47362147
56030651
35007349
47358690
55148498
38356523
48259843
21954941
56549754
56548881
56527377
56538573
56549753
56538575
56527292
56550424
56527268
56548888
56549761
56549756
56527290
56540633
56585099
56540631
56547534
56527263
56527293
56527287
56528920
56550429
56527269
56528921
56530701
56528923
56550427
56527463
56530702
56549750
56527466
56538574
56550432
56550428
56031867
56031402
56030623
56030625
48565517
56258060
47378365
47358809
47358813
45384205
35227140
48552665
47358323
47374129
47383324
47362149
34746366
35322647
45098133
36142179
47411670
47429724
47358811
36599681
35446995
47399928
48491658
54270137
55135915
54265910
54264834
54271102
36886538
56767711
56768724
56768723
56768837
56768845
56768872
56767709
56768873
56768874
56768871
37269519
54138647
54132782
49220144
47375914
35237317
56031172
56031698
56029835
56031469
56029826
56030652
56031117
56030890
56030856
56031653
56030160
56030412
56030655
56030100
56031625
48854561
47398736
56031177
56030318
39018519
38908152
54266850
54270612
56819633
56819705
47370587
56030159
25139708
26272897
34367502
52284513
54501397
54501396
54501403
54501401
54501399
55298198
55299718
55299715
55298200
55299717
55298196
55299716
55299719
55298195
56031427
56030140
56031901
56030670
56030685
56030126
56031446
56031425
56030128
56030943
56029926
56132840
56542260
56542265
56463033
56462873
56464747
56462904
35526347
35528453
41160087
35528079
35528016
35526944
35575751
49942297
35528478
35526364
35575784
35528513
35528484
35528091
44026076
35528474
35526951
47398731
47362152
48035957
16369113
18921532
23381908
23381364
56874988
56875755
29121175
23078003
23078392
25952096
49983455
54266848
35528464
35526351
39868707
35526355
35528007
35527833
35528434
35528447
35528103
54746328
54748835
54748763
35527824
35528076
38362292
35527830
35528490
38073654
35528493
35575754
35528020
35526348
35528013
35575763
35528489
35575753
38357727
44026081
35528038
35575790
35575785
35528099
44365533
38359759
35528101
35528073
35575752
38908019
35528023
35575786
35528100
44771772
44770463
35528011
34670240
35528433
35575750
35528098
37324621
44026046
22108969
35528032
35575765
48267047
45004681
45500359
44770306
47555269
45219724
56835647
56945297
56945296
35528439
35526354
35575758
35526346
35575798
38198599
35528488
35575799
35528451
35575767
35528012
35575764
35526334
35526941
35526338
35528429
43295791
56959421
56031204
56029828
56029929
46210073
54840485
54839956
44770405
44770453
44770401
44770390
35526949
35575788
35528463
35528467
35528094
35528491
45534119
38362262
46799064
35528466
56985565
56985566
35528443
35528465
35528031
56992517
56992500
56992523
56992522
38198635
56992534
56992630
56992799
48563990
39868169
45380528
47399927
56031175
44027397
45220964
45050257
42475552
54278098
54278097
35526942
54282438
37405216
21688895
45500623
45534122
47897068
47666766
45828487
46385032
46385042
52516102
56985562
57015315
55091982
55092027
55091924
55091934
55092037
47896509
26022837
26022429
26022393
26023684
26022356
44770415
56030115
56030920
40264338
41403231
41401976
41402163
48461530
52394385
52394426
50587219
35736748
48538366
57297499
57297501
55291538
55291535
56098144
56098125
56030415
52285127
52283764
52284972
52284907
52284802
52284125
52283868
52284537
52292735
52298325
52316236
52288742
52315542
52307821
52299448
52311068
52297175
52301200
52303063
52312693
52289779
52293831
52316502
52300212
52314364
52299910
52294848
52310034
52310329
52314257
52300265
52316396
52286203
52315629
52316298
52311157
52288377
52301597
52313276
52297573
52292248
52300997
52297337
52316244
52314473
52287659
52316360
52296533
52301792
52311202
52301189
52303987
52289247
52297259
52311178
52302464
52310088
52287239
52298689
52287215
52302564
52300454
52316144
52311187
52310605
52318831
52318688
52317463
52317403
52319156
52318670
52318775
56029920
56030676
56031874
56030673
56030102
56031870
56030156
56030952
56015388
55695259
55696104
55696098
55696100
55695147
55695149
55695155
41861761
40863662
57363511
57363310
56460283
47666183
55970783
37544578
37544161
37544949
37269785
26021148
26022316
26022782
57458993
57459603
57459609
57463037
52982715
40366792
57472139
57472140
57472141
37544596
38376251
57627492
57627486
56874033
34333639
57429099
57438449
57438450
57438451
57705668
44365532
57744242
57744158
54211396
54458340
45378630
54525054
54523568
54521761
54493156
54498936
8957708
57580137
57580126
57580485
57580479
57580549
57580120
57580469
57582027
57581996
57581045
57581055
57581051
57581150
57581991
57581982
57582283
57582031
57581987
57581161
57581155
57582001
57581145
57582022
57581501
57582247
57582633
57582591
57582629
57582632
57582631
57582593
45088696
57015316
57628036
57628003
57627983
57628002
57655701
57655881
57655792
57655964
57886780
54356164
54211603
55261197
55261785
54764370
57656763
57656770
57656768
47352868
46843600
53182611
57470271
57470252
57914964
57655709
57655800
57655888
57655971
57771072
57771078
57923680
45239580
55696102
55695152
57543420
55291512
35526359
57891705
57891701
32295167
38358231
57891743
57892380
57892389
57891742
57891740
56792949
56793034
43321578
32371862
57563060
40809798
55696114
55695171
55695168
55696112
42149422
39018500
38908861
48259331
35528496
35528452
52284584
37404323
57891749
57891711
57891741
57891744
57891725
57891723
58041767
57891717
58042295
58042303
58042637
58042736
58042868
58074615
58072474
58071322
58076025
41560265
56546585
58118735
55261792
55261802
55261857
34747547
58178527
35114204
58242165
58248533
58249242
52313564
58132251
47666583
58300951
58379912
58121710
58285490
58412580
43623043
57475789
57475817
46241647
58443568
58453076
58455472
58463086
58455627
58460579
58458920
58456908
58453685
52286293
52293160
55400420
55459403
57214532
55782114
55411767
56561317
55459577
56701770
56561310
55400426
55411774
56560482
55786971
52284055
52293309
52148746
58244675
45004655
55459669
55459684
55400799
57315671
32371861
44235588
44235597
44235623
56179547
38008457
58477295
58476926
58477157
58477242
58476719
58477384
58547091
58265090
58265164
58265133
58265128
58265103
58265174
55261938
55771873
55771776
55771749
58526706
58526696
58526685
58526716
56773986
46851637
58643959
58643955
58643958
58643954
58643929
58276073
58278681
58278651
58278761
58278179
58278181
58670343
58330828
58330993
58330753
58330630
58331055
58331029
58330625
58330953
58330541
58330735
58330955
58330701
58330632
58330966
58330816
58330699
58330796
58330730
58331045
58331057
58331005
58331094
58330742
58330606
58331097
58331065
58330925
58331026
58331028
58331088
58330976
58330751
58330948
58330941
58330808
58330633
58330822
58331173
58331022
58331134
58330642
58330743
58330852
58330952
58330995
58330890
58330985
58331000
58330788
58330997
58330900
58330899
58331038
58331181
58330613
58331479
58331511
58331440
58331364
58331518
58331507
58673009
58673002
58672962
58672979
58672972
58673008
58672989
58672973
58672966
58673014
58672990
58673004
58673001
58672984
58672985
58672998
58672978
58672994
58672981
58672975
58672988
58672961
58672965
58672951
58672996
58672999
58673005
58672956
58672968
58672959
58672969
58673010
58672955
58672991
58672995
58673015
58672982
58672960
58673016
58672977
58672997
58672993
58672952
58672957
58673012
58068020
58779448
58779444
58779449
58779447
58779445
58779443
58779446
58278071
58275918
58277768
58278103
58277697
58277748
58277823
58277883
58275961
58278177
58277923
58277783
58278074
58277852
58275896
58278077
58278068
58278109
58278110
58277867
58278111
58277920
58277827
58277897
58277680
58278078
58275901
58278133
58278184
58277807
58277803
58278065
58275957
58277876
58278066
58275999
58277794
58277777
58278088
58278668
58278617
58278669
58278792
58278645
58278671
58278699
58278666
58278660
58278634
58278771
58278684
58278777
58278664
58278646
58278696
58278644
58278794
58278611
58278661
58278630
58278629
58278639
58278702
58278793
58278678
58278786
58278618
58278711
58278782
58278790
58278627
58278616
58278717
58278655
58278774
58278635
58278652
58278640
58278692
58278665
58278624
58278781
58278599
58278654
58278648
58278653
58278689
58278662
58278766
58278788
58278705
58278637
58278672
58278626
58278656
58278694
58278632
58278762
58278643
58278638
58278659
58278765
58278795
58278791
58278787
58278687
58278641
58362832
38908652
38908727
51664699
57081661
33911842
58840259
58840225
58840270
58840258
58840220
58840275
58840184
58840267
58840271
58840230
58840268
58840223
58840269
58840240
58840266
58840164
58840239
58840229
58840219
58840167
58840236
58840237
58840260
58840227
58840226
58840221
58840217
58840272
58840224
58840188
58840238
58844597
58651906
58627317
58651936
58651928
58657823
58659107
58659105
58659098
58659104
58659103
58659102
57770164
52286888
38709308
58662456
38353785
58669134
58661066
58678015
58669179
22479619
57804390
57804501
57804461
57804441
57804224
41053789
55042228
58905133
58651192
58651219
54698820
54698811
57015442
57015327
57015431
57015427
57015300
57015540
54333226
58761912
11118271
11118704
11118270
58910775
58912211
58905589
58908317
58906935
58908521
58908591
58907282
58908889
42392717
58954141
58839007
41397842
58842106
52290173
58856388
58856392
58856252
58847329
58856262
58847328
58663030
58876592
58876593
57829522
57821535
58495578
58495587
58495550
58495605
58546138
58546090
58546051
58546097
58546065
58546155
58546092
58546039
58546160
58546154
58546144
58546102
58546127
58546165
58546040
58546084
58546034
58546106
58546080
58546156
58546119
58546028
58546069
58546017
58546045
58546032
58546148
58546058
58546085
58546132
58546067
58546135
58546122
58546029
58546161
53753784
51760261
38199074
58661096
59027376
59002215
58960526
58961989
58962143
58961514
58945123
58945125
58945041
58963971
37269303
59047267
59049189
59049529
59002475
59026503
59025162
59042419
59042425
59042392
59042377
59026565
59042400
59031340
59042394
59042411
59026538
54657091
58972917
58972879
58972916
58978682
52284568
58988689
58996389
52284463
58998557
58994275
58994271
38378656
44428733
32371863
59064997
59065002
59065001
59065000
59064998
52425734
58663025
58661085
59099704
59016123
47360006
47358325
59081201
59016374
59015365
59015369
55066817
55068329
52155576
52156463
45497153
58463557
58945120
58963963
58964020
47427359
57005541
45008947
59138668
56888585
55262011
55261853
55262005
55291513
59154435
11971019
11971029
11971026
11971022
11971033
59077125
55705817
53396002
35892264
59207591
59207623
59207677
59207658
59207626
59207918
59208006
59207855
59207938
59208109
59208074
59208110
59208140
59077655
47766965
24410084
59240579
22109629
59030143
26737537
58407861
59105158
59101725
59130783
34908387
34908398
34908767
34908754
34908802
34908614
34908465
34908819
35114193
59158408
59158406
59165873
59167029
59149466
59147918
59165874
59158449
59158438
59158419
59158448
59158550
59148685
59148684
59158557
59129140
35949377
58478314
59158553
59158407
59158413
38544909
59429102
59158446
59158551
59158552
26413183
26413354
26413286
26413148
26413167
26413386
26413224
26413487
26413474
26413233
26413326
26413502
26413267
26413398
26413274
26413144
26413191
26413751
26414051
26413680
26413848
26413964
26413697
26413896
26413855
26413590
26413882
26413950
26414101
26413692
26413723
59161851
59166349
59472773
59476150
59478406
59483347
59481434
59478402
59481457
59483319
59481424
59485050
59485011
59483356
59478408
59481431
59481443
59486125
59486177
59478476
59478473
59478462
59475951
59478381
59475971
59478388
59476010
59478461
59478517
59476102
59475957
59478395
59483365
59481568
59478521
59483373
59481446
59488039
59488075
59487096
59488089
59490831
59486995
59488108
59486187
59490820
59492161
59492182
59490904
59490917
59490936
59490938
59492207
41240153
59493056
59494920
59492248
59495535
59495775
59495062
59495542
59496328
41560764
59495528
59496804
59496812
59496358
59496291
59496287
59496829
59496836
59495533
59495788
59496285
59497290
59497286
59497831
59497822
59497824
59497873
59497802
59497260
59497264
43432500
43440285
43440330
46234099
59545883
59548756
59545892
59184367
59184363
59184376
59184379
59184364
59184377
59184378
58822558
59575838
59575836
59575927
59579808
59579357
59579836
59579883
59583621
59350000
59594463
59579882
59582202
59575893
59579813
59575861
59578612
59579765
59575913
59575922
4332871
59166361
55457970
55457984
55457971
55468291
55468292
55457988
55457965
55457975
56029905
57998248
41805807
59166371
59166100
59165930
36767359
58245771
58250331
58331512
58331513
58331516
58651956
58672963
58821687
6348715
7459821
7459903
7459880
59908666
59101321
59166367
59166366
58478192
59141254
59141301
59148882
59147942
59148898
59153579
59166368
59166378
59166360
57879587
57909284
59227757
59227841
59276693
59276713
42128019
57876853
57877241
57876856
57878107
58265123
59238320
59266337
59266253
59266303
59236870
58745005
59430198
59380279
59407351
59394190
59379672
59426618
59130597
59147327
53231305
59366206
60036927
59133969
59133974
60036930
55319161
60071690
60071757
60071539
60071566
60071791
60071751
60071667
4699833
59141230
59141251
60071392
60099144
60098138
60105541
60100745
60101387
60108034
60108021
60108004
59522960
59522989
60071932
57877842
57879521
57879541
57879503
57879776
57909228
59527956
57909243
57909275
59555365
59555370
59555390
59555381
59555376
59555397
59555408
59555374
59555368
59555387
59555404
59555401
59555378
59555393
59555383
59555364
59534296
59538163
59529074
59537204
59537409
59537207
59632012
59585100
59585104
60102190
60105513
60102249
60105667
60105518
60102222
60102232
60102203
60130881
60102264
60105591
37324608
60130891
60130794
60130888
60130849
60130886
60130838
39018512
41680791
46342765
45363730
46342726
46342803
46342743
58905980
58905973
58905978
58905977
58905972
45008786
34861665
59729314
59630038
60147394
59783194
59782831
59786386
59785235
59548280
59548603
59730176
59730178
59730171
59730228
59730180
59730172
59730167
59730164
59730179
25646936
59730175
45220191
37544345
58896478
58992602
58896097
58893970
33685259
58897234
58895170
58895668
59155213
59071956
59071912
59156061
59155785
55300035
55300032
59156564
59072770
59548283
59529493
59548254
59529508
59534526
59529061
59538148
59537210
59676091
59632134
59632140
59676019
57878282
57878752
60170232
60170969
60171339
55468423
55468490
59537212
59537233
59537224
60179141
60179144
60179344
60179143
60179145
60179140
60179142
60170195
60171048
60170164
60171372
60170186
60180525
60182035
60184516
60182059
60181841
60184506
60182037
60181872
60182080
60182047
60180497
60181865
60182043
60180475
60182223
60181874
60180483
60182069
60181852
60181797
60180510
60182058
60182055
60181813
60182068
60184676
60182076
60180528
60182074
60184560
60184424
60180453
60182101
60182077
60182230
60184492
60180503
60184680
60184437
60182112
60180512
60182067
60184368
60181804
60181802
60182211
59763486
58994776
47516167
57655978
57655807
57655895
57655716
59071908
60009767
33685258
34971405
60098036
58895400
58895427
60098302
58896673
58896545
54132811
54132816
59927223
59072120
59529068
60098306
60098039
57879746
60257700
32070499
31778978
58894601
58894436
58895215
59155922
60189854
60188974
59738768
59738771
59240689
60196249
60196160
58995089
58995105
58994971
58995116
59071380
59570685
58631630
58632480
58632481
58631805
58631670
58962009
4004371
57878855
57909181
57909224
57909158
60371624
57877285
57876823
57878484
57878433
57878122
57877828
57878316
57878688
57877834
57877899
57879058
57879111
60392807
60410602
60410596
60410607
60410624
60410619
60439698
60490424
58478303
47897391
60524420
60524424
60523454
59029438
59029437
59029433
59029406
59575774
59495741
59545874
59497281
59497285
59579767
59579777
59582226
59545878
59545898
59495780
23823360
23823356
23823362
23823366
59116544
60371774
34941755
34941647
34941844
34941831
34941641
60627578
59486939
59483361
59486160
59490915
58163049
58162956
38950428
38962656
38965282
38963978
38964560
38963406
38944132
38943718
38943189
38962126
38946026
58895904
58896003
58895786
59155199
40614703
40614473
40614755
40617279
40617314
40615824
40615763
40615112
40617259
40617110
40614972
59095606
59095947
40874267
40874263
40874240
40874086
40873853
40874494
40874477
40874403
40874545
40874504
40874599
40874724
40874846
40875053
50541818
43440598
60689623
45800796
45800801
45800797
45800804
45800798
60588878
60734616
45881866
57848799
57817034
57817048
57848788
57816959
57868528
57816820
57897145
57901680
57897196
58596339
60781615
60781614
12224317
60804579
60787605
41145785
40905525
49393501
49392892
49392999
49393079
49393000
49393841
49393838
49393351
49393850
49393502
49393528
50983557
50983294
50983550
51039535
40756626
40756627
40756624
40756612
40756636
40756623
40445943
40756638
40756687
40756690
40756685
40046305
40046044
40046060
40039037
40041436
40045567
40046306
40045574
40041427
42313053
42313058
40047908
40049558
40046591
40047910
40049577
40049555
40049574
40046880
44346549
40073240
40073234
40073220
40073227
40054351
40054464
40073244
40054452
40073209
40054578
59026539
59042357
59026543
59031348
51304945
51307461
51307669
51307620
51307701
58279236
41882281
40454934
39364659
38505639
38506543
38702881
39018863
39018885
45571053
50969191
50890793
50891701
50969208
50969190
40033861
39139935
39139484
39248672
50972444
39249241
39249235
39249076
39249247
39249447
39249244
49426482
49426027
60820328
58895417
58995173
58994890
59155611
59155651
48787839
59497289
59486127
60837804
60837806
60837815
60837817
60837813
60837821
60837807
60837818
60837819
60837811
60837860
60837775
60837823
60837831
60837788
60837861
60837824
59494943
41532641
44567240
44567239
44567245
44567246
44567278
54467046
60926521
60899349
60899600
60961600
60959792
60956441
60956299
60956403
60956204
54687475
55706874
55706961
55706872
55705985
58659142
58660354
58711175
58894591
60488273
59129179
60114778
59410165
45825463
59486166
60925523
60098316
60098322
60098327
60233815
59002208
59156457
35869696
47355376
42963225
42984311
43141838
59893843
47401514
58660358
58662605
59071346
61078851
60098026
60098014
60396138
61144524
42799829
58673204
48688766
24478461
24478465
58673203
34624041
59156459
58893998
33693515
48533166
48521071
48535479
47668664
60349340
60136109
60688476
60705289
60723381
60725790
60144081
60144080
60754687
60754686
60754690
60712276
60666679
34523182
34625618
60805023
60787915
55948188
55948205
55948197
55948196
55948194
55948186
55948187
55948185
55948174
55948191
55948176
55948189
55948180
55948195
55948198
55948181
55948179
55948201
55948175
55948182
55948177
55948193
55948202
55948190
55948183
55948203
55948184
55948200
55948173
59024649
60761913
60761909
59024635
60372590
60348729
60348630
44374759
38463118
25715140
49640060
26272622
26272621
29074795
33505034
34941608
34941718
34941794
34941842
34941820
35078970
35079191
35079182
35079019
35078872
35079206
35078888
35079010
35079204
35078898
35078890
35079081
35078902
35078757
35078626
35078616
35078932
35078878
35079105
35078851
35078768
35078761
35078807
35079226
35079045
35078773
35079217
35078624
35078735
35078840
35079150
35079137
35078658
35078648
35078939
35079209
35078930
35078620
35078752
35079144
35078967
35079141
35078650
35079185
35079202
35078961
35078832
35079068
35079170
35079102
35078882
35078654
35078802
35078910
35079156
35078922
35079214
35078836
35079166
35079220
35078953
35079198
35079073
35078920
35078924
35078764
35079097
35078936
35079162
35078879
35079005
35078949
35079029
35078978
35078645
35078981
35078867
35078634
35078956
35079052
35078958
35079001
35079025
35078631
35078775
35078857
35078817
35078987
35078777
35079053
35078754
35078675
35078986
38283038
38937933
38937943
38937940
43018435
59134119
49403687
39623921
39623945
39623951
39623958
39623999
39624008
39623990
39624021
39624025
39623937
39624018
39623960
39623988
39624010
39623939
39623928
39623962
39623934
39623949
39623944
39623929
39624020
39624017
39624005
39624015
39623987
39623948
39624012
39623973
39623924
39624001
39624007
39623931
39623926
39623935
39623992
39623956
39623919
39623995
39623953
39623998
59410140
24840353
61206614
61206146
45800808
45800810
45800885
45800806
45800888
45800807
45800795
45800805
45800884
45800809
61207682
48522361
48522417
48522406
48522373
48522380
48522420
48501073
48522410
48522359
48522428
48522379
48522340
48522411
48522433
48522375
48501074
48522349
48522353
48522371
48522347
48522378
48522356
48522396
48522342
48522363
48522368
48522413
48522400
48522376
48522423
48522425
48522436
48522370
48522377
48522384
48522351
48522427
48522408
48501069
48522422
48522337
48522307
48522404
48522391
48522374
48501230
48522365
48522354
48522333
61208457
61209206
61190059
61190034
61190046
61131329
61190227
61190224
60171070
59129178
61190235
61190252
61129689
61131710
61130929
60182082
61190379
61190380
61190362
61190369
61190386
61190371
61190422
61190445
61190398
61130968
61143128
61133206
61131835
61131994
61191122
61190951
61190941
61190899
61132339
61132274
61191217
61191220
59167108
59132299
59129188
54698929
57306860
57581010
57580132
57582578
57582575
57582577
57582540
57580499
57581602
57581116
57580998
57580908
57581004
38462496
59127536
59132871
59130908
59132550
59132455
59162126
59166305
59147337
59167053
59166101
59147215
59147338
59165764
59165761
59166304
59165859
59166306
59165793
59147211
59162088
59225048
59140205
59526502
59030140
59496317
60000519
60100729
60100699
60101027
60100962
60110192
60098347
60100989
60098310
60098309
60098342
60101021
60098307
60098308
60098313
9143746
59764566
60680346
60502412
58993286
37544751
60813754
61031391
61127458
61124551
61241683
61241680
61241679
61241684
61267232
61269482
61269468
61269469
61269944
61269472
61269471
60659640
61334137
61334312
61334027
61335118
61334719
61335121
61334674
61335119
61340445
61340444
61348787
61348780
61369684
58790011
58790025
58789943
58790041
58790055
58789957
58790096
58790077
58790015
58790065
60371620
61413340
61465305
61487488
61487509
61489205
39249279
50986080
51168088
54326306
61259684
49403614
49403393
61532969
37324849
40612343
40616407
39017933
40874965
40873717
42395613
43141787
60633517
60874847
49641661
61271376
61272185
60987466
60987451
60987441
60657271
61027816
61018193
29977917
60566746
61563188
55448057
58631447
58896505
61604779
61604778
61604777
61604759
61604762
61604775
61604758
61604760
61604776
60509873
47896805
44411509
44411522
44410762
44411500
44410738
44419050
44418878
44418876
44419300
44418396
44419264
44419031
44420152
44421579
44421550
44421549
44420158
61618637
44836328
44821774
44836330
44837034
44821777
44821176
44821166
44837068
44821183
44901496
44898685
44898668
44943738
44943796
44943745
44898653
44901485
44943770
44858675
44898667
44901473
44898663
44838408
44865937
44943799
49421789
49843494
44945958
44945957
44945996
44946738
49131225
44945998
46081732
60348895
60349109
60349458
44414179
49408787
49421810
60599679
60735324
60757363
60757345
60757384
60757335
60757325
60757331
60757374
60757353
60757372
60757362
60757337
60757287
60757388
60735371
60735522
60650670
61667797
61714637
61713305
61599666
61677439
60813757
61720028
57419706
51877855
61746589
61749462
61764833
47674348
47667476
39983692
44335482
60349002
60349171
60349151
60349255
60349062
60348861
60348714
60348887
58712716
60349274
60348881
60348694
60349055
60348921
61801327
61801449
61484228
61270514
49186540
48658878
48658825
49186536
48704543
49408785
49186537
49180453
37269774
40508821
40508816
38849846
59495544
36906181
36907542
37112325
37113010
57749070
56131383
60349050
61485998
61485773
61593628
60931668
61837514
61818070
61457837
47666486
45500028
49428238
49428231
49428311
49652388
49428256
49428242
49653131
49652845
49652792
38462398
26281362
59156197
61070383
61070386
61070387
40521438
21265369
39803937
34859473
47666683
62126050
57490226
61747442
40756605
58990250
58990252
60349144
60349043
60348662
60349522
60349016
60349038
40521435
60987481
61466876
41716904
45230422
45230424
45230423
58490391
43636016
58486966
58490346
58491360
58491348
62199984
62198787
57979970
57979677
62230126
62230623
61457951
57991977
57992018
57959505
57992005
57961597
61343704
54333224
54333223
54333225
55826971
54214933
52818963
20829179
44349661
44347970
44349916
44349842
62025579
62025950
58275906
58278106
58278073
58278673
62280395
62280389
62024079
51307460
62261024
62285643
57953025
57961768
57972394
57970219
57972403
40330236
57979691
50816463
40764871
40331019
50877540
50877631
14558280
61997670
61994792
61994862
61469917
61469938
32026686
32026670
52424880
52371869
49403396
62227261
62227246
62227590
62227405
62227492
62227370
62227751
62227684
62227767
62227812
44046470
43141847
52424885
61744673
61746846
61748084
61864664
62334152
62044934
62044879
62044905
62044887
62044964
62045391
61985651
61985662
61985665
61985631
61985696
61985673
61985646
61985680
61985692
61985695
61985655
61985691
61985652
61985685
61985658
61985711
61985709
61985679
61985672
61985700
61985681
61985647
61985634
61985641
61985664
61985706
61985704
61985694
62388479
62401790
61048672
60287920
34869593
38183639
62447672
25959598
62405430
62405416
62498959
58484564
58925163
58489001
58924996
26975209
62508778
37976509
62479896
62534340
44796363
60851928
33935323
38991720
62551773
43141870
51553851
58484623
61343703
61343700
61747051
61938224
62534339
49175410
56766298
60287902
30971027
61013463
58992424
61013972
58895296
60659584
60321313
44409479
44409424
57521640
49640115
61942446
61939477
45004404
62653968
62653537
62653494
52289998
42984337
60349356
60348859
59155216
60349112
60348868
58896186
60055414
42984296
60349328
60348746
62654026
62654019
60686747
60349444
34977979
42984295
39138128
62194380
61145770
62124728
52372046
59156462
56769099
62202076
43028712
62192895
62192947
62197206
62197791
62197201
62197171
62197793
62197208
62197212
62198534
62198531
62198536
58744900
62180499
62180583
62180682
62180774
62148728
62148776
62148646
50878295
50878292
50878302
50878310
50878309
58994552
60215345
40770917
60296163
61877229
61877240
61877175
61877223
61877186
61877230
61877219
61877181
61877588
61877178
61877182
61877180
61877634
61879840
61879655
61879356
61879645
61879338
61879608
61879353
61880266
61879696
61879613
61879363
61880570
61878901
61880559
61881768
61881731
61881453
61881743
61881618
61881716
61881626
61881435
47897054
44410774
58744856
61721366
61721365
38338448
38337175
38340349
38340763
38338466
38340768
38336377
38336402
62202079
62192989
62192903
62198540
62194406
62198652
62789431
62789423
62789361
62180383
62180467
62180470
62180420
62180446
62180592
62180391
62180415
62180563
62180422
62180582
62180398
62180555
62180455
62180591
62180421
62180505
62180589
62180504
62180588
62180498
62180424
62180522
62180492
62180465
62180474
62180554
62180527
62180376
62180495
62180488
62180407
62180477
62180557
62180417
62180524
62180414
62180412
62180480
62180430
62180511
62180551
62180450
62180369
62180435
62180390
62180405
62180537
62180454
62180447
62180427
62180428
62180393
62180497
62180443
62180904
62180723
62180632
62180754
62180890
62181104
62180572
62180779
62180871
62181359
62180663
62181144
62180726
62180800
62180806
62181136
62180812
62180598
62180560
62180939
62180788
62181040
62180816
62181274
62180819
62181255
62180687
62180814
62180857
62180882
62180848
62180671
62180796
62180787
62180791
62180874
62180966
62180607
62181309
62180854
62180659
62180777
62180831
62180768
62180828
62180618
62180811
62180862
62180617
62180679
62181048
62180655
62180662
62180733
62180896
62181276
62180763
62180736
62181288
62181074
62180803
62180780
62181195
62180739
62180851
62181270
62181080
62180983
62180624
62180845
62180698
62180847
62180705
62180807
62180850
62180863
62180625
62180887
62180621
62180677
62180636
62180873
51375450
52143859
54268841
54270615
54680103
54272189
54268929
62202081
62202072
62202048
62202109
62202114
62202065
62202062
54214958
59155912
60349336
60348671
60874837
60689240
60686746
59130714
62088978
60129738
21265383
25534637
27062482
61985739
61985745
61985751
61985780
61985793
61985779
61985769
61985740
61985815
61271316
61985768
61985818
61985812
62455279
55889645
55889625
55889644
55889622
62947276
62948263
62947346
62947535
62947278
62947530
62947532
62947531
62949201
62949319
62949321
62946469
62946453
62954457
62947192
62976593
63021409
59490886
63032673
63043526
63043524
37253069
37442039
37929121
38203713
40038532
4088813
40439605
40430058
40431570
40432254
40817045
40817519
40817033
40817521
41281315
42383033
43296822
43295729
44102832
44420120
45218361
45731248
61778161
47907450
61804456
52319064
52439180
52439024
60987482
62342316
62342305
53426164
53262870
53262881
62342309
62342307
62342304
62342964
54277548
58265547
55359435
62124861
62124699
58896442
55695878
55694690
58265658
58265683
58265709
58265696
58265644
58265717
58265598
58265684
58265611
58265702
58265701
58265613
58265638
58265711
58265556
58265713
58265710
58265676
59072652
62343279
59128806
59128812
59128805
59128801
59128792
59128789
59128331
59128813
59128804
59128342
59128307
59128810
59128807
59128943
59129202
59128926
59128973
59129220
59130472
59128972
59129212
59128919
59128970
59128951
61073719
61136675
63109565
63109580
63109555
50878304
61425328
61425314
61425375
61425305
61425407
61425380
61425333
61425379
61425316
48306398
43001102
47312411
47467167
47467137
61886923
41990728
61877168
61878341
61878881
61879055
63180758
47218397
63203758
63191572
63191614
63191627
63191602
63191636
63191605
63191613
63191609
63191617
63191612
63191595
63191618
63191623
63191611
63191604
61877176
61877191
61877169
61878814
61880325
61877179
61877241
61878695
61878721
62337285
62337276
62337349
62337450
61878654
61881612
61879650
61881761
61879611
61881719
62132050
62132046
62485198
62485221
62493965
62493481
62493480
62514478
62514414
62486642
62486634
62486855
62514351
62486839
62486356
44410784
44420106
44418849
44410249
37976365
58992445
61864682
60641063
61337769
61334687
61338863
39868168
48533163
48521068
29128102
54214954
62124692
62180620
62180613
62180944
62180742
62180744
62180771
62180615
62180969
62180886
62180972
62180676
62180859
62180623
62180911
62180902
59078770
61879432
62197209
62485908
62514527
62486851
62514322
62486139
62486850
62486499
62486636
62485838
62486836
62342784
62342597
62342620
62342916
62343275
62342617
62342759
62342647
62342608
62344575
62344616
62344345
62344530
62344560
62344613
62344535
62344657
62344393
62344449
62344615
62344339
62344597
62344346
62066647
62066661
62066994
62066525
62067227
62067192
62066471
62066486
62066923
62066911
62066902
62067028
62067864
62067853
62583824
62583870
43141798
60348743
60692132
62342325
62342303
62342289
62342290
62342287
62342291
62342297
62342288
62342918
62342299
63257870
55612026
61880245
61879348
61877173
62344532
62485568
62670194
62670195
62670204
62670214
62670184
62670181
62670182
62670191
62670403
62670405
62670404
62670398
62670395
62670392
62670389
62748931
62748933
62774819
62774839
62774394
62774550
62342611
62342662
62342776
62342661
61878720
44374788
39868164
39879190
39868171
62699178
62655902
62670305
62670192
62670308
62670210
62670394
62670200
62670208
62670189
62670166
62670188
62670307
62670309
62710539
49810526
44419035
57490232
44410215
37545495
49188181
44409464
44414157
55839832
49439522
49641635
44409409
62774539
62774658
62774889
62774980
62774976
62774444
62774540
62774786
62774443
62774979
62774362
62774424
62774654
62774663
62774442
62774781
62774366
62774769
62774787
62774462
62774782
62774406
62774784
62774445
62774372
52452558
38289086
60348720
33935300
61030937
62343181
58895797
58994233
58812140
60861392
43459931
58406989
60348640
63320841
63320837
63320831
63320836
59023600
62242240
62242231
62242142
62216976
62204159
62204288
62217048
62242145
62242165
62217051
62242130
62242127
62204244
62242132
62242144
62216947
62242156
62216957
62277247
62242172
62277211
62204204
62242229
62216966
62204287
62242148
62277181
62277176
62242192
62242120
62217047
62277214
62242218
62204203
62204226
61271917
62326373
62313121
62297928
62328290
62313097
62328304
62313153
62326368
62328243
62326382
62318419
62328259
62313152
62318420
62318447
62297965
62326428
62336436
62328265
62326365
62326405
62313127
62313126
61963397
62341324
62363535
62341287
62336485
62363518
62451448
62363526
62341317
62341335
62336455
62427976
62341339
62341286
62336480
62336484
62336483
62336487
62451451
62424358
62424336
62424357
62424353
62774982
62774887
62774541
62774536
62774662
62774542
62774535
62774861
62774653
62774783
62774661
62774649
62774441
62774984
62774773
62493922
63372741
45308692
60129750
63374374
61878696
61878853
62132097
61878652
62132064
62132042
61879048
61878656
62132100
62363524
62298047
62297998
62277224
62649957
62336442
62313090
62427981
62217049
62298049
62341333
62297894
62326429
62242209
62298061
62204165
62363545
62297883
62318432
62242204
62298071
62313100
62297897
62242141
62277203
61137005
62318472
62277227
62336441
62297892
62363489
62328261
61137113
62242212
62277269
62277222
62298009
62341334
62318471
62326427
60850486
37280378
44410745
51297280
44836299
44821148
44410764
38378603
63044576
62774549
47349524
63042668
53182606
62198676
62596757
62597608
62344304
62342265
62198515
62597640
62597456
43296210
62337243
63043201
63043206
61271592
62124855
62336486
62548925
62596993
62597174
62597182
62597181
62597121
62597146
62597399
62597321
62486933
62597483
62597615
62597607
62597609
62597621
62597604
63043209
63041685
63041703
63043802
63044566
63044890
63087079
63446396
63181102
63181175
63181194
63484102
63268888
63268885
63268908
63268900
63268889
63268886
63268891
63268894
63268883
63268905
63268895
63268907
63268893
63268887
63268913
63268898
61881703
62486484
63512583
61547040
61878967
61878697
61878895
62132077
62132068
61877232
61877166
62597299
62597634
62597176
62597186
48688619
61139862
62597200
63043772
63044574
62328237
62216991
62341281
62277205
62326391
62318450
62326397
62242152
62548926
62363541
62242221
62328306
62341323
62217046
62505869
62318427
62242151
62204197
62277253
62277167
62505858
62336432
62341336
24255911
61881763
61877233
61877236
58894973
60294762
62197789
62342474
63583879
44414160
44418870
44418211
51760260
60305877
32371865
47184822
62636800
57121642
49641977
49438110
62193445
61139387
63551505
63241994
63241991
42984309
62774645
62774873
62774471
62774922
62774643
60850484
60850520
59030908
60659615
61425183
61424984
62508046
62508126
61424983
61424981
61425213
61425121
61425081
61425120
61425224
61425176
63044665
63607062
45380482
62936034
63372032
62506244
60348785
62344499
62194379
57892384
61609611
60850518
63482718
62596775
62597487
62597648
62597612
63044664
63044832
63044663
63044105
63043831
63508647
60987468
62315792
61777938
61777923
61778078
61778077
30889469
42845171
40054117
43542939
63548420
63548424
63548427
63548429
63548405
63548416
59128783
63548447
63548445
63548442
63548435
63548441
63548454
63548443
63548456
63548440
59166323
59165810
59147363
59149491
59165919
59166314
59129150
59147186
59130376
59149472
59158564
60181851
61209121
58744977
58744986
61994541
61994378
61994491
61994442
61995221
62131525
62127486
62005637
62005663
62015285
61086171
62320149
62342583
62342981
62342592
62342321
62342577
62344635
62596773
62597636
62597122
62597056
62596871
62789202
61271924
61895584
61877134
61877814
59496362
62653933
37281077
54680098
47114941
47114927
47114944
47114942
47114968
58895981
44821745
32372331
47114916
55300039
55300078
55300046
55300026
55300074
60349294
58265695
58277893
58276005
62774919
62774945
62774472
63264093
63264175
63264158
63264246
63264322
59024798
49404801
63508635
63508616
38356631
63723332
63723444
63723373
63723319
63723217
63723221
63723261
63723224
60125041
60129687
62597334
60126057
60129721
60126931
60121396
60129717
60124804
42984363
42984386
59235130
60126184
60121871
60124722
62597115
62596772
62597008
62597006
62596776
60129742
60129740
60129707
60129713
60129720
60129716
62597366
62597192
62597633
62597596
62597639
62597731
62597191
62597490
62597486
62597133
62597197
62597617
62597646
62597482
63032566
62662195
62975018
62662189
60129719
60129688
63044557
63043785
63587111
60055348
63647075
63747490
60842351
56766129
61070418
61425112
61425073
36289932
61271868
61546969
30970975
63623500
44350040
59071368
58897298
58994936
58993087
58993101
59072868
59156551
59333646
58994575
48521070
48533165
44491052
44491118
44491008
44491085
44490901
44491071
38708911
62597261
58994729
38709259
62342660
38374972
49810527
47891177
44411543
44836301
63534847
63534911
63535109
63535111
44410176
38183246
63685232
21265380
61270463
34732774
63736790
63736807
63762121
60349497
60349059
63736788
63736786
62342917
63761890
62003931
58521563
44837074
49843321
63756030
63888799
60296122
63070793
37271233
59072911
44415885
44838368
44418414
38709055
44901476
63044977
46949145
46949079
46949159
46949161
46949155
46949146
46949099
46949021
46949157
46949104
46949101
46949060
46949103
46949111
46949083
46949064
46949107
46949100
46949106
46949102
46949151
63534932
44365530
61271922
62654983
62654960
62654961
59128791
63256414
62907844
62908897
62910025
62907384
62907547
51555074
62873692
63970270
63970273
63970268
63970264
64027185
57562942
57563061
34086939
34086940
34086941
34086944
34086945
64030738
63908572
63906057
64089965
64089955
62935894
62935871
62936298
63257022
63257026
63256978
63256415
63256419
63256873
63256871
57883843
57883836
57883849
57883804
57883845
64104578
52231054
52231072
52229742
63348095
57648080
64088810
57883754
63736799
63736813
63736802
63736794
64097528
14300722
60305963
64175782
64009192
62552999
60293794
60305705
64215124
51602685
51602958
64241927
64241926
64241962
64242097
64240649
64240650
64240683
44898666
44821044
44414178
44414183
44424883
64257662
57524505
23784910
25418269
13355581
13355683
15487017
30882393
55416300
64278779
37421735
64274005
40054352
40809801
41383476
41383471
41383474
41383380
41383470
41695371
60284292
49134111
64298339
36435422
49951182
51053926
52128694
52128869
52128636
54517950
54517992
54748627
58651278
56235937
55465972
55467684
44424853
61587936
61587933
43517625
61587946
61587978
64331710
64332647
64334227
64333291
64332001
64334115
64333169
64332946
64332861
59843435
59843430
64345089
64345141
64345257
64345312
61985667
61985675
64351534
64351500
64347608
64349289
64347303
64351478
64331165
60198791
38339692
60519927
60520012
60520023
60519970
60520015
60519910
60519921
60519994
60519874
60519884
60520020
60519969
60519998
60519955
60519999
60519882
60520018
60519941
60519863
60519993
60519878
60519950
60520010
60519909
64331231
64353565
64347189
64336307
64353571
60162027
60161831
60234108
60161846
60161827
60161808
60161973
60161981
60161828
60161937
60161911
60161769
60162009
60161952
60161806
60237375
60235937
60235990
60235867
60234181
60235897
60235944
60234147
60587602
60236417
60236705
60236370
60236702
60236407
60236791
60236701
60236391
60236801
60236249
60236771
60236360
60236708
60236372
60236606
60236079
60236707
60236696
60236084
60237233
60236869
60236854
60237084
60236868
60236870
60237091
61270513
61879970
61879972
61879858
61879921
61880752
64377558
64377565
64377557
64377567
64377561
64181874
64364065
64364086
64393252
64393275
62277174
62216971
62242154
62313086
62181069
62180509
62181004
62180616
62654537
62745634
62745241
62745244
62902033
62902299
62905246
62905293
62905022
62905266
62905268
63181075
63181007
63508689
63512802
63515706
63959735
63959577
63956724
63968960
63386103
64004024
64004068
64004058
64004035
64004031
64004064
64004065
64004075
64004028
64004019
64004023
57375906
63386146
61587918
61587873
57382484
57876852
63698875
63699219
57878187
57878350
57879129
57909291
64046554
64034064
64050421
64081683
5896473
57375957
64133981
63256859
59156463
47389032
63044978
46851636
61193549
61193432
15657882
15657878
15657926
15657973
15657925
15657965
15657938
15657967
15657955
15657864
15657890
15657953
15657933
15657940
15657876
64436864
58895515
62604014
57897128
61042913
63032579
64444311
63032609
58265576
58265580
61209152
61205869
62597647
63369701
60658469
64493801
64480872
63701676
58895632
64527487
47360679
64533189
64533518
60682390
64387722
49220134
64589397
64437943
64437916
61971613
40044362
60287916
45578946
44415214
57471583
64640112
44419278
64483573
44410247
63701382
60989575
32960689
63906035
62654054
64405114
64440346
64436637
64517105
64499950
64518857
64534150
44365534
64110313
64547985
64453441
37112429
57223283
64173320
64173347
64170952
64170894
64170918
64170812
64170692
64170850
64179029
64178175
64182533
64181824
64181866
64632443
64170109
64169868
64170076
64170103
64169866
64170101
64169846
64169943
64169938
64169924
64170357
64169840
64169917
64169842
64170137
64170127
64185213
58994814
64171085
64183771
64183791
64172416
64183326
64631589
64647694
26857780
22487246
49810215
45964584
45747942
43944412
43944986
20216356
20216360
20216341
20216352
20758693
61994434
21458554
22487259
21809218
61995074
61995249
22761321
22741296
23240483
22741339
22741299
22741357
23240489
22741302
22741322
22741306
22741330
22741316
22741325
22741295
23235502
23240487
22741348
22741333
22741318
23240486
22741346
22741369
22741362
22741374
22741377
22741293
22741353
22741311
23240484
22947600
23240488
22741342
22741300
22741310
22741360
22741370
22741378
22741334
22741294
22741309
22741312
23240491
23240490
22741331
22741364
22741297
22741326
22741329
22741315
22741351
22741304
22741317
22741336
22741343
23643209
23642517
24651315
23643422
24376072
24299758
24699777
25180125
25518235
25315116
25876888
25645317
25738200
25791692
25738242
25924206
25892332
26098081
26417849
26417905
26525116
26523299
26524985
27575833
26974366
27569030
28714291
2923535
2923550
29314459
29456345
31392932
31443187
31734810
32191912
32172210
32173296
32172337
32173436
33718423
3477004
35261835
35260558
35743814
35779251
35986248
35986253
35986258
35986268
35986192
35986179
35986277
35986282
35986236
35986214
35986255
35986239
35986185
35986230
35986227
35986175
35986267
59167934
59167922
37332425
38337976
39018878
39445071
39445039
39445058
39445076
39445041
39445033
39445020
39445018
39445055
39445059
39445030
39445070
39445010
40301734
41708869
41708868
41708871
41977523
43141783
44191757
44026330
44126707
44335459
44729174
44823764
44771032
44934972
44935006
44934973
44934974
45602332
45730767
45730780
45731258
45951038
46082931
46210054
47379817
47006991
47257918
47196422
47196378
47196345
47196445
47196365
47522858
47516164
47658582
48017177
48521048
48521012
48382422
48382412
48622836
48535703
48535745
48718805
48718784
46843554
46851619
46851572
46851603
46855608
46851604
46855633
46855720
47349434
47352812
47354568
47354546
47354567
47354557
47352827
46865162
47354590
47389056
47400085
47400164
47400144
47401532
47401535
49183457
49183641
49183490
49393113
49393560
49393111
49393276
49393270
49393698
49594314
49652324
49652335
49428229
49652322
49652321
49652716
49914352
50542696
51168033
50988261
51421356
51421343
51438893
51515952
52540535
51181842
52001931
52001893
52561825
5282130
53262845
53262821
53262850
53262831
53262812
53262815
53262907
53262836
53262912
54132838
54024163
54024160
54536400
54536344
54536342
54536564
54536338
54536334
54536348
54536339
54536346
54536337
54536402
54536335
54536340
54536351
54536406
54536399
54536350
54536347
54536343
54536413
54536341
54536407
54536404
54536401
54536405
54536414
63386129
54821325
54821328
54749967
54748615
64732345
64732344
55091868
55091867
55091897
55092003
55092036
55091852
55177822
55177823
55177821
55195031
55860239
55860212
56124318
56124304
56124301
56124278
56124266
56124216
56124276
56124298
64871438
64873661
64902793
57447043
57459604
57459605
57224922
63386253
63386282
59155258
64915701
57627487
57627488
47006992
47006989
64930919
64930923
58265111
58511574
58331552
58330864
58331545
58330620
58330839
58406971
58407803
58406947
58408570
58663029
58651913
58847231
58659140
58723350
61190202
64937671
58990136
58993188
58994576
58993187
59332569
58993324
58992891
58993292
58993288
58993177
59332516
58993114
58993105
64937712
59363624
59363587
59830490
64872269
64872270
60071709
60071939
60071820
60071614
60071618
60071549
60071552
60071872
60517544
60807357
60932851
60932845
60932843
60932876
60932849
60932839
60932847
60932841
60932859
60932855
60932861
60932870
60932863
60932866
60932873
60933227
60932868
60932853
60932857
60932837
61209183
61546420
61487194
61487549
61587939
61679804
61849287
61849341
61849262
61878386
61916619
61985659
49183263
62368854
62423992
62455330
62455319
62455324
62455345
62455338
62455321
62455312
62455352
62455314
62455313
62455341
62455308
62455328
62455311
62455355
62455347
62455310
62455316
62455315
62455318
62455346
62455331
62455351
62455339
62455323
62455356
62455336
58928442
62745642
62654465
62902195
62905276
62905274
62973987
63032610
63032580
63032581
64964250
63264591
63264407
63264005
63263928
63264068
63264524
63386164
63386260
63351397
64967171
64967886
63870381
47401517
63814841
63915053
63934956
63954107
64004050
64030355
64104542
64191292
64191335
64191294
64191333
64191330
64169730
64170526
64240814
64392487
64392504
64392508
64392492
64392485
9054562
967865
64647647
64647682
64647646
64647714
64647679
64647676
64647675
64647680
64647644
64647681
64647678
64647693
9816807
38378484
64169524
22083960
64985679
64985684
64985669
64985682
64183291
44836308
63698800
62329230
64706666
64706668
64706676
64706541
64706671
64706557
47512848
29288911
63402983
63403146
63518761
63603507
63603515
44783021
45314195
50797373
43944338
43945078
43944445
43945075
45747939
43944341
43944701
47878110
45747951
43945069
43944489
45747943
64810937
64810941
65070571
58129904
58129666
58129906
58129800
58129803
58129777
58129952
58129665
58129694
58129945
58129916
58129715
58129671
58129664
58129662
58129889
58129720
58130750
58130736
58130693
58130392
58131311
58131307
58131312
58131326
58131292
58131176
58131138
58131255
58131287
58131308
58131134
58131204
58131126
58131277
58131270
63386281
63386252
63386099
59024657
64782781
64782878
64782877
64850488
58896419
62124716
61193484
65129089
65126011
47275157
64899159
64895179
60129705
60124811
60124718
64848946
64848969
64467937
65135384
36945175
65135772
65155431
63545508
65087459
65198687
65198704
65198732
65198741
65200758
65203618
65203598
65087741
65087742
65087732
64883262
64883260
65087711
65087738
65087748
65087756
65087695
65087713
65087752
65087717
62936022
65228232
65228384
65228274
65228331
65228245
65228394
65228391
65228312
64506344
65233186
65252297
65251570
65252096
65252370
65251286
65252162
65251133
65252195
65251736
65251376
65250606
65250620
65250638
65250439
65250585
65250615
65250574
65250625
65250589
65250572
65250605
65250443
65250633
65250596
65250593
65262546
65262676
65262518
65262606
65262696
65250775
65250906
65251016
65251080
65251078
65250712
65250769
65251065
65251066
65251075
65251068
65250922
65251087
65262741
65262770
65262892
65263006
65263005
64170870
44822148
62935878
64939626
58993131
65006079
65006065
65006081
65006069
65006112
65006071
65006093
65006106
65006097
65006100
65006092
65006089
65006094
65006075
65006091
65006077
60850141
55076966
55077166
63117540
65307042
65333637
65339368
47389054
65029260
65029280
65345761
64453521
63032679
18921945
65339509
38463767
64139182
64778275
64778295
64783169
65388933
65383754
65319002
65384520
65382598
65382617
65382637
65382650
65382623
65382635
65382615
65382641
65382570
65382591
65382602
65256740
65406260
65405754
65406126
65405828
65406306
65405671
65405741
65405760
65406067
65405687
65406413
65406418
65405971
65406304
65406227
65405960
65405765
65405915
65406398
65405652
65406569
65406609
65406595
65406447
65406570
65406560
65406616
65406501
65406433
65406503
65406291
65405696
65405710
65406234
65406473
65407026
65406993
65407049
65406932
37544463
63402891
63402415
63403056
63403035
63403047
63402906
63403095
63402968
63402893
63403072
63402941
63402491
63403093
63403075
63403003
63402904
63403049
63403099
63402966
63403006
63402986
63402965
63402907
63402925
63403033
63403019
63403014
63402969
63403004
63402934
63402894
63402890
63403153
63402972
63403024
63403046
63402944
63403015
63402982
63402970
63402501
63403110
63402905
63403156
63402477
63403151
63402985
63403074
63402988
63402441
63403077
63402461
63403098
63402999
63403124
63403054
63403186
63457098
63403345
63457100
63494613
63403413
63457075
63492381
63403157
63403362
63403180
63403364
63403306
63403366
63457074
63403316
63403183
63403298
63403167
63403360
63403318
63457119
63457085
63457097
63403319
63494632
63403344
63403294
63403315
63403331
63403304
63403176
63403401
63403175
63403328
63457101
63403402
63457106
63403200
63457121
63403337
63403309
63403335
63403314
63403301
63403311
63403165
63492740
63403209
63403381
63403376
63403361
63603463
63518769
63518768
63603473
63494633
65409481
65409982
65409607
65409891
65409902
65409840
65410017
65410307
65410286
65410117
65410368
22932861
46621396
46621304
65482341
65488334
65482362
65482366
65482198
65486738
65486745
65486777
65486771
38708646
63755995
65488341
65488335
65488269
65488325
65488056
65488045
65488065
65488254
65488053
65488320
65488307
65488130
65488078
65488292
65505706
65505693
65505678
5538494
65510361
63290412
62653871
62654017
62653961
61880838
65093602
64169872
64283862
64488204
65515303
25528206
65505591
65534601
38375414
38360666
65528939
64779218
64779219
64779239
64779234
64779221
64779217
27603419
27603853
27604411
47349493
46229861
59484981
65510963
65510966
65510955
64261839
64262034
64261889
64261872
64261905
64261823
64261921
64261792
64261879
64261859
64261972
64261969
55696096
55695144
64955481
64955474
64955471
64955478
64955500
64955511
64955520
64955491
64955492
64955499
64955524
64955525
64955490
64955486
64955504
64955483
64955517
64955482
64955495
64955497
64955472
64955475
64955473
64955501
64955510
64955498
64955522
64955516
64955513
64955496
64955489
64955502
64955477
64955505
64955494
64955503
64955519
64955512
64955484
64955488
64955515
64955518
64955493
64955523
64955480
64955509
64955841
64955814
64955768
64955796
64955826
64955820
64955771
64955756
64955760
64955830
64955787
64955834
64955822
64955845
64955847
64955779
64955762
64955840
64955812
64955809
64955801
64955758
64955824
64955777
64955816
64955818
64955764
64955781
64955773
64955769
64955811
64955789
64955766
64955792
64955798
64955832
64955794
64955849
64955775
64955836
64955800
64955843
64955807
64956253
64956257
64956293
64956284
64956285
64956261
64956258
64956290
64956279
64956260
64956288
64956273
64956252
64956255
64956276
64956256
64956254
64956250
64956289
64956283
64956287
64956263
64956291
64956264
64956275
64956266
64956268
64956271
64956295
64956262
64956270
64956286
64956292
64956248
64956267
64956278
64956269
64956265
64956282
64956277
64956294
64956251
64956272
64956280
64956274
64956540
64956533
64956523
64956521
64956555
64956517
64956531
64956549
64956534
64956543
64956504
64956546
64956532
64956542
64956522
64956545
64956553
64956541
64956536
64956525
64956509
64956535
64956550
64956529
64956514
64956519
64956516
64956544
64956551
64956526
64956507
64956524
64956513
64956511
64956552
64956527
64956515
64956548
64956512
64956506
64956539
64956503
64956508
64956530
64956554
65618469
65618621
64261891
64261928
64262038
64261881
64261847
64261837
64261925
64261991
64261930
64261890
64261950
64261945
64261858
64261855
64261854
64261920
64262006
64262000
65619612
65621248
65620861
48013601
65243640
65617444
65617402
65617447
65617404
65617548
65617413
65617555
65617799
65617815
65617999
65617807
65617793
65617813
60293440
65665996
65227996
65237430
65237434
65237432
65237437
65237441
65237435
65237440
65237433
65237438
65237436
65689612
65690415
65689692
65689643
65690634
65690937
65690443
65690770
65665754
65665755
65665764
65665762
65665758
65205160
65208790
63231534
65691374
65691444
65691286
61190221
59024861
63083041
63132892
64645878
63083409
65505368
64171502
65297958
65297394
65298053
65297419
65297881
65705265
37112630
65298035
65718054
65718049
65718058
61013302
65339362
65299955
65351942
65299038
65722950
65728693
65728699
65728700
65299778
37269294
65734559
65299718
65742441
65343809
65305465
65297603
65298769
65299951
65299613
65299677
65299832
65299836
65299812
65299023
65299194
65298862
65335447
65335353
65335303
65335453
65335286
65414764
65414752
50816434
32295603
65335298
65335492
64172751
65394202
65396439
59432342
65298355
61271535
61466677
65787525
65468209
65297282
65196593
65192450
64517114
65299191
65055196
65298579
65414772
65414760
65299885
65335133
65335376
65299033
65534779
65555668
65335369
65299739
65299908
65335434
65298935
65299127
65299834
37544791
65335333
65335317
65335545
65335262
65335473
65335482
65319738
65310213
65319764
65319725
65310180
65319714
65319771
65310167
65310176
65310181
65310190
65319761
65319736
34911586
34911611
65530642
65530631
65530310
65530455
65816757
58992934
65542331
65542342
65056597
20721234
65299461
58895090
64752935
64792430
65319754
60331757
65414759
65414785
65414787
65414828
27605422
65847065
65847089
65846990
65847058
65847037
65847044
65847016
65847043
65847071
65847050
65846977
65847094
65847070
65847042
65847027
65534663
59155648
65551317
65313110
65718782
65319769
65319748
65298113
65847072
65847048
65847038
65846984
65847000
65847055
65846996
65847053
65847108
65847081
65847080
65847105
65847104
65847061
65847045
65548430
65151005
65849030
65848967
65618099
65661825
65661927
65662121
65661975
65662089
65661999
65661867
65661895
65661831
65661890
65661896
65661877
65661881
65661824
65661875
65662150
65662091
65662245
65662257
65662243
65876664
65297319
65909242
65909588
65909586
55776334
65335419
65298557
65319740
28039317
65908873
65916426
65921910
65922029
65921884
65922149
65922140
65922274
65921900
65921939
65922109
65922292
65922231
65922198
65922355
65922369
65922398
65922352
65922492
65922502
65922376
65922469
65917162
65917085
65917086
65917022
65917219
65917472
65917164
65917430
65917255
65917355
65917474
65917220
65917256
65917473
65917218
65917499
65917679
65917745
65917741
65917730
65917703
65917680
65917590
65917746
65917681
65918145
65918143
65918037
65918138
65918034
65918135
65918139
65918147
65918031
65299646
65299830
65299765
65718709
65718600
65719123
65721348
65720624
65720612
65721532
65719470
65719498
62610682
65530443
65530619
65703348
62194381
35986265
65713504
65713521
65713515
65713498
65713506
65713512
65713520
65713508
65713509
65713517
65713501
65713500
65713514
65713513
65713518
65713503
65713519
65713523
65713511
65726345
65707716
65707678
65707532
65717173
65737114
66026809
65718836
65719122
65718883
65718919
15102356
65719212
65719579
65719519
65719214
65719228
54536367
23980874
24993332
24994419
27600552
65746674
65746684
65746683
65746692
65746641
65746636
65746666
65746672
65746682
65747343
65747357
65747359
44349769
44347932
44349635
64968489
62428369
62617320
62605100
62744854
61145959
61145678
61743560
61743569
61152831
61145650
61145897
63736824
61145735
61145929
61743562
61145960
61145893
61145908
61145855
61152776
61145634
63736830
64083338
63736899
63736910
63736902
63386231
64835549
64835664
64848910
63265833
64962862
64967898
64967474
64967709
65006067
66096371
66104422
66104407
66104343
66104376
66131681
66131699
66131677
66131679
66131694
66131645
66131685
66131647
66131643
66131692
66131642
66131724
66131715
66131764
66131774
66131736
66132331
66132290
66131828
66131900
66132289
66131814
66132069
66132085
66132439
66132292
66132083
66132440
66131821
66132348
66132056
66131960
66132051
66131925
66132291
66132136
66132394
66132403
66132357
66132084
66132059
66132086
66131832
66132010
66131829
66132118
66132032
66132049
66132392
66132354
66132329
66131931
66132016
66132333
66132132
66132053
66131980
66132729
66132899
66132731
66132784
66132807
66132746
66132569
66132905
66132804
66132696
66132781
66132463
66132547
66132750
66132572
66132508
66132441
66133027
66133070
66133066
66133002
66132978
66133072
66133060
66132994
66132960
66133011
66133805
66133759
66133904
66133886
66133726
66134007
66133725
66133702
66133704
66133686
66133870
66133956
66133751
66133826
66133776
66133840
66133778
66133897
66133806
66133865
66133867
66133915
66133837
66133862
66133964
66133828
66133830
66133703
66133795
66133878
66133892
66133715
66133814
66133948
66133750
66133885
66133735
66133827
66133793
66133757
66133754
66133856
66133773
66133816
66133739
66133916
66133724
66133804
66133756
66133760
66134150
66134148
66134215
66133841
66133792
66133800
66134046
66134151
66134135
66134091
66133700
66134109
66134107
66133696
66134094
66134130
66134105
66131948
66131961
66133944
66133993
66134019
66134263
66133973
66132459
66132264
66132148
66132322
66132601
66132145
66132138
66131879
66132045
66132574
66131959
66132128
66131765
66132573
66132607
66132295
66131877
66132265
66132323
66132037
66132602
66132277
66131855
66132600
66132692
66132618
66132293
66132457
66131941
66131878
66132038
66132274
66132278
66132143
66131862
66132342
66132966
66132909
66133162
66133168
66133169
66133217
66133125
66133090
66133063
66133153
65542345
65228335
65228271
65250604
65250843
65250968
65250624
65250543
65250970
65250592
65250597
65251116
65250664
65250594
65250508
65250613
65250725
65250460
65262724
65262561
65262652
65262586
65262564
65262772
65262644
64508509
64508531
65262975
65262833
65305321
64742564
64742560
66238030
66238088
65766048
65766063
65766068
65299827
65298874
65335239
65833361
61942403
65415281
65415498
65415479
64036544
37976450
65784901
65784968
34086997
34087005
65719581
65719120
65718651
65719465
65718653
65718918
65718644
65718685
65721263
65721590
65745129
64518443
65720630
65720388
65721167
65720020
65721163
65721361
65721222
65721706
66052517
66052538
66280389
47499099
66052495
61878612
64678693
51934196
51934192
62654055
66148484
65622272
65622314
66295895
65314826
66333043
51895495
51895496
65542357
65542333
65785149
64508551
64508629
64508503
64510178
65314696
65797168
65797165
65797166
65797171
40043035
38378533
64508587
66149718
66149611
61485967
61485799
61486002
65893186
65893167
65892992
65893608
65893261
65879110
65893298
66434540
65797145
54282653
54283470
54284332
54284038
54385889
54385857
54385777
54385833
54386039
54385839
54385893
54453197
54453262
54453267
54452999
54453266
54453233
54453154
54284870
54285314
54285222
54453450
54453429
54453611
54453607
54386360
54453670
54659952
54660051
66437164
66437167
55182023
57912423
57990898
57912428
57920604
57912424
59198227
64169865
66042048
66042228
66042297
61942229
66453822
66453585
47896562
47666237
66258686
66238057
65209960
65209794
58928108
18803377
35022761
29073395
29073780
64497463
21808792
66472670
52746136
52747649
52746125
52750592
52750596
52957205
52750612
59013129
66238032
66238028
66238090
65797172
66238047
64678749
64678786
64678799
66263099
65993073
58906027
66258676
66511565
66520139
66520135
66520134
66520149
66520137
66520131
65209799
65209966
65210012
65209951
65780953
59034924
47668460
47671927
52510180
52513327
52543489
52510063
52150413
65766032
66308637
66308665
66308641
51307462
65766054
66633569
65766055
65718877
66657879
66657905
66238092
65840922
65766031
52150429
52510097
52543477
52510080
40916873
40916875
58470392
40916869
40916864
40916859
40916877
66238036
66598326
64169852
66290274
45454460
65766064
65766061
47196478
59332401
66702589
66702590
65209954
65209798
66712486
52148162
66712698
66284848
52150412
62488147
66573779
66573771
52308122
66563965
66563963
66563973
66563959
66563971
66563972
66563976
66563957
66563968
66563967
66563962
66563970
66563960
66563958
66563966
66563974
66563975
66563956
66563964
66563961
66563955
66563954
66502683
66749681
66749678
66749676
66749680
63534438
63614508
1107589
66624800
65502155
65487785
65495665
60932670
60932697
60932674
60932693
60932676
60933220
60932682
60932684
60932680
60932691
60932652
60932686
60932703
60932695
60932699
60932672
60932689
60932688
60932701
60932678
53990233
53990232
54795678
54795679
65641709
65641710
65641711
65641712
16096788
3324471
66561415
66440769
66835975
66834114
66837283
66834839
66838381
65908877
66839630
66652821
65505332
62506256
51555798
65047563
65047582
65047791
65047750
65047571
55291590
55291589
65063796
65064003
65064874
65063797
65064839
65064831
65064838
65063804
65063965
65065029
65064918
65065054
65064963
65065056
65064920
66880547
66880606
20469772
22149053
66894997
22790813
24987404
66915901
66915895
66915896
66915907
66915906
66915899
66915902
66915908
66915905
27069729
27069747
27568966
27569003
27569011
66895553
28783666
66935111
30082750
66618385
66618835
31127213
30906972
32026680
32392648
65344987
33456392
66950964
65226543
65226536
66953132
37273068
36290583
37508566
38507016
38475042
38479002
38478956
38479006
38475038
38478975
38478978
38475041
38479019
38475050
38475051
38478998
38738778
38745250
38745204
38745208
38745219
39017370
39017372
66555851
66555852
39538228
39469587
39538227
39538057
39469584
66556786
66556785
66557211
66557201
66557212
66557202
35711657
35147522
35147589
35268045
35268052
35268381
66978138
42494736
42475549
42512995
63614796
60786998
59326693
65295559
66970932
66993710
66995890
67026478
67027970
67033642
67034082
42025548
42025567
42025528
42025529
42025576
42025676
42025636
67035580
65209795
65209793
65209976
65210933
65209977
65210022
66995895
66995901
66995873
66995815
66995891
66995893
66995900
66995875
66995943
66995897
66995892
66995898
67048476
42470903
65583599
65583601
65583726
65583685
65583603
65583628
65583746
65583759
65583648
65583707
65583600
65583738
65583660
65583747
67020458
64956823
66235550
66826467
66826470
66826469
66826471
66826468
54495145
44346493
64675680
64964215
64675681
64675709
64675687
66277367
67089530
67089533
67089540
67089537
44846048
44825680
45363246
59907187
46432054
45996991
67105483
47539466
48585142
67089564
67089561
67089556
67089551
51876785
49579229
51879578
52183341
52182891
52493837
52483557
52483562
52483531
52483523
52483540
52483555
52483546
52483543
52477784
52483547
52483545
52477787
52483533
52483556
52483548
52483525
52483550
67158352
28173992
28174132
28174012
28174129
28174134
28174558
28174562
28174552
28174595
28174568
28174566
28174553
28174587
28174571
28174596
28174550
28174554
28174548
28174561
28174570
28174557
28174569
28174556
28174574
28174381
28174551
28174577
28174573
28174597
28174549
28174545
28174576
28174584
28174564
28174567
28174586
28174555
28174579
28174593
28174582
28174581
28174588
28174589
28174563
28174591
28174578
28174580
28174672
28174624
28174611
28174754
28174599
28174638
28174671
28174608
28174647
28174695
28174670
28174644
28174650
28174612
28174648
28174652
28174621
28174634
28174637
28174663
28174605
28174677
28174598
28174653
28174674
28174665
28174675
28174657
28174799
28174609
28174636
28174625
28174627
28174751
28174619
28174673
28174626
28174660
28174629
28174659
28174633
28174615
28174666
28174750
28174655
28174651
28174623
28174639
28174667
28174797
28174640
28174642
28174604
28174662
28174678
28174603
28174617
28174649
28174641
28174661
28174614
28174622
28174676
28174618
28174610
28174600
28174643
28174616
28174613
28174601
28174620
28174630
52927685
52927688
52927678
52927669
52927700
52927671
52927663
52927684
52927683
52927686
52927694
52927681
52927695
52927661
52927693
46438908
53918416
55294943
55294942
55294758
55294759
55696105
55696178
55695262
49409070
49409071
49409069
57106890
57532853
58986209
58986192
58986202
59166329
59153567
59166328
59158542
59147908
59570683
59541416
59541412
59541417
59541405
59777857
59777952
59777896
59777816
59779229
59778483
59779109
59779159
59779139
59779213
59779165
59779169
59779191
59778418
59779174
59779149
59908218
59908223
59908224
59908221
59907190
59908219
59908220
59908210
59907181
59908215
59908222
59908216
59908225
59779503
59779320
59779582
59779443
59779459
59779466
59779414
60757306
60682361
32891187
24892257
67245906
67245914
67246009
67246003
67246360
67246022
67246734
67246757
67246772
67246459
67247280
67247359
67228259
67228238
67228237
67228254
60161799
67247872
67247946
67247875
67247947
67246695
67247749
67247870
67247736
67247386
67246668
67247732
67248398
67248395
67248191
67248643
67248484
67248482
67248382
67248146
67248422
67248621
67252437
67252453
67252434
67252466
67252464
67252444
67252459
67252456
67252462
67252451
67252460
67252468
67252447
67252439
33050269
62485971
62485192
67288615
61487506
67254038
67341066
67332714
67228394
67228393
64532827
61877764
67229036
67331627
67331790
67332673
67356074
61359091
67333124
67333128
67333121
67333129
61487248
61487209
61487214
61487285
61487119
61487291
61485976
61487243
61485744
61485993
61487275
61485990
61485730
61487168
61485987
61487225
61487566
61487198
61487241
61487147
61487185
61487234
61485988
61487264
61485794
61485746
61487258
61485771
66881010
62401793
65379255
62326921
62292479
62066641
62344296
62596877
62506377
62506269
62506428
62506336
62509211
62506226
62506276
47352899
63386151
63826927
63826943
63895900
63896037
63895933
63895923
63895937
63895899
63895890
63896001
63896000
63896023
63895889
63895976
63895878
63895990
63895911
63895884
63896040
63895920
63895916
63895905
63895886
63896007
64017907
64017908
64078259
64078239
64170397
64183813
64283527
63647163
64604445
64883258
64883251
64883237
64883241
64883255
67388736
65029437
65228287
65228355
65295632
65295631
65297453
65396272
65250667
65250637
65250708
65250485
65250668
65262559
65263099
65263033
65263237
65262598
65262902
65312087
65406122
65405654
65406058
65405736
65406346
65406299
65406110
65405623
65405831
65405871
65405636
65405716
65409606
65409464
65409646
65409435
65409487
65409642
65409633
65406747
65406410
65406750
65406649
65406777
65406502
65406634
65406843
65406769
65406784
65406459
65406672
65406697
65406448
65410018
65409932
65409730
65409819
65410084
65409905
65410116
65409732
65409771
65409759
65410108
65410130
65409864
65409798
65409736
65409947
65407037
65407027
65406984
65410184
65410218
65410300
65410285
65410292
65410279
65410330
65410246
65410152
65410265
65410151
65410153
65410187
65439391
65530321
65530649
65530335
65529198
65528742
65529183
65529184
65529249
65463308
65617391
65617556
65616388
65616654
65681775
65719233
65720362
65746693
65746650
65766066
67402978
67390543
67390540
60161917
64488250
65922346
65922304
65922317
65916855
65916854
65917089
65917092
65916941
65916940
65917188
65917159
65917189
65917166
65917090
65916864
65916990
65916866
65916939
65917155
65917187
65917179
65917094
65916988
65916853
65917157
65916852
65917165
65916989
65916867
65917501
65917559
65917353
65917586
65917286
65917358
65917395
65917359
65917600
65917275
65917396
65917558
65917588
65917352
65917735
65917803
65917734
65917836
65917838
65917804
65917790
65917733
65917740
65917807
65917777
65917837
65917633
24218703
66102878
66133728
66132395
66133047
66131775
66132004
66131890
67405730
67407443
67407294
67407320
67407257
67407516
67407343
67407440
67407466
67407518
67407517
67407911
67407659
67407838
67407567
67408128
67407914
67408224
67407986
67408462
67407768
67407720
67407657
67408448
67408065
67407719
67407715
67407849
67408151
67407710
67407559
67408129
67407714
67407767
67407840
67407665
67407913
67408145
67407954
67408094
67407769
67407680
67407972
67407713
67407660
67407839
67408150
67407790
67408542
67408575
67408511
67408516
67408513
67408576
67408539
67408515
67408484
67408551
59194132
67407872
67407915
67407530
65846974
65846978
65846982
65846975
65846979
65846983
65846987
65847102
65847060
65847015
65847018
65847014
65847064
65847041
65847013
65846991
65847057
65847005
65847026
65847003
65846994
65847011
65847086
65846998
65847074
65847034
65847078
65847093
65847111
65847067
65847022
65846995
65847063
65847049
65847023
65847103
65847030
65847024
65846989
65847073
65847112
65847062
65847020
65847033
65847091
65847079
65847090
65847035
65847101
65847008
65847107
65847069
67423243
67423249
67423267
67423276
67423291
64848978
67463141
67461408
67457480
24829795
67463588
67443979
67467957
67028963
67028996
42450675
61197145
67405809
67407971
67407980
67407775
67407414
67407871
67407529
67407950
67408009
67407870
67407973
67408010
67407968
67408061
67407797
67407965
67407198
67407949
67407979
67408020
67407951
67407868
67407867
67407857
67407557
67407869
67408005
67407522
67407996
67407969
67407629
67407722
67407802
67407880
67407236
67407953
67407261
67408001
67408583
67408586
67408541
67408164
67408461
67408222
67408590
67408203
67408452
67408519
67408182
67408135
67408475
67408096
67408127
67408232
67408443
67408506
67408572
67408202
67408569
67408192
67408545
67408540
67408589
67408570
67408596
67408479
67408183
61145952
67530481
67530157
67530459
67530460
67530164
67530098
67530535
67530160
67530165
67530457
67535189
67530123
67530068
67530401
67530067
67515253
67459884
52140870
65766059
63977685
65036849
65036899
32753256
61195799
67577875
63623449
63623482
38203013
59848735
62342809
60160609
60160076
60236882
59844192
60162464
65718880
61941861
65852540
66238125
54269661
65693020
23813826
67597704
63755981
36653681
23306496
65766030
65766058
65766052
65766028
64631605
44386299
61349773
65708247
47352879
65766049
65766067
66939769
54975410
52468760
50839708
67625478
54268358
54268495
67623712
67623707
67623713
62736989
62736983
62736988
62736990
67634006
67634015
67634012
67636756
67611813
67646983
67649553
67647969
67647998
67646843
67621639
67621531
67615888
67690256
67708851
67708848
67708857
67708854
67724182
66908431
67742706
67742485
65146943
66954504
66434535
67805817
67805821
67789945
66623964
67810356
67810357
67810546
34615154
67812134
67812140
67812133
64752983
67818746
66623264
66497118
66381041
59579884
67808303
64361147
67432340
64504246
63518573
67807498
67838677
67835443
67734122
67852036
67841626
67843416
67742897
67742887
67742901
67742864
67742902
67844333
67940220
1189709
22955254
22955498
22955141
22955127
22955226
22955259
22955217
64367928
64367937
64367945
64367926
64367956
64367930
64367961
64367952
64367924
64367931
64367950
64367936
64367955
64367925
64367949
64367954
64367938
64367951
64367940
64367935
64367953
67957087
66830774
66830520
66830402
66830769
66830452
66830783
66830731
66830825
66830517
66830377
66830716
66830422
66830444
66830689
66830606
66830587
66830471
66830631
66830822
66830646
66830763
66830732
66830486
66830701
66830566
66830376
66830611
66830585
66830482
66836419
66830841
66830847
66830838
66998802
67976156
67976114
67977986
67979455
67976155
67980177
67980208
67980927
67980214
67981025
67989898
59541409
38378626
52510186
61942367
65766043
65766044
65335041
66066275
65345162
68002324
67210439
67210437
37271245
67964374
67964375
60976272
66830489
66830745
66830535
66830599
68008644
66836516
66836459
66836461
46026912
67169743
67183799
37269511
37406270
37326046
38709052
63935018
64783197
17484595
67392461
57920307
54385785
54453338
54453786
54453248
54386411
60223219
60071890
60071917
60071959
61145889
68013366
64392484
64392501
64392493
65298213
64178156
65298440
64488060
64488029
64488263
64488062
64488033
64488399
66317628
66317355
66317300
66318009
66318035
66318112
66318247
66318082
66318504
66365438
66365475
66365437
66370574
66370996
66371305
66371009
66367267
66369807
66369806
66379728
44349656
67330233
67330231
67330330
67330245
67330230
67330236
67953128
68008799
67511508
67538701
67550315
67514056
67535463
67570431
67535205
67536361
67568942
67521435
67567536
67570499
67535616
67570635
67698886
67699764
67699613
67696300
61070430
64964282
67699320
67570552
67618683
67618984
67618681
61942308
67827670
63515793
68044973
68045066
68045058
68045061
68045062
68045063
68045052
68045055
68045064
68044697
67616111
61942291
61942242
61941798
61942270
61942232
61942716
61942421
61941885
61942161
61942415
43830064
66435370
67619041
67807732
44943818
63935021
64763159
67564855
38374253
37325358
37326133
67840154
66435361
65533293
63738248
67834154
25397926
45037934
45037930
45037908
45037921
68078542
68078547
68078515
68078897
68078894
68075594
68075463
68075542
68076567
68075736
68077539
68077776
68077540
65899104
65854359
61942246
61941807
61942158
61942222
61942230
61941853
61941955
61941886
61942479
61942741
61942699
61942388
61942396
68090561
67794960
65845530
64155978
64155895
64156040
64155953
64156280
67890667
64156043
64155914
64156013
64156095
64156035
64155946
64155994
64155982
64156033
64155948
64156081
64155939
64156006
64155941
64156046
64156118
64155928
64156252
64156163
64156174
64156304
64156312
64156179
64156299
64156241
64156229
64156211
64156218
64156145
64156288
64156180
64156157
67265720
68097799
68097796
68097794
68097797
68097801
68097803
68097800
68097798
67886761
61209224
67785281
67504863
36905836
64778277
10588856
21594616
10588855
21594686
10588859
10588861
10588867
10588853
10588863
10588866
10588857
10588862
21494792
10588860
21494815
67721756
45775746
67028981
53673944
55779524
38376975
37325008
37544713
37544610
37323477
68122127
68122185
68122234
61271554
63935026
67994956
32392692
68157491
68157557
67868197
68160343
68160604
68160620
46835624
68157340
49182498
68071961
43939650
67530784
37070129
67564860
68189332
68189331
68189820
67660147
35123190
68197309
65249547
65209815
65209817
65209814
65210961
65210948
65210969
65209971
65209829
65210951
65209890
65209828
65210960
65209835
65209832
65209980
65210029
65210971
65209947
65209940
65210934
65209860
65209989
65210972
65210965
65209982
65210973
67644865
67644870
67644863
67674508
68220443
65210936
65210931
65210010
65210941
65210006
65210014
65210937
68240238
68144653
68250044
68250795
68250550
68254957
68254923
68254926
68254920
68254954
68254961
68254902
68217136
68217154
68227951
68217173
68223812
68223805
68227960
68223816
68217174
68227957
68230784
68223820
68217166
68223818
68223819
68217140
68217163
68244202
68244219
68244196
68244158
68244154
68244229
68230838
68253768
68253657
68253631
68253836
68253589
68253608
68253752
68253617
68253659
68253807
68253860
68253683
68253718
68253701
68253776
68253678
68253620
68253835
68253769
68253611
68253764
68253849
68253848
68253846
68253785
68253801
68253783
68253702
68253822
68253651
68253754
68253604
68253580
68253669
68253639
68253847
68253605
68253797
68253830
68253637
68253601
68253753
68253579
68253582
68253755
68253728
68253703
68253730
68253765
68253828
68253638
68253679
68253680
68253640
68253918
68253913
68253874
68253942
68253917
68253951
68253923
68253940
68253941
68253916
68253909
68254929
68254908
67451682
68327520
68331585
68331579
68332984
68318659
68236113
68236136
68236126
68235587
68235943
68235577
68236112
68235800
68235836
68235579
68235571
68235552
68235631
68235584
68235591
68236084
68236004
68235527
68236094
68236121
68235771
68236107
68235727
68235924
68235921
68235839
68236115
68235734
68235595
68235953
68235665
68235518
68236143
68236118
68235768
68249369
68249527
68249564
68249432
68249599
68249592
68249405
68249377
68249639
68249388
68249680
68249651
68249403
68249669
68249418
68249590
68249523
68249376
68249580
68249424
68249681
68249393
68249653
68249521
68249425
68249624
68249517
68249655
68249378
68249597
68249515
68249668
68249404
68249650
68249652
68249656
68249625
68249654
68249525
67381339
68236256
68236273
68236225
68236204
68236202
68236215
68236255
68236276
68236178
68236257
68236248
68236235
68236245
68236172
68236186
68236249
68236223
68236220
68110685
68110691
63755954
37323212
37323415
37281082
37324640
37324981
65544297
67811901
56095903
68350315
16110075
37817947
37405031
68351768
68351735
68351762
68351777
68351744
68351741
68351738
68351783
68351786
68351774
68360842
66042096
66042222
66042170
66041971
57418824
67109684
68331532
68331514
68102751
68013684
65766047
65766062
68014191
68392120
53655373
21809181
61878390
61878384
61881595
68438368
68438929
68172882
66916091
66916080
66916089
66916082
66916086
66916078
66916084
66916073
66916070
66916065
66916071
66916076
37325655
37323222
37323276
37544664
37544565
64510255
58895095
66361384
65720394
65797169
57684839
57684921
65766045
10548968
67803634
68199588
12803570
67803852
68540588
67803708
67803669
28174631
68542180
67390539
36048655
38509434
67810756
67156400
68550848
67812132
67159110
41657793
67159465
67532909
67532906
47667032
47673401
47897317
47500385
59158462
59907194
59907184
59907185
59478467
62654013
63761821
63761887
63868167
63868023
63868364
63762219
65037875
65093629
65228230
66132307
66511016
66995762
59582613
58569338
58569366
59579693
58569357
58569321
58569319
58569345
59579692
58569370
58569334
58569330
58569308
58569362
58569360
58569355
58569316
58569341
58569373
58569312
58569350
58569348
58569375
67058368
67057486
67228642
67228687
67228866
67228834
67246714
67247039
67247657
67247643
53305477
68421305
67332633
67332607
67332554
67252435
67252449
67252443
67252442
67252448
67252438
67252446
67252441
67252454
67252458
67252463
67252471
67252469
67408191
67407664
67407837
67477850
67477875
68590499
68590500
68591644
68592957
24120613
68641538
68575143
68575145
68649027
68102822
68674693
63131466
50622608
50622550
50622565
52740719
52740728
68699192
68701344
47156502
47156520
47156482
47156491
47156495
47156510
67532903
67532910
38375043
43066968
67642184
67555961
67811907
67783960
67797479
67797476
67797474
68718240
68718115
49183051
64783223
64783170
67886928
67981564
67981412
63846781
68102620
67949752
68013703
67949754
63761888
63761911
68721088
68721118
65845697
68221980
64497466
11672781
62302556
67976070
67976069
67980491
67980876
67980898
67981759
67980913
67981784
67980451
67980901
67981011
67981038
67980459
67981053
67981367
67980943
67980905
67981023
67980919
67980915
67981020
67981785
67981399
67981403
67980922
67980481
67981017
67980930
67981039
67980446
67981015
67980920
67981755
67981364
67981016
67981402
67981753
67980928
67982299
67982230
67982250
67982337
67982271
67982232
67981802
67982256
67982261
67981807
67982254
67982248
68724103
68724100
68724097
63518614
68725127
68726190
68729567
64504240
63515733
68319929
37544641
37405654
67981366
67981018
67981019
11688312
38378632
41704120
68102897
68659058
68659059
68659062
68659060
68659061
68659057
58990095
66036195
66036182
66036206
66036180
66036176
66036209
68641535
68773763
26136741
68787186
68787188
68787085
68787270
68787301
68787192
68787194
68787088
68787084
68787200
68787184
68787228
68787112
68787190
68787086
68787252
68787138
68787137
68787187
68787299
68787087
68787083
68787300
68787139
68787487
68787604
68787488
68787366
68787354
68787520
68787521
68787522
68787518
68787519
68787546
68787574
68787530
68787448
68787393
68787392
68787370
68787596
68787365
68787471
68787490
47499338
47672206
68813955
68813959
67908284
65209955
65209953
56537434
56537435
68837370
68837617
68837620
68837522
68837424
68837149
68837422
68837484
68853384
68853279
68853416
68853372
68853360
68853400
68853391
68853281
68853306
68853410
68853335
68853300
68853417
68853298
68853361
68853413
68853368
68853421
68853336
68853396
68853270
68853395
68853385
68853435
68853376
68853319
68853365
68853318
68853359
68853332
68853389
68837368
68837260
68837316
68837193
68837669
68837528
68837489
68837400
68837676
68837367
68837541
68837168
68837524
68837406
68837508
68372378
68462306
65850613
68372432
64337017
41160096
37269198
66148462
67649298
62533447
39457960
68937672
46843565
37544611
68927122
68723502
68723517
68723894
68723893
68723561
68723508
68723598
68723539
68723550
68723535
68723556
68723555
68723923
68723935
68723917
68723918
68723913
41162407
68699887
68700076
68699896
68700131
68699899
68700083
68699885
68700115
68699888
68953609
68953610
68712408
68997466
69001411
59148880
68013367
67843678
69046103
67843653
67620138
65297906
65297470
65297417
67024588
29128260
66622700
28731558
68528939
65200741
67830526
67830484
67830504
65975714
65975469
65975467
65975498
65975422
65975733
65975720
65975463
65975494
65975426
65975445
65976195
65975985
65976182
65975941
65975973
65976196
65976197
65975934
65982599
65982654
65982614
65982551
65982637
65982557
65982671
65982583
65982679
65982567
65982608
65982613
65982561
65982625
65982560
65982600
65982652
65982666
65982633
66163553
66163572
66163687
66163789
66163751
66163498
66163552
66163525
66163668
66163688
66163807
66163591
66163523
66163640
66163601
66163662
66163620
66163542
66163672
66163623
66163817
66163837
66163850
66163873
66163844
68562722
68562728
68522976
68522977
68522969
68562720
68522975
68597994
68598022
68597998
68598016
68597993
68597950
68598002
68597948
68597986
68598004
68597967
68598011
68597966
68597989
68597955
68598030
68598024
68597991
68598007
68597997
68597977
68597980
68597949
68598010
68597963
68598017
68597969
68598020
68597976
68597990
68597970
68597987
68597995
68597956
68597983
68597984
68597975
68597985
68694210
68657403
41704119
69117666
47275155
63423156
66361306
68983459
68953608
65982683
65982569
68598009
68615909
37405838
49411146
63137354
68989596
68989608
68989775
68989581
68989737
68998260
69129380
69129382
69063487
69000851
69130127
69130269
69012513
69130888
69130701
68989888
69130610
69130375
69130497
69130368
68425631
69129952
67830459
69129440
69129565
69129408
69129476
69129472
69129409
69130565
64422888
64213381
52468829
67748778
67774480
49410523
68330388
47895635
38709374
69144784
61036246
61036244
65973114
65893441
67067769
69038537
68803048
68857101
68857060
40447028
69132098
69096154
69095203
69095982
69095530
62798275
69065072
69038523
69038180
69038172
69038124
69038559
69077211
69078973
69117694
69078247
69078263
69118008
69094119
68946565
68943001
65973072
65973119
69008891
65171727
65200733
65200743
68567064
69017209
67530785
67792120
67792166
68715064
65298604
64169934
63771016
69199437
65344807
69077729
69077059
69082740
69082749
69038551
69038580
69038173
69077070
69077079
69038195
69183679
69183643
69183666
69183678
44771811
64170522
69118076
65335463
65344820
66011873
58895731
69144782
69144315
69144700
69193369
69169404
69118012
69172635
69146551
69144798
69247345
69094090
69094101
69093995
69094107
69093914
69093953
69093916
69093918
69094089
69094122
69094116
69094023
69094115
69093930
69094022
69094074
69094036
69093912
69094030
69094114
69094121
69094086
69094105
68901425
68899261
69134028
69162130
69255677
69255719
69172651
68723521
68723928
68723895
69177445
68723898
69176500
69176475
68723941
68723927
58993055
59072718
69185258
44341103
46333295
69185324
65459474
63623483
53533252
53533269
69268059
69268050
69268062
69268060
69268054
69268056
69268048
69268055
69268052
69268063
49833242
69038161
69038508
69038105
69038106
69038568
63971170
69193531
69101550
69310150
69310667
37405627
59749233
69312278
69312254
69312286
69312544
59266312
69307112
69307119
69306882
69306818
69306967
69307193
69307291
69307325
69307303
69307449
69307298
69307381
69307425
69307192
69307296
69307228
69307292
69307437
69307231
69307312
69307447
69307382
69307297
69307313
69307397
69307524
69307607
69307750
69307609
69307714
69307707
69307875
69307614
69307752
69307523
69307719
69117793
65902649
69220924
69220902
34914612
34914105
34914259
34914382
34914319
34914170
34914591
34914476
34914323
34914100
34914394
34914075
34914419
34914555
34914091
34914119
34914348
34914056
34914286
34914114
34914270
34914408
34914149
34914630
34914344
34914218
34914245
34914572
34914304
34914651
34914326
34914057
34914053
34914547
40454910
43581500
49289131
52190514
52077861
47400078
55649874
53428454
54193513
52992231
53428805
53428800
53428803
52992229
53428798
53428801
53428806
69313017
53428802
53428799
53428804
69306920
69362901
69348211
69382381
69382447
50988243
63868302
69399266
69423653
59540500
69443125
69427416
69455172
69471145
69410708
33613172
69457544
69457555
69463842
69463843
33613210
33613717
33613923
33613736
61558790
61558858
61558791
61558848
61559032
61558929
61558942
61558964
61558962
61559221
61559066
61559276
61559209
61559172
61558900
61559258
61559364
61559423
65898652
65485246
63934994
59578607
59496326
58243371
66996016
66996011
69121137
60729299
61487582
61487536
61487585
61487267
61485749
61485981
61485764
61487184
61487130
61487232
61487290
61485808
61485728
61485748
61487126
68550069
61877775
65047619
65583712
65530592
37668236
37668195
37668186
37668239
37668187
37668219
37177788
37668189
37668235
37668237
37668215
37668204
37668226
65062001
65062002
65063975
65063828
65061952
65063918
65063808
65064887
65064894
65064969
65064902
65064937
65064871
65064923
65250990
65250573
65250607
65251020
65250837
65250503
65251012
65251118
65250665
65251018
65250936
66361327
66361396
65661861
66052506
66345591
66134258
66133918
66133675
66133876
66133888
66133977
66134117
66134168
66133798
66134101
66134002
66133935
66133850
66133784
66133710
66133818
66134196
66133868
66134062
66134172
66133774
66133694
66134174
66133681
66133764
66133731
66132267
66131926
66132344
66133006
66132427
66131781
66132341
66132404
66132740
66132013
66132088
66132545
66132297
66132630
66132460
66131962
66132506
66131930
66132096
67252932
67252943
67252937
67252948
67252936
67252922
67252944
67252933
67252941
67252935
67252942
67252929
67252938
67252940
67252930
67252947
67504862
67530534
68117900
68124766
68117906
68117890
68117886
68124767
68117889
68124762
68124764
68117892
68117898
68250227
68250225
68250226
68250235
68250237
68250215
68250236
67843916
67957797
68067415
68070657
68037958
68113911
68102264
68102749
68182238
68160561
68223821
68241471
68276829
68248053
68414060
69517053
69518574
69519214
68665844
7690630
69317983
68717701
68717699
68717702
69038101
69220884
69220903
69172764
69255698
69255700
69255341
69310646
69310648
69310678
69309914
69310680
69310660
69311575
69310144
69309929
69311596
69310622
69310655
69311595
69310171
69310682
69309904
69309920
69309915
69312523
69312291
69312277
69312500
69312269
69312283
69312258
69312540
69312508
69311618
69312284
69312534
69259054
69355682
69268684
69268609
69289758
45006815
59024878
38375341
63603619
67234729
63060484
65766039
69354834
69077411
69038171
69038179
49411156
66235562
69311615
69310644
69473303
69473350
69473367
61466684
69473441
69473445
69551961
69593252
69593245
69593368
69593285
69584381
25718562
69585304
69585289
69601691
69601690
69602927
69654604
69426987
69427415
69672597
69672223
69146588
68943024
64973564
69682681
69682711
61036243
58810884
67932178
67930364
67931495
67931715
67930843
67930336
67930332
67930325
67931501
67930312
67932179
67931756
67931749
68221281
68221280
69162477
69307392
69307036
69307826
69354457
69414380
69414384
69414383
69414370
69414372
69414382
69414391
69414378
69414374
69693391
69693388
69693389
65685850
65685838
69517080
69517806
69517058
68866218
67285162
69221086
69221087
69146515
69254189
65609230
58810542
69354381
69354371
69354440
69354454
69705105
67931768
67932157
67932160
67930365
67932159
67932118
67930868
67930366
67932161
67931752
67930820
67931683
67930819
67932791
67930359
67930815
67930821
67930335
68008288
68553380
68359691
69709566
69444560
52148701
69312223
49409685
69309936
69310145
69309950
69309903
69309939
69309894
69310157
69310177
69312256
42833327
69468704
69290388
69290446
69290433
69289730
69289749
69289741
69289753
69289695
69289833
69289738
69289686
69289678
69289760
69289685
69289727
69290453
69290469
69290463
69290542
61740574
69700796
61740578
65335176
69517803
69517856
69518586
69518567
69518570
69519213
69518582
69517855
69518559
69518580
69518627
69517840
69517807
69518576
47865388
69550554
69412554
69421437
69421682
69421596
69421259
69421887
69421804
69731191
65847085
69731214
69731216
69731219
69731218
69731222
69731217
69731215
59029920
59024244
69759039
69576679
69576683
58408471
67799536
69654687
69682487
68898285
69568791
69390750
69306233
69309026
69306260
69308919
69306527
69817071
69816198
69816194
69816203
69571289
26565512
69604207
37269761
37405839
69029204
69731074
69654661
69835362
38709196
68425705
68425649
68425659
68425684
68425715
68425640
68425655
69775143
69775154
45407230
69842590
69842577
69840614
69840693
69840682
69842639
69855297
66498964
69673262
69673261
41387962
69639458
69614566
44960613
68699863
69626247
69871485
61740577
62769639
62769533
62769706
62769540
62769493
62769773
62769434
62769385
62769494
62769660
62769708
62769715
62769471
62769579
57859421
57859406
62769436
62769769
60706202
23308647
37405632
69723746
69723679
69723893
69700986
69723837
69723726
69723686
69723703
69723555
69729544
69729378
69729529
69723894
69723805
69916940
69920439
69922440
69922426
69922442
69922419
69922445
69922444
69922417
69922447
69922441
69922446
69922439
69966051
69966009
69966080
69966038
69966012
69965992
69966001
69966010
69966025
69966014
69966015
69965981
69965998
69966081
69966063
69966043
69966053
69966067
69965996
69966086
69966006
69966005
69965983
69966013
69966018
69966023
69966065
69966011
69966034
69966000
69965993
69966036
69965986
69966019
69965987
69966045
69966050
69966083
69965984
69966077
69966017
69966004
69965990
69966035
69965989
69965979
69966024
69966016
69966076
69965997
69966002
69966041
69966033
69966030
69966071
69965999
69966079
69966070
69966042
69966046
69966020
69966059
69966058
69965988
69966060
69966054
69966072
69966039
69966056
69966008
69966044
69966003
69965991
69966064
69966027
69966007
69965995
69966062
69966040
69966032
69965994
69966055
69966022
69966078
69966047
69966052
69966061
69966028
69966068
69966057
63755957
69682490
69747501
69985837
43140131
69922438
69922443
69983673
69983664
69983559
69983647
69983630
69983558
69983593
69983562
69983572
69983579
69983596
69983600
69983576
69983637
69983635
69983582
69983669
69983594
69983584
69984190
69984186
69984274
69984275
69984207
69984226
69984306
69984230
69984347
69984395
69984268
69984277
69984217
69984177
69984427
69984181
69984260
69984239
69984228
69984250
69773144
69943152
69943150
69943197
69943159
69943186
69943192
69943177
69943194
69943198
69943166
69943170
69943157
69943190
69943188
69943151
37271234
69999846
69999784
69999835
69999773
69999852
69999820
69999777
69999813
69999829
69999824
69999786
69999818
69999788
69999826
69999799
69999795
69999775
69999844
69999834
69999774
69999842
70029828
69867963
52045194
61074208
39013110
36996351
36986709
36986711
37002497
37002502
37002499
37002477
37069364
37070120
69480986
69480857
37283351
58990291
62067164
62066942
62066469
69924373
69924383
69924322
69924331
69924399
69924384
69924382
69924356
69924395
69924363
69924385
69982963
69983114
69983890
65893598
69307305
69307403
70023482
69736127
36682234
69924323
69924368
69924398
69121170
67689133
67689334
67689268
67688991
67689214
67689020
67689108
67689182
67689147
67689091
67689155
67689284
67689281
67689244
67689003
67689006
67689343
70106636
68956419
68956855
69552742
70106640
69938770
67689352
67689337
69411455
70106635
69411454
67689345
69993472
69695144
70136740
70136747
70136745
70136741
70136761
70136743
70136750
70136739
70136737
70136749
70136738
70136736
70136754
62768726
62768749
67916494
67918113
67932375
67932273
67932262
67932501
67922151
67919967
67924239
67927861
67932538
67929946
67932694
67932718
67932696
67932712
67935930
67935921
67936025
67926531
67926087
67933760
67936274
67936292
67936294
67936056
67936288
69924340
69924347
41882279
70170232
70170340
70170266
70170211
70170209
46083079
69847669
70170948
70170927
70170648
70170565
70170934
70170639
70170563
70170619
70170647
70170605
70170935
70170566
70170628
70171220
70171006
70170954
70171235
70171112
70171164
70171161
70170974
70171226
70171180
70171104
70171159
70170997
70171102
70171020
70171004
70171018
70171097
70171212
37325685
60460638
70175874
70001502
69983026
69983015
69983126
69983039
69983088
69983131
69983090
69983144
69983135
69983093
69983119
69983037
69983034
69983065
69982978
69983865
69983856
69983874
69983922
69983866
69983926
69983898
69983861
69983872
69983876
69983896
69983886
69983899
69983900
69983863
69983897
60681984
31728190
66238679
66622677
66622714
47156477
30889899
32446417
4040646
70231857
69722804
69722801
69722811
41351249
41351247
41351240
41351241
41351238
41351245
44771061
44921970
44921965
45364813
45364816
45356069
45351328
45354011
45354008
45369344
45347629
45356675
45347006
45345533
45356340
45356333
45365091
45352751
45347677
45347597
45365598
45365083
45346963
45352680
45365099
45365089
45382143
45355861
45347038
45346920
45369349
45356169
45365096
45347697
45345541
45352678
45349042
45356660
45345562
45382192
45346936
45345552
45351375
45345498
45353961
45347605
45356666
45351342
45365558
45349118
45364836
46835764
45597863
46835707
46835767
46006951
47188973
46855582
48017728
48097622
48017717
48273081
48020216
38378535
49953907
50151539
49953872
50439871
50396068
51297342
52483414
53385266
52326000
53385283
54521989
56087934
55275122
56087956
56087943
56258361
56088085
56087940
56087914
56088068
56088038
56087918
55275149
56088078
56087959
57816880
57868548
58279232
57901717
57897189
57939772
58279254
57897119
57868580
57901715
57817018
57901700
58627211
57910504
57888948
58990089
58949462
57897187
57848807
57816884
58279226
57940527
58596367
57888958
59575857
59148907
59148899
59148707
61927935
61425125
59632162
65533895
65533328
65530744
62653121
64082252
64082251
64081187
65200720
65200727
62769816
63256989
67597695
67788658
68432857
68432832
68102622
68102604
68102111
68102113
68102112
66487440
66484494
66487300
68747445
68725041
45230479
68121865
68868179
68824104
68824217
68824304
68824402
68824122
68824108
68824282
68824115
68824491
68824290
68824465
68824216
68824095
68824088
68824802
68824784
68825995
68825468
68826022
68825896
68826031
68825875
68824948
68824971
68825465
68825870
68825889
68825807
68826032
68826020
68825908
68825825
68825981
68825915
68826042
68825808
68826362
68826268
68829079
68826093
68826320
68826363
68828933
68826196
68826288
68826366
68826348
68826092
68826255
68826305
68826342
68857112
68857063
68857047
68857121
68857054
68857089
68857138
68877051
68910472
68895685
68895791
68895497
68895782
68895500
68895788
68895536
68895785
68895619
68927123
68993351
68989622
68989621
68989637
68989822
68989808
68989599
69011950
69016490
69146686
69146539
69145986
69078169
69077218
69078357
69078293
69172648
69172652
69078272
69129607
69130488
69193207
69185157
48219580
52452561
60682353
62255337
62255335
61798230
70068642
70065699
70065706
70065704
70068638
70068617
23729320
32858291
70273783
70273786
70273802
70273816
70273819
70273795
32858297
60667103
60668092
60676091
60656502
68827844
70103447
70068527
64170531
68700071
68700073
67797952
58078783
58078784
58078782
53428630
70273800
58603985
69187663
70117742
70117716
70117764
65938405
68751057
68599338
70196531
69944090
70106824
70256668
70256681
70256528
70256593
70256529
70256530
32211587
32211586
37325659
69924379
69924381
69924378
69924337
69924333
69924380
69924329
69924369
69924332
69924396
70293236
68824141
68824366
68824191
68824274
68824367
68825250
68828932
68825978
68825787
68829091
68824417
68824432
68825190
68825482
68825447
68825762
68825443
68824416
68824992
68826061
68826063
68825790
68824495
68824400
68824419
68824493
70296463
70296345
70298295
70298483
70298478
70298745
70298744
70298746
70298524
70296907
70296903
70296904
70296905
70298129
70296913
70298131
70296908
70296914
70296912
70296918
70296909
70296906
70298814
70298793
70298813
70298375
70298806
70298377
70298372
70298816
70298405
70298811
70298580
70298378
70298373
70299169
70298907
70299170
70299174
70299167
70299160
70299166
70299161
70298910
70299153
70299151
70298998
70299018
70299020
70299041
70299006
70299026
70299017
70299027
70299011
70299016
70299013
70299030
70299029
70299014
70299253
70298994
70298827
70299019
70299208
70299216
70299250
70299254
70298997
70299251
70299255
70299042
70298912
70299321
70299172
70299313
70299322
70299644
70299670
70299672
70299674
70299668
70299649
70299715
70299720
70299716
70298371
70299724
70299682
70299722
70299706
70299707
70299686
70299732
70299671
70299717
70299690
70299721
70299725
70299010
70299159
70299673
70298374
70299023
70299252
70299259
70299712
70298526
70298818
70299224
70298376
70298911
70299718
70299330
70298992
70299714
70299727
70299028
64973006
68010537
60725838
68857045
66622761
70238742
70238718
70035391
68327478
69759418
69759378
69759383
69759364
69759412
69759384
69759356
69759381
70267074
43874584
70257919
38380720
62005628
62180932
62181131
62180765
62180778
50395614
37325039
70283103
70283159
65542680
70090866
69172650
69306918
70020663
70020662
41003564
69169352
70280005
70126182
67530754
67530755
65621386
67872408
30389139
59149482
67530786
66482873
70348845
70348839
70348844
60677203
59078834
63334185
58331091
70357978
70357983
70357984
70357980
70357982
70357981
70357979
66500403
70354254
70354249
70354250
70039116
69077408
70035417
69759382
69759374
69759407
68999072
68826067
70311808
70311778
68183366
62755493
68183673
68182580
45112024
68183273
69729516
69729497
69729519
39537807
39537677
39537923
39025603
51877713
64973419
70433579
70433565
35806600
70090634
68725040
44349634
70440836
60661198
60460620
60669230
60460622
60668095
61036245
70313890
70391330
70442946
70442960
70442970
70090625
70348932
70348947
70348938
70348935
70348937
70348944
70350665
70348945
70348943
70348942
70348940
70348946
70348952
70348936
70348933
70348931
70348948
70348934
70348950
70348941
70348951
70439695
70320528
70440320
69117679
68898270
68898261
70453494
70453492
70453489
70237126
55248053
55248020
70329993
70341930
17768674
70455826
70455868
70455017
70455839
70453844
70455832
70463408
70463405
70458954
70457242
70458868
70458926
70457267
70458945
70459036
70458913
70459021
70458963
70458918
70458966
70458969
70458932
70459031
70458976
45263138
28737741
70472893
67616340
67616708
70486770
67616085
70457656
67616207
67616105
70283189
70283228
70501501
65973120
38462416
37405022
70516398
70516388
70535364
70516523
70516526
70516360
70516501
70516507
70516498
70516520
68609970
68609953
68610418
68610268
68610065
68610240
68610139
68610315
68610060
68610135
68610300
68610070
68610180
70542178
67609536
67609545
69975539
69975455
69975537
69975481
69975535
69975524
69975495
69975492
69975438
69975491
69975473
69975440
69954272
69954268
69954267
69954466
69954252
69954218
69954451
69961330
69974669
69975550
69975657
69975566
69975703
69975686
69975660
69975613
69975555
69975639
69975602
69974799
69974915
70516463
70545898
55433677
45352762
45356699
45353976
58740543
58742044
58740580
58743442
58744664
58744854
61194760
58742261
58748638
58745224
58745561
65542036
69163773
64081686
50152402
61080530
61080537
61080532
61080538
61080542
61080543
61080544
61080531
61080540
61080539
61080533
61080541
61080441
63111164
61080574
61080561
63111238
61080620
63111248
63111275
63111223
63111284
63111265
61080563
63111303
63111295
61080604
63111237
63111135
63111274
63111293
63111246
63111219
63111292
63111302
63111270
63111167
63111281
63111256
63111226
63111273
63111299
63111182
63111297
63111227
63111286
61080618
63111200
63111170
63111272
61080583
63111236
61080559
61080562
63111279
63111289
63111144
63111206
61080614
63111251
63111268
63111276
63111193
61080557
63111267
63111298
63111285
63111283
63111202
63111143
63111153
63111148
63111264
63111141
63111266
63111220
61080550
63111150
61080635
63111140
63111271
61080564
63111229
63111278
63111257
63111254
63111203
63111242
61080608
63111197
63111304
63111192
61080555
63111142
63111280
63111152
63111134
61080616
63111288
63111146
63111247
63111149
63111228
63111159
63111137
63111160
63111291
63111287
63111204
63111282
63111260
63111269
63111218
63111241
63111230
61080558
63111390
63111385
63111384
63111405
63111365
63111403
63111387
63111410
63111391
63111412
63111401
63111413
63111402
63111407
60775072
60776616
70588317
68825177
68826021
68826044
68826015
68826095
68825912
68824904
68826094
68825890
68826018
70587953
70588001
70588125
70588083
70588124
70588202
70587950
70587973
70588044
70588037
70588099
70587952
70588181
70588193
70587954
70588171
70587996
70588109
70587990
70588136
70587974
70587969
70587956
70588116
70588050
70588108
70588119
70587991
70587957
70588096
70363930
70591892
70592237
70590524
70588984
70617129
60086571
70408607
67244395
70620457
67244386
67244375
67244389
67616690
70172619
70172786
70172762
70172664
70172941
70173002
50838671
59817435
70464165
70464152
70464116
70464149
70464158
70464140
70464151
70464168
70464117
55345320
67053430
67053427
70329941
70463082
70463081
70519752
70443240
70443238
70443239
65861999
70450563
70452725
70210780
70210746
70210760
70210742
70210754
70210787
70211085
70210950
70210816
70210946
70210974
70210940
70210906
70211191
70211184
70210945
70211043
70210799
70210975
70210943
70211095
70211027
70210971
70211132
70427001
70651181
47666511
47896830
70669734
54749631
70667640
70667645
70667644
70667647
70667643
70667621
70667629
70667638
70667649
70667642
70667641
70667600
70697587
70667528
70428213
70709164
70709258
70709175
70709182
70709410
70709442
70709383
70709228
70709204
70709274
70709445
70709471
70709271
70709335
70709345
70709309
70709270
70709259
70709199
70709308
70709485
70709494
70709479
70709495
70727239
70728228
70732138
70732139
70732128
70732141
70732124
70732126
70732122
70732127
70732125
70732133
70732129
70732140
70732123
70738920
70739667
70739605
70739938
70739908
70739910
68821040
68821035
70739940
67294463
67311765
67309807
68826624
69428165
68826449
68826443
69952833
70748309
70748318
60018025
68541108
70341933
70462877
70809329
70825589
45562301
60676201
52493792
67053425
67053429
67053426
48489346
48489335
48489344
48489351
48489321
48489312
48489323
48489318
48489343
48489332
48489365
48489337
48489348
48489362
48489349
53612257
48489355
48489361
48489341
48489353
48489334
48489336
48489319
48489367
48489350
37544787
70504149
70520018
70519788
70520091
70554108
37324400
67451159
70852006
68103232
70828310
70828336
70828338
43065925
68182433
70617945
70617173
68824955
69554498
52452553
37405903
62204730
64742573
65862165
70634671
70880832
70563865
70574975
40718077
67534906
70899292
70899276
70899343
70899263
70899316
70899273
66453815
62754836
57840777
70712640
70634505
70821602
70821594
70768099
70768061
70821590
70768067
70768082
70873775
70873774
70873776
57892855
70899355
70899268
70899267
70935273
70880162
70473503
70750552
70945585
70948277
70948319
70948316
70948328
70896483
70905569
70896459
70896426
70896464
70896455
70896428
70896452
70896434
70883261
70896454
70896447
70926511
70926530
70883260
70905576
70926528
70896435
70938725
70938739
65308007
69475865
69475619
69475805
69475793
69475739
69475808
65711085
70898649
69473934
70986071
70986108
70986057
70986051
70986048
70986097
70986081
70986089
70991073
70753431
71011457
52755839
70428494
71025792
56768880
56768877
69534915
69917488
51171364
51171409
51284965
58870004
71050353
39013126
21870122
67235068
70898374
70898375
70898369
70898367
70740975
70898372
70898370
70740982
70898365
70898366
70740977
70740973
70740985
56768879
56768864
56768867
71060097
44589441
44589438
44589437
44589444
44589439
71072236
65712694
68895563
68895752
65560451
71082509
71082606
71082760
71082613
71082608
71082942
71082603
71082746
71082502
71082801
71082744
71082932
71082507
71082607
71082281
71082503
71082750
71093506
71093476
71093486
71093523
71093526
71093467
71093477
71093485
71093491
71093473
71085458
71084310
71083452
71083438
71094290
71094287
71094323
71094296
71094272
71094257
71094320
71094293
71094308
71094569
71094596
71094581
71094510
71094710
71094619
71094621
71094714
71094713
69307282
70822784
46632326
43065869
71096017
69847666
58869994
58870000
70414994
70414995
70870808
67680711
70898345
71129445
71129446
71104619
71104475
71104691
71104468
71106284
71106137
71106040
71108120
70892941
71106711
71106631
71106451
71104985
71104796
71105049
71104943
71104756
71107014
71106901
71105104
71105088
71105244
71105272
71105257
70898362
70898364
70893100
70892943
70892942
70863403
70863406
70863631
70863713
70863705
70863700
70863627
70863686
70863766
70863704
70764230
70863703
63868323
63868426
70863709
70863645
70863676
70863637
70863725
70863718
70863854
71130087
71111156
71111225
71111251
71111345
71111190
71111270
71111271
71111390
71113204
71111463
71111449
71111585
71111961
71111870
71111544
71111763
71111754
71111886
71112171
71111909
71111894
71112098
40077427
40768097
41145882
41351217
41351218
41351236
41351237
42749002
68212050
68212066
68212041
61424714
61424390
62542212
58260082
59540497
62653197
62653159
63044608
63044656
63044064
63044581
63044654
63044659
63868011
63868421
63762126
65711296
65251119
65405708
65407032
65406332
65262524
65486742
65262574
65262709
65262540
65262908
65409957
65922295
65922288
65410181
65410048
65921933
65410325
65409846
65922120
65921913
65409920
66943088
66132340
66132679
66131993
66132551
66132539
68909444
65935831
66133923
67844314
68102136
68102287
68102286
68102289
68182616
68183652
68182987
68235649
71122571
67164864
71112088
69312529
69560911
69475761
69514832
69576978
69585313
69576697
69966069
69966029
69934783
69966048
69975531
69975439
69975615
69975574
69997077
69997076
69997087
69997113
69997080
69997084
69997104
69997115
69997110
69997109
69997103
69997086
69997090
69997074
69997105
69997072
69997079
69997093
69997075
69997101
69997082
69997099
69997100
69997112
70016327
70138282
70031993
70031994
70129163
70129160
70129157
70129149
70171079
70172723
70172943
70170201
70166927
70166936
70166923
70167037
70228529
70228519
70228522
65712477
66944874
67106956
67106963
66944876
66944868
65792335
65791880
65792338
65792351
65792013
65792334
65710420
65710198
65710206
66943050
67164998
67165839
67167124
67165256
67167108
67164865
67107414
67107506
67107542
65752334
65752335
65752198
65752349
65792549
65792559
65792651
65711354
65711413
65711603
65711679
66944608
66944706
67677000
69474697
70634515
65711393
65712465
70832025
65792436
65792343
65792318
65752379
71159999
71159806
71160012
71160138
71159744
71159724
71159794
71160217
71160215
71159745
71159729
71160628
71160214
71160013
71160230
71160210
71160213
71160011
71160655
71160639
70942883
70942649
70942709
70930855
70942940
70942960
70939332
71038320
71038168
71038330
71038336
71112099
71111881
71112003
71112167
62976592
69038197
69145982
69144792
69145958
70898252
71160216
71160218
52163584
52163628
52163350
52163735
52163684
52163652
52163586
52163594
51519170
51519060
51519140
51519114
51647510
51647975
51526683
52163814
52163924
52163919
51520238
51522364
51521772
51521734
51522372
51521752
51522366
51525469
51648957
51648590
51648626
51648952
51648938
71171971
51893716
51894159
71172006
71172057
71172016
71172028
71172005
71172759
71172033
51895165
55046916
55047127
55046976
55047006
55047135
55047163
52484074
52483861
52483780
52483964
52484078
52483915
52483882
52483880
54869337
52484018
55274272
55274148
55048231
51523391
55048234
55274130
51523304
55274254
71172996
71172847
71172975
71172955
71172987
71172985
71172992
56071521
56071481
71173054
71173633
71173629
71173615
71173640
71173045
71173693
71173636
71173641
71173663
71173639
71173628
71173667
71173658
67600632
71173696
71173695
56512324
55047668
55047669
55047648
55047350
55047419
55274348
54869552
54869382
54869362
54869557
54869556
55274527
54869462
54869464
55274381
54869466
54869369
54869553
54869423
54869396
54869528
55274306
69531551
69238488
69238722
69531566
69238720
67394708
67600937
67600938
67814822
67395790
67395791
55274689
55274571
55274633
68094686
68011131
68094855
68094800
67394804
69911329
67396184
67396011
67396037
68010881
67396036
67396035
67396032
68931868
69147124
68554826
68554822
68011008
68010931
68011043
68011033
71124780
71182538
71182636
70922766
71180597
48688822
21526711
69475760
69475814
71202778
66943595
65792337
66944655
66944588
65791679
65752576
65791681
65752377
71212304
70166914
71212232
67107545
67106954
67107543
67165246
67107532
68609943
71213288
70452739
70452740
71201510
71201746
71201453
71201700
71201452
71201500
71201525
71201578
71201484
71201769
71201685
71201557
71201469
71201468
71201466
71201451
71201492
71201482
71201493
71201549
71201455
71201657
71201459
71201489
71201552
71201551
71201673
71201507
71201460
71201534
71201446
71201471
71201550
71201486
71201352
71201454
71201553
71201465
71201480
71201463
71201758
71201450
71201495
71201729
71201514
71201498
71201448
71201457
71201467
71201544
71201516
71201447
70812802
71113126
69849653
69849700
69849705
47669072
63811794
71284841
71284885
71323632
71193930
71204383
57893989
57893959
57893814
70753472
70753473
56095901
65792008
65712429
68287864
66943583
71038388
71038277
71038259
71038312
71038305
71038321
71038120
71038260
71038311
71038417
71038130
71038314
71038069
71038296
71038332
71038291
71038387
71038068
71038326
71038318
71038294
53101120
71331381
71331350
38198721
37326125
37326112
65752276
61546911
71077763
64169491
70826827
47883549
65792329
43469592
69310627
52468788
68078529
68090835
71351603
71357242
71113537
71358161
71361983
71362022
71363035
71366669
71369081
71369085
71369071
47349439
43882515
52163360
68010938
67164997
52163364
71394571
71394575
71395127
71395131
71395202
71395187
71395203
71395151
71395148
71395147
58644315
69742491
71194114
71404909
71401227
71401223
71401225
71401226
71401224
68641531
71415304
71264119
71262016
71442621
69146002
71341187
71341181
71341208
71341165
71341261
71341263
71341272
71341275
71341269
71409047
71408203
71409078
71408230
71409093
71409105
71408287
71409074
71409338
71409856
71409844
71409838
71409833
71409846
71409847
71409853
71409834
71409841
71409861
71409355
71409843
71409860
71409864
71409839
71409865
71409892
71409901
71410122
71409874
71409867
71410119
71409878
71410125
71409887
71409902
71409869
71409870
71409893
71409886
71410106
71409888
71409882
71410095
71410115
71409885
71409890
71409868
71410453
71410441
71410200
71410452
71410187
71410209
71410483
71410472
71410491
71410474
71410495
71411128
71410524
71410505
71410515
71410502
71410501
71410531
71410518
71410511
71410492
71410498
71410514
71410533
71410512
71410529
71411120
71410517
71411146
71410521
71410519
71411153
71411181
71411160
71411188
71411150
71411526
71411535
71411154
71411519
71411499
71411156
71411524
71411183
71411151
71411187
71411186
71411559
71411547
71411548
71411659
71411621
71411561
71441808
71452599
71458487
71468654
71491322
71491350
71491174
71491133
71491373
71491340
71491137
71491283
71491295
71491270
71491339
71491265
71491312
71491296
71491315
71491247
71491252
71491361
71491235
71491244
71491310
71081272
71501403
71500068
71499427
71499426
71498598
71126797
71126800
71126799
71126801
71126794
71126796
71126803
71126792
65711658
65791882
70110548
71466454
71466423
71466442
71466436
71466427
71466433
71466451
71466458
71466437
71466431
71466432
71466434
71466429
70922779
71339709
71192618
71141214
71522820
71174565
71174397
71174402
71174403
71182607
71182599
71182631
71182638
71182634
71182625
71183025
71183027
71206802
71218485
71335530
71263816
71263825
71263817
52749102
71341622
71336951
71341596
71341618
57893951
38849602
66308693
63846733
38198727
71489151
71489211
47873216
37069313
54272849
69474105
66943828
59174988
71263831
71263827
71263832
70192483
68897927
66240232
52148686
70864762
70864966
70865275
70865266
70865297
70865293
70865322
70865205
70864997
70864999
71302447
71336962
71336912
69210799
70865408
70865558
70865377
70865507
70865553
70865436
70865425
70865515
70865460
70865355
70865409
70865610
70865562
70865387
70865462
70865457
70865739
70865751
70866227
70866233
70866098
70866218
70866287
70866164
70866223
70866109
70866209
70866257
70866296
70866271
70866078
70866266
70866236
70866101
70866332
70866340
70866355
67794386
68069565
70866558
70866467
70866466
70866401
70866568
70866404
70866390
70867117
70867033
70867050
70867454
70867497
70867564
70867588
70867519
70867467
70867656
70868211
70863702
70863884
70868873
70868747
71341553
71341551
70563120
43065872
51877804
69101572
71173912
71183030
71173368
70944782
70944533
37976484
59165807
69490375
71563979
71563965
71563734
71563818
71563982
71563925
71563974
71563964
71563977
71563983
71563989
71563986
71563963
71563980
71563927
71564590
71564588
71564490
71564514
71564532
71564505
71564508
71564582
44393984
43137140
44394097
61664596
61664545
71540711
71584076
71584577
36907456
71585159
71585158
71585157
71174372
61698623
70945787
71588038
71588039
71593421
71593428
71593419
71141221
52483914
55047410
55274536
50856480
51171807
71601642
71601701
71602133
70472772
71173911
71173914
71361352
71435090
71433148
71432442
71577787
71577788
71577785
71577800
71577764
71577786
71577789
71577782
71608045
71607736
71607046
71186927
71186795
71186994
71186898
71187154
71187132
71186857
71186850
71186913
71187190
71186883
71542950
71543142
71538702
71560150
71606089
71560445
71560392
71560278
71543861
71609596
71608252
71609047
34864174
31223268
52487804
69849667
69849697
69849629
68824804
46102978
71441592
38720435
70942928
62896567
71245097
71572223
69183664
69183627
38199009
71630124
71629096
71629695
71628748
71629519
71630366
71630206
71630114
71629407
71630131
71630059
71630748
71631130
71630066
71628625
71629642
71630107
71630062
71629662
71629657
22256694
71629613
71629600
71629502
68999497
71634962
71634986
71634959
71634967
71634987
71634964
71634971
71634988
71634972
71572182
67107368
68828326
68828334
68828340
68828338
68828348
68828341
68828332
68828355
68828350
68828336
70942625
70943147
70943150
70942919
70942663
70942952
70942650
70942648
70942638
70942920
70942683
70942923
70942692
70942651
70943146
70942672
70942657
70942914
70942896
66500478
71302903
71302923
71302520
37323658
70313062
38112077
70869930
70870173
70870384
70870556
70871518
70866276
70866225
70871716
70871792
70872951
70311442
69102641
70868204
68533958
70876444
70876387
70876382
69102795
70876699
70876725
70865607
70865588
71640988
61642973
70293062
26554809
58642342
56849911
46843495
71663490
71663492
55826978
54861429
71664985
71664987
71577791
71577784
71577797
71577796
71577781
71577792
71577790
71577799
70341958
57816943
57868564
59165768
64518892
71629457
71361173
38380542
69310183
71117683
71117716
71174562
71606101
71604611
71603772
71606098
71605672
71605613
71606832
71606970
71606959
71651357
71651371
71651416
70257540
70257595
70257609
70257608
70257547
70257590
70257618
70257560
70257528
70257583
70257580
70257602
70257599
70257556
70257565
70257534
70257574
70257549
70257542
70257613
70257531
70257596
70257570
70257537
70257573
70257588
70257578
70257604
70257615
70257564
70257592
70257611
70257620
70257562
70257558
70257568
70257554
70257585
71694980
44898670
71695223
71695222
71695227
71695219
71695238
71663430
71168386
70473307
70473288
70473309
70473296
71141560
71141563
71235335
38198810
69121151
71249734
71249765
71249748
71705528
62769803
62769581
71441596
71410687
71410671
71410683
71410682
71410684
71410672
71411647
71709381
71709374
71709417
71709445
71709435
55063329
70942905
70942685
70942643
71234735
71490702
71710614
67530781
71705670
71705631
71705568
71705604
71705629
71705555
71705579
71705661
71705544
71705592
71705627
71705615
71705585
71705534
71705662
71705535
71705637
71705594
71705600
71705584
71705539
71705622
71705612
71705613
71705552
71705556
71705566
71705578
71705533
71705645
71705601
71705583
71705581
71705620
71705593
71705580
71705540
71705575
71705626
71705621
71705543
71705665
71705633
71705644
71705606
71705572
71705545
71705642
71705554
71705614
71705611
71705587
71705538
71705605
71705657
71705623
71705599
71705628
71705603
71705577
71705648
71705598
71705571
71705624
71705589
71705609
71705590
71705669
71705597
71705551
71705549
71705570
71705564
71705547
71705639
71705550
71705650
71705607
71705643
71705625
71705608
71705574
71705561
71705560
71705586
71705654
71705630
71705602
71705610
71705569
71705573
71705553
71705635
71647404
71712093
71712293
71712290
71709423
69555572
71612655
71612656
68605022
45500171
71628545
71716249
71716558
57893958
57893956
71633759
71633761
61560393
71719160
71718628
71249733
70313020
70313032
71613640
15657879
52452547
54995143
71559870
70872207
38466902
70871771
70868771
69210919
71651417
43874608
45255366
48673213
70875027
71542169
71542166
71755740
71755745
71755782
71755981
71755800
71755835
71759986
71756108
71761183
71761215
71762223
71762358
51877880
44943713
69146495
71663502
71775263
71775275
71775336
71775286
71775404
71775397
71775409
71775414
71775408
71775427
65546382
71390002
70473433
71336880
70875028
71408036
71410688
71671665
71411042
71411705
71718600
71156994
71745844
71745935
71746116
71746372
71747313
71789621
71789598
71790106
71789590
71789237
71790107
71789650
71789617
71789649
71789393
71789620
71789274
71789618
71789399
71789619
71733296
71733301
71733295
71733298
71733568
71733294
71733302
71733300
71733567
71733297
71733299
71733010
71733008
71732957
71733011
44836314
44943736
44901471
64334511
42665321
64334535
64334573
71523809
63633643
71822817
70166963
71822846
71822850
71822837
71823582
62514352
71696427
71822838
71864047
71613107
71885288
71885323
71885304
71890941
71815390
70764020
70764306
70764193
70763373
71023477
71023478
71023332
71023305
71023408
71023769
71023294
71023308
71023588
71023587
70765526
70766084
70765521
70765530
70766334
70765995
70765525
70766036
70766961
70576890
70576889
70576739
70576721
70577048
70576782
70577088
70576783
70576781
71024439
71024322
71024380
71024774
71024397
70577178
70577310
70577211
70577356
70577450
70577431
70577148
70577256
70577144
70577131
70577090
70767508
70767497
70767522
70767180
70767525
71582237
70767509
70767153
70767514
70767512
70767181
70767519
71133749
70767506
70767173
70767175
70767530
71582240
70767213
71582241
70767493
71296075
71364423
71364350
71364376
71364647
71364374
71364346
71364787
71364372
71363045
71363081
71363041
71363082
71362890
71363061
71362992
71363037
71024901
70577864
70577898
70577785
70577455
70577624
70577609
70577646
70577867
70577790
70577911
70577607
71582869
71582956
71135870
71298309
71298303
71298326
71296751
71364843
71364875
71365137
71365055
71365110
71364891
71365038
71364806
71583230
71583150
71583187
71583106
71583318
71363199
71363398
70577942
71363128
71363352
71363212
71363124
70577947
71363302
71363256
71363117
71295738
71582294
71298797
71298451
71298665
71298628
71298629
71298564
71298801
71298733
71363506
71363514
71363515
71297375
71297738
71297526
71365460
71365327
71365437
71365435
71365261
71365447
71365433
71365246
71365451
71583564
71583558
71583664
71583566
71583507
71583506
71583505
71363537
71363709
71363555
71363600
71363556
71298966
71298857
71299071
71299031
71299066
71299141
71298869
71298830
71298860
71365519
71365637
71582445
71582385
71582342
71582402
71365516
71582361
71299307
71362805
71362813
71582324
71299303
71299377
71299305
71362812
71363995
71364184
71363953
71363968
71363997
71364020
71364226
71364197
71363971
71364016
71363988
71363985
71364213
71364300
71582523
71582483
71582658
71582784
70764723
47896673
71907661
71907663
71339188
70577603
70577056
37544366
37069335
63934992
67388832
71912866
70765132
71911788
71911789
71911787
71911783
71911790
71911784
71911777
71911781
70764712
70764718
38709011
71921070
71832397
71833819
71833327
71833625
71923039
71922978
71922961
71923021
71923006
71923008
71923082
71922984
71923041
70039126
69078611
50068245
50068275
50068326
50068242
50068285
50068321
50068247
50068309
50068254
71651407
71651420
71651421
71651418
71651424
71651422
71651419
51877860
70874794
70874659
70875495
70874853
71182610
71173923
71174555
71174541
71182533
71173926
71179194
71173951
71174542
71174406
38708983
69210734
71953239
71953739
71953738
71963000
52452563
71657903
71657911
71657912
71657906
71657946
71660706
71660725
71657937
71660710
71657948
71660714
71660696
71660722
71660705
71660715
71660724
71973105
71973126
1284369
1284368
1284371
1284367
1702128
1702115
20141584
40871066
70090652
25136047
70090631
70068599
70068609
38470221
42928650
39018833
58823307
59227098
59227122
59541446
70865396
70866943
70866418
71173922
71179160
71174405
71174540
71174544
71438658
71836259
71836753
71836738
71836740
71748419
71651425
71830492
71830692
71830722
71830576
71830574
71830680
71830779
71923133
71923224
51526691
71947954
71952316
61877212
69463755
69463839
69463841
69451422
64008383
63044599
63044065
68199182
65335288
70090633
65335552
65406396
65406936
65410361
66132672
65410146
65505582
65718982
65792669
65618030
65752279
68157261
68160150
68235705
68236212
68235603
68249500
68236224
68249502
68235509
68610050
68610247
68609986
68610038
68610023
68609995
68610194
68610077
68609972
68609980
70456979
70457013
70456981
70456997
70323771
70330029
70324229
70330028
70549982
70577828
70635335
70635334
70646084
70645895
70646090
70646087
70646089
70712812
70712600
70769722
70869988
70871317
70871341
70871353
70871324
70871352
70871374
70869880
70871316
70871378
70871368
70871333
70932782
70863626
70863618
70863653
70863636
70983953
70983819
70985853
70985856
70985848
70990884
71020861
71003411
71021868
71038292
71160010
71160009
71160651
71160221
71160017
71082615
71082600
71082598
71160223
71105003
71105221
71104922
71104855
71105053
71105046
71187458
71187256
71187459
71187455
71187130
71187481
71186792
71203683
71187958
71187749
71187764
71187563
71187641
71187557
71188018
71187697
71187956
71187625
71188063
71187896
71187628
71204135
71188104
71188289
71188089
71188174
71188235
71188284
71188282
71275930
60125582
71298642
71298321
71298772
71297373
71298412
71299114
71297374
70230726
71295707
71299146
71473756
70737294
70449136
71823714
72007316
70942627
70942629
72007315
72007314
72007371
72000805
72000847
72007415
72030084
72029615
72029609
72029552
72029547
72030008
72030005
72029613
72029537
72029587
72029576
72029610
72030123
72030003
72029559
72029998
72029993
72029535
72029600
72029990
72030076
72030107
72029994
72029604
72029614
72029548
72029541
72029597
72029536
72029564
72030074
72029571
72029608
72029554
72030083
72030071
72029543
72029545
72030072
72030001
72030006
72030108
72029581
72030009
72030087
72030082
72029549
72029579
72029557
72029596
72030012
72029598
72030110
72029611
72029558
72030015
72030073
72029538
72029992
72029991
72029605
72029580
72029574
72029561
72029594
72029551
72029553
72029577
72030122
72030089
72030004
72030111
72029585
72029595
72029606
72029583
72030011
72029589
72029568
72030085
72030088
72029593
72030090
72029563
72029542
72029997
72029572
72029567
72030078
72029540
72029578
72029586
72030018
72029999
72030017
72030069
72030079
72030068
72030075
72029612
72029562
72029539
72029550
72029544
72030086
72030070
72029588
72029607
72029570
72030081
72029602
72030124
72029592
72029591
72030125
72030002
72030080
72029996
72030016
72029566
72030013
72030000
72030077
72029573
72029565
72030067
72029599
72029569
30971150
64923148
69997111
68131912
68132409
68131918
68131923
71836281
71836290
71706097
23642349
72038313
72039526
60287869
71830534
37324037
55068444
68132335
68132062
68132252
68132401
68132260
68132351
68132266
68132108
68132300
68131924
68132305
68132412
68132299
68132333
68132247
68132141
68132302
68132231
68132065
68132232
68132253
68132307
68132291
68132151
68132343
68132064
68132454
68132262
68132306
68132101
68132290
68132402
68132519
68132552
68132533
68132534
68132540
68132554
68132539
68132525
68132531
68132523
68132541
68132535
71549552
58993017
71414830
58994882
64912383
64921471
71836733
71438564
71439081
71438556
71836743
71438514
71836754
71438523
71836261
71439085
71836776
71438518
71836742
71439073
71836771
72086130
71313243
71602915
38198833
72066305
70482655
70482650
70482664
70482657
71551279
72099920
72085393
72085395
72085392
72085400
72085398
72085391
72085399
71655767
71655548
71655990
71653488
71653723
66943929
66944869
71841351
71841292
68132419
72005621
72046108
72045582
70577605
70577934
50838763
72126549
23308361
72129429
72129430
72129096
72016115
72135432
71324391
60309817
72149724
54996587
37822240
37822465
72166926
72166950
72086148
71952390
71952386
72177652
72179268
72193776
70476221
70475938
70476021
70476018
70482863
71602916
71947947
71854297
72002282
72002305
72050791
72125167
72119839
72119805
59478337
72207014
72025663
72101222
71399746
72025398
71399752
72209208
71399747
68132079
68132263
68131933
68132296
68132331
68132298
68132230
68131954
68131929
68132221
68132258
68131921
68132284
68131927
68131934
68132273
28731806
72214831
72215784
55271741
55271882
55271871
72222079
72224675
65343126
65342022
65554314
72228121
70167066
70166969
72228457
72224090
72224628
72227432
72224896
72225235
72237408
72228417
72228415
72228418
72228420
72228422
72228419
72228421
72228416
72228423
72228196
72228204
72230963
72236652
72234509
72236947
72241680
72243150
72205642
72014866
61624962
71936313
71936563
71936587
71936550
71936361
71936756
71936797
72260177
72260100
72260097
72228199
72228201
72228198
71158682
71692661
71692455
71692432
71393228
71392399
72260598
56792929
71836285
71833621
71832649
72265236
72269086
71830360
72279281
71712055
71668844
72265455
72280840
72287097
72284068
72280780
72279402
72279419
48942290
72273125
72255049
72268185
72263817
72081377
72081389
72081402
72081502
72081663
72081504
72081686
72081412
72294752
72268214
72268218
72268226
72268246
72296057
72302891
72302865
72302924
66388295
66388230
72049552
72051249
72307099
72307220
72307114
72307628
72308163
72308158
72307897
72307900
72307118
72307934
72307177
72307100
72308200
72307179
72307110
72308662
72307191
72307103
72308464
72307112
72308052
72308831
72307108
72307616
72214729
72307194
72307206
72307190
72307746
72311247
72310106
72308046
72307172
72307185
72309725
72306889
72307129
72312334
72311770
72306418
72312295
72307125
72307480
72311775
72307740
72307766
37545060
37323770
72313593
72311825
72313659
72315848
72313684
72308895
72315015
72310597
72311585
72310553
72310595
72311552
72311529
72311861
72309230
72314401
72309833
72312581
72313675
72315039
72313678
72312212
72315379
72313418
72313456
72312438
72315484
72315341
67843131
72315023
72314584
72312588
72314987
72315227
72313700
72313581
69161375
70105116
72318624
72316047
72316055
72318762
72318717
72316539
72318693
72318753
72315796
72318995
72315851
72050740
72320818
72316044
72316520
72317535
72316490
72317958
72318130
72081217
72081468
45220364
72320829
72323901
72323886
72323848
72320432
72323097
72320503
72324163
72323918
72319952
72321158
72321123
72323135
72323089
72324188
72321168
72324186
72324199
72318539
65752344
65712434
72330239
72330263
72330315
72332217
72332198
72333927
72330086
72330070
72330089
72329852
72331805
72328810
72331802
72332953
72328859
72332981
72330248
72328790
72333004
72331415
72331809
72330420
72333948
72332535
72331803
72335902
72335898
72330228
72336028
72335895
72335941
72333909
72333368
72329894
72334999
72335437
72332561
72333341
72335080
72335037
72333333
72335400
72119835
72336729
72335472
72334480
72334495
72337332
72338152
72337225
72335906
72336947
72337330
72337015
72335970
72338022
72337431
72338288
72338319
72338005
72338007
72344233
29414428
72344065
72344070
72344075
34638011
34870121
72272972
51877856
72329981
72331491
72315668
72319143
72315653
72315677
72323917
72332679
72341809
72307723
72295797
72319063
72329898
72315853
72367230
72367224
72367233
72367222
72367227
72383836
72367943
69856019
51376090
58860542
58741545
43315632
38199192
71126798
72242853
38709118
72415298
72298172
72190110
70090869
72190063
36391252
51518476
72430694
72204303
68221154
68221639
68220996
68221561
68221152
68221157
68221562
68221569
68221153
68221720
68221735
68562749
68221731
68221737
68221734
70481306
70481351
70480859
71856901
72206301
72193747
72193781
72342661
72342668
72342665
72342672
72342663
72342670
72342675
72342660
72342666
72432426
72432427
72432362
71139955
72432568
71156234
69145972
72393162
72450653
72091658
72091659
72091668
72466263
72466264
70166971
51680300
51680296
51680303
51680359
72483075
72430730
72444850
72493459
72493457
72493463
72493462
72493455
72493461
72493458
72493456
38709188
71351770
71351505
71351619
72273260
72319214
72323200
72323708
71351990
72340428
72509599
72521923
72521934
72522353
72323890
72323895
72323893
72323872
72323861
72323889
72323870
72323879
72272445
72319013
72473836
72319018
72339573
72329920
72326158
72319050
72304201
72304134
72304089
72306325
72304114
72327987
72326038
72325985
72326100
72325965
72326024
72326001
72326017
72326059
72326011
72326030
72518973
72467467
72467477
72467405
72467417
72467555
72467410
72467457
72467413
72467494
72467401
72467527
72467460
72467424
72467403
72467486
72467552
72467530
72467412
72467472
72467535
72467480
72467561
72467512
72467487
72467402
72467520
72467462
72467505
65618135
70942661
72510863
34911662
34911639
72545514
72554942
72554943
72554941
53674026
71830770
71830391
71830702
71830438
71830571
71830669
71830645
71830640
72562907
67553262
71439090
72285610
72269489
71563206
72570522
72570549
60100635
63386074
72597803
72597820
72597810
72597808
72597825
72597795
72597804
72597823
72597830
72597833
72597796
72597806
72597814
72597811
72597827
70746250
72157623
72597436
59024600
72570893
72570848
72570840
72570832
72570827
72570890
72570910
72570851
72571012
72570957
72570849
72609400
72570734
72570894
72570936
72570861
72570935
72419864
72422665
72420287
72419860
72419868
72299776
72424171
72424174
72419869
72422229
72424172
72424160
72408182
72422227
72424383
72424394
72424381
72408488
72408071
72424378
72419865
72420292
72422134
72408185
72420293
72424389
72424391
72424169
72424168
72408056
72408074
72420286
72408058
72419861
72419863
72424386
72420302
72424162
72420296
72408473
72419871
72408472
72419866
72407776
72424382
72407778
72408067
72408065
72407774
72422663
72424384
72419870
72424451
72424166
72408487
72419872
72424173
72408474
72424379
72424387
72419862
72424165
72407768
72420294
72420291
72424385
72424452
72420299
72408471
72407412
72420295
72408178
72408484
72407030
72419873
72408180
72408469
72408486
72407405
72424164
72420298
72422217
72424167
72408181
72408483
72420297
72422235
72407766
72424161
72420289
72407773
72424377
72419859
72375613
72375612
72408076
72408069
72407031
72535614
72408179
72408479
72535622
72408186
72424388
72408073
72375614
72422664
72407780
72535617
72407763
72407398
72419867
72407775
72420290
72424170
72407401
72407403
72424159
72424380
72424390
72420288
72408062
72424392
72420300
72422215
72606355
72606354
72510865
72502413
43874622
61086266
61086261
71914496
70443296
70477053
72264420
72408524
72350632
72408986
72408574
72352163
72408525
72476527
72476523
71974851
72642008
72642864
46843601
42080641
72625995
72352140
72494590
72494587
72494548
72494529
72494556
72494540
72494598
72494563
72461658
72494592
72494596
72636495
72664710
72660536
72659848
72650156
72650262
47896761
47666439
72264382
72264201
72264192
72264381
72264186
72264243
72264132
35892121
35891915
35890225
37652595
35890256
35891265
35892149
35889334
35892120
35891956
35892245
35891914
35888679
58959697
58958525
58962165
58960524
58961397
58960289
58962157
58962145
58960520
58963046
58960516
58962378
58961135
58962540
58962128
58960728
58962148
68221577
72680057
63623513
72690052
35891730
72260130
71830647
71830751
72738927
67442820
58960725
70619143
59452503
58961388
70619169
58961139
70619147
64175770
58962686
70169275
70169160
58962173
70619145
69377296
59453149
72512132
72223532
72223573
71411646
72739154
72687093
72688217
72769745
72455194
71346874
71346670
72166721
71655205
72625324
71348433
72166862
71350482
71348990
71496767
71800933
71496225
71498288
71497998
71498605
71800866
71800934
71498401
71498301
71496011
72766143
72766032
72766122
72766051
72766053
72766020
72766120
72766044
72766129
72766144
72766061
72766163
72764993
72768317
72768278
72768275
72768316
72768269
72768276
72768313
72768315
72768272
72768271
65006083
65006115
65006073
69210627
45255379
72151964
72449375
71346484
51375449
71914706
71348540
71348537
50839346
72865871
72865899
70090873
44025802
69238515
34523158
72328614
72354784
72411051
71354274
71354339
71351969
72401825
70449143
70449137
72885048
72885052
72885411
45460810
72885458
72885720
72908397
37544585
47934074
72914488
72914466
72914463
72917741
72873609
72463637
72357417
72927906
72927889
72927907
72928001
72364511
72927873
72928000
72927890
72927882
71830716
71830705
72400546
67676897
67677102
67676908
67676305
67676901
67677093
67676913
67676919
72408576
71411043
59207818
60349431
65029262
69268282
65622158
42833412
47934077
65712728
66943801
72540287
38720010
46082921
69162906
72941337
72942729
61797271
61013971
72946115
67676856
67676907
67677145
67676895
67677075
67676899
67677154
67677073
67677092
67676910
67677160
67676898
67677049
72943317
47011930
2005947
2005953
2054077
2005952
70596805
69154717
28432830
30650000
30649949
30649981
30649969
30377271
31207996
32446405
31471179
32192049
33271798
35575835
35575828
37332593
37407867
38906954
36713779
36680983
38501306
36597925
36598321
36681620
36681594
36597936
36680978
36598373
36598157
37269820
37696397
41657788
41657801
41657791
41657800
41657787
41657799
42700923
42700922
39916086
39445014
39277345
39277341
39277355
39277347
39277358
39277357
39277344
40330796
40073200
40054126
40049576
40044989
40073238
41151070
44083335
44605682
31127431
43065908
42963573
43141832
43517556
43141850
43321712
45328977
48287792
45670707
47030779
46507872
47754392
55827030
55827024
49850820
52723921
52736030
52736032
52741484
52707893
52741486
52741485
50675542
51185922
50522093
50521839
50761231
50760783
51259131
51864024
51864381
51864342
51864387
51864310
51864364
51863591
51864353
53569972
54649913
51954357
54687670
72870411
72870412
72870493
72870468
72870470
72870459
72870492
72870467
72870481
72870417
72870478
72870423
72870434
72870442
72870491
72870476
72870477
72870474
72870496
72870490
72870472
72870426
72870443
55248026
55248037
55248008
54219444
54219447
56323563
55689094
55689218
56866238
56993116
54868306
54867490
58651946
58659139
56868907
60733545
58908137
58912347
58775473
58768401
58778523
58778005
58777929
58773210
58762676
58768424
58778132
58902790
58925347
59577585
59541120
67891489
61743054
62654031
60930526
61221637
61677335
61676939
62230122
63484347
61676980
62980495
64017169
63499492
62980458
61950415
64017162
63499479
64017168
63499642
62980494
62980457
64017161
64017170
61881420
62194438
64687186
64687191
64687190
64441320
63761100
63761303
63708573
63970484
63972531
63972256
65186439
65186733
65186661
65219229
65219230
65916496
64420365
64422985
64422982
64432235
65697428
65036923
65036913
67888099
67888093
67888102
67058899
67057874
67058341
68250562
67890671
67799924
67890672
67890683
67890681
67890688
67890675
67891509
67890686
67890680
67891469
67890682
68260284
68263801
68260274
68260275
68260281
68260756
68260271
68260269
68260283
68260279
68260280
67517689
67517329
67514206
67515700
67514071
67518747
68699706
68992774
69382505
69598612
69514835
69514831
67979329
68098219
68098218
68090586
68103246
68103247
68090540
68220429
68156188
67912299
68360855
69009696
69601416
69013612
69601523
69410626
69470637
68853307
69146512
69517071
69519218
69517822
69310185
69517835
69312572
69518573
69348324
70874878
70874714
70191391
70191393
70726951
70134359
70138383
70728206
70728219
70727790
70191309
70191308
63756028
70414998
70415001
70414997
70415002
70415003
70728787
70870223
70762429
70762423
71021870
71299293
71362808
71362807
71362809
71363667
71415698
71415687
71415706
71346890
71346881
71216096
71220049
71215189
71473571
71437294
71648915
71495155
71582458
71563754
71563738
71563751
71563747
71563740
71564129
71563750
71563748
71563753
71627967
71709291
71709339
71709364
71709295
71709299
71824380
7238480
38709179
45112003
65711287
46385359
72981846
38909223
37416659
40046867
38400013
39365351
58812056
58812103
58812065
58812135
58812069
58812152
58925161
58812167
58812062
58925019
72996740
72996739
38353797
38361702
38471391
38354959
38074042
38074407
72337805
72337447
72408995
72983338
72986618
56869926
37549608
71830726
62736981
62736986
62736985
71411687
68565809
72385557
67530774
60349442
60348749
60349166
60349247
60348991
60349215
60349159
37325649
37405904
68103244
68103241
68098216
68098213
71949131
71655563
71655409
65711415
65711317
65710473
71655758
71651784
65710187
69475317
38198821
43828771
58242727
68327539
71864624
71005651
71005694
35837060
72151963
63755980
52468861
70847016
72966070
71358154
71367861
45008466
71367604
71369073
71370137
71636495
60125067
47169273
73096374
38378678
67943723
60126941
60122348
72385583
72385337
73113894
38112715
38198908
71094488
73104451
73104475
73104449
73104418
73104445
73104450
73104429
73104443
73104426
73104469
73104421
73104424
73104462
73104428
73104439
73104430
73104474
73104466
73104468
73104419
73104477
73104437
73104476
73104442
73104467
73104420
73104458
73104444
73104422
73104425
73104441
73104459
73104463
73104455
73104461
73104473
73104427
73104456
73104453
73104404
73104460
73104438
73104452
73104454
73104479
73104465
73104434
73104448
73104423
73104431
73104478
73104432
73104447
73104472
73104433
73104464
73104471
73105091
37405810
72350639
73091430
72466916
72385686
62772484
73147064
69989997
69284187
69284170
69284157
69284159
69284164
73166763
73166769
73160037
73160038
71586796
71586820
71586817
71586813
71586822
71586816
71586819
71586814
71586829
71586818
71586824
71586823
71586821
71586828
71800397
73188306
73188629
73160004
73189933
73191567
64242151
73188713
73075509
73075534
73207207
73208232
73190299
73190297
73190295
73153246
73213989
72534626
73134918
73134919
72408857
53788107
52353105
51863137
51863377
51863361
51863469
51863372
51863326
52333810
53027139
52333526
51863371
51863467
51863121
51863426
51863381
51863429
51863234
51863427
52333764
51863383
51863370
66194070
66193330
73216921
53774180
53779989
53780005
53027451
53766721
53778973
53778815
53769641
53029569
53779027
53030266
53778395
53029526
53028886
53772524
53773910
66196725
66196697
66196455
72606221
72606219
72606162
71076287
73266077
72273265
72403167
64972952
38356536
55842462
73282596
70898371
60348704
60348753
64483568
69268263
65622150
59155282
38377179
65710202
65712723
65712568
57894099
65712462
65711380
65711414
65712440
65711084
65711395
65752390
71653456
65792098
73302336
72634517
72634460
72634452
72634493
72634269
41154566
41154568
41154569
41154586
41151465
41154563
41149714
41154596
41154592
41154565
73277153
69308315
69308210
69308347
69308122
69308211
69308019
69308187
69308196
69308246
69308171
69308299
69308345
69308188
69308185
69308076
69308017
69308221
69308103
69308337
69308378
69308370
69308343
69308050
69308148
69308153
69308143
69308184
69308377
69308146
69308218
69308018
69308144
69308166
69308321
69308101
69308375
69308174
69308216
69308102
69308070
69308096
69308263
69308169
69308173
69308376
69308363
69308319
69308252
69308217
69308302
69308186
69308160
69308091
69308300
69308230
69308142
69308063
69308278
70612078
70611940
70611927
70612178
69325655
70612158
69325641
69325675
69325621
70612150
70612074
70612177
70612153
70611941
70612154
69325659
70612027
69325687
71935589
71322813
71322800
71935604
71322844
71322822
71322825
72417102
70820509
71322852
71322828
70820502
71322815
70820499
72130836
72878804
73208547
73208549
73279780
67616793
67618210
73302929
59433358
71179184
71174536
71182604
71179187
73040536
73333778
38709227
38378631
35276316
35276318
73340275
45347619
73355105
38198972
70826761
69546537
69546530
72357804
65336997
65299622
71614319
44771654
73201195
73201193
73201192
73201190
71604704
73221348
73221339
73221346
73221336
73221338
73309170
72891386
72890700
72890701
70170253
73382209
73382125
73382142
73382111
73382141
73382146
73382138
73382144
73382241
73382221
73382190
73382188
73390208
73390206
71439136
71438521
72714844
20375854
72708271
72708351
68857410
73198086
73198080
73198078
73198082
73198088
73198084
73198083
73198077
73198087
73449350
73431716
73431653
73431655
73431771
73431650
73431649
73431714
73431717
73431631
73431652
73431629
73431651
73431630
73431659
73431715
73431933
73432041
73431938
73431926
73431935
73431922
73432165
73432046
73431939
73432044
73432051
73431934
73431923
73431915
73431912
73432039
73431914
73431924
73431919
73431913
73432048
73431918
73432053
67931570
67931572
61881715
71565237
44340096
70634502
64533550
69307747
70943148
70943161
70481308
70482887
70480890
70481353
70481344
70480862
70481378
70480877
70482873
70481286
70481299
70482865
70473452
70477070
70473429
70477056
70476023
70475940
70476047
70476214
70476009
70476219
70475950
70475964
70476231
70475934
70473437
70477017
70473467
70476223
70477050
73479944
73467644
73467694
73471130
73467696
73473111
73473113
71438520
73485160
73486150
73486104
73467581
73473033
73499134
73498972
71415655
71411707
63934991
51259093
51259125
51259249
51259192
51259211
51259242
61878841
62583873
38354807
73529518
65711304
65752341
70930854
69475255
73468556
73497974
73467296
73533220
73533193
73533232
73533201
73533171
73533178
73533198
73533202
73533185
73533207
73533176
73533208
73537627
70577612
73544699
73544681
73544680
30649906
70577052
73547986
73549879
73549667
73550987
73551032
73551065
73551070
73551069
73551066
63755992
69546531
72715049
71655184
71348978
71912543
69078781
69088957
69089091
72596732
72637809
72624522
72587377
72587378
61878069
73562617
73569900
72692169
72712078
72714815
72712398
72713494
72738819
37282434
73575262
71298663
56258367
49253142
66622671
71346943
71346788
71347975
71346904
71346850
71346754
71346601
71346569
72808370
71346600
71347415
71354338
71354048
55063384
44821152
71347396
71347679
71347421
71348122
31428424
73491524
73491527
62486651
73597474
73597475
70166965
44901462
73420822
73601705
73601879
73601796
73601847
73597244
73599769
73243526
73579150
73579636
73579044
73579736
73579737
73579623
73579649
73579141
73579145
73579735
73579144
73579647
73579753
73579627
73579626
73579733
73579751
73579142
73579138
73579137
73579042
73579158
73579739
73579749
73579741
73579156
73579629
73579652
73579732
73579157
73579628
73579639
73579641
73579638
73579754
73579621
73579734
73579132
73579624
73579155
73579648
73579622
73579646
73579643
73579151
73579133
73579637
73579152
73579640
73579752
73579149
73579043
73579644
73579650
73579136
73579645
73579148
73579147
73579146
73579651
73579135
73579129
73579740
73579731
73579738
73579729
73579630
73579139
73579654
73579655
73579045
73579633
73579750
73579730
73579656
73579140
73579653
73579625
73579143
73579642
73621449
73621620
73621606
73621528
73621358
73621374
73621671
73597980
73232884
71603761
71605615
71605886
71604625
72851752
73613963
73613964
73613966
73637200
73637201
68350493
72438922
73426031
73426080
71525408
73596672
73638342
73638328
73649349
73651605
73622588
73622590
73622586
73619848
73622587
73622591
73619851
73619852
73619849
73651573
73223264
73661068
73595097
64534202
64527491
73314320
73314319
73314326
73314327
73314328
73314318
73314330
73314323
73314322
73314324
73296456
73678632
73680247
73653475
73682442
73682426
73682447
73682467
73682423
73682434
73682532
73682523
73682487
73682445
73682424
73682438
73682511
73682431
73682443
73682450
73682440
73682500
66944872
69474104
65792848
63256416
73695771
73695718
67890717
67891484
67799930
71721058
71721073
71721078
71721071
73704994
73705017
73705098
73704839
73704925
73704955
73705065
73704833
73704947
73705024
73704945
73705143
73705069
73704931
73704944
73705051
73705089
73704856
73704893
73704935
73704956
73705076
73705083
73705154
73704932
73704937
73705105
73705137
73704882
73704861
73704913
73704838
73701044
73711134
73711135
73711148
73711145
73711147
73711137
73711129
73711141
73711138
73711151
73711139
73711132
73711136
73711142
73711131
73711124
73709693
66623092
72890697
73713058
73709696
73709875
73709694
73709695
72891398
71042923
71042941
71042970
71044135
71044133
71212356
71212557
71212410
71212662
73227293
66500887
73738922
73738930
63257112
63257088
63257092
63257095
63257079
63257081
63257094
63257128
63257078
73762804
73758081
73765838
73769832
73742241
73753453
73772091
69522751
73772596
73756883
73750361
73754557
73698607
73698252
73698606
73698602
73698264
73699028
73699027
73699024
73698266
73698262
73698207
73699030
73698196
73698194
73698603
73698596
73698265
73698613
73698254
73699023
73699020
73698256
73698198
73698608
73698206
73698203
73699025
73698597
73698195
73698259
73699021
73698610
73698605
73698251
73698202
73698204
73698205
73698208
73699026
73698609
73698255
73698200
73698253
73698199
73698260
73698261
73698257
73698211
73698258
73698263
73698601
73698209
73698599
73698197
73698210
73699022
73699029
73698604
73698201
73769677
73769522
73773844
73772233
73773840
73771980
63256093
63256087
63256088
63256091
63256085
63256086
63256084
73775561
73775634
73755901
73755967
73755943
73755979
73755976
73755970
73755978
73756121
73756106
73756209
73756229
73756228
73756212
73756227
73756480
73756489
73756605
73756606
73756589
73756591
73756631
73756734
73756676
73756763
73756723
73756775
73756778
73756776
73756800
73757235
73756781
73757219
73757222
73756817
73757232
73756782
73757453
73757254
73757318
73757240
73757253
73757286
73757274
73757465
73757267
73757340
73757288
73757239
73757439
73757548
73757519
73757488
73757497
73757506
73757484
73757515
73757527
73776939
45365093
34863814
72976090
64283210
64169823
72629609
72628892
70115492
4267892
71348029
71348095
71348110
68008393
71346553
71346676
71346599
71347924
71347918
71347954
71347404
71347391
71347941
71347863
71348445
71348376
71348380
71348377
71348411
71357765
71357764
71357771
72786129
72890112
72889826
72890113
72796401
72796393
72890714
72890729
72810899
72812659
72976022
72975845
72976889
72813712
72814015
72816507
73281895
73284341
73411091
72713200
72711151
73426078
73427558
73784866
73784864
73784708
73784872
73784868
73784865
73784867
73784869
73784871
73784870
64529614
73788692
73549885
73549843
73549620
73549921
73785479
67107299
73768960
73737325
72375050
17778595
17778677
21386035
21383301
21365635
21367086
61134436
66237977
71348681
71348026
71348013
71348664
71348042
71348027
71348372
71348048
71347999
71348024
71347449
71346885
71346738
71346776
71346568
73774821
72851815
73800263
73800275
73597074
73673111
73675772
57947039
73227309
73227312
73800265
73800270
73812638
72005225
72098791
70942676
70942658
70942634
70942894
73810636
73810421
73810342
73810265
73810518
73810335
73810701
73811022
73810763
73810818
73810958
73810833
73811040
73810823
73810757
73816903
73810917
73810908
73811276
73811243
73816795
73811272
73811054
73811246
73811101
73811083
73811137
73811300
73819965
73819748
73819340
73819339
73819749
73816963
73816929
73817025
73816933
73816996
73816959
73816972
73816975
73817068
73816957
73817069
73817090
73822139
73822519
73820263
73819783
47025139
73823559
73816967
73816936
73816986
73826791
73826571
73819201
73819337
73819276
73819326
73819325
73819278
73819354
73819274
73819293
73819338
73819318
73819309
73819279
73819282
73819324
73827124
73827116
73827087
73827089
73827068
73827163
73827451
73827357
73827217
73827219
73827178
73827346
73827453
73827240
73819857
73819926
73819925
73819919
73819905
73819854
73820033
73820029
73820051
73820087
73820077
73820042
73820356
73820398
73820617
73820866
73820962
73820977
73820970
73820949
73820914
73820975
73820972
73820900
73820952
73820958
73820973
73820971
73820919
73821232
73821260
73821239
73821220
73821240
73821242
73820985
73821267
73821244
73821230
67052700
73877982
73830051
73873797
73873802
73873942
73873941
73873709
73873839
73873783
73873954
73873806
73874056
73873834
73873937
73873687
73871286
73871262
73871260
73885832
73885883
73885885
73885753
73885948
73885950
73885949
73885785
73885953
73886223
73886101
73886102
73886219
73885976
73886221
73886222
73886094
73886224
73886233
73886356
73886261
73886248
73886333
73886269
73886336
73886345
73886347
73886343
73886342
73886344
70324226
73885792
64913509
63756002
73895421
73890730
73890715
73890896
73890744
73890735
73890739
73890832
73890855
73890720
73804901
73891678
73891729
73891210
73891714
73891217
73891215
73891676
73891669
73891389
73891772
73891191
73891680
73891719
73891741
73891739
73891213
73891716
73891383
73891193
73891387
73892004
54268498
73800102
66200663
66199297
66198756
66198750
66199545
66200234
66198751
66199550
66199303
66199267
66198754
66198755
66199375
66198662
66201331
71297640
71297639
66201464
71282163
71289368
66201728
66202351
71288648
71289707
71284239
66201710
71288650
71287153
71282473
71282165
71282166
71299831
71298711
71290985
71291486
71293160
73646395
73899231
73503026
73503061
73503007
73751989
73751858
73751746
73751741
73751919
73751933
73751813
73751917
73767521
73751913
73751739
73765843
73751740
73751957
73751971
73760284
73751883
73910393
72619526
59128976
73496627
73496651
73496649
73496638
73908688
73757834
73758017
73751941
73758024
73925577
73903010
73925811
73922998
73763319
73771494
73772557
73767321
73771469
73771646
73771941
73700341
73929360
72179894
72408698
72408678
72179905
72408680
72408714
72408697
73697054
73697046
73697048
73697047
73697053
73697056
73495878
72873528
72873529
72985653
72985622
72985636
72985610
72985623
73599049
73599137
67164874
69475231
69474120
66943596
70930859
73939832
73940440
73943104
73900976
73900972
73900967
73900963
73900969
73900975
73900977
73900973
73900943
73900957
73900962
73900965
73900946
73900980
73900961
73900956
73900964
73900974
73900970
73900979
73900958
73900971
73901155
73901154
71957585
30218044
38174634
30218037
30217973
30217971
30218038
30218031
30217974
38174642
38174638
38174639
38174636
38174641
38174635
72890072
72890062
72889812
72891410
53766788
73964214
73964595
73964600
72455306
71499159
51863258
35383633
73971653
53031423
73973612
73974564
73973608
73973650
70027963
73709614
72597239
72597237
73980442
73932094
70767690
70767703
71024948
73410554
73755958
73421984
73421988
73422124
71559873
73989797
73989796
73989799
73989800
73989795
21037868
64907408
73392719
66199081
66200001
66200665
30650035
30650009
30650074
30650055
30650085
30650030
30650094
53029567
72664843
37253012
37283267
71717852
73439645
73995259
48102897
48102898
45278055
49253132
51375456
52901388
53632238
51863283
59158490
59148710
71346691
60184552
71347419
60680331
60307896
60441155
61879371
62336444
71663495
71347598
63043599
63044657
63435674
64752068
65791803
65710696
65710698
66387991
67794962
66677726
66845461
67387373
67866161
70014112
67887656
67887644
70755766
74000485
69790870
74001672
71151063
70414847
70414753
70414748
70414752
70414750
70414858
70414851
70414856
70414857
70414852
70414855
70414854
70414853
70414861
70414850
70414862
70414863
70414905
70414928
70414929
70414882
70414888
70414885
70414914
70414932
70414904
70414899
70414924
70414894
70414864
70414925
70414912
70414889
70414883
70414915
70414880
70414931
70414884
70414922
70414879
70414916
70414900
70414930
70414955
70414959
70414919
70414918
70414910
70414887
70414926
70414958
70414886
70414913
70414896
70414892
70414957
70414895
70414903
70414908
70414907
70414881
70414898
70414917
71070768
71070702
71072145
71346914
71514866
71515131
71414917
71497503
71496502
71496287
71496862
71496969
71498074
71496393
71720463
71923086
71922968
71922956
71982814
71982746
71982338
71980721
71982748
72002359
71982744
72050484
72098964
72277371
74002796
72306998
72227101
72315590
72315594
72260124
74003417
72319453
72318392
72476778
72476411
72476443
72476754
72464447
72461692
72497602
72519135
72515723
72516685
72516582
72520216
72520191
72517676
72517688
72516830
72517698
72517074
72517346
72516827
72516828
72517340
72517697
72517332
72517969
72517848
72518452
72518475
72517968
72518474
72612713
72694278
72694274
72694259
72694276
72689339
72709873
72711538
72741637
72771134
72794154
72794895
72890973
72890784
72891207
72891083
72890972
72890783
72890990
72891008
72797908
72890772
72891080
72891002
72795772
72795770
72795857
72795807
72795806
72891232
72796209
72796212
72796296
72796200
72796300
72796318
72796153
72976595
74004786
73661611
73730776
73716060
71346547
71350470
71348529
71348657
74009529
74009525
74009530
74009501
68103245
69185575
68098217
68090537
72516623
72518551
69210696
72628101
71655175
71346707
67107525
74015644
37282290
50839320
33719201
74010697
74011329
69310701
42697263
58951560
74021756
65618081
54204127
74026281
74026280
74025806
74025956
74026031
74026136
74025751
74025823
74025755
74025820
74026139
74026016
74026138
74026005
74025781
74026137
74025819
74026418
74026306
74026388
74026295
74026408
74026422
74026411
74026391
74020367
74020542
74020366
74020368
74020544
74029008
74029676
74029042
74029513
74019427
74019436
74023832
73536140
73536163
73536138
74024059
74024085
73943529
74037322
74037320
73955812
73961519
73961360
73961354
73958002
73958330
73964007
73964010
73964176
73964006
73964121
74022370
74022420
73956025
73955943
73955924
73958820
73958805
73958808
73958816
73958574
73958851
73958793
73965363
73965096
73965203
73965076
73965226
73965098
74023230
74022476
74023208
74022514
73956865
73959199
73959132
73959058
73817614
73963673
73963221
73963494
73963686
73963688
73963681
73963223
73963679
73959302
73959261
73963917
74026813
74026811
74026735
74026820
74026815
74026816
74026823
73000553
74039310
74022525
74023932
74023792
74023176
74025827
74025826
74022725
74022672
74022674
74022724
74022678
71765422
71765084
74041664
73766033
73766098
73766117
73766019
73766030
73766116
73766108
68735345
68735346
68911432
68911437
68735336
68911419
68911438
68911435
68911447
68911441
68911429
74023127
74023106
74022016
74022028
74022026
74022030
74050724
74021778
74021779
74022859
74024007
74022836
74023987
74022839
74024002
74023955
74022857
74022863
74024009
74022470
74021856
74021873
74022385
74022468
74021870
74021869
74021860
74021867
74022449
74022490
74022465
74021868
74021872
74024023
74022536
74022577
74022569
70728203
74010321
74010316
74023064
74052864
74053529
74053205
74053702
74054862
74053687
74052858
74052676
74054861
74053260
74054863
74054892
74053814
74022077
74022157
74022130
74022208
74022085
74022155
74022223
74056081
74053691
73850727
21635716
74055814
74056308
74056545
74056286
74055840
74056090
74057365
74057859
74057818
74058177
74059130
74058537
63767985
74058959
74059345
71308118
71307845
71306637
71308192
71308439
73996306
73967551
74057632
74061058
74061062
74061054
74064456
74055842
74055846
74055843
74045965
74055849
74055845
74062010
74062381
74063729
74061970
74072452
74059144
74076241
74072785
72462560
72462824
72462847
72462827
72462671
72462448
72462594
72462539
72462879
72462845
72462802
72462538
72462500
72462480
72462797
72462504
72462569
72462473
72462603
72462436
72462502
72462529
72462601
72462520
72462547
72462596
72462808
72462550
74103498
74103135
74103402
74103460
73978518
73978462
73978551
73978464
73978536
73978492
73978689
74085259
74085494
74085082
74086143
74085246
74085779
74085282
74085646
74085328
74085335
74085561
74085508
74085798
74085631
74085623
74085778
74085627
74085611
74085443
74085440
74085741
74085178
74085524
74085954
74085792
74085828
74085695
74085685
74085659
74085653
74085796
74085458
74085280
74085586
74085606
74085844
74085083
74085131
74085121
74076876
70334580
73987707
73987656
73987638
73987683
73987676
73987545
73987515
73987650
73987710
73987539
73987522
73987585
73987513
73987643
73987564
73987540
73987535
73987696
73987541
73987589
73987611
73987579
73987607
73987629
73987705
73987590
73987652
73987627
73987519
73987518
73987653
73987717
73987533
73987524
73987517
73987680
73987531
73987677
70480646
72374732
74127680
72166894
72867103
72891385
72890057
72890039
73429490
68712256
73766038
73766037
73786877
73789868
73902686
73830988
73903022
73847407
73901674
73850573
69474106
73989956
73755045
73755043
73755042
73755037
74139948
74140696
74140947
74157005
74141308
74141398
74141467
74141221
66622699
74151170
74151176
74151179
74146039
74151171
74151162
74151178
74148055
74151182
74169902
74169896
74169901
74169897
74169905
74169912
72388522
74171574
54990538
54990469
54991163
54990467
54990442
54990489
73969851
43874597
74174546
69576899
69576847
69555909
69576859
69576852
69576904
69576886
69576850
69576846
69576834
69576845
69576858
69576838
69576836
70311488
69536480
69555942
69576844
74175385
74175386
74175383
74178273
74178264
74178254
74178261
74178257
69522725
74178270
74178773
74179113
74179038
74179003
74178750
74178645
74178811
74180018
74180021
74180037
74180020
74180015
74184059
74178762
74178752
74179954
74178671
37544276
74185405
74185403
74185694
74185691
74185693
74185695
74186519
73961577
73961607
74186727
74187258
74187554
74187354
74187127
74187557
74187558
73716198
73716088
73716085
58742402
73903195
18425600
18429323
18427226
47622628
67164863
65752275
73769955
71348130
71605017
73766095
73766103
73948919
73949502
73946555
73946554
73947736
73947781
73961738
73961715
73961609
73961731
73961601
73961726
73961789
73961616
73961656
73961670
73961744
73961557
73961591
73961754
73961869
73961595
73961682
73961712
73961629
73961845
73961638
73961669
73961558
73961740
73961729
73961653
73961783
73961660
73961693
73961666
73961627
73961641
73961861
73961900
73961714
73961881
73961567
73961596
73961979
73962063
73961964
73961940
73961978
73962067
73962106
73962187
73961928
73961966
73962157
73962116
73962071
73962035
73962122
73962075
73962057
73962087
73961957
73962162
73964899
73964858
74019255
74019266
74019269
74019268
74019262
74026903
74036639
74004411
74004574
74005334
74004872
74053942
74051830
74053934
74051842
74054911
74054309
74047811
74052157
74051840
74051832
74051835
74052177
74054308
74052166
74051833
74051841
74052956
74051843
74070556
74070842
74056165
74057702
74110760
74174356
74163210
74163098
74163227
74175233
74175234
74170992
74171067
74171022
74171091
74170764
74171478
74171370
70634558
71761256
71762181
73000816
52468726
52739477
71348373
71322827
72856301
74002552
41151420
41149627
41151085
41152015
41149680
41149626
41151407
41151442
41160102
74178790
74178778
74178786
74178806
74178813
74178805
74178779
74178777
74179024
74178784
74178787
37271231
72966519
74180047
74202438
74202437
74202429
74202435
72130837
72130607
70942635
70942632
70942668
73766120
73766118
73766034
73962419
74210439
74210430
74210441
74210444
74210442
74210446
74210433
74210440
74210445
74210435
74210438
74206203
47321175
47321245
74207527
74208204
74208191
74210434
74210436
74210437
74210432
74207113
74208122
74208119
74206620
74208118
74206619
74206612
74206610
74208595
74206752
74206684
74206705
74206743
74206707
74206692
74206676
74206680
74206722
74206691
74206700
74206681
74206686
74206712
74206685
74206690
74206718
74206689
74206702
74206708
74206703
74206699
74206687
74206715
74206704
74206675
74207895
74206940
74207793
74206944
74206950
74206846
74206843
74206786
74206787
74206847
74207407
74207435
74207417
74207463
74207410
74207413
74208070
74208116
74208106
74208117
74208115
74208104
74208105
74208114
50793127
74206353
74207601
74207615
74207591
74207622
74207621
74207616
74207613
74207620
74207602
74207599
74207636
74207637
74207624
74207629
74207625
74207631
74207627
74207623
74207795
74211559
74211565
74211562
74211567
44605720
44594554
44605691
44594550
44594556
44594555
44594552
44594551
42697267
42697266
44594553
73426580
47312995
73824446
74213611
73597428
73597443
74162576
74165895
74163885
74174344
74166062
74165929
74174323
67235359
66308739
71414937
73894228
37544746
74206435
74206425
46851638
73317138
69513150
73901589
74036658
74207414
72447691
74054909
74050963
74051845
74050973
74054901
74050966
74048129
74052160
74054907
74050965
74048134
74051132
74053236
74050972
74051141
74049050
74052149
74045553
74207141
74207147
74207187
74207142
63697709
58960125
66589611
74044263
65744915
74046050
74047563
73536165
73536166
73536141
74221578
72634192
74215036
74215037
74215045
74215043
74215041
74215042
74215040
74215044
74215039
73926654
74071155
62798564
74227672
63934979
74238720
74050727
73962335
73960203
71324452
73928121
73928112
73928120
74020822
74020816
71172269
74020841
74168529
74241180
74241177
74241181
74250735
74254786
67760697
74188214
74253174
55004910
74252643
74259929
74260731
74260217
74260047
72523697
72814007
72815945
73755457
73766099
71172268
72853554
72166880
72166885
73850906
72523654
72523494
72523718
72523565
72719295
72523731
72523568
72523673
72523724
73756520
74188600
74198445
74188987
74189697
74189502
74189658
74197290
74197283
74229920
74230523
74229918
74230524
74229873
74229871
74229863
74229869
74229906
74229919
54869355
21371504
41046907
72449360
46835690
64542356
64543276
64542342
64542339
64542790
64542366
64541372
64542372
64541835
64542135
64542369
64542340
64541603
64541609
64541606
64542371
64542779
64542349
64541366
64542789
71759923
64533089
52739473
74268667
74268584
74268728
74268624
74268639
74268664
74268591
74268590
74268661
74268710
74266300
74268636
74268739
74268760
74266410
74266517
71347414
71655182
71348534
73997814
73997808
73766112
73997815
71348000
73997810
73766104
73997816
73997813
73766096
73552681
73552404
71348072
71347399
71347440
71351452
40078401
73962154
73962024
73962043
73961724
73961628
73961559
73961968
73962171
73961605
73961560
73962094
73961764
73962130
73962044
73961626
73961917
73962175
73961604
73961606
74267448
74268763
74267994
74268043
74268725
74268872
74268907
74268869
74268209
74268245
74268242
74267753
74267721
74267325
74266354
74266336
74267085
74267039
74267155
74268521
74268477
74268527
58740545
74266129
74266140
74266094
74266021
74266102
74266092
74266087
74266089
74266091
74266116
74266098
74266096
74266118
74265953
74266100
74266104
74266791
74267154
74266778
74266825
74267131
74267267
74266817
74266777
74266818
74266816
74266790
74267265
74267674
74267910
74267965
74267693
74267658
74268058
74267689
74267697
74267692
74267695
74267691
69325654
70820505
74277331
74277301
74277309
74277308
74277333
74277326
74277246
74277324
74277327
74277254
74277371
74277322
74277311
74277521
74277502
74277523
74277572
74035727
74035713
74035996
31022180
33503641
74278299
74278298
74278347
74038451
74038433
74038508
69485926
74222344
74278735
74278738
74278740
74110011
74124275
74124326
74123193
74123982
74124112
74124999
67570649
42700921
44605701
44605747
44605759
44605738
44605775
73756135
73756816
73756677
73755886
73756679
73756678
73757531
73757282
73756609
73756638
73756646
73755983
73756131
73757556
73757553
73819851
73819824
73819847
73819848
73819811
73819850
73819803
73819801
73819804
73819808
73819806
73819852
73819813
73819849
73819837
73819814
73820015
73819997
73819990
73819853
73820048
73819994
70734925
71415702
71414911
71414888
38375575
72619530
72619535
72619547
72619539
72619542
74203352
74291856
74291689
68271947
69475257
66945118
47011912
17671270
72125455
74289638
74071529
74071033
72890033
72796706
73309164
74070584
74227395
74293192
74293218
74293216
74293689
74293762
74058869
74059393
37544908
37111845
37544546
68291899
41634
39873091
74111262
74111563
74112351
74113136
74113121
74112934
74116679
74116007
74115996
74116011
40532667
40532668
40814774
66500413
74317229
74317286
72634691
74163199
74163218
74312140
74312106
74312104
74312129
74312125
74312114
74312120
74312078
74312154
74312081
74312115
74312080
74312145
74312092
74312068
74312065
74312073
74312088
74312150
74312119
74312091
74312079
74312110
74312064
74312093
74312075
74312143
74302568
74300006
74164050
74164061
74164031
74164051
74332449
60129686
74342807
74342810
74342803
74342815
74342804
74342755
74342799
74342809
74339936
74340041
74340026
74340119
64541610
64542364
64542142
64541376
64541377
64541604
64527212
64527490
74340128
74339939
74339018
74339037
74346908
74350553
74350563
74351207
74353499
74353523
74353516
71348034
71348128
71346868
74339808
74339807
74339809
74349319
74349350
74349349
74348296
74348312
74349737
74349726
74349781
74349729
74349739
74349779
74348471
74357281
74347642
74347598
74347633
74347634
74347563
74349641
74349643
74349629
74349646
74349628
74348127
74348204
74348195
74348201
74348197
74348189
74348146
74348198
74348202
74348175
74348207
74348205
74348165
74348176
74348203
74348371
74348366
74347738
74348369
74347753
74347739
74348412
74348372
74347724
74347716
74348374
74348370
74347737
74347911
74347899
74347961
74347873
74347918
74347905
74347472
74349577
74349531
74349706
74348273
74348286
74348293
74348261
74348291
74348284
74348278
74348288
74348267
74348263
74348275
74348269
74348257
74348280
74347757
74348613
74348532
74348597
74359501
74304763
72443206
74363050
72443274
72443862
72443517
74259177
74259037
74259157
74259030
74259036
74259031
74259501
74259502
74259439
74259440
74260548
74260673
67408449
74364049
74364736
74363800
73696006
42370490
73695994
74045994
73930409
73930403
72318690
74384656
74384653
74384635
74384645
74384643
74384646
74384654
74384649
74384650
74384644
74384647
74384648
74384651
74378040
59169308
74393503
74389366
57298949
56160627
74348654
74348652
74348622
74268381
74348562
74348658
74348472
74348626
74348528
74348475
74348662
74348624
74348634
74348660
74348651
74405031
74411568
71054286
71054320
71054281
71054796
71054834
71054789
71054762
71054830
71054837
71054774
71054839
71054836
71054780
73756132
73756130
73755915
73755907
73755868
73755871
73756114
73755925
73756163
73755910
73755916
74250626
74253077
74253079
74253052
74178993
74413285
74253384
74253351
74414877
73636113
73960525
73960403
73960231
73960413
73960397
73960229
73960338
73960526
73960399
73960396
73960332
73960342
73960398
73960522
73960518
73960489
73960527
73960400
73960319
73960230
73960232
73960375
73960402
73960238
73960401
73960404
73960440
73960491
73960254
73960233
73960524
73960528
74294991
73960628
74294988
74294973
73960636
74294992
74294957
74294989
74294987
74294975
73960610
74294976
74294986
74294990
74294985
74294974
74295107
74294932
74414969
74418358
74414957
45500278
74420621
74277299
74410813
74410810
74404642
74404767
74404592
74404644
74404769
74404646
74404641
74404643
74404772
74404594
73751975
53882671
40689789
73757245
73755897
73756634
73756213
73756674
73756755
39868163
38345565
36907455
58783699
71415703
71410644
36597864
74448810
74448811
36682068
36682114
74448966
38498746
38500900
74437143
74437237
51864358
58781915
51864356
21809206
37544190
37325367
71586831
72619528
38375657
71411768
74464051
74464001
74464048
74426141
74426207
74426122
74426143
74468738
44365531
74470408
65708237
73958849
73958906
74293189
74293182
74293161
74292977
74292959
74293130
74293188
74293166
74293795
74293796
74293797
74293780
74293788
74293782
74293613
74293792
74293783
74293786
74293747
74295037
74295035
74406965
73751979
71054732
71054854
71054798
71054771
71054743
71054822
71054274
71054868
71054217
71054251
71054272
71054804
71054220
71054823
71054203
71054828
71054755
71054827
71054777
71054213
71054224
71054210
71054269
71054208
71054240
71054288
71054263
71054258
71054856
71054767
71054802
71054318
71054825
71054814
71054824
71054244
71054290
71054746
71054857
71054295
71054238
71054769
71054279
71054764
71054792
71054284
71054794
71054292
71054815
71054748
71054231
71054833
71054859
71054843
71054831
71054849
71054757
71054760
71054855
71054819
71054267
71054860
71054816
71054840
71054861
71054265
71054806
71054215
71054308
71054242
71054784
71054803
71054249
71054277
71054847
71054800
71054253
71054851
71054206
71054236
71054311
71054852
71054805
71054222
71054752
71054247
71054846
71054817
72374622
74296444
52856990
53189476
54193548
52894785
52362449
74481903
74070574
74071345
74073970
74108671
74073902
74073895
74073905
74073892
74296395
74296394
72890761
72890762
72905093
74484807
74484777
74484768
72891394
72891389
68651193
55765008
67476692
74491132
74500744
74501031
73387207
74315536
74319941
74315387
63256156
63256160
63256157
71173385
71174579
74514507
74514636
44425010
44385716
44388430
74291929
44425474
62317911
46471747
44440378
49413704
74026742
74026814
74026821
74026771
74026759
74026817
74026740
74026743
53658686
58843403
74026750
74026818
74026822
74026755
74026819
65706037
71346697
63606855
61560006
71911419
71361896
71361913
73819799
73819791
73820001
73820000
73819789
73820005
73819792
73819829
73819989
73820021
74520284
74520282
74180017
71951761
73552704
73552686
73552385
73553138
72966928
74179632
74179036
34640505
58978684
73716074
74527265
45007631
57637397
74527308
71908507
72401564
71348383
72166715
74191814
74191819
74191841
74191818
74191825
70945784
74111134
74294328
74293858
72891300
72891292
72891298
74294229
74294107
74297025
74296533
74296890
74296461
74296568
73549859
52362156
74329367
41871697
41871692
41871705
41871710
41871701
41871652
41871673
41871662
41871694
41871666
41871653
41871661
41871702
41871699
41871703
41871708
41871695
41871672
41871700
41871690
41871651
41871657
41871696
41871660
41871650
41871714
41871698
41871688
41871713
41871691
41871655
41871667
41871709
65613367
65639261
72797922
74533285
74533287
74253568
74537248
62270943
62467054
62305377
62306945
63031477
62255086
61891409
61751943
71540715
71936920
71936959
71936849
71936993
71937028
71937024
71936902
71937056
71936969
71936856
71936918
71937016
71540721
71936868
71936950
71936912
71936926
71540729
71936960
71937053
71936866
71937018
71937057
71936923
71937054
71936847
71936854
71937048
71936859
71936886
71936972
71936932
71936894
71936968
71936955
71936963
71936906
71937155
71937133
71937115
71937061
71937100
71937089
71937151
71937091
71937107
71937114
71937074
71937109
71937096
71937156
71937122
71937069
71937110
71937082
71937067
71937149
71937164
71937101
71937181
71937183
71937176
71937148
71937139
71937145
71937174
71937157
71937060
71937071
71937087
74437117
74437176
74437245
74437139
74437235
69307984
74551955
74552924
74552928
69306969
71523774
74556097
74277334
74277338
74253589
74179043
74277269
74179017
74277312
74178772
74516258
74516321
74516192
74523599
74523601
74516330
72465277
74523609
65240387
74558868
73646069
74040529
74040540
74555039
74555038
74555168
74555037
74555036
74555192
74362341
74362363
74362352
74362347
74362380
74572926
74572931
74273090
74274066
74362572
74362596
74362623
74362506
74362525
74362646
74362541
74362670
74362867
74362905
74362514
74580491
74584658
64017166
42548406
74564023
74591715
74596049
74595778
74577052
74576972
74577029
74577011
74577027
74577054
74577014
74577064
74576999
74577013
74577044
74576997
74577026
74576983
74576994
74577012
74577084
74577057
74577056
74576975
74577082
74576996
74577003
74577048
74577002
74576980
74576984
74576986
74577050
74577008
74577031
74577066
74576973
74577080
74576998
74577034
74576971
74576977
74577051
74577000
74576988
74576995
74577018
74577069
74577058
74577006
74577047
74577106
74577005
74576970
74577033
74576982
74576993
74577016
74576990
74576985
74576992
74576981
74576978
74577062
74577071
74576987
74577004
74577053
74577087
74577032
74576976
74577068
74577039
74577030
74577009
74577037
74577046
74577036
74577015
74576979
74577059
74577010
74577076
74577035
74577060
74577078
74577072
74577067
74577085
74577061
74576989
74592106
74579965
73957043
74111835
74111227
74113772
74113366
74118487
74119703
74120913
74121145
74121458
74123012
74121156
74122251
74121135
74121389
74122508
74117887
74117890
74124086
74294208
74293895
74293859
74293863
74293864
74294763
68648972
74606028
37545642
74605631
71850391
74122957
73957058
74505041
74505062
74505138
72272812
45365080
72274032
74617516
74615402
74609674
74609225
73547460
47349482
73549876
74619885
41151991
41151071
74599995
74600029
74600026
74599873
74599871
74599869
74599878
74599857
74600603
74600218
74600217
74600225
74601336
74601312
74601319
70577027
70820485
69308364
70820486
70612146
72130589
72130591
72130839
72130596
74633596
74610871
74619433
74614558
74619431
74635383
74635617
74635770
74112861
74109892
74112855
74112848
74112864
74112860
74112331
74109891
74646669
74645881
74645832
74646658
74646642
74645886
74646650
74646654
74646647
74646646
74646637
74646641
74645887
74646648
74645747
74645739
74646636
74646652
74646635
74645738
74646666
74645745
74645749
74646656
74646651
74645830
74646673
74646665
74646657
74646655
74645774
74645769
74646689
74645772
74645835
74645883
74645891
74645849
74645737
74645766
74645828
74646684
74646670
74645825
74645834
74646649
73440177
74646344
74646351
74646412
74646361
74646362
74646326
74646328
74646364
74646469
74122950
74295619
74295358
74295726
74295270
74295450
74296554
74296599
74296498
74296430
74296766
69512848
74639957
74639854
74644550
74644599
74644565
74644560
74644403
74665794
74665795
74665786
74666870
74647915
74645272
74645320
74645311
74645318
74645187
74645183
74644496
74644347
73992518
74662769
74662758
74669990
74678751
43066909
45012472
63935012
74646096
74646094
74646091
74644715
74678736
74678737
74677071
74580358
72125578
72125609
72125587
74692828
74599647
46629105
74697473
74697469
74697464
74697817
74697818
74697831
74697829
74697824
74697828
74697820
74697816
74697813
74697772
74697821
74697814
74697826
74697823
47644855
74334954
74333547
74333072
74333030
73755936
74324686
74374023
72711716
73426582
62064623
74688404
34639557
72551562
65312041
50838624
68327445
69986892
73706156
73425922
33456485
37113098
74178748
74026756
74026812
74026746
74178666
72298565
72307109
72306316
72300918
74706001
74706818
68931866
74713175
30580493
30580481
27568981
30217978
30218042
30218043
38174637
46386993
51680285
51680354
51680323
51680295
51680350
51680291
51680351
51680328
51680326
51680337
51680333
54851301
74182464
59541155
59541498
60198792
62341337
63958982
63960998
63966330
63966218
63961032
63734179
64169230
65070296
65070304
65066149
65530341
67094894
66722302
66692702
66692690
67474247
66715197
66692705
66715200
67474232
66722305
67334011
67333981
67474235
66715209
67333984
66692693
67474240
67094995
66722293
67334005
67390687
68538022
68540400
68538025
68136509
67735904
68136515
68136506
68136512
68539084
68146443
67854565
68540403
67811069
74718419
74718381
74718383
74718121
74718124
74718126
74718122
74718209
74718221
74718188
74718161
74718189
74718197
74718206
74718212
74718357
74718187
74718195
74718185
74718214
74718182
74718371
74718368
74718181
74718190
74718184
74718149
74718369
74718216
74718166
74718162
74718192
74718359
74718211
74718254
74718300
74718262
74718183
74718264
74718160
74718261
74718271
74718167
74718257
74718207
74718256
74718157
74718186
74718280
74718159
74718292
74718191
74718156
74718201
74718259
74718163
74718282
74718370
74718367
74718298
74718277
74718265
74718193
74718430
74718444
74718442
74718400
74718403
74718474
74718450
74718438
74718432
74718436
74718402
74718455
74718440
74718465
74718397
74718468
74718395
74718453
74718445
74718451
74718434
74718457
74688061
69310464
68682579
69310455
69310448
69310461
69310458
69310451
69310445
68682532
69310436
69310439
69146452
69308353
69306862
70040408
70038142
70053451
70042171
70055852
70057870
70043204
70051424
70051403
70053906
70057417
71369627
71070703
71070757
71307785
71306936
71308212
71307722
71311613
69969293
71906488
70058105
70316244
70731959
70316241
69876795
71005066
71906495
70574424
70263941
71005069
72318120
72318561
72318204
72317973
72467483
72467426
72467404
74686286
73317117
73317114
73266290
73343242
73382093
73421964
73431936
73431921
73771491
73583744
73612608
73784269
73775490
73771483
73773542
73774827
73757320
73757338
73820030
73819809
73756535
73757329
73755973
73811213
73810772
73810632
73811257
73811253
73811024
73829899
73966013
73966857
73968322
33122363
73961358
73961364
74023115
73991397
74011161
74036654
74036659
74023973
74022800
74022914
74022047
74022020
74005366
74023699
74022467
74024055
74023825
74071216
74071035
74070890
74071021
74071219
74070891
74071000
74071147
74071146
74071291
74071098
74070894
74070847
74070850
74071129
74071192
74071028
74071320
74070893
74071337
74071085
74071533
74071551
74071621
74071793
74058812
74076427
74117864
74122201
74163915
41318014
41317984
74164366
72891285
72891306
72891297
71914786
74731574
73329099
73329098
73329102
74733141
74733137
74733170
71633538
70960899
74734455
74734462
74743282
74746340
74742140
74742149
74742148
74742139
74742142
74742141
74742135
74742130
74742134
74742147
74742145
74742143
74742138
74742136
74742144
74742132
74742131
74612506
73395063
74168518
74112853
74701919
73767684
74758400
68061555
68062365
68061406
68061828
68062089
68061696
68061633
68061526
74749458
74749456
74749457
74749463
74749466
74749467
74239896
74239895
48066870
74754539
74752854
74771265
74763501
74761275
74772606
74765813
17941530
17941712
17941842
17941752
17941764
17941813
17941814
17941779
17941958
17942258
17942073
17942130
17942154
17942406
17942361
17942402
17942379
74729312
74777559
74777502
74777510
74777548
74600150
74600694
74733202
74600549
74600559
74599896
74733204
74733203
74600166
74733214
74733237
74600169
74600713
74733205
74600168
74733371
74600581
74600583
74600721
74601381
74601191
74600333
74733212
74733208
74600696
74600359
74601198
74659336
73961799
74780993
74782211
74437343
73829982
73830018
72945550
72755593
74437113
74606769
74752332
63083504
74752333
74766337
74760447
74770011
74759821
74759588
74759858
74765038
74772393
74765047
74767847
74794209
74798566
74797396
74797183
74797216
74798589
74803148
74808474
74808607
74808639
74808652
74808616
74808473
74808640
74808468
74808469
74808630
74808626
74808641
74808647
74808621
74808471
74808472
74808601
74808644
74808636
74793378
74793331
74793389
74793896
74793551
74793400
74793394
74798835
74798905
74798971
74798978
74798991
74798846
74798836
74799002
74799375
74799365
74794435
74794456
74794449
74794414
74800140
74800075
74799912
74813861
74815697
74813894
74815707
74813895
74813873
74813893
74815717
74815693
74813888
74797808
74797463
74797532
74797511
74797731
74797735
74797517
74797513
74797728
74797540
74797472
74797717
74797541
74797968
74805521
74799836
74805489
74805375
74805451
74818021
74818011
74820105
74819837
74819848
74819856
74819864
74804709
74804942
74804953
74805203
74805217
74804690
74805229
74804728
74804954
74804952
74805214
74804653
74804990
74805211
74804650
74805213
74804708
74805224
74805000
74805218
74804940
74804692
74805216
74805212
74804944
74804691
74804955
74804951
74804950
74804946
74804948
74805215
74820358
7380542
7380547
7380540
7914455
7380548
7380532
74827914
74827912
74827913
74827915
69306958
74825062
74795693
74806690
74797370
74798561
74799446
74794262
74797379
74797363
74797362
74797299
74797378
74798497
74798545
74798559
74798531
74797390
74798584
74797270
74794192
74797383
74798845
74799592
74798582
74797360
74798850
74797384
74799447
74797389
74797382
74799448
74798555
74798854
74828449
74830802
74828756
74830764
74828757
74828395
74828436
74828478
74828408
74828422
74830123
74828725
74437353
74828604
74818651
74818654
74599589
74838673
74838629
74805507
35528034
74842974
74842977
74842982
72952356
74838676
74838645
74837920
74283466
74848213
74848212
40689312
72891411
74848194
74848162
74848140
74848174
74849501
74836636
73367935
74812441
74849493
74439414
74805381
74805378
74849988
74850015
74849989
74759277
74759852
74836211
74812265
74814811
74817776
74819755
47328699
74537262
53428643
74440174
74440039
74440072
74440148
74439086
74439115
74435539
74440450
74440713
74440728
74440732
74439694
74439690
74439643
74439678
74865054
74070655
74070876
74071008
74070991
74071243
74070817
74026299
74026551
72467333
74868375
72890704
72889992
72890774
72797910
72890055
72890031
74869388
74869387
74880326
74828595
74850647
74850645
74700753
74700756
74119499
74121757
74110004
74118568
74881856
74880748
74881267
74885980
74674560
72130597
74881503
74881491
74881410
74881683
74881443
74881439
74881441
74881444
74881448
74881556
74881558
74881540
74881623
74881543
74881553
74881555
74881542
74881560
74881561
74881574
74881557
74881544
74881575
74881552
74881562
74881810
74881745
74881768
74881714
74881764
74881807
74881739
74881828
74881705
74881831
74881799
74881815
74881851
74881748
74881711
74881771
74881742
74881760
74881818
74881787
74881873
74881781
74881812
74881784
74881708
74881774
69146973
74880582
74880580
50839500
74451494
73640462
73640494
74880651
74880677
74880650
74880670
74880732
74880681
74880669
74880734
70231611
74894037
74894063
74894062
74894045
74894578
74894590
74894646
74894633
74894658
74894574
74894625
74894628
73000809
73000818
73000815
74881311
74881310
69348326
69312487
69312234
69312521
74893158
74075408
74072106
70313072
70307319
74071929
74907548
73296729
74907529
74908734
74592192
74893713
74893712
74893710
74893709
74179115
41782230
57733329
61295715
59131241
67535103
61561566
71203026
69308266
69308105
69308249
69308195
69325644
69308349
69308381
69307973
69307978
69308301
69308379
69308335
69308371
69308157
74076924
74137728
74363796
74384336
74384289
74383212
74381918
74404791
74406927
74480713
74513427
74513426
74504997
74537264
74537251
74537250
74528142
74528776
74528761
74527933
74527876
74597342
74579914
74608753
74567174
74572240
74921860
74648414
73961232
73961046
73961042
73961215
73961214
73961197
73961233
73961081
73960995
73961037
73961222
73961098
73961038
73961175
73961077
73960938
73961055
73961056
73961120
73961185
73961218
73961019
73961007
73961251
73961255
73961271
57475904
74927504
74923373
74923211
74923354
74923368
70611933
74925140
74928316
67394189
69308348
69308092
69308330
69308170
70611925
69325598
74188404
74188517
34868115
74635701
74102792
74104149
74410806
74928631
69643606
68682564
44234118
42749001
64183801
70820496
72125658
72125652
72125637
72125655
74932589
74932610
74932599
74932622
74677532
74697810
74689337
66453068
72952795
46623536
74715137
71348694
70731824
57733328
74914343
74942126
74804782
74805130
74827958
74827956
74828030
74805157
74815657
74815716
74828037
74805197
74805132
74805186
74828822
74752878
74753004
58960288
74891692
74891693
74892018
74891937
74891954
74922993
1369050
74956563
74959063
74957566
74958781
74957564
74958821
74957563
74957567
74957562
74958829
74958795
74960252
74961468
74962383
74962857
74961743
74961926
74962023
74961576
74962848
74961483
74962842
74962847
74962845
74962852
74961827
74962849
74962104
74961512
74962850
74961645
74962362
74962858
74962841
74963345
74963357
74963343
74963754
74963342
74963356
74963344
74963708
74963691
74963743
74963648
74963662
74963351
74963352
74963340
74963347
74963349
74918026
74816768
74933644
74939232
74938980
74938463
74939147
74937897
74937971
74937839
74938211
74938693
74939072
74938690
74938929
71254203
62062139
61066374
74686244
74685886
74910300
74909861
74910249
74909822
74910253
74910074
74909834
74910187
74977449
71215598
74977287
74977408
74977427
74977344
74977288
74686364
74686631
74686365
74686600
74686401
74686606
74686444
74686434
74686581
74686478
74849198
74849199
74850582
74849151
74850585
74910684
74910713
74910770
74910619
74910737
74910639
74910815
74910755
74910741
74686834
74686681
74686906
74686839
74686903
74686951
74910982
74911033
74911122
74911038
74910983
74910965
74977881
74978746
74977573
74980519
69643603
70313887
69310470
74804679
74804706
74804714
74804674
74804678
74987601
74985504
74676514
74989457
74989459
74989449
74988623
74437344
74992930
73461208
74988517
74988521
74988558
74988516
74988526
74988530
74988520
74988527
74988524
74992145
74992138
74994745
74992043
74992049
73969053
74464897
74441177
74440915
74441132
74440901
74441140
74440815
74440936
74484674
74943221
74402484
74992128
74988513
74827826
74971738
74971902
74827084
74827078
74827079
74827371
74361428
74361207
74361417
74361577
74826225
74826137
74826164
74826165
74826144
74826159
74826179
74826155
74826178
74826176
74826174
74826138
74826162
74826232
74826270
74826218
74826156
74826167
74826258
74826154
74826152
74826235
74826136
74826272
74826168
74826157
74826160
74826153
74826265
74826158
74826180
74826150
74827585
74827744
74827674
74827675
74826419
74361764
74361791
74361772
74361786
74826433
74826434
74826418
74361780
74826448
74826438
74826443
74826444
74361792
74361779
74361788
74361763
74361790
74361784
74361787
74826437
74361756
74361877
74361789
74826436
74361878
74361778
74361785
74361781
74826439
74826435
74826578
74995187
75022739
75030051
75032351
75030701
74074056
67297835
57888969
58279217
57888974
75035622
45355901
72282653
75020791
75020747
75020799
75020804
75020894
75020861
75020863
75020841
75020757
75020893
75020750
75020901
75020812
75020823
75021071
75021084
75020951
75021042
75021098
75021066
75053163
75048526
75048287
75048515
74995707
75037185
75037340
75037223
75037060
75037106
75037124
75037170
75037156
75037238
75037150
75037092
75037236
75037258
75037342
75037134
75037250
75037348
75037066
75037126
75037513
75037403
75037387
75037382
75037460
75037381
75037485
75037397
75037385
75037389
75037448
75037464
75037414
75037505
75037415
75037472
75037471
75056736
74929307
74929368
74929485
74929367
74929372
74929086
74929087
74929300
74929309
74929308
74929366
74931039
74929365
74931038
75030058
75033748
75032647
75032800
75034654
75034821
75056855
75021175
75020864
75063265
75063382
74948945
74948882
74948947
74948965
74948798
74949326
74949296
74949337
74949241
74949365
74949371
74949363
74949314
74949341
74949339
74949277
74949380
74949245
74949207
74949258
74949223
74949319
74949378
74949327
74949261
74949254
74949347
74949311
74949252
74949224
74949278
74949335
74949271
74949274
74949312
74949243
74949231
74949306
74949264
74949353
74949321
74949358
74949304
74949211
74949291
74949238
74949246
74949285
74949308
74949376
74949283
74949325
74949315
74949302
74949292
74949236
74949273
74949772
74949767
74949792
74949756
74949780
74949759
74949785
74949743
74949774
74949787
74949779
74949760
74949786
74949788
74949745
74949753
74949739
74949776
74949791
74949735
74949777
74949825
74949891
74949848
74949841
74949863
74949796
74949793
74949824
74949833
74949866
74949847
74949840
74949859
74949851
74949888
74949875
74949819
74949870
74949828
74949883
74949814
74949886
74949880
74949850
74949810
74949813
74949823
74949862
74949835
74949802
74949861
74949877
74949839
74949820
74949852
74949817
74949882
74949854
74949808
74949818
74949890
74949864
74949815
74949800
74949838
74949873
74949887
74949806
74949821
74949836
74949837
74949856
74949869
74949843
74949831
74949860
74949798
74949794
74949878
74949803
74949826
74949805
74949804
74949807
74949827
74949855
74949868
74949885
74949832
74949867
74949858
75058769
75087755
75055678
75055651
75055633
75062599
75061829
75061776
75061619
75061702
75061859
75061677
75061684
75061777
75063326
75063323
75121526
74871520
74871519
75027844
75027886
75027591
75027619
75027733
75027509
75027832
75133592
75133601
75133603
75133609
75133604
75134288
75134258
75134283
75134264
75134272
75134273
75134266
75134261
75134271
75134240
75134270
75134243
75134234
75134265
75134260
75124438
75139317
75139314
74978496
74978502
74978495
74978488
74978498
74978492
74978491
74978503
74978486
74978497
74978501
74978493
74745990
75141871
75141842
75141970
75141976
75141839
75141936
75141975
75141929
75141907
75141855
75141997
75141852
75141952
75141957
75141966
75141898
75141894
75141910
75141996
75141866
75141890
75141917
75141865
75141923
75141965
75141861
75141989
75141982
75141932
75141987
75141978
75141847
75141876
75141901
75141988
75141991
75141953
75141969
75141908
75141934
75141995
75142415
75154239
75156753
75149077
75149090
75149085
75149087
75149074
75160696
75160678
75162910
75151794
75152170
75152197
75152193
75152172
75151886
75162375
75162378
75162304
75163325
75163612
71042854
75169036
75169037
52163764
55047823
75164335
67600947
55048253
75170855
75170096
75170318
75161899
74992333
75181219
75181231
75185796
75150662
75151658
75151669
75120365
75188341
75188346
75150804
75152274
75193105
75167239
75167240
75176806
75176815
75176808
75176805
75176875
75176879
75176831
75190901
75199292
75209317
75192778
73208701
75211030
75211293
75205313
75204544
75200517
75218127
75217099
75217817
75213452
75206539
75198543
75220304
73491533
75173316
75206551
75168861
75202990
75202989
75169699
75223659
75223650
75223678
75223405
75223398
75223580
75229470
75229474
75229466
75229467
75229469
75205192
75205177
75205164
75205230
75205232
75205231
75205179
75205184
75205181
75205197
75205155
75205193
75205174
75205229
75205212
75205157
75205190
75205196
75205185
75205180
75205151
74280417
74280342
74280423
74280451
74280318
74280330
75216960
75231459
75022819
75233863
75233849
75233889
75233876
75233864
75233866
75238552
75235408
75136349
75245604
75257464
75248454
75252618
75252615
75263416
75263301
74933188
74933011
74933192
74932934
74932911
74932932
74933182
74933175
74932879
74933057
74933328
74933606
74933533
74933313
74933548
74933426
74933285
74933789
74933655
74933772
74933694
75201063
75269550
75268884
75028452
75271959
75022060
75023759
75153991
75153766
75022803
75277933
75252590
75271949
75271948
75220330
75220341
75220331
75220300
75249913
75148930
74408200
74408199
74408214
74408194
74408196
74408205
74408218
74408211
74408198
74408212
74408215
75264045
75264048
75263187
75264049
75263186
75264047
75288165
75288634
75289621
75288146
75288636
75305868
75295328
75231907
75231951
75231874
75318506
75317993
75321452
63083321
75332522
75332443
75332519
75332676
75332739
75332724
75263489
75333369
75230552
75332709
75343385
75343394
75343382
75217870
75217876
75217862
75347815
75347821
75347827
75347728
75347731
75347848
75350233
75350220
75350231
75351126
75350851
75351347
75353821
75353811
75353812
75353814
75356781
75356738
75356788
75356779
75356760
75348850
75348715
75349461
75348713
75349462
75349532
75349849
75349655
75349173
75349112
75349126
75349110
75349103
75350137
75350153
75348504
75348491
75349393
75348834
75357541
75357638
75357635
75352772
75332733
75332434
75332449
54869558
54869386
52164054
75360065
74942157
74942168
74942143
75353619
75353621
75353620
75353655
75353725
75353633
75370477
75370454
75370474
75370461
75370481
75360383
75353819
75353817
75353818
75237978
75237980
75239356
75239358
75239568
75239570
75381881
75381866
75380049
75380084
75380012
74934025
74934041
74934069
74934130
74934090
74934142
74934185
74933863
74933902
74933854
75175727
75175578
75175828
75175648
75175745
75175844
75175662
75175790
75175813
75175660
75175645
75175709
75175697
75175700
75175939
75175839
75174914
74934811
75174813
75174915
75174759
74934237
74934345
74934392
74934368
74934401
74934359
74934393
74934375
74934335
74934513
74934236
74934400
74934321
75369340
74934627
74934604
74934522
74934639
74934533
74934626
75175505
75175457
75175548
75175360
75202491
75203217
75203218
75202796
75202795
74503305
75399781
75348678
75205182
75395254
75395281
75397435
75397853
75398267
75397411
75397390
75397481
75395269
75395297
75396599
75395278
75395291
75397385
75395270
75397410
75395276
75398735
75398757
75399016
75399456
75399134
75399460
75399355
75399362
75399071
75399028
75398752
75398767
75399461
75398726
75398753
75399032
75399019
75399020
75398747
75399354
75399184
75398737
75399066
75399017
75399463
75399432
75399423
75399550
75399527
75399632
75399537
75399644
75399531
75399690
75400175
75400165
75399641
75399678
75400199
75400479
75400180
75399633
75399642
75399551
75399585
75399648
75400172
75399536
75400136
75399629
75400422
75399546
74526204
75402600
75402523
75402612
75401472
75401487
75401392
75401542
75402533
75402550
75401532
75401386
75401539
75401382
75402548
75401507
75402545
75401437
75401529
75401423
75402547
75401448
75396612
75398751
75382861
75427781
75421121
75421051
75421042
75421130
75421064
75421045
75421115
75421106
75421039
75421124
75421057
75421061
75377894
74997486
74997422
74997434
74997460
74997458
75469719
75469720
75470654
75487081
75407233
74659846
75497804
75493986
58196329
75496071
75502031
75502101
75498155
75498075
75498068
75498140
75498149
75498177
75498175
75503851
75506552
75506553
75506583
75506581
75506660
75314524
75314448
75315436
75315376
75316140
75356080
75314863
75314683
75314684
75314855
75355084
75355026
75527213
75532007
75532003
75532005
75253462
75253410
75529998
75529381
75567463
75567461
75567459
72628866
72628849
72628871
72628878
72628939
72629551
72629613
75560524
74813449
74828610
75302717
73208760
75611456
75611398
75611251
75615317
75615201
75615095
75615646
75615576
75615587
75615609
75615601
75615592
75615570
75615593
75615637
75615655
75615659
75615520
75615581
75615618
75615533
75615606
75615525
75615573
75615575
75615572
75615687
75615562
75615582
75615600
75615645
75615555
75615545
75615631
75615547
75615548
75615681
75615638
75615684
75615667
75615673
75615608
75615649
75615546
75615695
75615569
75615540
75615627
75615643
75615677
75615571
75615574
75615594
75615527
75615674
75615539
75615647
75615517
75615586
75615578
75615689
75615639
75615644
75615605
75615650
75615588
75615568
75615563
75615648
75615653
75615640
75615580
75615577
75615585
75615675
75615682
75615565
75615669
75615654
75615538
75615523
75615666
75615557
75615660
75615561
75615528
75615591
75615716
75615709
75615721
75615697
75615698
75615725
75615723
75615718
75615727
75615798
75615789
75615778
75615766
75615788
75615770
75615765
75615797
75615762
75615775
75615759
75615774
75615787
75615784
75615794
75615769
75615783
75615777
75615750
75615805
75615748
75615785
75615779
75615753
75615804
75615791
75615756
75615781
75615795
75615747
75615768
75615776
75615780
75615749
75615752
75615760
75615754
75615802
75615771
75615803
75615751
75615773
75615786
75615799
75615755
75615451
75615455
75615454
75615071
75615088
75617662
75619612
75619778
75621348
75621405
75621373
75621423
75621388
75621399
75622094
75622095
75621872
75622096
75621929
75622024
75621900
75622097
75624875
75621918
75621920
75621950
75621926
75621886
71347490
75633273
75633274
75633738
75633743
75632841
75634502
75634652
75634721
75634796
75636426
75636686
52163590
51171260
75636765
75638344
75638346
75638739
75639841
75639206
75643955
75643938
75643948
75643954
75643933
75643935
75638733
75638862
75638791
75638847
75638870
75638734
75638839
75638858
75638937
75638761
75639544
75639546
75645377
75644290
75644261
75644266
75644251
75644634
75644620
75644830
75644652
75644411
75644827
75644633
75644769
75644723
75644720
75644706
75644791
75644779
75644763
75644392
75644603
75644853
75644994
75645068
75644880
75645047
75645045
75644984
75645069
75644895
75644856
75645120
75645038
75644934
75644957
75645157
75645229
75645640
75646372
75630959
75634576
75643723
75647978
75647948
75647937
75647943
75647956
75647955
75647976
75647953
75647938
75647971
75647928
75647935
75647972
75647975
75647957
75647932
75647952
75647931
75647940
75647929
75647933
75647941
75647963
75647979
75647958
75647977
75648012
75647996
75648005
75647990
75647989
75647998
75648009
75648015
75648007
75648023
75648018
75648013
75647997
75648006
75648000
75647991
75647981
75648019
75648016
75647994
75647993
75647980
75648010
75648127
75648113
75648114
75648078
75648098
75648065
75648084
75648061
75648101
75648080
75648079
75648083
75648104
75648121
75648055
75648100
75648137
75648058
75648059
75648126
75648066
75648086
75648053
75648119
75648097
75648122
75648099
75648094
75648105
75648106
75648120
75648124
75648075
75648125
75648067
75648130
75648073
75648093
75648076
75648115
75648054
75648139
75648070
75648129
75648091
75648128
75648090
75648064
75648052
75648123
75648092
75648074
75648071
75644426
75644582
75644866
75648538
75648566
75648577
75648537
75648536
75650799
75649333
75649304
75649852
75650077
75650207
75650205
75650198
75650079
75650100
74340059
75654506
75655106
36426872
73222421
75649847
75650115
75650116
75660868
70878470
72130595
75656588
75656596
75678523
75665180
75665641
75665176
75666301
75666195
75666065
75666067
75666311
75678122
75678299
75678383
75678235
75678101
75678474
75678353
75678330
75678239
75678446
75678379
75678334
75660802
75660841
75659778
75659776
75659777
75659774
75659733
75659768
75659771
75659770
75659775
75659769
75659772
75659773
75659767
75660798
75660795
75678742
75702614
75678807
75678715
75678804
75699489
75720909
75732759
75733137
75333846
75739866
75739832
75739838
75739873
75739837
75739829
75739758
75739868
75739882
75739748
75745347
75742161
75742185
75742177
75746294
75739983
75740022
75739999
75740045
75740095
75740101
75739997
75740150
75739917
75739968
75740091
75740154
75739994
75740035
75739973
75740152
75739916
75740107
75740115
75740122
75740093
75740015
75740009
75739993
75739913
75740058
75740036
75740040
75740000
75739902
75740043
75740019
75740127
75739909
75740274
75740249
75740295
75740275
75740267
75740327
75740250
75740261
75740310
75740413
75740403
75740255
75740273
75740402
75740460
75740420
75740296
75740746
75740778
75740549
75740498
75740849
75740606
75740780
75740841
75740880
75740827
75740836
75740730
75740717
75740839
75740834
75740510
75740871
75740847
75740845
75740952
75740964
75741001
75740980
75740907
75740881
75740898
75740981
75741124
75741092
75741187
75741220
75741195
75741199
75741263
75741096
75741196
75741257
75741071
75741123
75741129
75741360
75741562
75741361
75741589
75741358
75741332
75741380
75741390
75741795
75741843
75741866
75741779
75741802
75741791
75741776
75741939
75741920
75741976
75741716
75741936
75741853
75741824
75741854
75741958
75741846
75741848
75741774
75741857
75741888
75741990
75741712
75742039
75742145
75742092
75742123
75742083
75742038
75742119
75730764
75732172
75732173
75732165
75732169
75732174
75732171
75732166
75732167
75732170
75749465
75749458
75749272
75747118
75656966
75756553
75757588
75751148
75751847
74204715
74205103
74204781
74204769
74204684
74204755
74204686
74204717
74204768
74204822
74204580
74205100
74204765
74204844
74204782
74204846
74204698
74204697
74204577
74204611
74204581
74204845
74204567
75762240
75762707
75750254
75750270
75759231
75758872
75758102
75759003
75758071
75758073
75758112
75760832
75759194
75758098
75758108
75758121
75759721
75758119
75759719
75759227
75759722
75759219
75758096
75759136
75759315
75759225
75760836
75759196
75759314
75758075
75760834
75758094
75759271
75758069
75758070
75759079
75759205
75759725
75758120
75758061
75758122
75758076
75758909
75758067
75758072
75759197
75758893
75759064
75759203
75758747
75759198
75759723
75758817
75758078
75759720
75759191
75758116
75758114
75760838
75759223
75758937
75759186
75759724
75759316
75758083
75758064
75759189
75758062
75759213
75758077
75758068
75758090
75758123
75759208
75758074
75759425
75768464
75768463
75766273
75772799
75776022
75776135
75776028
75776119
75776044
75776006
75776052
75776019
75775989
75776053
75776177
75776267
75776259
75776623
75778537
75778514
75778633
75332706
75785457
75789731
75789669
75791033
75792767
75796591
75796487
75810064
75810085
75810270
75810260
75810280
75810892
75234889
75812151
75811784
75811900
75811743
75811859
75811845
75811828
75816236
75816819
75811089
75811057
75811912
75816110
75657206
75815289
75815282
75815276
75815270
75815261
75815284
75815243
75815259
75815291
75815234
75815263
75815280
75815235
75815253
75815265
75815245
75815278
75815237
75815236
75815250
75815272
75815287
75815246
75815293
75815267
75815244
75815041
75815036
75815033
75815034
75815035
75815037
75815040
75822136
75822238
75822223
75822242
75822206
75822190
75822241
75822234
75822194
75822258
75823684
75823737
75823745
75823888
75823954
75823963
75823956
75823950
75832942
75837756
75656972
75658126
75658117
75658111
75658423
75658414
75838669
75658440
75840082
75842244
75842215
75844576
75844595
75844571
75844570
75844633
75844682
75844675
75678647
75678566
75678680
75851998
75486074
75486073
75855669
75855663
75857436
75865686
75857474
75857471
75852013
75855675
75850246
75876238
75877183
75877158
75877166
75880462
75880458
75880439
75880461
75880463
75880441
75134736
75329651
75287930
75883323
75883380
75883337
75883339
75883326
75883362
75883366
75883377
75883368
75883631
75883624
75883628
75883626
75883629
75883622
75883623
75883615
75883614
75883618
75884159
75635068
75635085
75805594
75732306
75635151
75635135
75805596
75887985
75889666
75891523
75892599
75891982
75538414
75894782
75887079
75884840
75876082
75883130
75883127
75883126
75883124
75883125
75883128
75399001
74659413
75852054
75852045
75852030
75852009
75852024
75852048
75852066
75852042
75903505
75880361
75878264
75880491
75880428
75879652
75908298
75885916
75911983
75914539
75914594
75272154
75916534
75917587
75917595
75917547
75852018
75933168
75933181
75934360
75930992
75930967
75943125
75922348
75930358
74835092
74835077
74835097
74835094
74836269
74836281
74835107
74864002
74863986
74864042
75947036
75947053
75946913
75946959
75421090
75421096
75957843
75957845
75957853
75957847
75957849
75957846
75957844
75958757
75958736
75958717
75958744
75958733
75958895
75959149
75959023
75959091
75958928
75958900
75959212
75959218
75959159
75965471
75965472
75963922
75963131
75963065
75963071
75963224
75965753
75966192
75966355
75966151
75966349
75965765
75953578
75952840
75967784
75967435
75967418
75967243
75967261
75967448
75969420
75969608
75969910
75969633
75969585
75970575
75969602
75969422
75970556
75974131
75982737
75923991
75983920
75978836
75973667
75978845
75973685
75957289
75957439
75957401
75957386
75957320
75957303
75957536
75957327
75957306
75957396
75957487
75957485
75957471
75957341
75957447
75957431
75957464
75957463
75957299
75957524
75957335
75957492
75957273
75957507
75957469
75957493
75957348
75957362
75957483
75957304
75957356
75957277
75957488
75957430
75957298
75957359
75957506
75957324
75957271
75957446
75957438
75957413
75957561
75957385
75957454
75957323
75957282
75957472
75957397
75957440
75957475
75957505
75957470
75957326
75957387
75958302
75958511
75958286
75958282
75958562
75957634
75957804
75957752
75957772
75957588
75957743
75957586
75957773
75957735
75957759
75957575
75957599
75957707
75957761
75957705
75957636
75957758
75957787
75957610
75957739
75957597
75957573
75957633
75957779
75957716
75957770
75957581
75957784
75952224
75952232
75952500
75985823
75363209
75363125
75363141
75364155
75364154
75364207
75362651
75363463
75363619
75363462
75363620
75637352
75637491
75637387
75637455
75637660
75637388
75637463
75110841
75363810
75363978
75363979
75363832
75363811
75363934
75978723
75978191
75980811
75979221
75980975
75979396
75978817
75961487
75978049
75961480
75961501
75961492
75978158
75961504
75978156
75961498
75961497
75978051
75978136
75978160
75978052
75978159
75978053
75989374
75989407
51179966
51179974
51181131
51181232
51182887
51182368
75293227
75283636
75989387
75989406
75989380
75989396
75994836
76006319
76006287
76006221
75827030
75827350
75827150
75832106
75833073
75828319
75826866
75827046
75827442
75827092
75833028
75826872
75838822
75839173
75838572
76010206
76010213
76010205
76010211
76009916
76009851
76009932
76009818
76009805
76009957
76009854
76010171
76011454
76017107
76021278
76021576
76021327
76021510
76021550
74437263
74437224
74437249
74437201
74437219
74437209
74437193
76024870
66167481
66131427
66280679
68067681
65839442
66280693
66280673
66280686
66167492
65826577
66280681
66280682
66286137
66263310
73625702
76025966
76025907
76025980
76025905
76025962
76025921
76025903
76025925
76025935
76025937
76025919
76025959
76025929
76025923
76036016
76037937
76037926
76037940
76037917
76037950
76037927
76037957
76037924
76037938
76037922
76037941
76037915
76037936
76037956
76037954
76039183
76039114
76040514
76040631
76050071
76050086
76051606
76054460
76054454
76054464
76054459
76054462
76054463
76054457
76054461
76054458
76017079
76017077
76040205
74933090
74933441
75175860
74934382
76040928
76065570
75941247
75941248
75941252
75941249
76064957
75490758
76023913
76023918
76023911
76023915
76023914
76023912
76066400
76066829
75903001
75905572
75905706
76020698
76020763
76020758
76015236
76070207
76070159
76071173
76071153
76071198
76070328
76070492
76070271
76070241
76070225
76070220
76071271
76071495
76071237
76071332
76070596
76071599
76050582
76069772
76080641
76074496
76074488
76074477
76074486
76074508
76074816
76074542
76074812
76075519
76075550
76074910
76075832
76075848
76075821
76075813
76075835
76075807
75624866
76092130
76092132
76095075
76095137
76095102
76096346
76096390
76096465
76095642
76102181
76102147
75991649
75991639
75991655
75991646
75991658
75991642
76101676
76092275
76092277
76093593
76093619
76093601
76093590
76095636
76104145
76006476
76006670
76054546
76054513
76055566
76054828
76054851
76054819
76054940
76055969
76055133
76055142
76055165
76109986
76051895
76051896
76052037
76051897
76052036
76052039
76052035
76051898
76052038
76053014
76052996
76052816
76052990
76052988
76053794
76053825
76054027
76053829
76054003
76053832
76054057
76053827
76053824
76053798
76053823
76053833
76053797
76053793
76053830
76053834
76052354
76052372
76052186
76052185
76052281
76052355
76052189
76052255
76052247
76052191
76052384
76052257
76052282
76052278
76052253
76052280
76052254
76052385
76052279
76052188
76052252
76052250
76052373
76053357
76053144
76053358
76053396
76053078
76053360
76053394
76053393
76052690
76052560
76052601
76052648
76052620
76052636
76052542
76052691
76052414
76052602
76052465
76052693
76052599
76052617
76052645
76052692
76052634
76052415
76052464
76052557
76052539
76052600
76052635
76052689
76053589
76053657
76053604
76053681
76053562
76105649
76105441
76112092
76111905
76111910
76112019
76111906
76112216
76112094
76112063
76111907
76112090
76112087
76112065
76112062
76112085
76112095
76112093
76112064
76112096
76112088
76111908
76111909
76112532
76112331
76112312
76112370
76112391
76112340
76112409
76112410
76112395
76112413
76112411
76112346
76112405
76112406
76112412
76112394
76112393
76112407
76124425
76124401
76124387
76124389
76124373
76124377
76124395
76124375
76124435
76124493
76124482
76124491
76124478
76124505
76124513
76124489
76124490
76124522
76110363
76110362
76110361
51296018
75844666
75341507
75337441
76135216
76135214
76135217
76135212
76135211
76135218
76135210
76128664
47782429
76128646
76128667
76128642
76128658
76128670
76128674
76128637
76128653
76113780
76113774
76113757
76113776
76113777
76113763
76113748
76113770
76113754
70767208
70767689
76140066
76143978
76143999
76144060
76144037
76143998
76143984
76144011
76144016
76143992
76144003
76144042
76144004
76143990
76144040
76144055
76144082
76144089
76144019
76143996
76144044
76144034
76144095
76144078
76144007
76144015
76144014
76143989
76133667
76146980
76147073
76148594
76148683
76147732
76150494
76155717
76155722
76155719
76153162
76153598
76153709
76150232
76156864
76156553
76156365
76150790
76150941
76150816
76150879
76150818
76150904
76151000
76153081
76153084
76150820
76150841
76150973
76150987
76150815
76150928
76150810
76150859
76150842
76150847
76150921
76150811
76153086
76150914
76150871
76150843
76150959
76150835
76150832
76150814
76153080
76150833
76150822
76150819
76150836
76150839
76150825
76150827
76150826
76150894
76150838
76150824
76173934
76163718
75286725
76183055
76144832
76187515
76187517
76187513
76185686
76192185
76184904
76184841
76184865
76184822
76184817
76184825
76184830
76184860
76184909
76184862
76184918
76184836
76184840
76184873
76184887
76184888
76184894
76184833
76184911
76184857
76184863
76184879
76184820
76184880
76184845
76184851
76184859
76184854
76184842
76184835
76184878
76184908
76184826
76184869
76184808
76184906
76184831
76184895
76184848
76184866
76184912
76184837
76184844
76184899
76184892
76184915
76184875
76184821
76184886
76184922
76184900
76184814
76184867
76184877
76184855
76184858
76184903
76184815
76184907
76184828
76184871
76184916
76184881
76184813
76184885
76184834
76184883
76184818
76184901
76184923
76184827
76184847
76184811
76184838
76184874
76184823
76184829
76184812
76184868
76184810
76184919
76184921
76184910
76184839
76184856
76184902
76184917
76184876
76184924
76184872
76184884
76184861
76184898
76184897
76184913
76184890
76184893
76184882
76184843
76184816
76184846
76184889
76184850
76184832
76225470
76207376
76227317
76016893
75309316
66167494
76191804
76241011
76241032
76241015
76241046
76242453
76242454
76235927
76243506
76243709
76243751
76243508
76243710
76225268
76226103
76102383
76259491
76257850
76263783
76263682
76263681
75341480
75341483
76009945
76009876
76009948
76009939
76009785
76228946
76009894
76009907
76009956
76009879
76265573
76268696
76269690
76269964
76274579
76275797
75637483
75733514
76300936
76301096
76301187
76301016
76301185
76300979
76301133
76301091
76301183
76301181
76301184
76301138
76301114
76301109
76301186
76301426
76301509
76305946
76274720
76274731
76274707
76274732
76274713
76274712
76274711
76274721
75217387
75217497
76274577
76268160
76313888
76313886
76314051
76320222
76320262
76322703
76322695
76322708
76325972
76328579
76326335
76326406
76326418
76326325
76326375
76326360
76326423
76326314
76331524
76305435
76305355
76305356
76305404
76305400
76305429
76305402
76305436
76305354
76305352
76305403
76305810
76305823
76305822
76305574
76305575
76305608
76305811
76305631
76305545
76305627
76305514
76305632
76305544
76337211
76336951
76337428
75981223
75981158
75981137
75981084
75981166
75981000
75981175
75981198
75981194
75981122
75981153
75981214
75981200
75981096
75981004
75981020
75981186
75981125
75981044
75981190
75981086
75981217
75981216
75981229
75981202
75981094
75981196
75981042
75981038
75981199
75981018
75981124
75981185
75981040
75981126
75981024
75981070
75981205
75981208
75981197
75981001
75981139
75981152
75980995
75981209
75981104
75981014
75981181
75981203
75981131
75981089
75981099
75981113
75981211
75981145
75981148
75981063
75981095
75981174
75981032
75981171
75981079
75981138
75981050
75981157
75981222
75981062
75981045
75981165
75981151
75981188
75981161
75981121
75981026
75981048
75981068
75981021
75981206
75981092
75981105
75981075
75981127
75981192
75981035
75981111
75981098
75981039
75981033
75981183
75981013
75981073
75981133
75981210
75981228
75981215
75981129
75981117
75981019
75981180
75981213
75981154
75981049
75981112
75981195
75981009
75981052
75981003
75981169
75981230
75981083
75981182
75981201
75981146
75981031
75981100
75981226
75981147
75981047
75981093
75981156
75981028
75981065
75981080
75981305
75981232
75981235
75981260
75981291
75981292
75981259
75981273
75981246
75981261
75981257
75981289
75981277
75981245
75981244
75981294
75981282
75981301
75981276
75981306
75981304
75981288
75981275
75981258
75981247
75981284
75981298
75981256
75981287
75981272
75981249
75981299
75981253
75981242
75981286
75981278
75981239
75981251
76125180
71498279
71498407
71496844
71496950
71541058
71496944
76316466
76290044
76290113
76290262
76291040
76291127
76290745
76290456
76291474
76291562
76291847
76291716
76291779
76346222
76322829
76323006
76322988
76323061
76322997
76340922
76346596
76189699
76353909
76353390
76353386
76353397
76353402
76353376
76353399
76347736
76352301
76353379
76353380
76353403
76353405
76354345
76353791
76353785
76354337
76353779
76354340
76320289
76342033
76341910
76355112
76356846
76355061
76355065
76355106
76355122
76355088
76355087
76355059
76355117
76355121
76355104
76356785
76355119
76355120
76355109
76355107
76355125
76355126
76355091
76355099
76355098
76355111
76355066
76355108
76356848
76355092
76355105
76355101
76355123
76355127
76356821
76355097
76355095
76355090
76355124
76355102
76355068
76355128
76355100
76355130
76355129
76360120
76361636
76338044
76363451
76362178
76361726
76361791
76362568
76361777
76361789
76362576
76362575
76361781
76361775
76361780
76361779
76362574
76362596
76362681
76353362
76353366
76353363
76353358
76353364
76353357
76353361
76353356
76353368
76353355
76353365
76363572
76363613
76363977
76364005
76364032
76363642
76364008
76363970
76364006
76364012
76363641
76364060
76364057
76364068
76364055
76364046
76364056
76364059
76364058
76344851
76354768
76354782
76354736
76354729
76354789
76354744
76354751
76354774
76289944
76374754
76374299
76374535
76374475
76374485
76374799
76374460
76374764
76374287
76374761
76374408
76374459
76374684
76374455
76374588
76374478
76374752
76374579
76374381
76374378
76374304
76374319
76374398
76374793
76374813
76374296
76374570
76374745
76374607
76374613
76374440
76374325
76374414
76374532
76374333
76374748
76374347
76374651
76374517
76374710
76374504
76374465
76374625
76374795
76374810
76374524
76374322
76374393
76374780
76374618
76374473
76374506
76374477
76374400
76374664
76374779
76374494
76374354
76374383
76374454
76374622
76374375
76374405
76374448
76374377
76374487
76374451
76374626
76374574
76374577
76374669
76374395
76374552
76374434
76374328
76374555
76374690
76374727
76374740
76374420
76374518
76374794
76374738
76374541
76374714
76374749
76374429
76374696
76374510
76374731
76374362
76374549
76374645
76374495
76374452
76374412
76374606
76374674
76374735
76374820
76374585
76374583
76374500
76374558
76374785
76374445
76374330
76374656
76374428
76374629
76374390
76374614
76374723
76374379
76374525
76374566
76374619
76374436
76374713
76374417
76374627
76374699
76374457
76374621
76374551
76374791
76374512
76374462
76374788
76374480
76374370
76374702
76374488
76374391
76374593
76374610
76374693
76374538
76374311
76374348
76374509
76374782
76374545
76374683
76374437
76374778
76374423
76374818
76374675
76374787
76374467
76374812
76374721
76374666
76374581
76374540
76374449
76374663
76374630
76374589
76374353
76374734
76374641
76374534
76374743
76374670
76374411
76374615
76374422
76374344
76374687
76374357
76374527
76374657
76374464
76374642
76374623
76374433
76374546
76374637
76374817
76374611
76374726
76374680
76374598
76374648
76374650
76374548
76374309
76374386
76374755
76374691
76374360
76374543
76374387
76374757
76374634
76374491
76374397
76374439
76374442
76374809
76374306
76374406
76374751
76374561
76374468
76374425
76374582
76374294
76374705
76374591
76374776
76374688
76374567
76374746
76374520
76374654
76374603
76374732
76374660
76374697
76374501
76374741
76374368
76374604
76374318
76374600
76374575
76374647
76374803
76374586
76374419
76374806
76374797
76374694
76374498
76375183
76374902
76374977
76375061
76375002
76374976
76374886
76374852
76375088
76375225
76375239
76375131
76375195
76375253
76374965
76374911
76375026
76375012
76375213
76375175
76374897
76375269
76374864
76375172
76375058
76374943
76374926
76375100
76375304
76375041
76375076
76374895
76375289
76375134
76374952
76375106
76374899
76374991
76375010
76375101
76374906
76375184
76375317
76375116
76375265
76374892
76375283
76375163
76375278
76375223
76375032
76374868
76375311
76375166
76374848
76374837
76374825
76375140
76375039
76374971
76374888
76374978
76374870
76375169
76374996
76374862
76374893
76375121
76374830
76375242
76374988
76374912
76375237
76375207
76375047
76375145
76375230
76375025
76374923
76375111
76375107
76374974
76374873
76375028
76374854
76375215
76375291
76375110
76375096
76374860
76375035
76374875
76374880
76375196
76375126
76375212
76374838
76375082
76374997
76375113
76374947
76375073
76375081
76375186
76375180
76375204
76375066
76375009
76375222
76375017
76375310
76375192
76375069
76375281
76375098
76374989
76375155
76375297
76374857
76375080
76374889
76375108
76375261
76375187
76374835
76374964
76375160
76374878
76375135
76374936
76375202
76375209
76375143
76375052
76374940
76374908
76375090
76375060
76375036
76375280
76374828
76375117
76375074
76374962
76375119
76375306
76375055
76375038
76374994
76375092
76375258
76375054
76375177
76374993
76374955
76375057
76375063
76374915
76375309
76374885
76375227
76375191
76374959
76374881
76375181
76375233
76374833
76375146
76374945
76374967
76375193
76375154
76374973
76375083
76375272
76375031
76375157
76375103
76375171
76375285
76374961
76375277
76374843
76375303
76374930
76374935
76375201
76375316
76375174
76374856
76375315
76375095
76374949
76375210
76375256
76375005
76375197
76375132
76375042
76375015
76375137
76374877
76375293
76375296
76375149
76375264
76375085
76375302
76375274
76375023
76375305
76374953
76375308
76374866
76375312
76374827
76375122
76375124
76374840
76375021
76374832
76374849
76375178
76375271
76375205
76375232
76374956
76374844
76375142
76375046
76353778
76355089
76353783
76353782
76353788
76353780
76353777
76355060
76353784
76353388
76353787
76353387
74329348
74836262
74836254
76356976
76382634
76382653
76382661
76382760
76384134
76382870
76382684
76385995
76388934
76380926
76389017
76362793
76362856
76362918
76362936
76362947
76362818
76362870
76362951
76362921
72952128
76364368
76364367
76394988
76394960
76394870
76394965
76394955
76394876
76394852
76394963
76394961
76395038
76394964
76394966
76394869
76394984
76394969
76394868
76021439
76021437
76021540
76397627
76395133
76396768
76394260
76397193
76400130
76396841
76396816
76396814
76396886
76396856
76396812
76398804
76403177
73142198
73142207
73142210
73142197
73142173
73142191
73142183
73142184
73142181
76404533
76397656
76397496
76397524
76397664
76397479
76397494
76397482
76397470
76397488
76395073
76402908
76402909
76416792
76395056
76422880
76413176
76426340
76245610
76245613
76429947
76408540
58205536
76428946
76428682
76428737
76428702
76428166
76428902
76428818
76428831
76428680
76463466
76463536
76435973
76472338
76466439
76483344
76464908
76464919
76486540
76516265
76509039
76508945
76509038
76509029
76508946
76518212
76382583
76522055
76522080
76526817
76526819
76526815
76526813
76519520
76519673
76518469
76518405
76518402
76519522
76518287
76521190
76529530
76452842
76533987
76532797
76532822
76533485
76533482
76533616
76533695
76533693
76517960
76533618
76518749
76518467
76526286
76516883
76542340
76533967
76533965
76270431
76270415
76270439
76270404
76270308
76270441
76270437
76270401
76270391
76270413
76270398
76270470
76270435
76270419
76270408
76270410
76270393
76270418
76270412
76270471
76270427
76270305
76270473
76270311
76270438
76270416
76270436
76270425
76270406
76270306
76270422
76270402
76270396
76270420
76270466
76270432
76270429
76270392
76270309
76270394
76270307
76270403
76270440
76270414
76270468
76270409
76270399
76270434
76270428
76270433
76270390
76270474
76270465
76270424
76270423
76270411
76270397
76270430
76270472
76270476
76270469
76270407
76270395
76270310
76270426
76270467
76270417
76270400
76270583
76270549
76270502
76270571
76270575
76270656
76270521
76270496
76270480
76270522
76270551
76270527
76270574
76270561
76270533
76270641
76270555
76270691
76270663
76270560
76270540
76270489
76293594
76270579
76270563
76270513
76270490
76270567
76270649
76270498
76270547
76270497
76270504
76270651
76270564
76270557
76270494
76270636
76270639
76270517
76270559
76270484
76293574
76270535
76293583
76270485
76270542
76270643
76270657
76270565
76270524
76270512
76270487
76293592
76270483
76270506
76270586
76270503
76270530
76270552
76270647
76270507
76270537
76270499
76270667
76270562
76270510
76270581
76270477
76270515
76293577
76270492
76270644
76270501
76270536
76270548
76270518
76270493
76270495
76270650
76270488
76270655
76293572
76270520
76270573
76293591
76270550
76270556
76270668
76270508
76270526
76270572
76270554
76270534
76270545
76270642
76293569
76270532
76270570
76270568
76270633
76270538
76270664
76293595
76270645
76270577
76270638
76270569
76270646
76270516
76270544
76270576
76270514
76270584
76270546
76270478
76270479
76270582
76270482
76270528
76270523
76270654
76270635
76270580
76270491
76270587
76270558
76270640
76270652
76270578
76270509
76270511
76270525
76293575
76270566
76270653
76270531
76270541
76293566
76270585
76270648
76270486
76270632
76270500
76270519
76270543
76270553
76398054
76398057
76398056
76398050
76398091
76398048
76398046
76398053
76545742
76564401
76563835
76564402
76564400
76563940
76564403
76563854
72886888
76557334
76587225
76587234
76587240
76587191
76587233
76595226
76559621
76595616
76595440
76595441
76595558
76595556
76595560
76595559
76601632
76601631
76594945
76610451
76610504
76610461
76608734
76608691
76608737
76608738
76608832
76608820
76604360
76604238
76604406
76602174
76604276
76598242
76601277
76601682
76604695
76604293
76604287
76604491
76600367
76604381
76604328
76604544
76602173
76604267
76604590
76612238
76612973
76610427
76610410
76610432
76614377
76614350
76614349
76614375
76614996
76615393
76615568
76615485
74728172
74728117
74728033
74727967
74728084
74728050
74728169
76425549
76601634
75964126
76425776
76425979
76425770
76425976
75964820
75964017
76623007
76424948
76458769
76458763
76456175
76441794
76446995
76455443
76453638
76447020
76453640
76454582
76654524
76387801
74449008
76656645
75135176
75135190
75135175
75135141
75135191
75135173
76656644
76674091
76638897
76638901
76638915
76638899
76638922
76638919
76638891
76638911
76638907
76638894
76638903
75328328
76654520
76654489
76636920
76636783
76636969
76636573
76637315
76637313
76637317
76637311
76701011
76699596
76319603
76690575
76690572
76690352
76689849
76690253
76690567
76689868
76689914
76690928
76689901
76690335
76691436
76690574
76689844
76690513
76689846
76690570
76690347
76691435
76690580
76689922
76689891
76689773
76690464
76689847
76689867
76690353
76689775
76689801
76689875
76703936
76703624
76703346
76703981
76703396
76703653
76703935
76703388
76703373
76703367
76703940
76703361
76703986
76703374
76703625
76703938
76534585
76534018
76534580
76534019
76527190
76534024
76534012
76527193
76527188
76527186
76527189
76534009
76534020
76527192
76527184
76527183
76527158
76534590
76527182
76527196
76534023
76527177
76534025
76534011
76527176
76527191
76527185
76534588
76534026
76534599
76534021
76527199
76534014
76534008
76527181
76527180
76527178
76527179
76534587
76534006
76527187
76534013
76527194
76534022
76527201
76534017
76527200
76534005
32794050
76689771
76690998
76691324
76691921
76691045
76691600
76689893
76690999
76438598
71271790
76703061
76703041
76702956
76618897
76703297
76722344
76724837
76724854
76719517
76719515
76724702
76724700
76724701
76724704
76725327
76726098
76726101
76726093
76726086
76726077
76726078
76726095
76726090
76726076
76754600
76744385
76142583
76760137
76760478
76760418
76761277
76761279
76761278
76760833
76747505
76749080
76763482
76763592
76763489
76772505
76772947
76229872
51864483
52750627
52494469
52150433
76776060
76776219
76776189
76776190
76776217
76776229
76776251
76776303
76776292
76776250
76776363
76776366
76776368
76777250
54869505
54869497
76777602
76777627
76777638
76777630
76777681
76777601
76777597
76777567
76777572
76777658
76777614
76778044
76777743
76778049
76777940
76777724
76778053
76777804
76777975
76777830
76778113
76778088
76777807
76777761
76777777
76778034
76777915
76778082
76778042
76778084
76778048
76778116
76777909
76778127
76777918
76778104
76778151
76778117
76778143
76778081
76778052
76778033
76777723
76778125
76777773
76778132
76777968
76778063
76778183
76778232
76778170
76778190
76778244
76778267
76778165
76778204
76778437
76778423
76786743
76786684
76774708
76773680
76773796
76774017
76773896
76774018
76774014
76773650
76773827
76773728
76773696
76773784
76799371
76799368
76777755
76777812
76764247
76764245
76764240
76764254
76764270
76777544
76801920
76802482
76802498
74934684
75175934
76803399
76803454
76803667
76803671
76773484
76804610
76804637
76804616
76804693
76804736
76804709
76804719
76804745
76805021
76805058
76805057
76805017
76804994
76804973
76805024
76805023
76805814
76805832
76805771
76805826
76805783
76805805
76805780
76762675
76762669
76809690
76809490
76813570
73971297
73971300
76815950
76815931
76816108
76816126
76816083
76819011
76819010
76824750
76824835
76824855
76824854
76824749
76824853
76828731
76713255
76713827
76713561
76713870
76690373
76689790
76689865
76689783
76689854
76689883
76689811
76689781
76689767
76689812
76689820
76690355
76691477
76689878
76689885
76689794
76690339
76690382
76689890
76690383
76689879
76690363
76690342
76690372
76689888
76691629
76689758
76690377
76689791
76690587
76689831
76689807
76690341
76689897
76689814
76689906
76690358
76689855
76689776
76689768
76689862
76689796
76689818
76689827
76690362
76691476
76689798
76690370
76690360
76689834
76689852
76689857
76690577
76690380
76689779
76690319
76689860
76689886
76689826
76691919
76850942
76834005
76856657
76856800
76856862
76856871
76833913
76833836
76833916
76859856
76845299
76845343
76845318
76845357
75838701
76866573
67876309
76872692
76872700
76868869
76873925
76876677
76691457
76690505
76690290
76691459
76690304
76690561
76690558
76690507
76689743
76690469
76690484
76690548
76690310
76690295
76690551
76690516
76690553
76690293
76689747
76690288
76690467
76690279
76691458
76690300
76690309
76690520
76690550
76690312
76690292
76689755
76690305
76690523
76690543
76690537
76690302
76690299
76690510
76689757
76875257
76875273
76875303
76875325
76875323
76875258
76875327
76875297
76875313
76875274
76875255
76875268
76875301
76875311
76875322
76875261
76875263
76875283
76875265
76875299
76875309
76875320
76875288
76875295
76875267
76875290
76875271
76875285
76875277
76875280
76875321
76875252
76913949
76914048
76913952
76913857
76913851
76913927
76913918
76914815
76914812
76916726
76928135
76917501
76932710
76932701
76935646
76942145
55692016
76955894
76955891
76955885
76941952
76962178
76966492
76966496
76968210
76968282
76968416
76968439
76968280
76968408
76968357
76968392
76968244
76968375
76968388
76968404
76968355
76968241
76968395
76968257
76968412
76968424
76968376
76968374
76968204
76968397
76968426
76968272
76968430
76968407
76968345
76968343
76968224
76968427
76968370
76968235
76968671
76968512
76968804
76968514
76968798
76968558
76968782
76968639
76968673
76968600
76968566
76968763
76968565
76968489
76968532
76968581
76968645
76968556
76968664
76968543
76968481
76968630
76968488
76968562
76968768
76968812
76968615
76968810
76968794
76968744
76968655
76968555
76968633
76968529
76968492
76968778
76968509
76968656
76968642
76968593
76968571
76968626
76968665
76968795
76968776
76968589
76968669
76968748
76968617
76968519
76968772
76968670
76968643
76968803
76968518
76968561
76968661
76968611
76968531
76968479
76968621
76913830
76969248
76969216
76969241
76969263
76969170
76969225
76969218
76969232
76969152
76969202
76969153
76969228
76969198
76969235
76969264
76968564
76968383
76968277
76980125
76980084
76980131
76980085
76980081
76980094
76980129
76980082
76980099
76980093
76980100
76980097
76980091
76980096
76982151
76982160
76985460
76985499
76985493
76985495
76983134
76986058
76986056
76986059
76986057
76985513
76980083
76990287
76995897
76985475
76997930
76998222
76998765
76998723
76998724
76998729
77002014
77009346
77009165
77009857
77009171
77009050
77011018
77009331
77009259
77009253
77017583
77009196
77025173
77025197
77025179
77025175
77025211
77025182
77025219
77025341
77025218
77025225
77025130
77025207
77025143
77025162
77025536
77025205
77025153
77025165
77025216
77025200
77025154
77025148
77025208
77025192
77025203
77025204
77025133
77025201
77025196
77025227
77025127
77025184
77025132
77025155
77025191
77025212
77025144
77025160
77025150
77025733
77025936
77026063
77026038
77026336
77026503
77026507
77026501
77026504
77026349
77026555
77009244
76870366
77028959
77028976
77028950
77029250
77029505
77029639
77029475
77029731
77036848
77036844
77009247
77009250
77009180
77036573
77036216
77045222
77045579
77047232
77045725
77056288
77056308
77056331
77058483
77058898
77058487
77058486
77058701
77058482
77058485
77058592
77058484
77059802
77060241
77060518
77060548
77060552
77060562
77060554
77060550
76939530
76939539
76939535
76939533
76939542
76939538
76939531
76939543
76939534
76939540
76939537
75998895
77061833
77065465
77069841
77069842
77064080
77064221
77064079
77066864
77066893
77066872
77066096
77066856
77066860
77066046
77066901
77066004
77066886
77066900
77066868
77066879
77066000
77066036
77066878
77066851
77066882
77066873
77066007
77066896
77066866
77066841
77066870
77066016
77066854
77066858
77066875
77066920
77066862
77066899
77068185
77068065
77068188
77068182
77068184
77068190
77068193
77068064
77068189
77069986
77072894
77072887
77072891
77073988
77009192
76936662
76936655
76936658
76936771
76936632
77082218
77082213
77082212
77082216
77082214
77082199
77082217
77082239
77082251
77082222
77085424
77085386
77009183
77081488
77101358
77101317
77101335
77101348
77101360
77101342
77101325
77101363
77105006
77104998
77104995
76410571
76410583
76410491
77099891
77099918
77099283
77099849
77099917
77099271
77099847
77099852
77099764
77099280
77099274
77099281
77099277
77099282
77109773
77101142
77101140
76306998
76602769
76602741
76602835
76603205
76308768
77122183
77112371
77141640
77124089
77126619
77161414
77161236
77162962
77173544
77173473
77173635
77172761
77172753
77173595
77173520
77173534
77173580
77173486
77173784
77172765
77173833
77173820
77173853
77173822
77172228
77172156
77172524
77172390
77172391
77172342
77172378
77169307
77169315
77169306
77169318
77169333
77169350
77169397
77169402
77169320
77169297
77169305
77169800
77169804
77169756
77169711
77169749
77169753
77169731
77169557
77169748
77169807
77169453
77169801
77169558
77169445
77169741
77169553
77169589
77170585
77169819
77170781
77170770
77169830
77170497
77170775
77170464
77170462
77170565
77170471
77174081
77174406
77174052
77174390
77174380
77174389
77174376
77174054
77174135
77171193
77171027
77170833
77171420
77171013
77171217
77171218
77171012
77170840
77171393
77171411
77171209
77171054
77171205
77174619
77174735
77174503
77174761
77174667
77174534
77174489
77174658
77174675
77174614
77174637
77174599
77174747
77174665
77174731
77174464
77174469
77174824
77174806
77174852
77174869
77174810
77174842
77174851
77174843
77174816
77174858
77174933
77174934
77174956
77174964
77174937
77186373
77186434
77186665
77186416
77186680
77186542
77181179
77181121
77181084
77181103
77181037
77181095
77181261
77181183
77181051
77181038
77181061
77181298
77181026
77181255
77181075
77181120
77181182
77181160
77181294
77181034
77181191
77181269
77181151
77181311
77181106
77181124
77181241
77181253
77181548
77181387
77181345
77181382
77181396
77181381
77181391
77181575
77181404
77181377
77181398
77181556
77181577
77181388
77181389
77181417
77181845
77181846
77182033
77181842
77181890
77181892
77183316
77197901
74933413
77186400
77186422
77124128
77062692
77062759
74655245
74655235
77200505
77009334
77204482
77230495
77229888
77229885
77229889
72034286
72034471
76098386
76096817
76117705
75984103
77236555
77236548
77236556
77236547
77236558
77245553
77247204
77247297
77247384
77247352
77247358
77247313
77247226
77247383
77247359
77247224
77247206
77247382
77247275
77247320
77247223
77247205
77247396
77247409
77247393
77247423
77247387
77247727
77247386
77247422
77247554
77247685
77247390
77247832
77248047
77247778
77247790
77247831
77247802
77247777
77247817
77247967
77247779
77247818
77248057
77248205
77248221
77264645
77264647
77264648
77264640
77265943
77265487
77265633
77266172
77265981
77266195
77266238
77265622
77265972
77266192
77265991
77265505
77266300
77269755
77269443
77270102
77266272
77283296
77284660
77299242
77299229
77299334
77301798
77302672
75142648
77310808
77310804
77310792
77310773
77310782
77310788
77310805
77310774
77310790
77310765
77310786
77310800
77310778
77310810
77310783
77310812
77310799
77310756
77310779
77310763
77310821
77297890
77315395
77315380
77315373
77315379
77315383
77312607
77312593
77312605
77312606
77287134
77287138
77287159
77287132
77287139
77287142
77331613
77331614
77331615
77310095
77313658
62731861
77337161
77337296
77339980
77339983
77339985
77340149
77340275
77336905
77332519
77324205
77317426
77322478
77322139
77321431
77319493
77331358
77329400
77326071
77316952
77332434
77331619
77332546
77332355
77343533
77343530
77343536
77344924
77313592
77313613
77345370
77367609
77367732
77369274
77378376
77380018
77383988
77357104
77388358
77397142
77394176
77413422
77438585
77438843
77439032
77441805
77444240
77442122
77442238
77442191
77442116
77438835
49942783
77438854
49942709
49942584
77438836
49942733
77438845
77438832
49942656
77438842
77438837
49942717
77438834
77438867
49942578
77438840
49942590
49942680
49942546
49942605
49942748
49942565
77438852
49942779
49942623
49942559
77438863
77438861
77438858
49942775
49942552
49942758
49942695
77438841
49942797
49942690
49942569
77438866
49942574
77438838
50228014
77438856
49942740
49942794
49942787
77441739
77441740
77441741
77442462
77442496
77442450
77443022
77446263
77451449
77474298
77474221
77474327
77474152
77473935
77477217
77475897
77482292
77482301
77482307
77482210
77482331
77482304
77482216
77482222
77482371
77473863
77489226
77489234
77489913
77489264
77489262
77489250
77473842
77473853
77473595
77473858
77473847
77473848
77473845
77473836
77473857
77473839
77473861
77473854
77473850
77473862
77473840
77473859
77473860
77473856
77473843
77473837
77474198
77475845
77474195
77474202
77475860
77475848
77474194
77474209
77474212
77474199
77475880
77474187
77474215
77475857
77475873
77474190
77474204
77474220
77474183
77474201
77475890
77475850
77474193
77475862
77474197
77474218
77475866
77475852
77474186
77474211
77474208
77474214
77475855
77475841
77474189
77474207
77475893
77474200
77474192
77474184
77474217
77475888
77474216
77474191
77474206
77475864
77474213
77474210
77475870
77474196
77475877
77475844
77474185
77474188
77474205
77475874
77474203
57884255
77499472
77499568
77499338
77499383
77499645
77499841
77499897
76942004
77499519
77434864
77482384
77482295
77532290
77532286
77542369
77542379
77542382
77542380
77542370
77544429
77560341
77560611
77560445
77560587
77560514
77563280
77563271
77565147
77565549
77566503
77567279
77567160
77567252
77433080
77528572
74933582
77581133
77581675
77581655
77581690
77589839
77590848
77591497
70496783
77609971
77610084
77610105
77610075
77610103
77610029
77610138
77610104
77610596
77610597
77611016
77610336
77611013
77611151
77611283
77628991
77629466
77635841
77642028
75175883
77452263
77565010
77564750
77565860
77565853
77565739
77565745
77566112
77447026
77447249
77447152
77447247
62792080
62792215
62792258
62792114
77649836
77464836
77464695
77464715
77464930
77464767
77464926
77464950
77464807
77464790
77464889
77465078
77465186
77465074
77465033
77465139
77465016
76463255
77654793
77656160
77092180
77092236
77655633
77458458
77458974
77458304
77458546
77458606
77458151
77458682
77458675
77458700
77458559
77458275
77458526
77458861
77458738
77458657
77458591
77458549
77458720
77458772
77458463
77458794
77458710
77458625
77458711
77458848
77458587
77458432
77458429
77656934
77656824
77656925
77656914
77656901
77458747
77458614
77458599
77458471
77458821
77458686
77458706
77458640
77458574
77656945
77458562
77458628
77458983
77458522
77458484
77458612
77458548
77458654
77458413
77458409
77458434
77458635
77458501
77458516
77458646
77458951
77458521
77458691
77656838
77667815
77529415
76384799
77438551
76752039
76286409
76286470
76286490
76125580
76287386
76287392
76287122
76287381
76286889
77683469
77695281
77454641
77454640
77462144
77457016
77456949
77457014
77457015
77456554
77458356
77458217
77458324
77457042
77705658
77696095
77706656
77706661
77706654
77706659
77706652
77706651
77706653
77706650
77706649
77706663
77706655
77707044
77458340
77008453
77716750
77716684
77716763
77717144
77454636
77719315
77719354
77719363
77726249
77460913
77717049
77713599
77713604
77713607
77454626
77763093
77458903
77454635
77771414
77696053
77696027
77696049
77696058
77696050
77696028
77696069
77696047
77788114
77457626
77795576
77796610
77799095
77799093
77799085
77799096
77799091
77799086
66920097
66920103
77803458
77811452
77812067
77812090
77812108
77812088
77812047
77812096
77812238
77812334
77812297
77812243
77812234
77812197
77812187
77812184
77821891
77821897
77821930
77821888
77821878
77821900
77821896
77821892
77821907
77821905
77821885
77821894
77821890
77821908
77821889
77821895
77821904
77821886
77709539
77790316
77790869
77790967
77820221
77843740
77844342
77851953
77851878
77851948
77851879
77852058
77852878
77860270
77852879
77861012
77861003
77861013
77860989
77860991
77777766
77861353
77861362
77861317
77861369
77861314
77861329
77861332
77861366
77861305
77861308
77861302
77861338
77861359
77861335
77861356
77861341
77861326
77861311
77861323
77861320
77864425
77329253
77786363
77786429
77786388
77786416
77428760
77395104
77563324
77564180
77876638
77564501
77877057
77628565
77897776
77434775
77887332
77888239
77888395
77938963
77864420
77958711
77952316
77952328
77952321
77952331
77965124
77965100
77966027
77965112
77965106
77965121
77978109
77981459
77980382
77986449
77986452
77986451
77986447
77952324
77989618
77990689
77989810
77990121
77990814
77992884
77994751
77994761
77992800
77992887
78002328
78002347
78011329
78044080
78044096
78044155
78044098
78044093
78044088
78045010
78044996
78045007
61929914
77957689
78049678
78049675
78050029
78050064
78050027
78050066
78050067
78050105
78050071
78050028
78050030
78080478
78085949
78090571
78100503
78113006
78113007
78112938
78113010
78113013
78113015
78113009
78149517
