#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '50 минут',
    comment => 'исправляем рубрики которые превратились в фразы и перепосылаем их в БК (DIRECT-16817)',
}

=cut

#     direct-sql tl:ppc "select count(*) from bids where phrase rlike '^[0-9]+$' and norm_phrase rlike '^#[0-9]+$' and numword > 0"
#     cat <<'ENDOFQUERY' |test-update test-load /var/www/ppc.yandex.ru/bin/mysql_direct.pl ppc --no-safe-updates -- -t
#      select count(*) from bids where phrase rlike '^[0-9]+$' and norm_phrase rlike '^#[0-9]+$' and numword > 0
#     ENDOFQUERY
#     +----------+
#     | count(*) |
#     +----------+
#     |      441 |
#     +----------+
#     0.18user 0.01system 26:14.93elapsed 0%CPU (0avgtext+0avgdata 68864maxresident)k
#     2792inputs+0outputs (1major+4937minor)pagefaults 0swaps

use warnings;
use strict;

use Settings;
use Yandex::DBTools;
use ScriptHelper;

our $CHUNK_BIDS = 100_000;

# --------------------------------------------------------------------
sub main {
    $log->out('start');

    my $max_id = get_one_field_sql(PPC_HEAVY, "select max(id) from bids");
    $log->out("max: $max_id");
    my $from_id = 0;

    while ($from_id <= $max_id) {
        my $to_id = $from_id + $CHUNK_BIDS - 1;
        $to_id = $max_id if $to_id > $max_id;

        my $data = get_all_sql(PPC_HEAVY, q|select id, cid, bid, numword
                                            from bids
                                            where phrase rlike '^[0-9]+$'
                                              and norm_phrase rlike '^#[0-9]+$'
                                              and numword > 0
                                              and id between ? and ?
                                           |
                                           , $from_id, $to_id
                              );

        $log->out("from: $from_id to: $to_id");
        $from_id += $CHUNK_BIDS;

        next unless @$data;
        $log->out($data);

        my $broken_ids = [map {$_->{id}} @$data];
        do_update_table(PPC, 'bids', {numword => 0, statusBsSynced => 'No'}
                           , where => {id => $broken_ids
                                     , numword__gt => 0
                                     , phrase__rlike => '^[0-9]+$'
                                     , norm_phrase__rlike => '^#[0-9]+$'
                                      }
                       );

    }

    $log->out('finish');
}

# --------------------------------------------------------------------
main();
