#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд',
}

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use lib "$Bin/../protected/";

use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Clone qw/clone/;

use utf8;

$log->out('START');

$log->out('Fetching data');

my @orderids = map {chomp; $_} <DATA>;

my $cids = get_one_column_sql(PPC_HEAVY, [q/
    SELECT cid
    FROM campaigns
/,  WHERE => {OrderID => \@orderids}]);
my $cids_copy = clone($cids);
while (my @cids_packet = splice @$cids, 0, 100) {
    $log->out('Marking cids as unsync: ', \@cids_packet);
    do_update_table(PPC, 'campaigns', {LastChange__dont_quote => 'LastChange', statusBsSynced => 'No'}, where => {cid => \@cids_packet});
}

my $mgids = get_one_column_sql(PPC_HEAVY, [q/
    SELECT mgid
    FROM media_groups
/, WHERE => {cid => $cids_copy}]);
my $mgids_copy = clone($mgids);
while (my @mgids_packet = splice @$mgids, 0, 100) {
    $log->out('Marking mgids as unsync: ', \@mgids_packet);
    do_update_table(PPC, 'media_groups', {statusBsSynced => 'No'}, where => {mgid => \@mgids_packet});
}

my $mbids = get_one_column_sql(PPC_HEAVY, [q/
    SELECT mbid
    FROM media_banners
/, WHERE => {mgid => $mgids_copy}]);
while (my @mbids_packet = splice @$mbids, 0, 100) {
    $log->out('Marking mbids as unsync: ', \@mbids_packet);
    do_update_table(PPC, 'media_banners', {LastChange__dont_quote => 'LastChange', statusBsSynced => 'No'}, where => {mbid => \@mbids_packet});
}

$log->out('FINISH');

__DATA__
385643
387037
404895
411787
417526
417528
418032
430815
435117
448384
460719
463314
505457
509303
531420
547296
563066
570952
593352
616917
640570
643736
648581
656781
666497
685037
690186
693154
703494
705440
709072
726319
754505
762189
763931
774606
787262
793805
798816
804371
818358
841121
847669
854274
856420
858633
860221
860268
860456
861300
864343
864357
882246
885984
908276
932459
932531
942778
947975
953536
968161
973375
973376
976181
982511
999544
1003351
1023558
1032406
1048082
1106586
1143039
1222901
1241282
1252112
1259334
1271747
1276694
1276880
1286443
1303754
1304611
1315594
1316232
1325485
1326322
1333314
1339826
1345077
1397094
1397113
1406359
1416593
1419700
1439790
1443975
1447906
1449695
1466951
1474533
1480532
